/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pro.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.org.domain.OrgDepartempReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.repository.OrgDepartServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectCskuDomain;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectCskuReDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectCskuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pro/projectCsku"}, name="\u9879\u76ee\u5ba2\u6237\u5546\u54c1")
public class ProjectCskuCon
extends SpringmvcController {
    private static String CODE = "pro.projectCsku.con";
    @Autowired
    private ProProjectCskuServiceRepository proProjectCskuServiceRepository;
    @Autowired
    private OrgDepartServiceRepository orgDepartServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;

    protected String getContext() {
        return "projectCsku";
    }

    @RequestMapping(value={"saveProjectCsku.json"}, name="\u589e\u52a0\u9879\u76ee\u5ba2\u6237\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveProjectCsku(HttpServletRequest request, ProProjectCskuDomain proProjectCskuDomain) {
        if (null == proProjectCskuDomain) {
            this.logger.error(CODE + ".saveProjectCsku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectCskuDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectCskuServiceRepository.saveProjectCsku(proProjectCskuDomain);
    }

    @RequestMapping(value={"getProjectCskuForC.json"}, name="\u83b7\u53d6\u9879\u76ee\u5ba2\u6237\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> getProjectCskuForC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
    }

    @RequestMapping(value={"updateProjectCsku.json"}, name="\u66f4\u65b0\u9879\u76ee\u5ba2\u6237\u5546\u54c1(\u5206\u6d3e\u516c\u53f8)")
    @ResponseBody
    public HtmlJsonReBean updateProjectCsku(HttpServletRequest request, ProProjectCskuDomain proProjectCskuDomain) {
        if (null == proProjectCskuDomain) {
            this.logger.error(CODE + ".updateProjectCsku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectCskuDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectCskuServiceRepository.updateProjectCsku(proProjectCskuDomain);
    }

    @RequestMapping(value={"queryProjectSkuBycode.json"}, name="\u6839\u636e\u5458\u5de5Code\u67e5\u8be2\u9879\u76ee\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectSkuBycode(HttpServletRequest request, String employeeCode) {
        Map map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("employeeCode", employeeCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(map);
    }

    @RequestMapping(value={"queryProjectSkuByCompanyCode.json"}, name="\u6839\u636e\u516c\u53f8Code\u67e5\u8be2\u9879\u76ee\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectSkuByCompanyCode(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        map.put("companyCode", this.getCompanyCode(request));
        map.put("tenantCode", this.getTenantCode(request));
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(map);
    }

    @RequestMapping(value={"updateProjectStartState.json"}, name="\u9879\u76ee\u5f00\u59cb\u5b9e\u65bd")
    @ResponseBody
    public HtmlJsonReBean updateProjectStartState(HttpServletRequest request, String projectCskuCode) {
        Map param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCskuCode)) {
            this.logger.error(CODE + ".updateProjectStartState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        param.put("projectCskuCode", projectCskuCode);
        SupQueryResult proProjectCskuReDomain = this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
        List proSkulist = proProjectCskuReDomain.getList();
        if (proSkulist.isEmpty()) {
            this.logger.error(CODE + ".proSkulist", (Object)"proSkulist is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4ea7\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ProProjectCskuReDomain proProjectCskuReDomain1 = (ProProjectCskuReDomain)proSkulist.get(0);
        String companyShortname = proProjectCskuReDomain1.getCompanyShortname();
        if (null == companyShortname || companyShortname.isEmpty()) {
            this.logger.error(CODE + ".companyShortname", (Object)"companyShortname is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u5148\u5206\u914d\u516c\u53f8\u518d\u5f00\u59cb\u5b9e\u65bd");
        }
        return this.proProjectCskuServiceRepository.updateProjectCskuStateByCode(tenantCode, projectCskuCode, Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"updateProjectOverState.json"}, name="\u9879\u76ee\u5b8c\u6210")
    @ResponseBody
    public HtmlJsonReBean updateProjectOverState(HttpServletRequest request, String projectCskuCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCskuCode)) {
            this.logger.error(CODE + ".updateProjectOverState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        return this.proProjectCskuServiceRepository.updateProjectCskuStateByCode(tenantCode, projectCskuCode, Integer.valueOf(2), Integer.valueOf(1));
    }

    @RequestMapping(value={"deleteProjectCsku.json"}, name="\u5220\u9664\u9879\u76ee\u5ba2\u6237\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteProjectCsku(Integer projectCskuId) {
        if (StringUtils.isBlank((Integer)projectCskuId)) {
            this.logger.error(CODE + ".deleteProjectCsku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectCskuServiceRepository.deleteProjectCsku(projectCskuId);
    }

    @RequestMapping(value={"queryProjectCskuPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u5ba2\u6237\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectCskuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
    }

    @RequestMapping(value={"updateProjectCskuState.json"}, name="\u66f4\u65b0\u9879\u76ee\u5ba2\u6237\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectCskuState(String projectCskuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectCskuId)) {
            this.logger.error(CODE + ".updateProjectCskuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectCskuServiceRepository.updateProjectCskuState(Integer.valueOf(projectCskuId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryProjectCskuPageByUserCodeForB.json"}, name="B\u7aef\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectCskuPageByUserCodeForB(HttpServletRequest request, String userCode) {
        SupQueryResult org;
        List list;
        Map map = this.assemMapParam(request);
        if (null != map) {
            map.put("userCode", userCode);
            map.put("order", true);
            map.put("fuzzy", true);
            map.remove("dataState");
        }
        if ((list = (org = this.orgEmployeeServiceRepository.queryEmployeePage(map)).getList()).isEmpty()) {
            this.logger.error("list null");
            return null;
        }
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)list.get(0);
        String employeeCode = orgEmployeeReDomain.getEmployeeCode();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("employeeCode", employeeCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
    }

    @RequestMapping(value={"queryProjectCskuByDepartCodeForB.json"}, name="B\u7aef\u6839\u636e\u90e8\u95e8\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectCskuByDepartCodeForB(HttpServletRequest request) {
        SupQueryResult org;
        List list;
        UserSession userSession = this.getUserSession(request);
        String userinfoCode = userSession.getUserPcode();
        Map map = this.assemMapParam(request);
        if (null != map) {
            map.put("userinfoCode", userinfoCode);
            map.put("order", true);
            map.put("fuzzy", true);
        }
        if ((list = (org = this.orgDepartServiceRepository.queryDepartempPage(map)).getList()).isEmpty()) {
            this.logger.error("list null");
            return null;
        }
        OrgDepartempReDomain orgDepartempReDomain = (OrgDepartempReDomain)list.get(0);
        String departCode = orgDepartempReDomain.getDepartCode();
        Map param = this.assemMapParam(request);
        if (null != param) {
            if (StringUtils.isNotBlank((String)departCode)) {
                param.put("departCode", departCode);
            }
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
    }

    @RequestMapping(value={"queryProjectCskuByCompanyCodeForB.json"}, name="B\u7aef\u6839\u636e\u4f01\u4e1a\u67e5\u8be2\u9879\u76ee")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectCskuByCompanyCodeForB(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String companyCode = this.getCompanyCode(request);
        if (null != param) {
            param.put("companyCode", companyCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
    }

    @RequestMapping(value={"companyAssignProject.json"}, name="B\u7aef\u516c\u53f8\u5206\u6d3e\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean companyAssignProject(HttpServletRequest request, String projectCskuId, String departCode, String departName, String employeeCode, String employeeName) {
        ProProjectCskuReDomain proProjectCskuDomain = this.proProjectCskuServiceRepository.getProjectCsku(Integer.valueOf(Integer.parseInt(projectCskuId)));
        if (null == proProjectCskuDomain) {
            this.logger.error(CODE + ".companyAssignProject", (Object)"no project");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "no project");
        }
        OrgEmployeeReDomain orgEmployeeReDomain = this.orgEmployeeServiceRepository.getEmployeeByCode(this.getTenantCode(request), employeeCode);
        if (null == orgEmployeeReDomain) {
            this.logger.error(CODE + ".companyAssignProject", (Object)"no employee");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "no employee");
        }
        proProjectCskuDomain.setDepartCode(departCode);
        proProjectCskuDomain.setMemberContactPhone(orgEmployeeReDomain.getEmployeePhone());
        proProjectCskuDomain.setDepartName(departName);
        proProjectCskuDomain.setEmployeeCode(employeeCode);
        proProjectCskuDomain.setEmployeeName(employeeName);
        return this.proProjectCskuServiceRepository.updateProjectCsku((ProProjectCskuDomain)proProjectCskuDomain);
    }

    @RequestMapping(value={"queryProjectCskuByDepartCodeToB.json"}, name="B\u7aef\u6839\u636e\u90e8\u95e8Code\u67e5\u8be2\u90e8\u95e8\u9879\u76ee")
    @ResponseBody
    public SupQueryResult<ProProjectCskuReDomain> queryProjectCskuByDepartCodeToB(HttpServletRequest request, String departCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("departCode", departCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectCskuServiceRepository.queryProjectCskuPage(param);
    }
}

