/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.qt.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.qt.domain.QtRecruitDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtRecruitReDomain;
import com.qjsoft.laser.controller.facade.qt.repository.QtRecruitServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/qt/recruit"}, name="\u62db\u8058\u62a5\u8868\u670d\u52a1")
public class QtRecruitCon
extends SpringmvcController {
    private static String CODE = "qt.recruit.con";
    @Autowired
    private QtRecruitServiceRepository qtRecruitServiceRepository;

    protected String getContext() {
        return "recruit";
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u8058\u62a5\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, String CityType) {
        HashMap<String, String> paramMap = null;
        if (StringUtils.isNotBlank((String)CityType)) {
            paramMap = new HashMap<String, String>();
            paramMap.put("CityType", CityType);
        }
        Map qtRecruitCityList = this.qtRecruitServiceRepository.getQtRecruitCityList(paramMap);
        return new HtmlJsonReBean(qtRecruitCityList.get("citys"));
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u8058\u62a5\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, QtRecruitDomain qtRecruitDomain) {
        if (null == qtRecruitDomain) {
            this.logger.error(CODE + ".saveRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtRecruitDomain.setTenantCode(this.getTenantCode(request));
        this.makeParam(request, qtRecruitDomain);
        return this.qtRecruitServiceRepository.saverecruit(qtRecruitDomain);
    }

    private void makeParam(HttpServletRequest request, QtRecruitDomain qtRecruitDomain) {
        UserSession userSession = this.getUserSession(request);
        qtRecruitDomain.setMemberBcode(userSession.getUserPcode());
        qtRecruitDomain.setMemberBname(userSession.getUserName());
        qtRecruitDomain.setChannelCode(this.getChannelCodeByUser(request));
        qtRecruitDomain.setTginfoCode(this.getTenantCode(request));
        qtRecruitDomain.setChannelName(this.getChannelName(this.getChannelCodeByUser(request), request));
        qtRecruitDomain.setProappCode(this.getProappCode(request));
        qtRecruitDomain.setMemberCode(userSession.getUserPcode());
    }

    @RequestMapping(value={"getRecruit.json"}, name="\u83b7\u53d6\u62db\u8058\u62a5\u8868\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public QtRecruitReDomain getRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".getRecruit", (Object)"param is null");
            return null;
        }
        return this.qtRecruitServiceRepository.getrecruit(recruitId);
    }

    @RequestMapping(value={"updateRecruit.json"}, name="\u66f4\u65b0\u62db\u8058\u62a5\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruit(HttpServletRequest request, QtRecruitDomain qtRecruitDomain) {
        if (null == qtRecruitDomain) {
            this.logger.error(CODE + ".updateRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtRecruitDomain.setTenantCode(this.getTenantCode(request));
        return this.qtRecruitServiceRepository.updaterecruit(qtRecruitDomain);
    }

    @RequestMapping(value={"deleteRecruit.json"}, name="\u5220\u9664\u62db\u8058\u62a5\u8868\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".deleteRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtRecruitServiceRepository.deleterecruit(recruitId);
    }

    @RequestMapping(value={"queryRecruitPage.json"}, name="\u67e5\u8be2\u62db\u8058\u62a5\u8868\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QtRecruitReDomain> queryRecruitPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.qtRecruitServiceRepository.queryrecruitPage(param);
    }

    @RequestMapping(value={"updateRecruitState.json"}, name="\u66f4\u65b0\u62db\u8058\u62a5\u8868\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitState(String recruitId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)recruitId)) {
            this.logger.error(CODE + ".updateRecruitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtRecruitServiceRepository.updaterecruitState(Integer.valueOf(recruitId), dataState, oldDataState, null);
    }
}

