/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.rec.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rec.domain.RecSupplierDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecSupplierReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.UmUserInfoReDomain;
import com.qjsoft.laser.controller.facade.rec.repository.RecSupplierServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.UmUserInfoRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/supplier"}, name="\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1")
public class SupplierCon
extends SpringmvcController {
    private static String CODE = "rec.supplier.con";
    @Autowired
    private RecSupplierServiceRepository recSupplierServiceRepository;
    @Autowired
    private UmUserInfoRepository umUserInfoRepository;

    protected String getContext() {
        return "supplier";
    }

    @RequestMapping(value={"saveSupplier.json"}, name="\u589e\u52a0\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveSupplier(HttpServletRequest request, String paramStr) {
        this.logger.error("----saveSupplier\u5f00\u59cb-----", (Object)paramStr);
        if (null == paramStr) {
            this.logger.error(CODE + ".saveSupplier", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        UmUserInfoReDomain userInfoReDomain = (UmUserInfoReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, UmUserInfoReDomain.class);
        if (null == userInfoReDomain) {
            this.logger.error(CODE + ".userInfoReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userInfoReDomain is null");
        }
        RecSupplierDomain supplierReDomain = null;
        if (null != userInfoReDomain) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userinfoCompname", userInfoReDomain.getUserinfoCompname());
            map.put("fuzzy", false);
            SupQueryResult userInfoPage = this.umUserInfoRepository.queryUmUserInfoPage(map);
            UmUserInfoReDomain domain = (UmUserInfoReDomain)userInfoPage.getList().get(0);
            this.logger.error(CODE + ".saveSupplier." + userInfoPage.getList().size(), (Object)"domain is null");
            if (domain == null) {
                this.logger.error(CODE + ".saveSupplier.domain", (Object)"domain is null");
                HtmlJsonReBean htmlJsonReBean = this.umUserInfoRepository.saveUmUserInfo(domain);
                supplierReDomain.setUserinfoCode((String)htmlJsonReBean.getDataObj());
            }
            if (null != domain) {
                this.logger.error(CODE + ".saveSupplier.userinfoCode" + domain.getUserinfoCode(), (Object)"userinfoCode");
                supplierReDomain.setUserinfoCode(domain.getUserinfoCode());
            }
            this.logger.error(CODE + ".saveSupplier.getUserinfoType" + domain.getUserinfoType(), (Object)"getUserinfoType");
            supplierReDomain.setSupplierType(domain.getUserinfoType() == 2 ? "01" : "00");
            this.logger.error(CODE + ".saveSupplier.getUserinfoCompname" + domain.getUserinfoCompname(), (Object)"getUserinfoCompname");
            supplierReDomain.setSupplierName(domain.getUserinfoCompname());
            supplierReDomain.setSupplierSource("1");
            supplierReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (supplierReDomain == null) {
            this.logger.error(CODE + ".saveSupplier.supplierReDomain", (Object)"supplierReDomain is null");
        }
        return this.recSupplierServiceRepository.saveSupplier(supplierReDomain);
    }

    @RequestMapping(value={"getSupplier.json"}, name="\u83b7\u53d6\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecSupplierReDomain getSupplier(Integer supplierId) {
        if (StringUtils.isBlank((Integer)supplierId)) {
            this.logger.error(CODE + ".getSupplier", (Object)"param is null");
            return null;
        }
        RecSupplierReDomain supplier = this.recSupplierServiceRepository.getSupplier(supplierId);
        UmUserInfoReDomain umUserInfoReDomain = this.umUserInfoRepository.getUmUserInfoByCode(supplier.getTenantCode(), supplier.getUserinfoCode());
        this.logger.error(CODE + ".getSupplier", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserInfoReDomain));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", supplier.getTenantCode());
        map.put("userinfoCode", supplier.getUserinfoCode());
        map.put("fuzzy", false);
        SupQueryResult userInfoPage = this.umUserInfoRepository.queryUmUserInfoPage(map);
        supplier.setUmUserInfoReDomainList(userInfoPage.getList());
        return supplier;
    }

    @RequestMapping(value={"updateSupplier.json"}, name="\u66f4\u65b0\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateSupplier(HttpServletRequest request, RecSupplierDomain RecSupplierDomain2) {
        if (null == RecSupplierDomain2) {
            this.logger.error(CODE + ".updateSupplier", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecSupplierDomain2.setTenantCode(this.getTenantCode(request));
        return this.recSupplierServiceRepository.updateSupplier(RecSupplierDomain2);
    }

    @RequestMapping(value={"deleteSupplier.json"}, name="\u5220\u9664\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteSupplier(Integer supplierId) {
        if (StringUtils.isBlank((Integer)supplierId)) {
            this.logger.error(CODE + ".deleteSupplier", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recSupplierServiceRepository.deleteSupplier(supplierId);
    }

    @RequestMapping(value={"querySupplierPage.json"}, name="\u67e5\u8be2\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecSupplierReDomain> querySupplierPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.recSupplierServiceRepository.querySupplierPage(param);
    }

    @RequestMapping(value={"updateSupplierState.json"}, name="\u66f4\u65b0\u5165\u5e93\u4f9b\u5e94\u5546\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSupplierState(String supplierId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)supplierId)) {
            this.logger.error(CODE + ".updateSupplierState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recSupplierServiceRepository.updateSupplierState(Integer.valueOf(supplierId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateSupplierBlackState.json"}, name="\u52a0\u5165\u9ed1\u540d\u5355")
    @ResponseBody
    public HtmlJsonReBean updateSupplierBlackState(String supplierId, Integer supplierBlack, Integer oldSupplierBlack, HttpServletRequest request) {
        if (StringUtils.isBlank((String)supplierId)) {
            this.logger.error(CODE + ".updateSupplierBlackState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String supplierBlackcause = request.getParameter("supplierBlackcause");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("supplierBlackcause", supplierBlackcause);
        return this.recSupplierServiceRepository.updateSupplierBlackState(Integer.valueOf(supplierId), supplierBlack, oldSupplierBlack, map);
    }

    @RequestMapping(value={"updateSupplierLable.json"}, name="\u5165\u5e93\u4f9b\u5e94\u5546\u8bbe\u7f6e\u6807\u7b7e")
    @ResponseBody
    public HtmlJsonReBean updateSupplierLable(String supplierId, HttpServletRequest request) {
        if (StringUtils.isBlank((String)supplierId)) {
            this.logger.error(CODE + ".updateSupplierLable", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return null;
    }

    @RequestMapping(value={"updateSupplierSort.json"}, name="\u5165\u5e93\u4f9b\u5e94\u5546\u8bbe\u7f6e\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean updateSupplierSort(String supplierId, String suppliersortCode, HttpServletRequest request) {
        if (StringUtils.isBlank((String)supplierId) || StringUtils.isBlank((String)suppliersortCode)) {
            this.logger.error(CODE + ".updateSupplierBlackState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap map = new HashMap();
        return this.recSupplierServiceRepository.updateSupplierSort(Integer.valueOf(supplierId), suppliersortCode, null);
    }
}

