/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.rec.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitEnrollDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitPersonnelReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.UmUserInfoReDomain;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitFileServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitPersonnelServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceAreaServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityQtypeReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityQtypeServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/recruit"}, name="\u62db\u52df\u670d\u52a1")
public class RecruitCon
extends SpringmvcController {
    private static String CODE = "rec.recruit.con";
    @Autowired
    private RecRecruitServiceRepository recRecruitServiceRepository;
    @Autowired
    private RecRecruitEnrollServiceRepository recRecruitEnrollServiceRepository;
    @Autowired
    private RecRecruitOtherServiceRepository recRecruitOtherServiceRepository;
    @Autowired
    private RecRecruitFileServiceRepository recRecruitFileServiceRepository;
    @Autowired
    private RecRecruitPersonnelServiceRepository recRecruitPersonnelServiceRepository;
    @Autowired
    private RecRecruitServiceAreaServiceRepository recRecruitServiceAreaServiceRepository;
    @Autowired
    private UmQualityQtypeServiceRepository umQualityQtypeServiceRepository;

    protected String getContext() {
        return "recruit";
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, String paramStr) {
        UserSession userSession;
        this.logger.error("saveRecruit----------------------------------paramStr------------------------------" + paramStr);
        if (null == paramStr) {
            this.logger.error(CODE + ".saveRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error(CODE + ".recRecruitReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if ("02".equals(recRecruitReDomain.getRecruitType()) && (recRecruitReDomain.getRecRecruitPersonnelList() == null || recRecruitReDomain.getRecRecruitPersonnelList().size() < 3)) {
            this.logger.error(CODE + ".recRecruitReDomain", (Object)"recRecruitPersonnelList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u73ed\u7ec4\u7684\u521b\u5efa\u4e0d\u5f97\u5c11\u4e8e3\u4e2a\u4eba\uff01");
        }
        if (null != recRecruitReDomain) {
            recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (null != (userSession = this.getUserSession(request))) {
            recRecruitReDomain.setMemberBname(userSession.getUserName());
            recRecruitReDomain.setMemberName(userSession.getUserRelname());
            recRecruitReDomain.setMemberCode(this.getUserInfo(request).getUserInfoCode());
            recRecruitReDomain.setMemberBcode(userSession.getUserCode());
        }
        this.logger.error(CODE, (Object)("RecRecruitEnrollList:" + recRecruitReDomain.getRecRecruitEnrollList().size()));
        return this.recRecruitServiceRepository.saveRecruit(recRecruitReDomain);
    }

    @RequestMapping(value={"getRecruit.json"}, name="\u83b7\u53d6\u62db\u52df\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getRecruit(HttpServletRequest request, Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".getRecruit", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruit(recruitId);
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = null;
        if (null != recRecruitReDomain && StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            recRecruitEnrollDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(map).getList();
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            recRecruitFileDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
            System.out.println("recRecruitReDomain.getRecruitType------------------------888889----------------------------" + recRecruitReDomain.getRecruitType());
            if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitType()) && recRecruitReDomain.getRecruitType().equals("02")) {
                SupQueryResult supQueryResult = this.recRecruitPersonnelServiceRepository.queryRecRecruitPersonnelPage(map);
                List recRecruitPersonnelReDomainList = null;
                System.out.println("supQueryResult.getList------------------------88888889---------------------------------" + supQueryResult.getList());
                if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    recRecruitPersonnelReDomainList = supQueryResult.getList();
                    for (int i = 0; i < recRecruitPersonnelReDomainList.size(); ++i) {
                        HashMap<String, String> map0 = new HashMap<String, String>();
                        map0.put("tenantCode", tenantCode);
                        map0.put("memberCode", ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).getMemberCode());
                        SupQueryResult supQueryResult0 = this.recRecruitServiceAreaServiceRepository.queryRecRecruitServiceAreaPage(map0);
                        ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).setRecRecruitServiceAreaReDomainList(supQueryResult0.getList());
                    }
                }
                recRecruitReDomain.setRecRecruitPersonnelList(recRecruitPersonnelReDomainList);
            }
        }
        return recRecruitReDomain;
    }

    @RequestMapping(value={"updateRecruit.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruit(HttpServletRequest request, String paramStr) {
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error(CODE + ".updateRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        return this.recRecruitServiceRepository.updateRecruit((RecRecruitDomain)recRecruitReDomain);
    }

    @RequestMapping(value={"deleteRecruit.json"}, name="\u5220\u9664\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".deleteRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.deleteRecruit(recruitId);
    }

    @RequestMapping(value={"queryRecruitPage.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPage(HttpServletRequest request, String qualityQtypeCode) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        String map = param.toString();
        String type = request.getParameter("type");
        String searchType = request.getParameter("searchType");
        StringBuffer childList = new StringBuffer();
        if (StringUtils.isNotBlank((String)qualityQtypeCode)) {
            if (StringUtils.isNotBlank((String)searchType) && "1".equals(searchType)) {
                childList.append(qualityQtypeCode);
            } else {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("qualityQtypePcode", qualityQtypeCode);
                map1.put("tenantCode", this.getTenantCode(request));
                SupQueryResult UmQualityQtype = this.umQualityQtypeServiceRepository.queryQualityQtypePage(map1);
                if (UmQualityQtype == null || ListUtil.isEmpty((Collection)UmQualityQtype.getList())) {
                    return new SupQueryResult();
                }
                for (UmQualityQtypeReDomain q : UmQualityQtype.getList()) {
                    childList.append(q.getQualityQtypeCode() + ",");
                }
            }
        }
        if (null != param) {
            if (StringUtils.isNotBlank((String)type) && "2".equals(type)) {
                param.put("memberBcode", userSession.getUserCode());
            }
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_CREATE desc");
            param.put("tenantCode", this.getTenantCode(request));
            if (childList != null) {
                param.put("qualityQtypeCode", childList);
            }
        }
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", true);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(enrollList.size()));
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            String flag = "0";
            for (RecRecruitEnrollDomain rr : enrollList) {
                if (null == rr.getDataState() || rr.getDataState() != 1) continue;
                ++count;
                if (userSession.getUserCode() == null || !StringUtils.isNotBlank((String)userSession.getUserCode()) || !rr.getMemberCode().equals(userSession.getUserCode())) continue;
                flag = "1";
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitOrigin(flag);
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"updateRecruitState.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitState(String recruitId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)recruitId)) {
            this.logger.error(CODE + ".updateRecruitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.updateRecruitState(Integer.valueOf(recruitId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryCountByState.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryCountByState(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int dataState = 0;
        return this.recRecruitServiceRepository.queryCountByState(tenantCode, dataState);
    }

    @RequestMapping(value={"queryCountByState1.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e1")
    @ResponseBody
    public HtmlJsonReBean queryCountByState1(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        int dataState = 0;
        return this.recRecruitServiceRepository.queryCountByState1(tenantCode, dataState, recruitType, userSession.getUserCode());
    }

    @RequestMapping(value={"userAcitivyPage.json"}, name="\u7528\u6237\u6d3b\u8dc3\u5ea6\u6392\u884c")
    @ResponseBody
    public SupQueryResult<UmUserInfoReDomain> userActivityPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.userAcitivyPage(param);
        return supQueryResult;
    }

    @RequestMapping(value={"queryRecruitPageC.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPageC(HttpServletRequest request, String qualityQtypeCode) {
        UserSession userSession = this.getUserSession(request);
        Map param = this.assemMapParam(request);
        StringBuffer recruitCode = new StringBuffer();
        String map = param.toString();
        String type = request.getParameter("type");
        String searchType = request.getParameter("searchType");
        StringBuffer childList = new StringBuffer();
        if (StringUtils.isNotBlank((String)qualityQtypeCode)) {
            if (StringUtils.isNotBlank((String)searchType) && "1".equals(searchType)) {
                childList.append(qualityQtypeCode);
            } else {
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("qualityQtypePcode", qualityQtypeCode);
                map1.put("tenantCode", this.getTenantCode(request));
                SupQueryResult UmQualityQtype = this.umQualityQtypeServiceRepository.queryQualityQtypePage(map1);
                if (UmQualityQtype == null || ListUtil.isEmpty((Collection)UmQualityQtype.getList())) {
                    return new SupQueryResult();
                }
                for (UmQualityQtypeReDomain q : UmQualityQtype.getList()) {
                    childList.append(q.getQualityQtypeCode() + ",");
                }
            }
        }
        HashMap<String, Object> param1 = new HashMap<String, Object>();
        param1.put("fuzzy", true);
        param1.put("tenantCode", this.getTenantCode(request));
        param1.put("memberCode", userSession.getUserPcode());
        List recEnrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(param1).getList();
        if (recEnrollList != null && ListUtil.isNotEmpty((Collection)recEnrollList)) {
            for (RecRecruitEnrollDomain recEnroll : recEnrollList) {
                if (param.get(recruitCode) != null) {
                    if (!recEnroll.getRecruitCode().matches(".*" + param.get(recruitCode) + ".*")) continue;
                    recruitCode.append(recEnroll.getRecruitCode() + ",");
                    continue;
                }
                recruitCode.append(recEnroll.getRecruitCode() + ",");
            }
        }
        if (StringUtils.isEmpty((String)recruitCode.toString()) || recruitCode.length() == 0) {
            return new SupQueryResult();
        }
        if (null != param) {
            if (StringUtils.isNotBlank((String)String.valueOf(childList))) {
                param.put("qualityQtypeCode", childList);
            }
            if (StringUtils.isNotBlank((String)type) && "2".equals(type)) {
                param.put("memberBcode", userSession.getUserCode());
            }
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_CREATE desc");
            param.put("tenantCode", this.getTenantCode(request));
            param.put("recruitObj", "2");
            param.put("recruitCode", recruitCode);
        }
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", true);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(enrollList.size()));
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            String flag = "0";
            if (!ListUtil.isNotEmpty((Collection)enrollList)) continue;
            for (RecRecruitEnrollDomain rr : enrollList) {
                if (null == rr.getDataState() || rr.getDataState() != 1) continue;
                ++count;
                if (userSession.getUserCode() == null || !StringUtils.isNotBlank((String)userSession.getUserCode()) || !rr.getMemberCode().equals(userSession.getUserCode())) continue;
                flag = "1";
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitOrigin(flag);
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }
}

