/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.res.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateGoodsDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateGoodsReDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateScopeDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateScopeReDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateShopDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResEvaluateShopReDomain;
import com.qjsoft.laser.controller.facade.res.repository.ResEvaluateReplyServiceRepository;
import com.qjsoft.laser.controller.facade.res.repository.ResEvaluateServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/res/evaluate"}, name="\u8ba2\u5355\u8bc4\u4ef7")
public class EvaluateCon
extends SpringmvcController {
    private static String CODE = "res.evaluate.con";
    @Autowired
    private ResEvaluateServiceRepository resEvaluateServiceRepository;
    @Autowired
    private ResEvaluateReplyServiceRepository resEvaluateReplyServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "evaluate";
    }

    @RequestMapping(value={"saveEvaluateGoods.json"}, name="\u589e\u52a0\u8ba2\u5355\u5546\u54c1\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean saveEvaluateGoods(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveEvaluateGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String tenantCode = this.getTenantCode(request);
        String msg = null;
        List evaluateGoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, ResEvaluateGoodsDomain.class);
        for (ResEvaluateGoodsDomain resEvaluateGoodsDomain : evaluateGoodsDomainList) {
            resEvaluateGoodsDomain.setTenantCode(tenantCode);
            resEvaluateGoodsDomain.setMemberBcode(userSession.getUserPcode());
            resEvaluateGoodsDomain.setMemberBname(userSession.showUserName());
            resEvaluateGoodsDomain.setEvaluateGoodsShow(Boolean.valueOf(true));
            HtmlJsonReBean hrb = this.resEvaluateServiceRepository.sendEvaluateGoods(resEvaluateGoodsDomain);
            if (hrb.isSuccess()) continue;
            msg = msg + hrb.getMsg() + ",";
        }
        if (msg == null) {
            msg = "ok";
        }
        return new HtmlJsonReBean((Object)msg);
    }

    @RequestMapping(value={"getEvaluateGoods.json"}, name="\u83b7\u53d6\u8ba2\u5355\u5546\u54c1\u8bc4\u4ef7\u4fe1\u606f")
    @ResponseBody
    public ResEvaluateGoodsReDomain getEvaluateGoods(HttpServletRequest request, String evaluateGoodsId) {
        if (StringUtils.isBlank((String)evaluateGoodsId)) {
            this.logger.error(CODE + ".getEvaluateGoods", (Object)"param is null");
            return null;
        }
        ResEvaluateGoodsReDomain goodsRe = this.resEvaluateServiceRepository.getEvaluateGoods(Integer.valueOf(evaluateGoodsId));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("evaluateGoodsCode", goodsRe.getEvaluateGoodsCode());
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult replyRe = this.resEvaluateReplyServiceRepository.queryEvaluateReplyPage(param);
        List replyReList = replyRe.getList();
        if (replyReList != null) {
            goodsRe.setShopReply(replyReList);
        }
        return goodsRe;
    }

    @RequestMapping(value={"updateEvaluateGoods.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5546\u54c1\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateGoods(HttpServletRequest request, ResEvaluateGoodsDomain resEvaluateGoodsDomain) {
        if (null == resEvaluateGoodsDomain) {
            this.logger.error(CODE + ".updateEvaluateGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resEvaluateGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.resEvaluateServiceRepository.updateEvaluateGoods(resEvaluateGoodsDomain);
    }

    @RequestMapping(value={"deleteEvaluateGoods.json"}, name="\u5220\u9664\u8ba2\u5355\u5546\u54c1\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean deleteEvaluateGoods(String evaluateGoodsId) {
        if (StringUtils.isBlank((String)evaluateGoodsId)) {
            this.logger.error(CODE + ".deleteEvaluateGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.deleteEvaluateGoods(Integer.valueOf(evaluateGoodsId));
    }

    @RequestMapping(value={"queryEvaluateGoodsPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u8bc4\u4ef7\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResEvaluateGoodsReDomain> queryEvaluateGoodsPage(HttpServletRequest request) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (!(list = (result = this.resEvaluateServiceRepository.queryEvaluateGoodsPage(param)).getList()).isEmpty()) {
            for (ResEvaluateGoodsReDomain resEvaluateGoodsReDomain : list) {
                String evaluateGoodsImgs;
                String userCode = resEvaluateGoodsReDomain.getMemberBcode();
                UmUserReDomainBean user = this.userServiceRepository.getUserByCode(userCode);
                if (user != null) {
                    String userImgurl = user.getUserImgurl();
                    resEvaluateGoodsReDomain.setUserImgurl(userImgurl);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("evaluateGoodsCode", resEvaluateGoodsReDomain.getEvaluateGoodsCode());
                map.put("tenantCode", this.getTenantCode(request));
                SupQueryResult replyRe = this.resEvaluateReplyServiceRepository.queryEvaluateReplyPage(map);
                List replyReList = replyRe.getList();
                if (replyReList != null) {
                    resEvaluateGoodsReDomain.setShopReply(replyReList);
                }
                if ((evaluateGoodsImgs = resEvaluateGoodsReDomain.getEvaluateGoodsImgs()) == null) continue;
                String[] imgs = evaluateGoodsImgs.split(",");
                resEvaluateGoodsReDomain.setEvaluateGoodsImgsList(Arrays.asList(imgs));
            }
        }
        return result;
    }

    @RequestMapping(value={"updateEvaluateGoodsState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5546\u54c1\u8bc4\u4ef7\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateGoodsState(String evaluateGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)evaluateGoodsId)) {
            this.logger.error(CODE + ".updateEvaluateGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.updateEvaluateGoodsState(Integer.valueOf(evaluateGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateGoodsShow.json"}, name="\u66f4\u65b0\u5546\u54c1\u8bc4\u4ef7\u663e\u793a\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGoodsShow(String evaluateGoodsId, Boolean show) {
        if (StringUtils.isBlank((String)evaluateGoodsId) || show == null) {
            this.logger.error(CODE + ".updateGoodsShow", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.updateGoodsShow(Integer.valueOf(evaluateGoodsId), show);
    }

    @RequestMapping(value={"checkCanEvaluate.json"}, name="\u68c0\u67e5\u5e97\u94fa/\u5546\u54c1\u662f\u5426\u5df2\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean checkCanEvaluate(String orderCode, String bgcode, String type) {
        if (StringUtils.hasBlank((String[])new String[]{orderCode, bgcode, type})) {
            this.logger.error(CODE + ".checkCanEvaluate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (!"shop,goods".contains(type)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u6709\u8bef");
        }
        return this.resEvaluateServiceRepository.checkCanEvaluate(orderCode, bgcode, type);
    }

    @RequestMapping(value={"saveEvaluateShop.json"}, name="\u589e\u52a0\u8ba2\u5355\u5e97\u94fa\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean saveEvaluateShop(HttpServletRequest request, ResEvaluateShopDomain resEvaluateShopDomain, String paramStr) {
        if (null == resEvaluateShopDomain) {
            this.logger.error(CODE + ".saveEvaluateShop", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        resEvaluateShopDomain.setTenantCode(this.getTenantCode(request));
        resEvaluateShopDomain.setMemberBcode(userSession.getUserPcode());
        resEvaluateShopDomain.setMemberBname(userSession.showUserName());
        resEvaluateShopDomain.setEvaluateShopShow(Boolean.valueOf(true));
        List scopeDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, List.class);
        resEvaluateShopDomain.setEvaluateScopeList(scopeDomainList);
        return this.resEvaluateServiceRepository.sendEvaluateShop(resEvaluateShopDomain);
    }

    @RequestMapping(value={"getEvaluateShop.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8bc4\u4ef7\u5e97\u94fa\u4fe1\u606f")
    @ResponseBody
    public ResEvaluateShopReDomain getEvaluateShop(String evaluateShopId) {
        if (StringUtils.isBlank((String)evaluateShopId)) {
            this.logger.error(CODE + ".getEvaluateShop", (Object)"param is null");
            return null;
        }
        return this.resEvaluateServiceRepository.getEvaluateShop(Integer.valueOf(evaluateShopId));
    }

    @RequestMapping(value={"updateEvaluateShop.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5e97\u94fa\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateShop(HttpServletRequest request, ResEvaluateShopDomain resEvaluateShopDomain) {
        if (null == resEvaluateShopDomain) {
            this.logger.error(CODE + ".updateEvaluateShop", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resEvaluateShopDomain.setTenantCode(this.getTenantCode(request));
        return this.resEvaluateServiceRepository.updateEvaluateShop(resEvaluateShopDomain);
    }

    @RequestMapping(value={"deleteEvaluateShop.json"}, name="\u5220\u9664\u8ba2\u5355\u5e97\u94fa\u8bc4\u4ef7")
    @ResponseBody
    public HtmlJsonReBean deleteEvaluateShop(String evaluateShopId) {
        if (StringUtils.isBlank((String)evaluateShopId)) {
            this.logger.error(CODE + ".deleteEvaluateShop", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.deleteEvaluateShop(Integer.valueOf(evaluateShopId));
    }

    @RequestMapping(value={"queryEvaluateShopPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5e97\u94fa\u8bc4\u4ef7\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResEvaluateShopReDomain> queryEvaluateShopPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.resEvaluateServiceRepository.queryEvaluateShopPage(param);
    }

    @RequestMapping(value={"updateEvaluateShopState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u8bc4\u4ef7\u5e97\u94fa\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateShopState(String evaluateShopId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)evaluateShopId)) {
            this.logger.error(CODE + ".updateEvaluateShopState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.updateEvaluateShopState(Integer.valueOf(evaluateShopId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateShopShow.json"}, name="\u66f4\u65b0\u8ba2\u5355\u5e97\u94fa\u8bc4\u4ef7\u662f\u5426\u663e\u793a")
    @ResponseBody
    public HtmlJsonReBean updateShopShow(String evaluateShopId, Boolean show) {
        if (StringUtils.isBlank((String)evaluateShopId)) {
            this.logger.error(CODE + ".updateShopShow", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.updateShopShow(Integer.valueOf(evaluateShopId), show);
    }

    @RequestMapping(value={"getEvaluateShopByOrderCode.json"}, name="\u6839\u636e\u8ba2\u5355\u83b7\u53d6\u5e97\u94fa\u8bc4\u4ef7\uff08\u6309\u5e97\u94fa\u62c6\u5206\u8ba2\u5355\u524d\u63d0\u4e0b\u4f7f\u7528\uff09")
    @ResponseBody
    public ResEvaluateShopReDomain getEvaluateShopByOrderCode(String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".getEvaluateShopByOrderCode", (Object)"param is null");
            return null;
        }
        return this.resEvaluateServiceRepository.getEvaluateShopByOrderCode(contractBillcode);
    }

    @RequestMapping(value={"saveEvaluateScope.json"}, name="\u589e\u52a0\u8ba2\u5355\u8bc4\u4ef7\u8be6\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveEvaluateScope(HttpServletRequest request, ResEvaluateScopeDomain resEvaluateScopeDomain) {
        if (null == resEvaluateScopeDomain) {
            this.logger.error(CODE + ".saveEvaluateScope", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resEvaluateScopeDomain.setTenantCode(this.getTenantCode(request));
        return this.resEvaluateServiceRepository.saveEvaluateScope(resEvaluateScopeDomain);
    }

    @RequestMapping(value={"getEvaluateScope.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8bc4\u4ef7\u8be6\u7ec6\u4fe1\u606f")
    @ResponseBody
    public ResEvaluateScopeReDomain getEvaluateScope(String evaluateScopeId) {
        if (StringUtils.isBlank((String)evaluateScopeId)) {
            this.logger.error(CODE + ".getEvaluateScope", (Object)"param is null");
            return null;
        }
        return this.resEvaluateServiceRepository.getEvaluateScope(Integer.valueOf(evaluateScopeId));
    }

    @RequestMapping(value={"updateEvaluateScope.json"}, name="\u66f4\u65b0\u8ba2\u5355\u8bc4\u4ef7\u8be6\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateScope(HttpServletRequest request, ResEvaluateScopeDomain resEvaluateScopeDomain) {
        if (null == resEvaluateScopeDomain) {
            this.logger.error(CODE + ".updateEvaluateScope", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resEvaluateScopeDomain.setTenantCode(this.getTenantCode(request));
        return this.resEvaluateServiceRepository.updateEvaluateScope(resEvaluateScopeDomain);
    }

    @RequestMapping(value={"deleteEvaluateScope.json"}, name="\u5220\u9664\u8ba2\u5355\u8bc4\u4ef7\u8be6\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteEvaluateScope(String evaluateScopeId) {
        if (StringUtils.isBlank((String)evaluateScopeId)) {
            this.logger.error(CODE + ".deleteEvaluateScope", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.deleteEvaluateScope(Integer.valueOf(evaluateScopeId));
    }

    @RequestMapping(value={"queryEvaluateScopePage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u8bc4\u4ef7\u8be6\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResEvaluateScopeReDomain> queryEvaluateScopePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.resEvaluateServiceRepository.queryEvaluateScopePage(param);
    }

    @RequestMapping(value={"updateEvaluateScopeState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u8bc4\u4ef7\u8be6\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEvaluateScopeState(String evaluateScopeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)evaluateScopeId)) {
            this.logger.error(CODE + ".updateEvaluateScopeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resEvaluateServiceRepository.updateEvaluateScopeState(Integer.valueOf(evaluateScopeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryEvaluateGoodsPageByUser.json"}, name="\u4e70\u5bb6\u7aef\u8bc4\u8bba\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ResEvaluateGoodsReDomain> queryEvaluateGoodsPageByUser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("memberBcode", this.getUserInfo(request).getUserCode());
        param.put("order", true);
        param.put("fuzzy", true);
        return this.resEvaluateServiceRepository.queryEvaluateGoodsPage(param);
    }
}

