/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.res.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.res.domain.ResConfigDomain;
import com.qjsoft.laser.controller.facade.res.domain.ResConfigReDomain;
import com.qjsoft.laser.controller.facade.res.repository.ResConfigServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/res/config"}, name="\u8bc4\u4ef7\u914d\u7f6e")
public class ConfigCon
extends SpringmvcController {
    private static String CODE = "res.config.con";
    @Autowired
    private ResConfigServiceRepository resConfigServiceRepository;

    protected String getContext() {
        return "config";
    }

    @RequestMapping(value={"saveConfig.json"}, name="\u589e\u52a0\u8bc4\u4ef7\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveConfig(HttpServletRequest request, ResConfigDomain resConfigDomain) {
        if (null == resConfigDomain) {
            this.logger.error(CODE + ".saveConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resConfigDomain.setTenantCode(this.getTenantCode(request));
        return this.resConfigServiceRepository.saveConfig(resConfigDomain);
    }

    @RequestMapping(value={"getConfig.json"}, name="\u83b7\u53d6\u8bc4\u4ef7\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public ResConfigReDomain getConfig(String configId) {
        if (StringUtils.isBlank((String)configId)) {
            this.logger.error(CODE + ".getConfig", (Object)"param is null");
            return null;
        }
        return this.resConfigServiceRepository.getConfig(Integer.valueOf(configId));
    }

    @RequestMapping(value={"updateConfig.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateConfig(HttpServletRequest request, ResConfigDomain resConfigDomain) {
        if (null == resConfigDomain) {
            this.logger.error(CODE + ".updateConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        resConfigDomain.setTenantCode(this.getTenantCode(request));
        return this.resConfigServiceRepository.updateConfig(resConfigDomain);
    }

    @RequestMapping(value={"deleteConfig.json"}, name="\u5220\u9664\u8bc4\u4ef7\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteConfig(String configId) {
        if (StringUtils.isBlank((String)configId)) {
            this.logger.error(CODE + ".deleteConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resConfigServiceRepository.deleteConfig(Integer.valueOf(configId));
    }

    @RequestMapping(value={"queryConfigPage.json"}, name="\u67e5\u8be2\u8bc4\u4ef7\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult queryConfigPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.resConfigServiceRepository.queryConfigPage(param);
    }

    @RequestMapping(value={"updateConfigState.json"}, name="\u66f4\u65b0\u8bc4\u4ef7\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateConfigState(String configId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)configId)) {
            this.logger.error(CODE + ".updateConfigState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.resConfigServiceRepository.updateConfigState(Integer.valueOf(configId), dataState, oldDataState);
    }
}

