/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/pntree"}, name="\u5546\u54c1\u7c7b\u578b")
public class RsPntreeCon
extends SpringmvcController {
    private static String CODE = "rs.pntree.con";
    @Autowired
    private RsPntreeServiceRepository rsPntreeServiceRepository;

    protected String getContext() {
        return "pntree";
    }

    @RequestMapping(value={"savePntree.json"}, name="\u589e\u52a0\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean savePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".savePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<String> checklist = new ArrayList<String>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.rsPntreeServiceRepository.queryPntreePage(param);
        List list = result.getList();
        for (RsPntreeReDomain rsPntreeReDomain : list) {
            checklist.add(rsPntreeReDomain.getPntreeName());
        }
        if (checklist.contains(rsPntreeDomain.getPntreeName())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u91cd\u590d");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeServiceRepository.savePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"getPntree.json"}, name="\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u4fe1\u606f")
    @ResponseBody
    public RsPntreeReDomain getPntree(String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".getPntree", (Object)"param is null");
            return null;
        }
        return this.rsPntreeServiceRepository.getPntree(Integer.valueOf(pntreeId));
    }

    @RequestMapping(value={"updatePntree.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean updatePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".updatePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeServiceRepository.updatePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"deletePntree.json"}, name="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean deletePntree(String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsPntreeServiceRepository.deletePntree(Integer.valueOf(pntreeId));
    }

    @RequestMapping(value={"queryPntreeTree.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreePage.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsPntreeReDomain> queryPntreePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.queryPntreePage(param);
    }

    @RequestMapping(value={"getChildByPntree.json"}, name="\u83b7\u53d6\u7c7b\u578b\u5b50\u7c7b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> getChildByPntree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.getChildByPntree(param);
    }

    @RequestMapping(value={"updatePntreeState.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePntreeState(String pntreeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".updatePntreeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsPntreeServiceRepository.updatePntreeState(Integer.valueOf(pntreeId), dataState, oldDataState);
    }
}

