/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmTenantReDomain;
import com.qjsoft.laser.controller.facade.tm.repository.TmTenantServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/classtree"}, name="\u5546\u54c1\u5206\u7c7b")
public class RsClassTreeCon
extends SpringmvcController {
    private static String CODE = "rs.classtree.con";
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;
    @Autowired
    private TmTenantServiceRepository tmTenantServiceRepository;

    protected String getContext() {
        return "classtree";
    }

    @RequestMapping(value={"saveClasstree.json"}, name="\u589e\u52a0\u5546\u54c1\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean saveClasstree(HttpServletRequest request, RsClasstreeReDomain rsClasstreeReDomain) {
        if (null == rsClasstreeReDomain) {
            this.logger.error(CODE + ".saveClasstree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveClasstree", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsClasstreeReDomain.setMemberCode(userSession.getUserPcode());
        rsClasstreeReDomain.setMemberName(userSession.getUserName());
        rsClasstreeReDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("classtreeName", rsClasstreeReDomain.getClasstreeName());
        param.put("tenantCode", rsClasstreeReDomain.getTenantCode());
        param.put("memberCode", rsClasstreeReDomain.getMemberCode());
        SupQueryResult rsClasstreeReDomainSupQueryResult = this.rsClasstreeServiceRepository.queryClasstreePage(param);
        if (null != rsClasstreeReDomainSupQueryResult.getRows() && rsClasstreeReDomainSupQueryResult.getRows().size() > 0) {
            this.logger.error(CODE + ".saveClasstree", (Object)"\u5546\u54c1\u5206\u7c7b\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        return this.rsClasstreeServiceRepository.saveClasstree((RsClasstreeDomain)rsClasstreeReDomain);
    }

    @RequestMapping(value={"getClasstree.json"}, name="\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u4fe1\u606f")
    @ResponseBody
    public RsClasstreeReDomain getClasstree(String classtreeId) {
        if (StringUtils.isBlank((String)classtreeId)) {
            this.logger.error(CODE + ".getClasstree", (Object)"param is null");
            return null;
        }
        return this.rsClasstreeServiceRepository.getClasstree(Integer.valueOf(classtreeId));
    }

    @RequestMapping(value={"updateClasstree.json"}, name="\u7f16\u8f91\u5546\u54c1\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean updateClasstree(HttpServletRequest request, RsClasstreeReDomain rsClasstreeReDomain) {
        if (null == rsClasstreeReDomain) {
            this.logger.error(CODE + ".updateClasstree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateClasstree", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsClasstreeReDomain.setMemberCode(userSession.getUserPcode());
        rsClasstreeReDomain.setMemberName(userSession.getUserName());
        rsClasstreeReDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("classtreeName", rsClasstreeReDomain.getClasstreeName());
        param.put("tenantCode", rsClasstreeReDomain.getTenantCode());
        param.put("memberCode", rsClasstreeReDomain.getMemberCode());
        SupQueryResult rsClasstreeReDomainSupQueryResult = this.rsClasstreeServiceRepository.queryClasstreePage(param);
        if (null != rsClasstreeReDomainSupQueryResult.getRows() && rsClasstreeReDomainSupQueryResult.getRows().size() > 0) {
            for (RsClasstreeReDomain rsClasstree : rsClasstreeReDomainSupQueryResult.getList()) {
                if (rsClasstreeReDomain.getClasstreeId().equals(rsClasstree.getClasstreeId())) continue;
                this.logger.error(CODE + ".saveClasstree", (Object)"\u5546\u54c1\u5206\u7c7b\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        }
        return this.rsClasstreeServiceRepository.updateClasstree((RsClasstreeDomain)rsClasstreeReDomain);
    }

    @RequestMapping(value={"deleteClasstree.json"}, name="\u5220\u9664\u5546\u54c1\u5206\u7c7b")
    @ResponseBody
    public HtmlJsonReBean deleteClasstree(String classtreeId) {
        if (StringUtils.isBlank((String)classtreeId)) {
            this.logger.error(CODE + ".deleteClasstree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsClasstreeServiceRepository.deleteClasstree(Integer.valueOf(classtreeId));
    }

    @RequestMapping(value={"queryClasstreePage.json"}, name="\u5e73\u53f0\u5546\u54c1\u5206\u7c7b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsClasstreeReDomain> queryClasstreePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("memberCode", this.getTeananMemberCode(request));
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsClasstreeServiceRepository.queryClasstreePage(param);
    }

    @RequestMapping(value={"queryClasstree.json"}, name="\u5e73\u53f0\u5546\u54c1\u5206\u7c7b\u6811")
    @ResponseBody
    public List<RsClasstreeReDomain> queryClasstree(HttpServletRequest request) {
        return this.rsClasstreeServiceRepository.queryClasstree(this.getTeananMemberCode(request), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryBusinessClasstree.json"}, name="\u5546\u5bb6\u5546\u54c1\u5206\u7c7b\u6811")
    @ResponseBody
    public List<RsClasstreeReDomain> queryBusinessClasstree(HttpServletRequest request) {
        return this.rsClasstreeServiceRepository.queryClasstree(this.getMerchantCode(request), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryBusinessPage.json"}, name="\u5546\u5bb6\u5546\u54c1\u5206\u7c7b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsClasstreeReDomain> queryBusinessPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsClasstreeServiceRepository.queryClasstreePage(param);
    }

    @RequestMapping(value={"queryClasstreePageByPlant.json"}, name="\u5e73\u53f0\u5546\u54c1\u5206\u7c7b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsClasstreeReDomain> queryClasstreePageByPlant(HttpServletRequest request) {
        HashMap<String, Object> param = this.assemMapParam(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        TmTenantReDomain tmTenantReDomain = this.tmTenantServiceRepository.getTenantByCode(map);
        if (null == tmTenantReDomain || StringUtils.isBlank((String)tmTenantReDomain.getTenantOpuser())) {
            return null;
        }
        param.put("memberCode", tmTenantReDomain.getTenantOpuser());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsClasstreeServiceRepository.queryClasstreePage(param);
    }

    @RequestMapping(value={"updateClasstreeState.json"}, name="\u7f16\u8f91\u5546\u54c1\u5206\u7c7b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePntreeState(String classtreeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)classtreeId)) {
            this.logger.error(CODE + ".updateClasstreeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsClasstreeServiceRepository.updateClasstreeState(Integer.valueOf(classtreeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryClasstreeList.json"}, name="\u5546\u54c1\u5206\u7c7b\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsClasstreeReDomain> queryClasstreeList(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("classtreeParentcode", "-1");
        param.put("tenantcode", this.getTenantCode(request));
        SupQueryResult rsClasstreeReDomainList_1 = this.rsClasstreeServiceRepository.queryClasstreePage(param);
        List rsClasstreeReDomainList1 = rsClasstreeReDomainList_1.getRows();
        if (null != rsClasstreeReDomainList1 && rsClasstreeReDomainList1.size() > 0) {
            for (RsClasstreeReDomain rsClasstreeReDomain : rsClasstreeReDomainList1) {
                param.put("classtreeParentcode", rsClasstreeReDomain.getClasstreeCode());
                SupQueryResult rsClasstreeReDomainList_2 = this.rsClasstreeServiceRepository.queryClasstreePage(param);
                List rsClasstreeReDomainList2 = rsClasstreeReDomainList_2.getRows();
                if (null != rsClasstreeReDomainList2 && rsClasstreeReDomainList2.size() > 0) {
                    for (RsClasstreeReDomain rsClasstreeReDomain2 : rsClasstreeReDomainList2) {
                        param.put("classtreeParentcode", rsClasstreeReDomain2.getClasstreeCode());
                        SupQueryResult rsClasstreeReDomainList_3 = this.rsClasstreeServiceRepository.queryClasstreePage(param);
                        rsClasstreeReDomain2.setChildList(rsClasstreeReDomainList_3.getRows());
                    }
                }
                rsClasstreeReDomain.setChildList(rsClasstreeReDomainList2);
            }
        }
        return rsClasstreeReDomainList_1;
    }
}

