/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsClasstreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsClasstreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSpecServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/specGroup"}, name="\u5546\u54c1\u89c4\u683c")
public class RsSpecGroupCon
extends SpringmvcController {
    private static String CODE = "rs.spec.con";
    @Autowired
    private RsSpecServiceRepository rsSpecServiceRepository;
    @Autowired
    private RsClasstreeServiceRepository rsClasstreeServiceRepository;

    protected String getContext() {
        return "spec";
    }

    @RequestMapping(value={"saveSpec.json"}, name="\u589e\u52a0\u5546\u54c1\u89c4\u683c")
    @ResponseBody
    public HtmlJsonReBean saveSpec(HttpServletRequest request, RsSpecDomain rsSpecDomain) {
        if (null == rsSpecDomain) {
            this.logger.error(CODE + ".saveSpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSpecDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSpecServiceRepository.saveSpec(rsSpecDomain);
    }

    @RequestMapping(value={"getSpec.json"}, name="\u83b7\u53d6\u5546\u54c1\u89c4\u683c\u4fe1\u606f")
    @ResponseBody
    public RsSpecReDomain getSpec(String specId) {
        if (StringUtils.isBlank((String)specId)) {
            this.logger.error(CODE + ".getSpec", (Object)"param is null");
            return null;
        }
        return this.rsSpecServiceRepository.getSpec(Integer.valueOf(specId));
    }

    @RequestMapping(value={"updateSpec.json"}, name="\u7f16\u8f91\u5546\u54c1\u89c4\u683c")
    @ResponseBody
    public HtmlJsonReBean updateSpec(HttpServletRequest request, RsSpecDomain rsSpecDomain) {
        if (null == rsSpecDomain) {
            this.logger.error(CODE + ".updateSpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSpecDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSpecServiceRepository.updateSpec(rsSpecDomain);
    }

    @RequestMapping(value={"deleteSpec.json"}, name="\u5220\u9664\u5546\u54c1\u89c4\u683c")
    @ResponseBody
    public HtmlJsonReBean deleteSpec(HttpServletRequest request, String specId) {
        if (StringUtils.isBlank((String)specId)) {
            this.logger.error(CODE + ".deleteSpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSpecReDomain specReDomain = this.rsSpecServiceRepository.getSpec(Integer.valueOf(specId));
        String specCode = specReDomain.getSpecCode();
        if (StringUtils.isBlank((String)specCode)) {
            this.logger.error(CODE + ".deleteSpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("specCode", specCode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult specOptionReDomainSupQueryResult = this.rsSpecServiceRepository.querySpecOptionPage(param);
        if (null != specOptionReDomainSupQueryResult.getList() && specOptionReDomainSupQueryResult.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4f7f\u7528\u4e2d");
        }
        return this.rsSpecServiceRepository.deleteSpec(Integer.valueOf(specId));
    }

    @RequestMapping(value={"querySpecPage.json"}, name="\u5546\u54c1\u89c4\u683c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSpecReDomain> querySpecPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSpecServiceRepository.querySpecPage(param);
    }

    @RequestMapping(value={"saveSpecGroup.json"}, name="\u589e\u52a0\u5546\u54c1\u89c4\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean saveSpecGroup(HttpServletRequest request, RsSpecGroupDomain rsSpecGroupDomain) {
        if (null == rsSpecGroupDomain) {
            this.logger.error(CODE + ".saveSpecGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSpecGroupDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSpecServiceRepository.saveSpecGroup(rsSpecGroupDomain);
    }

    @RequestMapping(value={"getSepcGroup.json"}, name="\u83b7\u53d6\u5546\u54c1\u89c4\u683c\u7ec4\u4fe1\u606f")
    @ResponseBody
    public RsSpecGroupDomain getSepcGroup(String specGroupId) {
        if (StringUtils.isBlank((String)specGroupId)) {
            this.logger.error(CODE + ".getSepcGroup", (Object)"param is null");
            return null;
        }
        return this.rsSpecServiceRepository.getSpecGroup(Integer.valueOf(specGroupId));
    }

    @RequestMapping(value={"editSepcGroup.json"}, name="\u7f16\u8f91\u5546\u54c1\u89c4\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean editSepcGroup(HttpServletRequest request, RsSpecGroupDomain rsSpecGroupDomain) {
        if (null == rsSpecGroupDomain) {
            this.logger.error(CODE + ".editSepcGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSpecGroupDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSpecServiceRepository.updateSpecGroup(rsSpecGroupDomain);
    }

    @RequestMapping(value={"deleteSpecGroup.json"}, name="\u5220\u9664\u5546\u54c1\u89c4\u683c\u7ec4")
    @ResponseBody
    public HtmlJsonReBean deleteSpecGroup(HttpServletRequest request, String specGroupId) {
        if (StringUtils.isBlank((String)specGroupId)) {
            this.logger.error(CODE + ".deleteSpecGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSpecGroupReDomain specGroup = this.rsSpecServiceRepository.getSpecGroup(Integer.valueOf(specGroupId));
        String specGroupCode = specGroup.getSpecGroupCode();
        if (StringUtils.isBlank((String)specGroupCode)) {
            this.logger.error(CODE + ".deleteSpecGroup", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("specGroupCode", specGroupCode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult specReDomainSupQueryResult = this.rsSpecServiceRepository.querySpecPage(param);
        if (StringUtils.isNotBlank((String)specGroup.getPntreeCode()) || null != specReDomainSupQueryResult.getList() && specReDomainSupQueryResult.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4f7f\u7528\u4e2d");
        }
        return this.rsSpecServiceRepository.deleteSpecGroup(Integer.valueOf(specGroupId));
    }

    @RequestMapping(value={"listSpecGroupQuery.json"}, name="\u68c0\u7d22\u89c4\u683c\u7ec4\u5217\u8868")
    public SupQueryResult<RsSpecGroupReDomain> listSpecGroupQuery(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"listSpecGroupQueryFromPntree.json"}, name="\u68c0\u7d22\u89c4\u683c\u7ec4\u5217\u8868 - \u5546\u54c1\u7c7b\u578b")
    public SupQueryResult<RsSpecGroupReDomain> listSpecGroupQueryFromPntree(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    public SupQueryResult<RsSpecGroupReDomain> fetchQuery(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSpecServiceRepository.querySpecGroupPage(param);
    }

    @RequestMapping(value={"querySpecByClasstreeCodeFromConsumer.json"}, name="\u6839\u636e\u5206\u7c7bcode\u67e5\u8be2\u89c4\u683c\u4fe1\u606f-C\u7aef")
    @ResponseBody
    public HtmlJsonReBean querySpecByClasstreeCodeFromConsumer(HttpServletRequest request, String classtreeCode) {
        return this.fetchSpecByClasstreeCode(request, classtreeCode);
    }

    @RequestMapping(value={"querySpecByClasstreeCode.json"}, name="\u6839\u636e\u5206\u7c7bcode\u67e5\u8be2\u89c4\u683c\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean querySpecByClasstreeCode(HttpServletRequest request, String classtreeCode) {
        return this.fetchSpecByClasstreeCode(request, classtreeCode);
    }

    public HtmlJsonReBean fetchSpecByClasstreeCode(HttpServletRequest request, String classtreeCode) {
        if (StringUtils.isBlank((String)classtreeCode)) {
            this.logger.error(CODE + ".querySpecByClasstreeCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", this.getTenantCode(request));
        RsClasstreeReDomain rsClasstreeReDomain = this.rsClasstreeServiceRepository.getClasstreeByCode(map);
        if (null == rsClasstreeReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        HashMap<String, String> pntreeParam = new HashMap<String, String>();
        pntreeParam.put("pntreeCode", rsClasstreeReDomain.getPntreeCode());
        pntreeParam.put("tenantCode", this.getTenantCode(request));
        List rsSpecGroupReDomains = this.rsSpecServiceRepository.getSpecGroupByPntree(pntreeParam);
        if (null == rsSpecGroupReDomains || rsSpecGroupReDomains.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        HashMap<String, String> specParam = new HashMap<String, String>();
        specParam.put("specGroupCode", ((RsSpecGroupReDomain)rsSpecGroupReDomains.get(0)).getSpecGroupCode());
        specParam.put("tenantCode", this.getTenantCode(request));
        SupQueryResult rsSpecReDomainSupQueryResult = this.rsSpecServiceRepository.querySpecPage(specParam);
        ArrayList<RsSpecDomain> specDomainList = new ArrayList<RsSpecDomain>();
        List<Object> specOptionDomains = new ArrayList();
        for (RsSpecDomain specDomain : rsSpecReDomainSupQueryResult.getList()) {
            HashedMap specOtParam = new HashedMap();
            specOtParam.put("specCode", specDomain.getSpecCode());
            specOtParam.put("tenantCode", this.getTenantCode(request));
            SupQueryResult specOptionReDomainSupQueryResult = this.rsSpecServiceRepository.querySpecOptionPage((Map)specOtParam);
            if (null == specOptionReDomainSupQueryResult || null == specOptionReDomainSupQueryResult.getRows() || specOptionReDomainSupQueryResult.getRows().isEmpty()) continue;
            specOptionDomains = this.transformation(specOptionReDomainSupQueryResult.getList());
            specDomain.setSpecOptionList(specOptionDomains);
            specDomainList.add(specDomain);
        }
        ((RsSpecGroupReDomain)rsSpecGroupReDomains.get(0)).setSpecList(specDomainList);
        return new HtmlJsonReBean((Object)rsSpecGroupReDomains);
    }

    public List<RsSpecOptionDomain> transformation(List<RsSpecOptionReDomain> list) {
        ArrayList<RsSpecOptionDomain> result = new ArrayList<RsSpecOptionDomain>();
        for (RsSpecOptionDomain rsSpecOptionDomain : list) {
            result.add(rsSpecOptionDomain);
        }
        return result;
    }
}

