/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/sku"}, name="\u5546\u54c1SKU")
public class RsSkuCon
extends SpringmvcController {
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    private static String CODE = "rs.sku.con";

    protected String getContext() {
        return "sku";
    }

    @RequestMapping(value={"saveSku.json"}, name="\u589e\u52a0\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean saveSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".saveSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.saveSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"getSku.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuBySpec.json"}, name="\u6839\u636eSpec\u4fe1\u606f\u53d6\u5546\u54c1SKU")
    @ResponseBody
    public RsSkuReDomain getSkuBySpec(HttpServletRequest request, String specStr, String goodsCode) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".getSkuByName", (Object)"param is null");
            return null;
        }
        List<String> specList = Arrays.asList(specStr.split("\\/"));
        return this.rsSkuServiceRepository.getSkuBySpec(specList, goodsCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"deleteSku.json"}, name="\u5220\u9664\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean deleteSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".deleteSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.deleteSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromReleGoo.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u53d1\u5e03\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromReleGoo(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromTc.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromJm.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u52a0\u76df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromJm(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    private SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromTc.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromTc(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromTcEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromTcEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    private HtmlJsonReBean checkGoodsNoMain(String tenantCode, String goodsNo, String goodsCode, String skuCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u4e3a\u7a7a");
        }
        Map param = this.getQueryMapParam("goodsNo,tenantCode", new Object[]{goodsNo, tenantCode});
        SupQueryResult rsSkuList = this.rsSkuServiceRepository.querySkuPage(param);
        if (null == rsSkuList || null == rsSkuList.getRows() || rsSkuList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            for (RsSkuReDomain rsSkuReDomain : rsSkuList.getRows()) {
                if (goodsCode.equals(rsSkuReDomain.getGoodsCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (StringUtils.isNotBlank((String)skuCode)) {
            for (RsSkuReDomain rsSkuReDomain : rsSkuList.getRows()) {
                if (skuCode.equals(rsSkuReDomain.getSkuCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsSkuList && null != rsSkuList.getList() && rsSkuList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateSkuState.json"}, name="\u7f16\u8f91\u5546\u54c1SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuState(String skuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".updateSkuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateSkuState(Integer.valueOf(skuId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateSkuFile.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean updateSkuFile(HttpServletRequest request, String skuCode, String fileList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)fileList)) {
            this.logger.error(CODE + ".updateSkuFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsGoodsFileDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(fileList, RsGoodsFileDomain.class);
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            rsGoodsFileDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.rsSkuServiceRepository.updateSkuFile(skuCode, this.getTenantCode(request), rsGoodsFileDomainList);
    }
}

