/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/sku"}, name="\u5546\u54c1SKU")
public class RsSkuCon
extends SpringmvcController {
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;
    private static String CODE = "rs.sku.con";

    protected String getContext() {
        return "sku";
    }

    @RequestMapping(value={"saveSku.json"}, name="\u589e\u52a0\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean saveSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".saveSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.saveSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"getSku.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuFromXn.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f-\u865a\u62df")
    @ResponseBody
    public RsSkuReDomain getSkuFromXn(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSkuFromXn", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuFromFd.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f-\u798f\u70b9")
    @ResponseBody
    public RsSkuReDomain getSkuFromFd(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSkuFromFd", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuBySpec.json"}, name="\u6839\u636eSpec\u4fe1\u606f\u53d6\u5546\u54c1SKU")
    @ResponseBody
    public RsSkuReDomain getSkuBySpec(HttpServletRequest request, String specStr, String goodsCode) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".getSkuByName", (Object)"param is null");
            return null;
        }
        List<String> specList = Arrays.asList(specStr.split("\\/"));
        return this.rsSkuServiceRepository.getSkuBySpec(specList, goodsCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"updateSkuFromTc.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateSkuFromTc(String goodsCode, String skuCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, RsSkuDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsSkuCode", skuCode);
        map.put("goodsRelType", "3");
        SupQueryResult supQueryResult = this.rsGoodsOtherServiceRepository.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u65e0\u5bf9\u5e94\u4fe1\u606f");
            return null;
        }
        HtmlJsonReBean deleteRes = null;
        for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
            deleteRes = this.rsGoodsOtherServiceRepository.deleteGoodsRel(rsGoodsRelReDomain.getGoodsRelId());
        }
        if (null == deleteRes) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u5173\u8054\u5173\u7cfb\u5220\u9664\u5931\u8d25");
            return null;
        }
        HtmlJsonReBean htmlJsonReBean = null;
        RsGoodsRelDomain rsGoodsRelDomain = null;
        for (RsSkuDomain rsSkuReDomain : list) {
            rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsSkuCode(skuCode);
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuReDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("3");
            rsGoodsRelDomain.setMemberCode(rsSkuReDomain.getMemberCode());
            rsGoodsRelDomain.setMemberName(rsSkuReDomain.getMemberName());
            rsGoodsRelDomain.setSkuCode(rsSkuReDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuReDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
            rsGoodsRelDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
            rsGoodsRelDomain.setDataPic(rsSkuReDomain.getDataPic());
            rsGoodsRelDomain.setTenantCode(rsSkuReDomain.getTenantCode());
            this.rsGoodsOtherServiceRepository.saveGoodsRel(rsGoodsRelDomain);
            htmlJsonReBean = this.rsSkuServiceRepository.updateSku(rsSkuReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deleteSku.json"}, name="\u5220\u9664\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean deleteSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".deleteSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.deleteSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuPageFromPtFd.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5e73\u53f0\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageFromPtFd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuRelation.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5173\u8054sku\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuRelation(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String skuCode = (String)param.get("skuCode");
        if (StringUtils.isBlank((String)skuCode)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSkuCode", skuCode);
        SupQueryResult supQueryResult = this.rsGoodsOtherServiceRepository.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skuMap.put("tenantCode", tenantCode);
        ArrayList<RsSkuReDomain> resultList = new ArrayList<RsSkuReDomain>();
        HashMap<String, String> goodsCodeMap = new HashMap<String, String>();
        for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
            skuMap.put("skuCode", rsGoodsRelReDomain.getSkuCode());
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuMap);
            if (!goodsCodeMap.containsKey(rsSkuReDomain.getGoodsCode())) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", new Object[]{rsSkuReDomain.getGoodsCode(), tenantCode}));
                goodsCodeMap.put(rsSkuReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsName());
            }
            rsSkuReDomain.setGoodsName(String.valueOf(goodsCodeMap.get(rsSkuReDomain.getGoodsCode())));
            resultList.add(rsSkuReDomain);
        }
        SupQueryResult supQueryResult1 = new SupQueryResult();
        supQueryResult1.setList(resultList);
        supQueryResult1.setRows(resultList);
        return supQueryResult1;
    }

    @RequestMapping(value={"querySkuFromLt.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u8f6c\u76d8")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromLt(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("dataOpbillstate", 1);
        }
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromFdRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromFdRel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromXnRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromXnRel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromXn.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u865a\u62df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromXn(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromFd.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromFd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromReleGoo.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u53d1\u5e03\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromReleGoo(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"querySkuFromTcEdit.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTcEdit(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"querySkuFromTc.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTc(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"querySkuFromQy.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u6743\u76ca")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromQy(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"querySkuFromJm.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u52a0\u76df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromJm(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    private SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"querySkuFromLb.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u793c\u5305")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromLb(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("dataOpbillstate", 1);
            param.put("dataState", 2);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFdRel.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFdRel(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXnRel.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXnRel(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXnEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXnEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXn.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXn(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFdEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFdEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFd.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFd(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromTc.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromTc(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromTcEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromTcEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    private HtmlJsonReBean checkGoodsNoMain(String tenantCode, String goodsNo, String goodsCode, String skuCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u4e3a\u7a7a");
        }
        Map param = this.getQueryMapParam("goodsNo,tenantCode", new Object[]{goodsNo, tenantCode});
        SupQueryResult rsSkuList = this.rsSkuServiceRepository.querySkuPage(param);
        if (null == rsSkuList || null == rsSkuList.getRows() || rsSkuList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            for (RsSkuReDomain rsSkuReDomain : rsSkuList.getRows()) {
                if (goodsCode.equals(rsSkuReDomain.getGoodsCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (StringUtils.isNotBlank((String)skuCode)) {
            for (RsSkuReDomain rsSkuReDomain : rsSkuList.getRows()) {
                if (skuCode.equals(rsSkuReDomain.getSkuCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsSkuList && null != rsSkuList.getList() && rsSkuList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateSkuState.json"}, name="\u7f16\u8f91\u5546\u54c1SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuState(String skuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".updateSkuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateSkuState(Integer.valueOf(skuId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateSkuFile.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean updateSkuFile(HttpServletRequest request, String skuCode, String fileList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)fileList)) {
            this.logger.error(CODE + ".updateSkuFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsGoodsFileDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(fileList, RsGoodsFileDomain.class);
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            rsGoodsFileDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.rsSkuServiceRepository.updateSkuFile(skuCode, this.getTenantCode(request), rsGoodsFileDomainList);
    }

    @RequestMapping(value={"querySkuBySkuCode.json"}, name="\u67e5\u8be2SKU\u5217\u8868")
    @ResponseBody
    public List<RsSkuReDomain> querySkuBySkuCode(HttpServletRequest request, String skuCodeStr) {
        List<String> skuCodeList = this.getGoodsIdList(skuCodeStr);
        HashMap<String, String> skuParam = new HashMap<String, String>();
        skuParam.put("tenantCode", this.getTenantCode(request));
        ArrayList<RsSkuReDomain> reDomains = new ArrayList<RsSkuReDomain>();
        for (String skuCode : skuCodeList) {
            skuParam.put("skuCode", skuCode);
            RsSkuReDomain skuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuParam);
            if (null == skuReDomain) continue;
            reDomains.add(skuReDomain);
        }
        return reDomains.size() > 0 ? reDomains : null;
    }

    private List<String> getGoodsIdList(String skuCodeStr) {
        String[] codeStr = skuCodeStr.split(",");
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (String code : codeStr) {
            skuCodeList.add(code);
        }
        return skuCodeList;
    }

    @RequestMapping(value={"querySkuByMscCodeFromYy.json"}, name="\u67e5\u8be2SKU\u5206\u9875\u5217\u8868-\u8fd0\u8425\u7aef\u9891\u9053\u7ba1\u7406")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuByMscCodeFromYy(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"updateCannelSkuList.json"}, name="sku-\u64a4\u724c")
    @ResponseBody
    public HtmlJsonReBean updateCannelSkuList(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateCannelSkuList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateAuditSkuPass.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuditSkuPass(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateAuditSkuPass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> skuIdList = this.getSkuIdList(skuIds);
        ArrayList<RsSkuReDomain> skuList = new ArrayList<RsSkuReDomain>();
        for (Integer skuId : skuIdList) {
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuId);
            skuList.add(rsSkuReDomain);
        }
        this.rsSkuServiceRepository.updateAhSkuList(skuList);
        return this.rsSkuServiceRepository.updateAuditSkuPass(this.getSkuIdList(skuIds));
    }

    private List<Integer> getSkuIdList(String skuIds) {
        String[] idStr = skuIds.split(",");
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            skuIdList.add(Integer.parseInt(id));
        }
        return skuIdList;
    }
}

