/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.cms.repository.CmsTginfoServiceRepository;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFilesortReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsFilesortServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.sc.domain.ScShopdeReDomain;
import com.qjsoft.laser.controller.facade.sc.repository.ScShopdeServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.springmvc.bean.CmsTginfo;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/resourceGoods"}, name="\u5546\u54c1")
public class ResourceGoodsCon
extends SpringmvcController {
    private static String CODE = "rs.resourceGoods.con";
    @Autowired
    private CmsTginfoServiceRepository cmsTginfoServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository goodsOtherServiceRepository;
    @Autowired
    private ScShopdeServiceRepository scShopdeServiceRepository;
    @Autowired
    private RsGoodsFilesortServiceRepository rsGoodsFilesortServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;

    protected String getContext() {
        return "resourceGoods";
    }

    @RequestMapping(value={"saveResourceGoods.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoods(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "default");
    }

    public HtmlJsonReBean saveResourceGoodsMain(HttpServletRequest request, String paramStr, String goodsRemark, String flag) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsMain", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".saveResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList() || ((RsSkuDomain)rsResourceGoodsDomain.getRsSkuDomainList().get(0)).getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4e0b\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String memberCode = rsResourceGoodsDomain.getMemberCode();
        String memberName = rsResourceGoodsDomain.getMemberName();
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(this.getShopdeName(userSession));
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsType("00");
        switch (flag) {
            case "gys": {
                rsResourceGoodsDomain.setMemberCcode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberCname(this.getShopdeName(userSession));
                rsResourceGoodsDomain.setGoodsOrigin("6");
                break;
            }
            case "tc": {
                rsResourceGoodsDomain.setMemberCcode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberCname(this.getShopdeName(userSession));
                rsResourceGoodsDomain.setGoodsOrigin("8");
                break;
            }
            case "fd": {
                rsResourceGoodsDomain.setMemberCcode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberCname(this.getShopdeName(userSession));
                rsResourceGoodsDomain.setGoodsOrigin("10");
                break;
            }
            case "xn": {
                rsResourceGoodsDomain.setMemberCcode(userSession.getUserPcode());
                rsResourceGoodsDomain.setMemberCname(this.getShopdeName(userSession));
                rsResourceGoodsDomain.setGoodsOrigin("0");
                rsResourceGoodsDomain.setGoodsType("07");
                break;
            }
            case "replace": {
                if (StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCcode()) || StringUtils.isBlank((String)rsResourceGoodsDomain.getMemberCname())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f9b\u5e94\u5546\u4ee3\u7801\u6216\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\u7a7a");
                }
                rsResourceGoodsDomain.setMemberCode(memberCode);
                rsResourceGoodsDomain.setMemberName(memberName);
                rsResourceGoodsDomain.setGoodsOrigin("6");
                break;
            }
            case "default": {
                if (null != rsResourceGoodsDomain.getGoodsOrigin() && !StringUtils.isEmpty((String)rsResourceGoodsDomain.getGoodsOrigin())) break;
                rsResourceGoodsDomain.setGoodsOrigin("0");
                break;
            }
        }
        this.makeChannel(rsResourceGoodsDomain, request);
        HtmlJsonReBean htmlJsonReBean = this.rsResourceGoodsServiceRepository.saveResourceGoods(rsResourceGoodsDomain);
        if (null != rsResourceGoodsDomain.getDataOpbillstate() && rsResourceGoodsDomain.getDataOpbillstate() == 1 && null != htmlJsonReBean.getDataObj()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", htmlJsonReBean.getDataObj());
            map.put("tenantCode", this.getTenantCode(request));
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
            if (null != rsResourceGoodsReDomain) {
                this.updateAhAndAuditResourcePass(rsResourceGoodsReDomain.getGoodsId() + "");
            }
        }
        return htmlJsonReBean;
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    private String getShopdeName(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", userSession.getUserPcode());
        map.put("tenantCode", userSession.getTenantCode());
        SupQueryResult qlist = this.scShopdeServiceRepository.queryShopdePage(map);
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            return userSession.getMerberCompname();
        }
        return ((ScShopdeReDomain)qlist.getRows().get(0)).getShopdeName();
    }

    private RsResourceGoodsReDomain fetchResGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null != rsResourceGoodsReDomain && ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", rsResourceGoodsReDomain.getTenantCode());
            ArrayList<RsGoodsRelDomain> relDomainList = new ArrayList<RsGoodsRelDomain>();
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                map.put("goodsCode", rsGoodsRelDomain.getGoodsRelGcode());
                RsResourceGoodsReDomain relGoods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                rsGoodsRelDomain.setRsResourceGoods((RsResourceGoodsDomain)relGoods);
                relDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsReDomain.setRsGoodsRelDomainList(relDomainList);
        }
        return rsResourceGoodsReDomain;
    }

    @RequestMapping(value={"getResourceGoods.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public RsResourceGoodsReDomain getResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResourceGoods", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain reDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
        return this.fetchResGoods(reDomain);
    }

    @RequestMapping(value={"getResGoodsFromFdEdit.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f-\u798f\u70b9")
    @ResponseBody
    public RsResourceGoodsReDomain getResGoodsFromFdEdit(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResourceGoods", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain reDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
        return this.fetchResGoods(reDomain);
    }

    @RequestMapping(value={"getResGoodsFromXnEdit.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f-\u865a\u62df")
    @ResponseBody
    public RsResourceGoodsReDomain getResGoodsFromXnEdit(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResourceGoods", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain reDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
        return this.fetchResGoods(reDomain);
    }

    @RequestMapping(value={"getResGoodsFromTcEdit.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public RsResourceGoodsReDomain getResGoodsFromTcEdit(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResGoodsFromTcEdit", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain reDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
        return this.fetchResGoods(reDomain);
    }

    @RequestMapping(value={"getResGoodsFromGysEdit.json"}, name="\u83b7\u53d6\u5546\u54c1\u4fe1\u606f-\u4f9b\u5e94\u5546\u7f16\u8f91")
    @ResponseBody
    public RsResourceGoodsReDomain getResGoodsFromGysEdit(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".getResGoodsFromGysEdit", (Object)"param is null");
            return null;
        }
        RsResourceGoodsReDomain reDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(Integer.valueOf(goodsId));
        return this.fetchResGoods(reDomain);
    }

    @RequestMapping(value={"updateResourceGoods.json"}, name="\u66f4\u65b0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoods(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateResGooMain(userSession, this.getTenantCode(request), paramStr, goodsRemark);
    }

    @RequestMapping(value={"updateResGoodsFromFdEdit.json"}, name="\u66f4\u65b0\u5546\u54c1-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean updateResGoodsFromFdEdit(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateResGooMain(userSession, this.getTenantCode(request), paramStr, goodsRemark);
    }

    @RequestMapping(value={"updateResGoodsFromXnEdit.json"}, name="\u66f4\u65b0\u5546\u54c1-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean updateResGoodsFromXnEdit(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateResGooMain(userSession, this.getTenantCode(request), paramStr, goodsRemark);
    }

    @RequestMapping(value={"updateResGooFromTcEdit.json"}, name="\u66f4\u65b0\u5546\u54c1-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean updateResGooFromTcEdit(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateResGooMain(userSession, this.getTenantCode(request), paramStr, goodsRemark);
    }

    private HtmlJsonReBean updateResGooMain(UserSession userSession, String tenantCode, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == userSession) {
            this.logger.error(CODE + ".updateResourceGoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, RsResourceGoodsDomain.class);
        if (null == rsResourceGoodsDomain.getRsGoodsFileDomainList() || rsResourceGoodsDomain.getRsGoodsFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == rsResourceGoodsDomain.getRsSkuDomainList() || rsResourceGoodsDomain.getRsSkuDomainList().size() == 0) {
            this.logger.error(CODE + ".updateResourceGoods.skuList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rsResourceGoodsDomain.getClasstreeCode())) {
            this.logger.error(CODE + ".updateResourceGoods.ClasstreeCode", (Object)"ClasstreeCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(this.getShopdeName(userSession));
        rsResourceGoodsDomain.setTenantCode(tenantCode);
        rsResourceGoodsDomain.setGoodsRemark(goodsRemark);
        return this.rsResourceGoodsServiceRepository.updateResourceGoods(rsResourceGoodsDomain);
    }

    @RequestMapping(value={"deleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteResourceGoods(String goodsId) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".deleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.deleteResourceGoods(Integer.valueOf(goodsId));
    }

    @RequestMapping(value={"queryResourceGoodsPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromFdRel.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromFdRel(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "10");
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromXnRel.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromXnRel(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("goodsType", "07");
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromXnEdit.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromXnEdit(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromFdEdit.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromFdEdit(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsFromXn.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u865a\u62df")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFromXn(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsType", "07");
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsFromFd.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFromFd(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "10");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsFromTc.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u5957\u9910")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsFromTc(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGooFromTcEdit.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGooFromTcEdit(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromRepRel.json"}, name="\u63a8\u8350\u5546\u54c1-\u5e73\u53f0\u4ee3\u53d1")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromRepRel(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("validFlag", true);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPageByPlant.json"}, name="\u5e73\u53f0\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPageByPlant(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromQy.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u6743\u76ca")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromQy(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResGoodsFromYy.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u8fd0\u8425\u7aef\u9891\u9053\u7ba1\u7406")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResGoodsFromYy(HttpServletRequest request) {
        SupQueryResult supQueryResult;
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (supQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param)) || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        ArrayList rsSkuReDomains = new ArrayList();
        for (RsResourceGoodsReDomain rsResourceGoodsReDomain : supQueryResult.getList()) {
            map.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            SupQueryResult supQueryResult1 = this.rsSkuServiceRepository.querySkuPage(map);
            if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) continue;
            rsSkuReDomains.addAll(supQueryResult1.getList());
        }
        SupQueryResult reDomainSupQueryResult = new SupQueryResult();
        reDomainSupQueryResult.setList(rsSkuReDomains);
        reDomainSupQueryResult.setRows(rsSkuReDomains);
        reDomainSupQueryResult.setTotal((long)rsSkuReDomains.size());
        return reDomainSupQueryResult;
    }

    @RequestMapping(value={"updateResourceGoodsState.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsState(String goodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".updateResourceGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateAuditResourcePass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u5ba1\u6838\u540e)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourcePass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateAuditResourceNoPass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u5ba1\u6838\u4e0d\u901a\u8fc7)")
    @ResponseBody
    public HtmlJsonReBean updateAuditResourceNoPass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAuditResourceNoPass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourceNoPass(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"checkGoodsRel.json"}, name="\u68c0\u67e5\u662f\u5426\u5b58\u5728\u5173\u8054\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean checkGoodsRel(HttpServletRequest request, String goodsCodeStr) {
        if (StringUtils.isBlank((String)goodsCodeStr)) {
            this.logger.error(CODE + ".checkGoodsRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<String> goodsCodeList = this.getGoodsCodeList(goodsCodeStr);
        for (String goodsCode : goodsCodeList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsRelGcode", goodsCode);
            map.put("tenantCode", this.getTenantCode(request));
            SupQueryResult goodsRelReDomainSupQueryResult = this.goodsOtherServiceRepository.queryGoodsRelPage(map);
            if (null == goodsRelReDomainSupQueryResult || goodsRelReDomainSupQueryResult.getList().size() <= 0) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u88ab\u5173\u8054\uff0c \u786e\u8ba4\u5220\u9664\uff1f");
        }
        return new HtmlJsonReBean();
    }

    private List<String> getGoodsCodeList(String goodsCodeStr) {
        String[] codeStr = goodsCodeStr.split(",");
        ArrayList<String> goodsCodeList = new ArrayList<String>();
        for (String code : codeStr) {
            goodsCodeList.add(code);
        }
        return goodsCodeList;
    }

    @RequestMapping(value={"updateCannelResourceList.json"}, name="\u5546\u54c1\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateCannelResourceList(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResourceList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateCannelResListFromXn.json"}, name="\u5546\u54c1\u4e0b\u67b6-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean updateCannelResListFromXn(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResListFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateCannelResListFromTc.json"}, name="\u5546\u54c1\u4e0b\u67b6-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateCannelResListFromTc(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResListFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateCannelResListFromFd.json"}, name="\u5546\u54c1\u4e0b\u67b6-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateCannelResListFromFd(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResListFromFd", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updatePlatformResourceList.json"}, name="\u5e73\u53f0\u5546\u54c1\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updatePlatformResourceList(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateCannelResourceList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }

    @RequestMapping(value={"updateAhResource.json"}, name="\u5546\u54c1\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateAhResource(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhResource", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            htmlJsonReBean = this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateAhAndAuditResourcePass.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u514d\u5ba1\u6838)")
    @ResponseBody
    public HtmlJsonReBean updateAhAndAuditResourcePass(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhAndAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(goodsIdList);
    }

    @RequestMapping(value={"updateAhAndAuditResPassFromXn.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u514d\u5ba1\u6838)-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean updateAhAndAuditResPassFromXn(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhAndAuditResPassFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(goodsIdList);
    }

    @RequestMapping(value={"updateAhAndAuditResPassFromTc.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u514d\u5ba1\u6838)-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateAhAndAuditResPassFromTc(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhAndAuditResPassFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(goodsIdList);
    }

    @RequestMapping(value={"updateAhAndAuditResPassFromFd.json"}, name="\u5546\u54c1\u4e0a\u67b6(\u514d\u5ba1\u6838)-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateAhAndAuditResPassFromFd(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateAhAndAuditResourcePass", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            RsResourceGoodsReDomain rsResourceGoodsDomain = this.rsResourceGoodsServiceRepository.getResourceGoods(goodsId);
            this.rsResourceGoodsServiceRepository.updateAhResource((RsResourceGoodsDomain)rsResourceGoodsDomain);
        }
        return this.rsResourceGoodsServiceRepository.updateAuditResourcePass(goodsIdList);
    }

    @RequestMapping(value={"batchDeleteResourceGoods.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResourceGoods(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"batchDeleteResGoodsFromXn.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResGoodsFromXn(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResGoodsFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"batchDeleteResGoodsFromTc.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResGoodsFromTc(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResGoodsFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"batchDeleteResGoodsFromFd.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResGoodsFromFd(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResGoodsFromFd", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXnRel.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXnRel(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXnEdit.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXnEdit(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFdRel.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFdRel(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFdEdit.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFdEdit(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoTcEdit.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoTcEdit(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoGysEdit.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u4f9b\u5e94\u5546\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoGysEdit(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNoGysEdit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    @RequestMapping(value={"checkGoodsNoFromRepRel.json"}, name="\u6821\u9a8c\u5546\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5e73\u53f0\u4ee3\u53d1")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromRepRel(HttpServletRequest request, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNoFromRepRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode);
    }

    private HtmlJsonReBean checkGoodsNoMain(String tenantCode, String goodsNo, String goodsCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map param = this.getQueryMapParam("goodsNo,tenantCode,memberCode", new Object[]{goodsNo, tenantCode, tenantCode});
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            for (RsResourceGoodsReDomain rsResourceGoodsReDomain : rsList.getRows()) {
                if (goodsCode.equals(rsResourceGoodsReDomain.getGoodsCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsList && null != rsList.getList() && rsList.getList().size() > 0) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)" exist goodsNo");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    private List<Integer> getGoodsIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            goodsIdList.add(Integer.parseInt(id));
        }
        return goodsIdList;
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsResourceGoodsServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"updateSkuFromFd.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u798f\u70b9\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateSkuFromFd(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsResourceGoodsServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"updateSkuFromXn.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u865a\u62df\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateSkuFromXn(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSkuFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsResourceGoodsServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"queryResourceGoodsByClassTreeCode.json"}, name="\u6839\u636e\u5206\u7c7b\u67e5\u8be2\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean queryResourceGoodsByClassTreeCode(HttpServletRequest request, String classtreeCode) {
        if (StringUtils.isBlank((String)classtreeCode)) {
            this.logger.error(CODE + ".queryResourceGoodsByClassTreeCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("classtreeCode", classtreeCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
        if (null == supQueryResult || null == supQueryResult.getRows() || supQueryResult.getRows().isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        ArrayList<RsResourceGoodsReDomain> resourceGoodsReDomainList = new ArrayList<RsResourceGoodsReDomain>();
        for (RsResourceGoodsReDomain resourceGoodsReDomain : supQueryResult.getList()) {
            ArrayList rsGoodsFileDomainList = new ArrayList();
            HashMap<String, Object> filesortPama = new HashMap<String, Object>();
            filesortPama.put("order", true);
            filesortPama.put("orderStr", "GOODS_FILE_NO ASC");
            filesortPama.put("pntreeCode", resourceGoodsReDomain.getPntreeCode());
            filesortPama.put("tenantCode", this.getTenantCode(request));
            SupQueryResult reDomainSupQueryResult = this.rsGoodsFilesortServiceRepository.queryGoodsFilesortPage(filesortPama);
            if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getRows() || reDomainSupQueryResult.getRows().isEmpty()) continue;
            block1: for (RsGoodsFilesortReDomain goodsFilesortReDomain : reDomainSupQueryResult.getList()) {
                if (rsGoodsFileDomainList.size() > 2) break;
                if (goodsFilesortReDomain.getGoodsFileMinnum() <= 0) continue;
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put("goodsCode", resourceGoodsReDomain.getGoodsCode());
                fileMap.put("goodsFileSort", goodsFilesortReDomain.getGoodsFileSort());
                fileMap.put("goodsFilesortName", goodsFilesortReDomain.getGoodsFilesortName());
                fileMap.put("tenantCode", this.getTenantCode(request));
                SupQueryResult goodsFileReDomainSupQueryResult = this.goodsOtherServiceRepository.queryGoodsFilePage(fileMap);
                if (null == goodsFileReDomainSupQueryResult || null == goodsFileReDomainSupQueryResult.getRows() || goodsFileReDomainSupQueryResult.getRows().isEmpty()) continue;
                if (rsGoodsFileDomainList.size() <= 0) {
                    rsGoodsFileDomainList.add(goodsFileReDomainSupQueryResult.getList().get(0));
                    continue;
                }
                for (RsGoodsFileReDomain rsGoodsFileReDomain : goodsFileReDomainSupQueryResult.getList()) {
                    if (rsGoodsFileDomainList.size() >= 3) continue block1;
                    rsGoodsFileDomainList.add(rsGoodsFileReDomain);
                }
            }
            resourceGoodsReDomain.setRsGoodsFileDomainList(rsGoodsFileDomainList);
            resourceGoodsReDomainList.add(resourceGoodsReDomain);
        }
        return new HtmlJsonReBean(resourceGoodsReDomainList);
    }

    @RequestMapping(value={"saveResGoodsReplace.json"}, name="\u5e73\u53f0\u4ee3\u4f9b\u5e94\u5546\u53d1\u5e03\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResGoodsReplace(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResGoodsReplace", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResGoodsReplace", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "replace");
    }

    @RequestMapping(value={"saveResourceGoodsGys.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsGys(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsGys", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsGys", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "gys");
    }

    @RequestMapping(value={"queryResourceGoodsGys.json"}, name="\u4f9b\u5e94\u5546\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGys(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsGysDtj.json"}, name="\u4f9b\u5e94\u5546\u5f85\u63d0\u4ea4\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGysDtj(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 0);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsGysDsh.json"}, name="\u4f9b\u5e94\u5546\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGysDsh(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 1);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsGysYsh.json"}, name="\u4f9b\u5e94\u5546\u5df2\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsGysYsh(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 2);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"batchDeleteResGoodsGys.json"}, name="\u5220\u9664\u5546\u54c1(\u903b\u8f91\u5220\u9664)-\u4f9b\u5e94\u5546")
    @ResponseBody
    public HtmlJsonReBean batchDeleteResGoodsGys(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".batchDeleteResGoodsGys", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), Integer.valueOf(-1), Integer.valueOf(0));
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"queryResourceGoodsPt.json"}, name="\u5e73\u53f0\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPt(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (StringUtils.isBlank((String)String.valueOf(param.get("dataState")))) {
            param.remove("memberCode");
        }
        if (String.valueOf(param.get("dataState")).equals("1")) {
            param.remove("memberCode");
            param.put("goodsOrigin", "6");
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPtPageDsh.json"}, name="\u5e73\u53f0\u5217\u8868\u4e2d\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtPageDsh(HttpServletRequest request) {
        return null;
    }

    @RequestMapping(value={"queryResourceGoodsPtDsh.json"}, name="\u5e73\u53f0\u5f85\u5ba1\u6838\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtDsh(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "6");
        param.put("dataState", 1);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPtDsj.json"}, name="\u5e73\u53f0\u5f85\u4e0a\u67b6\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtDsj(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("dataState", 0);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPtYsj.json"}, name="\u5e73\u53f0\u5df2\u4e0a\u67b6\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtYsj(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("dataState", 2);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPtTy.json"}, name="\u5e73\u53f0\u505c\u7528\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtTy(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("dataState", -1);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"queryResourceGoodsPtGysXj.json"}, name="\u5e73\u53f0\u4f9b\u5e94\u5546\u4e0b\u67b6\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResourceGoodsPtGysXj(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("dataState", 3);
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"updateResourceGoodsStateGys.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u4f9b\u5e94\u5546")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStateGys(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStateGysDtj.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u4f9b\u5e94\u5546-\u5f85\u63d0\u4ea4")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStateGysDtj(String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStateGysYsh.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u4f9b\u5e94\u5546-\u5df2\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStateGysYsh(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePt.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePt(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtDsh.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u5f85\u5ba1\u6838")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtDsh(HttpServletRequest request, String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtDsj.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u5f85\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtDsj(String goodsIdStr, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateResourceGoodsStatePtDsj", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (goodsIdStr.contains(",")) {
            List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
            HtmlJsonReBean htmlJsonReBean = null;
            for (Integer goodsId : goodsIdList) {
                htmlJsonReBean = this.fetchUpdate(String.valueOf(goodsId), dataState, oldDataState);
                if (null != htmlJsonReBean && !htmlJsonReBean.getSysRecode().equals("error")) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            return htmlJsonReBean;
        }
        return this.fetchUpdate(goodsIdStr, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtYsj.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u5df2\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtYsj(String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"updateResourceGoodsStatePtTy.json"}, name="\u66f4\u65b0\u5546\u54c1\u72b6\u6001-\u5e73\u53f0-\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean updateResourceGoodsStatePtTy(String goodsId, Integer dataState, Integer oldDataState) {
        return this.fetchUpdate(goodsId, dataState, oldDataState);
    }

    public HtmlJsonReBean fetchUpdate(String goodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsId)) {
            this.logger.error(CODE + ".updateResourceGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateResourceGoodsState(Integer.valueOf(goodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveResourceGoodsTc.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveResourceGoodsTc(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsTc", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "tc");
    }

    @RequestMapping(value={"saveResGoodsFromFd.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean saveResGoodsFromFd(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResGoodsFromFd", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResGoodsFromFd", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "fd");
    }

    @RequestMapping(value={"queryResGoodsByDis.json"}, name="\u6839\u636e\u7ad9\u70b9\u548c\u79df\u6237code\u67e5\u8be2\u5546\u54c1sku-\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResGoodsByDis(HttpServletRequest request, String tginfoCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            CmsTginfo tginfo;
            String json = SupDisUtil.getMap((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode));
            if (StringUtils.isNotBlank((String)json) && null != (tginfo = (CmsTginfo)JsonUtil.buildNormalBinder().getJsonToObject(json, CmsTginfo.class))) {
                param.put("channelCode", tginfo.getChannelCode());
            }
        } else {
            param.put("channelCode", this.getNowChannel(request));
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"queryResGoodsByDisForBus.json"}, name="\u6839\u636e\u7ad9\u70b9\u548c\u79df\u6237code\u67e5\u8be2\u5546\u54c1sku-\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResGoodsByDisForBus(HttpServletRequest request, String tginfoCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            CmsTginfo tginfo;
            String json = SupDisUtil.getMap((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode));
            if (StringUtils.isNotBlank((String)json) && null != (tginfo = (CmsTginfo)JsonUtil.buildNormalBinder().getJsonToObject(json, CmsTginfo.class))) {
                param.put("channelCode", tginfo.getChannelCode());
            }
        } else {
            param.put("channelCode", this.getNowChannel(request));
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"queryResGoodsForBusByDis.json"}, name="\u6839\u636e\u7ad9\u70b9\u548c\u79df\u6237code\u67e5\u8be2\u5546\u54c1sku-\u7528\u4e8e\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResGoodsForBusByDis(HttpServletRequest request, String tginfoCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            CmsTginfo tginfo;
            String json = SupDisUtil.getMap((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode));
            if (StringUtils.isNotBlank((String)json) && null != (tginfo = (CmsTginfo)JsonUtil.buildNormalBinder().getJsonToObject(json, CmsTginfo.class))) {
                param.put("channelCode", tginfo.getChannelCode());
            }
        } else {
            param.put("channelCode", this.getNowChannel(request));
        }
        return this.rsSkuServiceRepository.querySkuPage(param);
    }

    @RequestMapping(value={"saveResGoodsFromXn.json"}, name="\u589e\u52a0\u5957\u9910\u5546\u54c1-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean saveResGoodsFromXn(HttpServletRequest request, String paramStr, String goodsRemark) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResGoodsFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResGoodsFromXn", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveResourceGoodsMain(request, paramStr, goodsRemark, "xn");
    }

    @RequestMapping(value={"queryResGoodsFromPtFd.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u5e73\u53f0\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsResourceGoodsReDomain> queryResGoodsFromPtFd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
    }

    @RequestMapping(value={"updateResListFromPtFd.json"}, name="\u5546\u54c1\u4e0b\u67b6-\u5e73\u53f0\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateResListFromPtFd(String goodsIdStr) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateResListFromPtFd", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsResourceGoodsServiceRepository.updateCannelResourceList(this.getGoodsIdList(goodsIdStr));
    }
}

