/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ge.domain.GeGextempReDomain;
import com.qjsoft.laser.controller.facade.ge.repository.GeGextempServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandRelationReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandRelationServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSpecServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/pntree"}, name="\u5546\u54c1\u7c7b\u578b")
public class RsPntreeCon
extends SpringmvcController {
    private static String CODE = "rs.pntree.con";
    @Autowired
    private RsPntreeServiceRepository rsPntreeServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private GeGextempServiceRepository geGextempServiceRepository;
    @Autowired
    private RsBrandRelationServiceRepository rsBrandRelationServiceRepository;
    @Autowired
    private RsSpecServiceRepository rsSpecServiceRepository;

    protected String getContext() {
        return "pntree";
    }

    @RequestMapping(value={"savePntree.json"}, name="\u589e\u52a0\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean savePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".savePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<String> checklist = new ArrayList<String>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.rsPntreeServiceRepository.queryPntreePage(param);
        List list = result.getList();
        for (RsPntreeReDomain rsPntreeReDomain : list) {
            checklist.add(rsPntreeReDomain.getPntreeName());
        }
        if (checklist.contains(rsPntreeDomain.getPntreeName())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u91cd\u590d");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeServiceRepository.savePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"getPntree.json"}, name="\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u4fe1\u606f")
    @ResponseBody
    public RsPntreeReDomain getPntree(String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".getPntree", (Object)"param is null");
            return null;
        }
        return this.rsPntreeServiceRepository.getPntree(Integer.valueOf(pntreeId));
    }

    @RequestMapping(value={"updatePntree.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean updatePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".updatePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeServiceRepository.updatePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"deletePntree.json"}, name="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean deletePntree(HttpServletRequest request, String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsPntreeReDomain pntreeReDomain = this.rsPntreeServiceRepository.getPntree(Integer.valueOf(pntreeId));
        String pntreeCode = pntreeReDomain.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pntreeCode", pntreeCode);
        param.put("tenantCode", tenantCode);
        SupQueryResult rsResourceGoodsReDomainList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (null != rsResourceGoodsReDomainList.getList() && rsResourceGoodsReDomainList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u4f7f\u7528\u4e2d");
        }
        HtmlJsonReBean htmlJsonReBean = this.rsPntreeServiceRepository.deletePntree(Integer.valueOf(pntreeId));
        if (htmlJsonReBean.isSuccess()) {
            SupQueryResult supQueryResult1;
            SupQueryResult supQueryResult = this.rsBrandRelationServiceRepository.queryBrandRelationPage(param);
            if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                for (RsBrandRelationReDomain rsBrandRelationReDomain : supQueryResult.getList()) {
                    this.rsBrandRelationServiceRepository.deleteBrandRelation(rsBrandRelationReDomain.getBrandRelationId());
                }
            }
            if (null != (supQueryResult1 = this.rsSpecServiceRepository.querySpecGroupPage(param)) && ListUtil.isNotEmpty((Collection)supQueryResult1.getList())) {
                RsSpecGroupReDomain rsSpecGroupReDomain = (RsSpecGroupReDomain)supQueryResult1.getList().get(0);
                rsSpecGroupReDomain.setPntreeCode("");
                this.rsSpecServiceRepository.updateSpecGroup((RsSpecGroupDomain)rsSpecGroupReDomain);
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryPntreeTree.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreeTreeFromMsc.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTreeFromMsc(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreeTreeFromGift.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868-\u793c\u5305\u5206\u7c7b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTreeFromGift(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreePage.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsPntreeReDomain> queryPntreePage(HttpServletRequest request) {
        SupQueryResult supQueryResult;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (supQueryResult = this.rsPntreeServiceRepository.queryPntreePage(param)) || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        ArrayList<RsPntreeReDomain> reList = new ArrayList<RsPntreeReDomain>();
        Map<String, String> brandCodeMap = this.getRelBrandCode(map);
        Map<String, String> specGroupMap = this.getSpecGroupCode(map);
        for (RsPntreeReDomain rsPntreeReDomain : supQueryResult.getList()) {
            if (brandCodeMap.containsKey(rsPntreeReDomain.getPntreeCode())) {
                rsPntreeReDomain.setBrandCodeStr(brandCodeMap.get(rsPntreeReDomain.getPntreeCode()));
            }
            if (specGroupMap.containsKey(rsPntreeReDomain.getPntreeCode())) {
                rsPntreeReDomain.setSpecGroupCodeStr(specGroupMap.get(rsPntreeReDomain.getPntreeCode()));
            }
            reList.add(rsPntreeReDomain);
        }
        supQueryResult.setList(reList);
        supQueryResult.setRows(reList);
        return supQueryResult;
    }

    private Map<String, String> getRelBrandCode(Map<String, Object> map) {
        map.put("fuzzy", true);
        HashMap<String, String> reMap = new HashMap<String, String>();
        SupQueryResult supQueryResult1 = this.rsBrandRelationServiceRepository.queryBrandRelationPage(map);
        if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) {
            return null;
        }
        for (RsBrandRelationReDomain rsBrandRelationReDomain : supQueryResult1.getList()) {
            StringBuilder brandCode = new StringBuilder(rsBrandRelationReDomain.getBrandCode());
            if (reMap.containsKey(rsBrandRelationReDomain.getPntreeCode())) {
                brandCode.append(",");
                brandCode.append((String)reMap.get(rsBrandRelationReDomain.getPntreeCode()));
            }
            reMap.put(rsBrandRelationReDomain.getPntreeCode(), brandCode.toString());
        }
        return reMap;
    }

    private Map<String, String> getSpecGroupCode(Map<String, Object> map) {
        HashMap<String, String> reMap = new HashMap<String, String>();
        SupQueryResult supQueryResult1 = this.rsSpecServiceRepository.querySpecGroupPage(map);
        if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) {
            return null;
        }
        for (RsSpecGroupReDomain rsSpecGroupReDomain : supQueryResult1.getList()) {
            reMap.put(rsSpecGroupReDomain.getPntreeCode(), rsSpecGroupReDomain.getSpecGroupCode());
        }
        return reMap;
    }

    @RequestMapping(value={"getChildByPntree.json"}, name="\u83b7\u53d6\u7c7b\u578b\u5b50\u7c7b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> getChildByPntree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.getChildByPntree(param);
    }

    @RequestMapping(value={"updatePntreeState.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePntreeState(String pntreeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".updatePntreeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsPntreeServiceRepository.updatePntreeState(Integer.valueOf(pntreeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryPntreePageByTenantCode.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTenantCode(String tenantCode) {
        return this.fetchPntreePageByParam(tenantCode, "");
    }

    @RequestMapping(value={"queryPntreePageByTCodeAndPCode.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b-\u8fc7\u6ee4\u5df2\u7ecf\u5173\u8054\u7684\u7c7b\u578b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTCodeAndPCode(String tenantCode, String pntreeCode) {
        return this.fetchPntreePageByParam(tenantCode, pntreeCode);
    }

    public List<RsPntreeReDomain> fetchPntreePageByParam(String tenantCode, String pntreeCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".fetchPntreePageByParam", (Object)"param is null");
            return null;
        }
        ArrayList<RsPntreeReDomain> resultList = new ArrayList<RsPntreeReDomain>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        List pntreeReDomains = this.rsPntreeServiceRepository.queryPntreeTree(param);
        SupQueryResult geGextempReDomainSupQueryResult = this.geGextempServiceRepository.queryGextempPage(param);
        if (null == geGextempReDomainSupQueryResult || null == geGextempReDomainSupQueryResult.getList() || geGextempReDomainSupQueryResult.getList().size() <= 0) {
            return pntreeReDomains;
        }
        Map<String, Object> beanMap = this.transformation(geGextempReDomainSupQueryResult.getList());
        for (RsPntreeReDomain rsPntreeReDomain : pntreeReDomains) {
            if (rsPntreeReDomain.getPntreeCode().equals(beanMap.get(rsPntreeReDomain.getPntreeCode())) && !rsPntreeReDomain.getPntreeCode().equals(pntreeCode)) continue;
            resultList.add(rsPntreeReDomain);
        }
        return resultList;
    }

    @RequestMapping(value={"queryPntreePageByTenantCodePicType.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b-\u5546\u54c1\u56fe\u7247\u5206\u7c7b\u9875")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTenantCodePicType(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryPntreePageByTenantCodePicType", (Object)"param is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    public Map<String, Object> transformation(List<GeGextempReDomain> geGextempReDomains) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GeGextempReDomain geGextempReDomain : geGextempReDomains) {
            map.put(geGextempReDomain.getPntreeCode(), geGextempReDomain.getPntreeCode());
        }
        return map;
    }
}

