/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.ReturnBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsShopDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsWhDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesValueDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/sku"}, name="\u5546\u54c1SKU")
public class RsSkuCon
extends SpringmvcController {
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;
    @Autowired
    private RsResourceServiceRepository rsResourceServiceRepository;
    @Autowired
    private RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    private static String CODE = "rs.sku.con";

    protected String getContext() {
        return "sku";
    }

    @RequestMapping(value={"saveSku.json"}, name="\u589e\u52a0\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean saveSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".saveSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.saveSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"getSku.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuFromXn.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f-\u865a\u62df")
    @ResponseBody
    public RsSkuReDomain getSkuFromXn(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSkuFromXn", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuFromFd.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f-\u798f\u70b9")
    @ResponseBody
    public RsSkuReDomain getSkuFromFd(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSkuFromFd", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuBySpec.json"}, name="\u6839\u636eSpec\u4fe1\u606f\u53d6\u5546\u54c1SKU")
    @ResponseBody
    public RsSkuReDomain getSkuBySpec(HttpServletRequest request, String specStr, String goodsCode) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".getSkuByName", (Object)"param is null");
            return null;
        }
        List<String> specList = Arrays.asList(specStr.split("\\/"));
        return this.rsSkuServiceRepository.getSkuBySpec(specList, goodsCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuServiceRepository.updateSku((RsSkuDomain)rsSkuReDomain);
    }

    @RequestMapping(value={"updateSkuFromTc.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateSkuFromTc(String goodsCode, String skuCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, RsSkuDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsSkuCode", skuCode);
        map.put("goodsRelType", "3");
        SupQueryResult supQueryResult = this.rsGoodsOtherServiceRepository.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u65e0\u5bf9\u5e94\u4fe1\u606f");
        }
        HtmlJsonReBean deleteRes = null;
        this.logger.error(CODE + ".updateSkuFromTc", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
        if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
                deleteRes = this.rsGoodsOtherServiceRepository.deleteGoodsRel(rsGoodsRelReDomain.getGoodsRelId());
            }
        }
        if (null == deleteRes) {
            this.logger.error(CODE + ".updateSkuFromTc", (Object)"\u5173\u8054\u5173\u7cfb\u5220\u9664\u5931\u8d25");
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsSkuDomain rsSkuReDomain : list) {
            RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsSkuCode(skuCode);
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuReDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("3");
            rsGoodsRelDomain.setMemberCode(rsSkuReDomain.getMemberCode());
            rsGoodsRelDomain.setMemberName(rsSkuReDomain.getMemberName());
            rsGoodsRelDomain.setSkuCode(rsSkuReDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuReDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
            rsGoodsRelDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
            rsGoodsRelDomain.setDataPic(rsSkuReDomain.getDataPic());
            rsGoodsRelDomain.setTenantCode(rsSkuReDomain.getTenantCode());
            rsGoodsRelDomainList.add(rsGoodsRelDomain);
            this.logger.error(CODE + ".updateSkuFromTc.rsGoodsRelDomainList", (Object)JsonUtil.buildNonDefaultBinder().toJson(rsGoodsRelDomainList));
            this.rsSkuServiceRepository.updateSku(rsSkuReDomain);
        }
        return this.rsGoodsOtherServiceRepository.saveGoodsRelList(rsGoodsRelDomainList);
    }

    @RequestMapping(value={"deleteSku.json"}, name="\u5220\u9664\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean deleteSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".deleteSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.deleteSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPla.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0\u5546\u54c1\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPla(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotAudit.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u5ba1\u6838\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotAudit(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuPlaStop.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u505c\u7528\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPlaStop(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPlaAudit.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPlaAudit(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForSupCannel.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u4f9b\u5e94\u5546\u4e0b\u67b6\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForSupCannel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotOnShelf.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelf(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotOnShelfForAt.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelfForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPass.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelfPalt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("goodsOrigin", "0");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPassStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0\u770b\u95e8\u5e97")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPassStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("goodsOrigin", "17");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPassSStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0\u770b\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPassSStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u95e8\u5e97")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("goodsOrigin", "17");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForSStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForSStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("goodsOrigin", "18");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForMem.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5546\u5bb6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForMem(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"updateAuditOrCannel.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannel(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForPass.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelPalt(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForPassStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u5e73\u53f0\u770b\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForPassStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForPassSStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u5e73\u53f0\u770b\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForPassSStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForSStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForSStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    private HtmlJsonReBean updateAuditOrCannels(String skuIds, String flag) {
        if (StringUtils.isBlank((String)skuIds) || StringUtils.isBlank((String)flag)) {
            this.logger.error(CODE + ".updateAuditOrCannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if ("1".equals(flag)) {
            return this.rsResourceGoodsServiceRepository.sendUpdateShelveSku(Integer.valueOf(skuIds));
        }
        if ("0".equals(flag)) {
            return this.rsResourceGoodsServiceRepository.sendUpdateSoldOutSku(Integer.valueOf(skuIds));
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
    }

    @RequestMapping(value={"querySkuPageFromPtFd.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5e73\u53f0\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageFromPtFd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuPageFromSh.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5206\u9500")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageFromSh(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuRelation.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5173\u8054sku\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuRelation(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String skuCode = (String)param.get("skuCode");
        if (StringUtils.isBlank((String)skuCode)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSkuCode", skuCode);
        SupQueryResult supQueryResult = this.rsGoodsOtherServiceRepository.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        skuMap.put("tenantCode", tenantCode);
        ArrayList<RsSkuReDomain> resultList = new ArrayList<RsSkuReDomain>();
        HashMap<String, String> goodsCodeMap = new HashMap<String, String>();
        for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
            skuMap.put("skuCode", rsGoodsRelReDomain.getSkuCode());
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuMap);
            if (!goodsCodeMap.containsKey(rsSkuReDomain.getGoodsCode())) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", new Object[]{rsSkuReDomain.getGoodsCode(), tenantCode}));
                goodsCodeMap.put(rsSkuReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsName());
            }
            rsSkuReDomain.setGoodsName(String.valueOf(goodsCodeMap.get(rsSkuReDomain.getGoodsCode())));
            resultList.add(rsSkuReDomain);
        }
        SupQueryResult supQueryResult1 = new SupQueryResult();
        supQueryResult1.setList(resultList);
        supQueryResult1.setRows(resultList);
        return supQueryResult1;
    }

    @RequestMapping(value={"querySkuFromLt.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u8f6c\u76d8")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromLt(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("dataOpbillstate", 1);
            param.put("dataState", 2);
        }
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromFdRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromFdRel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromXnRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromXnRel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromXn.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u865a\u62df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromXn(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromFd.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromFd(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromReleGoo.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u53d1\u5e03\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromReleGoo(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromRepRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5e73\u53f0\u4ee3\u53d1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromRepRel(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromTcEdit.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTcEdit(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromTc.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTc(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        this.logger.error(CODE, (Object)("-----------" + param));
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromQy.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u6743\u76ca")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromQy(HttpServletRequest request) {
        return this.querySkuFromQyCom(request);
    }

    @RequestMapping(value={"querySkuFromQyForPlat.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u6743\u76ca\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromQyForPlat(HttpServletRequest request) {
        return this.querySkuFromQyCom(request);
    }

    private SupQueryResult<RsSkuReDomain> querySkuFromQyCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromJm.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u52a0\u76df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromJm(HttpServletRequest request, String channelCode) {
        Map param = this.assemMapParam(request);
        param.put("channelCode", channelCode);
        this.logger.error(CODE + ".param", (Object)("===:=====" + param));
        return this.querySkuMain(param);
    }

    private SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromLb.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u793c\u5305")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromLb(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("dataOpbillstate", 1);
            param.put("dataState", 2);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFdRel.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFdRel(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXnRel.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXnRel(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXnEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXnEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromXn.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromXn(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFdEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFdEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromFd.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromFd(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromTc.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromTc(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromTcEdit.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromTcEdit(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    @RequestMapping(value={"checkGoodsNoFromRepRel.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728-\u5e73\u53f0\u4ee3\u53d1")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNoFromRepRel(HttpServletRequest request, String goodsNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, goodsCode, skuCode);
    }

    private HtmlJsonReBean checkGoodsNoMain(String tenantCode, String goodsNo, String goodsCode, String skuCode) {
        String skuChannel;
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error(CODE + ".checkGoodsNo", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u4e3a\u7a7a");
        }
        Map param = this.getQueryMapParam("goodsNo,tenantCode", new Object[]{goodsNo, tenantCode});
        SupQueryResult rsSkuList = this.rsSkuServiceRepository.querySkuOnePage(param);
        if (null == rsSkuList || null == rsSkuList.getRows() || rsSkuList.getRows().isEmpty()) {
            return new HtmlJsonReBean();
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)goodsCode)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", new Object[]{goodsCode, tenantCode}));
            for (RsSkuReDomain rsSkuReDomain : rsSkuList.getRows()) {
                if (rsSkuReDomain.getDataState() == -1 || goodsCode.equals(rsSkuReDomain.getGoodsCode())) continue;
                String goodsChannel = rsResourceGoodsReDomain.getChannelCode() == null ? "" : rsResourceGoodsReDomain.getChannelCode();
                String string = skuChannel = rsSkuReDomain.getChannelCode() == null ? "" : rsSkuReDomain.getChannelCode();
                if (StringUtils.isBlank((String)goodsChannel) && StringUtils.isBlank((String)skuChannel)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
                }
                if (!goodsChannel.equals(skuChannel)) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (StringUtils.isNotBlank((String)skuCode)) {
            RsSkuReDomain skuBean = this.rsSkuServiceRepository.getSkuByCode(this.getQueryMapParam("skuCode,tenantCode", new Object[]{skuCode, tenantCode}));
            for (RsSkuReDomain rsSkuReDomain : rsSkuList.getRows()) {
                if (skuCode.equals(rsSkuReDomain.getSkuCode())) continue;
                String oldChannel = skuBean.getChannelCode() == null ? "" : skuBean.getChannelCode();
                String string = skuChannel = rsSkuReDomain.getChannelCode() == null ? "" : rsSkuReDomain.getChannelCode();
                if (StringUtils.isBlank((String)oldChannel) && StringUtils.isBlank((String)skuChannel)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
                }
                if (!oldChannel.equals(skuChannel)) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
            flag = true;
        }
        if (!flag && null != rsSkuList && null != rsSkuList.getList() && rsSkuList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateSkuState.json"}, name="\u7f16\u8f91\u5546\u54c1SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuState(String skuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".updateSkuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateSkuState(Integer.valueOf(skuId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateSkuFile.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean updateSkuFile(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFilePass.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateSkuFilePalt(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFilePassStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u5e73\u53f0\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateSkuFilePassStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFilePassSStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u5e73\u53f0\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateSkuFilePassSStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFileStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateSkuFileStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFileSStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateSkuFileSStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    private HtmlJsonReBean upfateSkuFiles(HttpServletRequest request, String skuCode, String fileList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)fileList)) {
            this.logger.error(CODE + ".updateSkuFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsGoodsFileDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(fileList, RsGoodsFileDomain.class);
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            rsGoodsFileDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.rsSkuServiceRepository.updateSkuFile(skuCode, this.getTenantCode(request), rsGoodsFileDomainList);
    }

    @RequestMapping(value={"querySkuBySkuCode.json"}, name="\u67e5\u8be2SKU\u5217\u8868")
    @ResponseBody
    public List<RsSkuReDomain> querySkuBySkuCode(HttpServletRequest request, String skuCodeStr) {
        List<String> skuCodeList = this.getGoodsIdList(skuCodeStr);
        HashMap<String, String> skuParam = new HashMap<String, String>();
        skuParam.put("tenantCode", this.getTenantCode(request));
        ArrayList<RsSkuReDomain> reDomains = new ArrayList<RsSkuReDomain>();
        for (String skuCode : skuCodeList) {
            skuParam.put("skuCode", skuCode);
            RsSkuReDomain skuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuParam);
            if (null == skuReDomain) continue;
            reDomains.add(skuReDomain);
        }
        return reDomains.size() > 0 ? reDomains : null;
    }

    private List<String> getGoodsIdList(String skuCodeStr) {
        String[] codeStr = skuCodeStr.split(",");
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (String code : codeStr) {
            skuCodeList.add(code);
        }
        return skuCodeList;
    }

    @RequestMapping(value={"querySkuByMscCodeFromYy.json"}, name="\u67e5\u8be2SKU\u5206\u9875\u5217\u8868-\u8fd0\u8425\u7aef\u9891\u9053\u7ba1\u7406")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuByMscCodeFromYy(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"updateCannelSkuList.json"}, name="sku-\u64a4\u724c")
    @ResponseBody
    public HtmlJsonReBean updateCannelSkuList(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateCannelSkuList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateCanSkuLisFromTc.json"}, name="sku-\u64a4\u724c-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateCanSkuLisFromTc(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateCanSkuLisFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateCanSkuLisFromXn.json"}, name="sku-\u64a4\u724c-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean updateCanSkuLisFromXn(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateCanSkuLisFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateCanSkuLisFromFd.json"}, name="sku-\u64a4\u724c-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateCanSkuLisFromFd(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateCanSkuLisFromFd", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuServiceRepository.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateAuditSkuPass.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuditSkuPass(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    @RequestMapping(value={"updateAudSkuPassFromTc.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateAudSkuPassFromTc(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    @RequestMapping(value={"updateAudSkuPassFromXn.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean updateAudSkuPassFromXn(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    @RequestMapping(value={"updateAudSkuPassFromFd.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateAudSkuPassFromFd(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    private HtmlJsonReBean updateAuditSkuPassMain(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error(CODE + ".updateAuditSkuPassMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> skuIdList = this.getSkuIdList(skuIds);
        ArrayList<RsSkuReDomain> skuList = new ArrayList<RsSkuReDomain>();
        for (Integer skuId : skuIdList) {
            RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuId);
            skuList.add(rsSkuReDomain);
        }
        this.rsSkuServiceRepository.updateAhSkuList(skuList);
        return this.rsSkuServiceRepository.updateAuditSkuPass(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"querySkuFromSc.json"}, name="\u5546\u54c1SKU-\u5e97\u94fa")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromSc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String memberCode = String.valueOf(param.get("memberCode"));
        if (null == memberCode || StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".querySkuFromSc", (Object)"param is null");
            return null;
        }
        param.put("dataOpbillstate", 1);
        param.put("dataState", 2);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromGiftInfo.json"}, name="\u5546\u54c1SKU-\u793c\u5305\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain querySkuFromGiftInfo(HttpServletRequest request, String skuCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".querySkuFromGiftInfo", (Object)"param is null");
            return null;
        }
        param.put("skuCode", skuCode);
        RsSkuDomain rsSkuDomain = this.rsSkuServiceRepository.getSkuDomainByCode(param);
        if (null == rsSkuDomain) {
            this.logger.error(CODE + ".querySkuFromGiftInfo", (Object)"rsSkuReDomain is null");
            return null;
        }
        param.remove("skuCode");
        param.put("goodsCode", rsSkuDomain.getGoodsCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(param);
        if (null != rsResourceGoodsReDomain) {
            rsSkuDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
            rsSkuDomain.setSkuRemark(rsResourceGoodsReDomain.getGoodsRemark());
        }
        RsSkuReDomain rsSkuReDomain = new RsSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuReDomain, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".querySkuFromGiftInfo", (Object)"rsSkuReDomain is null");
        }
        return rsSkuReDomain;
    }

    @RequestMapping(value={"queryHotResources.json"}, name="\u731c\u4f60\u559c\u6b22")
    @ResponseBody
    public SupQueryResult<Map<String, Object>> queryHotResources(HttpServletRequest request, String pageSize) {
        if (StringUtils.isBlank((String)pageSize)) {
            this.logger.error(CODE + ".queryHotResources", (Object)"pageSize is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        String channelCode = this.getNowChannel(request);
        String tenantCode = this.getTenantCode(request);
        String userCode = userSession.getUserCode();
        String userPhone = userSession.getUserPhone();
        SupQueryResult queryResult = new SupQueryResult();
        ReturnBean returnBean = this.rsSkuServiceRepository.queryHotSku(userCode, userPhone, pageSize, channelCode, tenantCode);
        if (null == returnBean) {
            return queryResult;
        }
        queryResult.setList(returnBean.getSourcelist());
        SupPageTools supPageTools = new SupPageTools();
        supPageTools.setRecordCount(returnBean.getCount());
        queryResult.setPageTools(supPageTools);
        queryResult.setTotal((long)returnBean.getCount());
        return queryResult;
    }

    private List<Integer> getSkuIdList(String skuIds) {
        String[] idStr = skuIds.split(",");
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            skuIdList.add(Integer.parseInt(id));
        }
        return skuIdList;
    }

    @RequestMapping(value={"querySkuMotherPage.json"}, name="\u5546\u54c1\u6bcd\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuInventory.json"}, name="\u67e5\u8be2\u5546\u54c1\u603b\u5e93\u5b58(\u4e2d\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuInventory(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("goodsOrigin", "0");
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"updateSkuNumBySkuNo.json"}, name="\u7f16\u8f91\u5546\u54c1sku\u603b\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateSkuNumBySkuNo(HttpServletRequest request, String skuNo, String goodsNum, String goodsWeight, String tenantCode) {
        if (StringUtils.isBlank((String)skuNo) || null == goodsNum || null == goodsWeight || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".updateSendUpdateSkuNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession session = this.getUserSession(request);
        if (null == session) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String memberCode = session.getUserPcode();
        String ste = this.rsResourceServiceRepository.sendToupdateSkuNum(skuNo, goodsNum, goodsWeight, memberCode, tenantCode);
        return new HtmlJsonReBean((Object)ste);
    }

    @RequestMapping(value={"getSkuByskuId.json"}, name="\u83b7\u53d6SKU\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSkuByskuId(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPageForAt.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)--\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        param.put("dataOpbillstate", 1);
        param.put("dataState", 2);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"queryResourceSkuPageAt.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u7ade\u4ef7\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResourceSkuPageAt(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("goodsOrigin", "19");
        param.put("validFlag", true);
        param.put("ginfoFlag", true);
        SupQueryResult rsResourceGoodsResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (ListUtil.isEmpty((Collection)rsResourceGoodsResult.getList())) {
            return null;
        }
        String goodsCodeStr = "";
        for (RsResourceGoodsReDomain rsResourceGoods : rsResourceGoodsResult.getList()) {
            goodsCodeStr = goodsCodeStr + "'" + rsResourceGoods.getGoodsCode() + "'" + ",";
        }
        goodsCodeStr = goodsCodeStr.substring(0, goodsCodeStr.length() - 1);
        param.remove("goodsOrigin");
        param.remove("validFlag");
        param.remove("ginfoFlag");
        param.remove("memberCode");
        param.put("goodsCodes", goodsCodeStr);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"excelExportGoods.json"}, name="excel\u5bfc\u51fa\u8d27\u54c1")
    @ResponseBody
    public HtmlJsonReBean excelExportGoods(HttpServletRequest request) {
        String jsonParam;
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param)) {
            this.logger.error(CODE + ".excelExportGoods", (Object)"param is null");
            return new HtmlJsonReBean((Object)"error");
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String string = jsonParam = null == param.get("json") ? "" : (String)param.get("json");
        if (StringUtils.isBlank((String)jsonParam)) {
            this.logger.error(CODE + ".excelExportGoods", (Object)"json is null");
            return new HtmlJsonReBean((Object)"error");
        }
        Map paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jsonParam, String.class, Object.class);
        paramMap.put("tenantCode", param.get("tenantCode"));
        paramMap.put("row", param.get("row"));
        paramMap.put("page", param.get("page"));
        paramMap.put("userInfoCode", userCode);
        try {
            this.rsSkuServiceRepository.exportExcel(paramMap, "rs.sku.querySkuOnePage");
        }
        catch (Exception e) {
            this.logger.error(CODE + ".excelExportGoods.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
            return new HtmlJsonReBean((Object)"error");
        }
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"getSkuInfo.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSkuInfo(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error(CODE + ".getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuServiceRepository.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuInfoByCode.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSkuInfo(HttpServletRequest request, String skuCode) {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".getSku", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.rsSkuServiceRepository.getSkuByCode(map);
    }

    @RequestMapping(value={"querySkuOnePageSvPageForPlat.json"}, name="\u67e5\u8be2\u670d\u52a1\u5546\u54c1SKU\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryquerySkuOnePageSvPageForPlat(HttpServletRequest request) {
        Map param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveSkuCopy.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveSkuCopy(HttpServletRequest request, String paramStr) {
        RsSkuReDomain rsSkuReDomain;
        Map param = this.assemMapParam(request);
        if (StringUtils.isEmpty((String)paramStr) || MapUtil.isEmpty((Map)param)) {
            this.logger.error(CODE + ".saveSkuCopy", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String isFictitions = null == param.get("isFictitions") ? "" : (String)param.get("isFictitions");
        String isUpdate = null == param.get("isUpdate") ? "" : (String)param.get("isUpdate");
        String goodsType = "06";
        if ("true".equals(isFictitions)) {
            goodsType = "28";
        }
        if (null == (rsSkuReDomain = (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RsSkuReDomain.class)) || null != rsSkuReDomain.getSkuId() && StringUtils.isBlank((String)rsSkuReDomain.getGoodsCode())) {
            this.logger.error(CODE + ".saveSkuCopy", (Object)("rsSkuReDomain is null" + rsSkuReDomain + "=:=" + paramStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Object reDomain = null;
        if ("false".equals(isUpdate)) {
            rsSkuReDomain.setGoodsType(goodsType);
            String returnStr = this.make(request, (RsResourceGoodsReDomain)reDomain, rsSkuReDomain);
            if (StringUtils.isBlank((String)returnStr)) {
                return null;
            }
        }
        HtmlJsonReBean htmlJsonReBean = null;
        this.logger.error(CODE + ".saveSkuCopy.update", (Object)(isUpdate + "=:=" + param + "=:=" + JsonUtil.buildNormalBinder().toJson(reDomain)));
        if ("true".equals(isUpdate)) {
            htmlJsonReBean = this.rsResourceGoodsServiceRepository.sendUpdateResourceGoods(reDomain);
        } else if (null != reDomain.getDataOpbillstate() && reDomain.getDataOpbillstate() == 1) {
            ArrayList<Object> rsResourceGoodsDomainList = new ArrayList<Object>();
            rsResourceGoodsDomainList.add(reDomain);
            htmlJsonReBean = this.rsResourceGoodsServiceRepository.sendSavePassResourceGoodsBatch(rsResourceGoodsDomainList);
        } else {
            htmlJsonReBean = this.rsResourceGoodsServiceRepository.sendSaveResourceGoods(reDomain);
        }
        return htmlJsonReBean;
    }

    private String make(HttpServletRequest request, RsResourceGoodsReDomain reDomain, RsSkuReDomain rsSkuReDomain) {
        if (StringUtils.isNotBlank((String)rsSkuReDomain.getGoodsCode())) {
            reDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", new Object[]{rsSkuReDomain.getGoodsCode(), this.getTenantCode(request)}));
            if (null == reDomain) {
                this.logger.error(CODE + ".saveSkuCopy", (Object)("reDomain is null " + rsSkuReDomain.getGoodsCode() + "=:=" + this.getTenantCode(request)));
                return null;
            }
            this.makeGoods(reDomain);
        }
        if (null == reDomain) {
            reDomain = new RsResourceGoodsReDomain();
        }
        UserSession userSession = this.getUserSession(request);
        rsSkuReDomain.setGoodsPro("6");
        if (StringUtils.isBlank((String)rsSkuReDomain.getGoodsOrigin())) {
            rsSkuReDomain.setGoodsOrigin("11");
        }
        rsSkuReDomain.setMemberCode(userSession.getUserPcode());
        rsSkuReDomain.setMemberName(null == userSession.getMerberCompname() ? userSession.getUserName() : userSession.getMerberCompname());
        rsSkuReDomain.setMemberCcode(userSession.getUserPcode());
        rsSkuReDomain.setMemberCname(userSession.getCompanyShortname());
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        rsSkuReDomain.setGinfoCode(rsSkuReDomain.getSkuNo());
        rsSkuReDomain.setSkuBarcode(rsSkuReDomain.getSkuNo());
        if (null != rsSkuReDomain.getSkuId()) {
            rsSkuReDomain.setSkuId(null);
        }
        if (null != rsSkuReDomain.getGoodsCode()) {
            rsSkuReDomain.setGoodsCode(null);
        }
        try {
            BeanUtils.copyAllPropertys((Object)reDomain, (Object)rsSkuReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveSkuCopy", (Object)("reDomain is null " + rsSkuReDomain.getGoodsCode() + "=:=" + this.getTenantCode(request)));
            return null;
        }
        this.logger.error(CODE + ".saveSkuCopy", (Object)("reDomain: " + JsonUtil.buildNormalBinder().toJson((Object)reDomain)));
        reDomain.setPntreeCode("100000262");
        reDomain.setPntreeName("PG");
        reDomain.setMemberMcode(this.getTeananMemberCode(request));
        ArrayList<RsSkuReDomain> rsSkuDomains = new ArrayList<RsSkuReDomain>();
        rsSkuDomains.add(rsSkuReDomain);
        reDomain.setRsSkuDomainList(rsSkuDomains);
        return "success";
    }

    private RsResourceGoodsReDomain makeGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsResourceGoodsReDomain) {
            this.logger.error(CODE + ",makeGoods.param is null");
            return null;
        }
        rsResourceGoodsReDomain.setGoodsId(null);
        rsResourceGoodsReDomain.setGoodsOldcode(null);
        rsResourceGoodsReDomain.setGoodsCodeOld(null);
        rsResourceGoodsReDomain.setGoodsCode(null);
        try {
            if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsSpecValueDomainList())) {
                ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsReDomain.getRsSpecValueDomainList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomainList.add(rsSpecValueDomain1);
                }
                rsResourceGoodsReDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            }
            if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsFileDomainList())) {
                ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
                for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsReDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomains.add(rsGoodsFileDomain1);
                }
                rsResourceGoodsReDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
            }
            if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsWhDomainList())) {
                ArrayList<RsGoodsWhDomain> rsGoodsWhDomains = new ArrayList<RsGoodsWhDomain>();
                for (RsGoodsWhDomain rsGoodsWhDomain : rsResourceGoodsReDomain.getRsGoodsWhDomainList()) {
                    RsGoodsWhDomain rsGoodsWhDomain1 = new RsGoodsWhDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsWhDomain1, (Object)rsGoodsWhDomain);
                    rsGoodsWhDomain1.setGoodsWhId(null);
                    rsGoodsWhDomain1.setGoodsWhCode(this.createUUIDString());
                    rsGoodsWhDomains.add(rsGoodsWhDomain1);
                }
                rsResourceGoodsReDomain.setRsGoodsWhDomainList(rsGoodsWhDomains);
            }
            if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsShopDomainList())) {
                ArrayList<RsGoodsShopDomain> rsGoodsShopDomains = new ArrayList<RsGoodsShopDomain>();
                for (RsGoodsShopDomain rsGoodsShopDomain : rsResourceGoodsReDomain.getRsGoodsShopDomainList()) {
                    RsGoodsShopDomain rsGoodsShopDomain1 = new RsGoodsShopDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsShopDomain1, (Object)rsGoodsShopDomain);
                    rsGoodsShopDomain1.setGoodsShopId(null);
                    rsGoodsShopDomain1.setGoodsShopCode(this.createUUIDString());
                    rsGoodsShopDomains.add(rsGoodsShopDomain1);
                }
                rsResourceGoodsReDomain.setRsGoodsShopDomainList(rsGoodsShopDomains);
            }
            if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
                ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
                for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    rsGoodsRelDomains.add(rsGoodsRelDomain1);
                }
                rsResourceGoodsReDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
            }
            if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomain.getRsPropertiesValueDomainList())) {
                ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsReDomain.getRsPropertiesValueDomainList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain1.setPropertiesValueId(null);
                    rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                }
                rsResourceGoodsReDomain.setRsPropertiesValueDomainList(rsPropertiesValueDomains);
            }
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makeGoods.e", (Object)rsResourceGoodsReDomain.getGoodsCode(), (Throwable)e);
            return null;
        }
        return rsResourceGoodsReDomain;
    }

    public static void main(String[] args) {
    }
}

