/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.core.util.HtmlUtil;
import com.qjsoft.laser.controller.facade.dis.repository.DisChannelServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandRelationServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoQuaReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/brand"}, name="\u5546\u54c1\u54c1\u724c")
public class RsBrandCon
extends SpringmvcController {
    private static String CODE = "rs.brand.con";
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsBrandRelationServiceRepository rsBrandRelationServiceRepository;
    @Autowired
    private DisChannelServiceRepository disChannelServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";

    protected String getContext() {
        return "brand";
    }

    @RequestMapping(value={"saveBrand.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean saveBrand(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        return this.saveBrand(request, rsBrandDomain, null);
    }

    @RequestMapping(value={"queryPriorityBrands.json"}, name="\u83b7\u53d6\u4f18\u9009\u54c1\u724c\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean queryPriorityBrands(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("brandType", 1);
        param.put("orderStr", "BRAND_SORT desc");
        SupQueryResult rsBrandReDomainSupQueryResult = this.rsBrandServiceRepository.queryBrandPage(param);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        htmlJsonReBean.setDataObj((Object)rsBrandReDomainSupQueryResult);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryBrandBindingCli.json"}, name="\u67e5\u8be2\u54c1\u724c\u7ed1\u5b9a\u5173\u7cfb")
    @ResponseBody
    public HtmlJsonReBean queryBrandBindingCli(String brandCode) {
        if (StringUtils.isBlank((String)brandCode)) {
            this.logger.error(CODE + ".queryBrandBindingCli", (Object)"brandCode is null");
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userinfoQuaKey", "brandTypes");
        params.put("userinfoQuaVaule", brandCode);
        List umUserinfoQuaReDomains = this.userServiceRepository.queryUserinfoQuaList(params);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        htmlJsonReBean.setDataObj((Object)umUserinfoQuaReDomains);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveBrandForPlat.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveBrandForPlat(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        return this.saveBrand(request, rsBrandDomain, TYPE_PLAT);
    }

    @RequestMapping(value={"saveBrandForUser.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveBrandForUser(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        return this.saveBrand(request, rsBrandDomain, TYPE_USER);
    }

    private HtmlJsonReBean saveBrand(HttpServletRequest request, RsBrandDomain rsBrandDomain, String type) {
        if (null == rsBrandDomain) {
            this.logger.error(CODE + ".saveBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request) && !this.getTenantCode(request).equals("2020121600000001")) {
                rsBrandDomain.setMemberCode(this.getTeananMemberCode(request));
                rsBrandDomain.setMemberName("\u5e73\u53f0");
            } else {
                rsBrandDomain.setMemberCode(userSession.getUserPcode());
                rsBrandDomain.setMemberName(userSession.getMerberCompname());
            }
        } else if (TYPE_PLAT.equals(type)) {
            rsBrandDomain.setMemberCode(this.getTeananMemberCode(request));
            rsBrandDomain.setMemberName("\u5e73\u53f0");
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                rsBrandDomain.setMemberCode(userSession.getUserinfoParentCode());
                rsBrandDomain.setMemberName(userSession.getUserinfoParentName());
            } else {
                rsBrandDomain.setMemberCode(userSession.getUserPcode());
                rsBrandDomain.setMemberName(userSession.getMerberCompname());
            }
        } else if (TYPE_USER.equals(type)) {
            rsBrandDomain.setMemberCode(userSession.getUserPcode());
            rsBrandDomain.setMemberName(userSession.getMerberCompname());
        }
        rsBrandDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", rsBrandDomain.getTenantCode());
        param.put("memberCode", rsBrandDomain.getMemberCode());
        param.put("brandName", rsBrandDomain.getBrandName());
        SupQueryResult result = this.rsBrandServiceRepository.queryBrandPage(param);
        if (null != result && ListUtil.isNotEmpty((Collection)result.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u54c1\u724c\u91cd\u590d");
        }
        this.makeChannel(rsBrandDomain, request);
        return this.rsBrandServiceRepository.saveBrand(rsBrandDomain);
    }

    private void makeChannel(RsBrandDomain rsBrandDomain, HttpServletRequest request) {
        if (null == rsBrandDomain || null == request) {
            return;
        }
        String memberCode = rsBrandDomain.getMemberCode();
        if (StringUtils.isBlank((String)memberCode)) {
            return;
        }
        DisChannel disChannel = this.getChannelByMemRe(memberCode, request);
        if (null == disChannel) {
            return;
        }
        rsBrandDomain.setChannelCode(disChannel.getChannelCode());
        rsBrandDomain.setChannelName(disChannel.getChannelName());
    }

    @RequestMapping(value={"getBrand.json"}, name="\u83b7\u53d6\u5546\u54c1\u54c1\u724c\u4fe1\u606f")
    @ResponseBody
    public RsBrandDomain getBrand(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".getBrand", (Object)"param is null");
            return null;
        }
        return this.rsBrandServiceRepository.getBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"updateBrand.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean updateBrand(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        if (null == rsBrandDomain) {
            this.logger.error(CODE + ".updateBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map map = this.assemMapParam(request);
        String oldBrandName = map.get("oldBrandName").toString();
        if (!oldBrandName.equals(rsBrandDomain.getBrandName())) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantCode", this.getTenantCode(request));
            param.put("memberCode", this.getUserSession(request).getUserPcode());
            param.put("brandName", rsBrandDomain.getBrandName());
            SupQueryResult result = this.rsBrandServiceRepository.queryBrandPage(param);
            if (null != result && ListUtil.isNotEmpty((Collection)result.getList())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u54c1\u724c\u91cd\u590d");
            }
        }
        rsBrandDomain.setTenantCode(this.getTenantCode(request));
        return this.rsBrandServiceRepository.updateBrand(rsBrandDomain);
    }

    @RequestMapping(value={"deleteBrand.json"}, name="\u5220\u9664\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean deleteBrand(HttpServletRequest request, String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsBrandReDomain brandReDomain = this.rsBrandServiceRepository.getBrand(Integer.valueOf(brandId));
        String brandCode = brandReDomain.getBrandCode();
        if (StringUtils.isBlank((String)brandCode)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("brandCode", brandCode);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("fuzzy", true);
        param.put("validFlag", true);
        SupQueryResult rsResourceGoodsReDomainSupQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        SupQueryResult brandRelationReDomainSupQueryResult = this.rsBrandRelationServiceRepository.queryBrandRelationPage(param);
        if (null != rsResourceGoodsReDomainSupQueryResult.getList() && rsResourceGoodsReDomainSupQueryResult.getList().size() > 0 || null != brandRelationReDomainSupQueryResult.getList() && brandRelationReDomainSupQueryResult.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u54c1\u724c\u4f7f\u7528\u4e2d");
        }
        return this.rsBrandServiceRepository.deleteBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"deleteUserBrand.json"}, name="\u5220\u9664\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean deleteUserBrand(HttpServletRequest request, String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsBrandReDomain brandReDomain = this.rsBrandServiceRepository.getBrand(Integer.valueOf(brandId));
        String brandCode = brandReDomain.getBrandCode();
        if (StringUtils.isBlank((String)brandCode)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userinfoQuaKey", "brandTypes");
        params.put("userinfoQuaVaule", brandCode);
        List umUserinfoQuaReDomains = this.userServiceRepository.queryUserinfoQuaList(params);
        if (ListUtil.isNotEmpty((Collection)umUserinfoQuaReDomains) && umUserinfoQuaReDomains.size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f53\u524d\u54c1\u724c\u5df2\u7ed1\u5b9a\u4f9b\u5e94\u5546");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("brandCode", brandCode);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("fuzzy", true);
        param.put("validFlag", true);
        SupQueryResult rsResourceGoodsReDomainSupQueryResult = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        SupQueryResult brandRelationReDomainSupQueryResult = this.rsBrandRelationServiceRepository.queryBrandRelationPage(param);
        if (null != rsResourceGoodsReDomainSupQueryResult.getList() && rsResourceGoodsReDomainSupQueryResult.getList().size() > 0 || null != brandRelationReDomainSupQueryResult.getList() && brandRelationReDomainSupQueryResult.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u54c1\u724c\u4f7f\u7528\u4e2d");
        }
        return this.rsBrandServiceRepository.deleteBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"queryBrandName.json"}, name="\u67e5\u8be2\u54c1\u724c\u540d\u79f0")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandName(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsBrandServiceRepository.queryBrandPage(param);
    }

    @RequestMapping(value={"queryBrandPageForDis.json"}, name="\u5206\u9500\u5546\u7528\u6237\u54c1\u724c")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForDis(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPage.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageByUser.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageByUser(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageForCms.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForCms(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageForSh.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u5206\u9500")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForSh(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromFdRel.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromFdRel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromXnRel.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromXnRel(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromFdEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromFdEdit(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromXnEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromXnEdit(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromTcEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromTcEdit(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromGysEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u4f9b\u5e94\u5546\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromGysEdit(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageFromC.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)- C\u7aef")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageFromC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromGoodsClass.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868- \u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromGoodsClass(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    private SupQueryResult<RsBrandReDomain> queryBrandMain(Map<String, Object> param, HttpServletRequest request) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String goodsClass = (String)this.assemMapParam(request).get("goodsClass");
        String channelCode = this.getChannelByMem(this.getMerchantCode(request), request);
        param.put("channelCode", channelCode);
        param.put("dataState", "0");
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".queryBrandMain.goodsClass");
            return null;
        }
        return this.rsBrandServiceRepository.queryBrandPage(param);
    }

    @RequestMapping(value={"updateBrandState.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBrandState(String brandId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.updateBrandState(Integer.valueOf(brandId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryBrandForUser.json"}, name="\u6839\u636e\u7528\u6237\u67e5\u8be2\u54c1\u724c\u8be6\u60c5")
    @ResponseBody
    public HtmlJsonReBean queryBrandForUser(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        UmUserinfoReDomainBean userinfoByCode = this.userServiceRepository.getUserinfoByCode(memberCode, this.getTenantCode(request));
        List umUserinfoQuaDomainList = userinfoByCode.getUmUserinfoQuaDomainList();
        for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaDomainList) {
            String userinfoQuaVaule = umUserinfoQuaReDomain.getUserinfoQuaVaule();
            if (userinfoQuaVaule == null) continue;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantCode", this.getTenantCode(request));
            param.put("brandCode", userinfoQuaVaule);
            RsBrandReDomain rsBrandReDomain = this.rsBrandServiceRepository.getBrandByCode(param);
            if (rsBrandReDomain == null || !rsBrandReDomain.getBrandName().equals(umUserinfoQuaReDomain.getUserinfoQuaVaule1())) continue;
            return new HtmlJsonReBean((Object)rsBrandReDomain);
        }
        return new HtmlJsonReBean(null);
    }

    @RequestMapping(value={"queryBrandForAll.json"}, name="\u67e5\u8be2\u6ca1\u6709\u88ab\u7ed1\u5b9a\u7684\u54c1\u724c")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandForAll(HttpServletRequest request) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult rsBrandReDomainSupQueryResult = this.rsBrandServiceRepository.queryBrandPage(param);
        List list = rsBrandReDomainSupQueryResult.getList();
        HashSet<RsBrandReDomain> set = new HashSet<RsBrandReDomain>();
        HashMap<String, String> param1 = new HashMap<String, String>();
        param1.put("userinfoQuaVaule1", "\u5382\u5bb6");
        param1.put("tenantCode", this.getTenantCode(request));
        SupQueryResult umUserinfoQuaReDomainSupQueryResult = this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(param1);
        for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaReDomainSupQueryResult.getList()) {
            String userinfoCode = umUserinfoQuaReDomain.getUserinfoCode();
            UmUserinfoReDomainBean userinfoByCode = this.userServiceRepository.getUserinfoByCode(userinfoCode, this.getTenantCode(request));
            List umUserinfoQuaDomainList = userinfoByCode.getUmUserinfoQuaDomainList();
            for (UmUserinfoQuaReDomain userinfoQuaReDomain : umUserinfoQuaDomainList) {
                String userinfoQuaVaule = userinfoQuaReDomain.getUserinfoQuaVaule();
                if (userinfoQuaVaule == null) continue;
                HashMap<String, String> param2 = new HashMap<String, String>();
                param2.put("tenantCode", this.getTenantCode(request));
                param2.put("brandCode", userinfoQuaVaule);
                RsBrandReDomain rsBrandReDomain = this.rsBrandServiceRepository.getBrandByCode(param2);
                if (rsBrandReDomain == null || !rsBrandReDomain.getBrandName().equals(userinfoQuaReDomain.getUserinfoQuaVaule1())) continue;
                set.add(rsBrandReDomain);
            }
        }
        ArrayList list1 = new ArrayList(set);
        for (int i = 0; i < list1.size(); ++i) {
            Integer brandId = ((RsBrandReDomain)list1.get(i)).getBrandId();
            for (int j = 0; j < list.size(); ++j) {
                if (!((RsBrandReDomain)list.get(j)).getBrandId().equals(brandId)) continue;
                list.remove(j);
            }
        }
        return list;
    }

    @RequestMapping(value={"queryBrandFac.json"}, name="\u6839\u636e\u7528\u6237\u67e5\u8be2\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean queryBrand(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String memberCode = userSession.getUserPcode();
        UmUserinfoReDomainBean userinfoByCode = this.userServiceRepository.getUserinfoByCode(memberCode, this.getTenantCode(request));
        List umUserinfoQuaDomainList = userinfoByCode.getUmUserinfoQuaDomainList();
        for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaDomainList) {
            String userinfoQuaVaule = umUserinfoQuaReDomain.getUserinfoQuaVaule();
            if (userinfoQuaVaule == null) continue;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantCode", this.getTenantCode(request));
            param.put("brandCode", userinfoQuaVaule);
            RsBrandReDomain rsBrandReDomain = this.rsBrandServiceRepository.getBrandByCode(param);
            if (rsBrandReDomain == null || !rsBrandReDomain.getBrandName().equals(umUserinfoQuaReDomain.getUserinfoQuaVaule1())) continue;
            if (umUserinfoQuaReDomain.getUserinfoQuaUrl1() == null) {
                return new HtmlJsonReBean((Object)rsBrandReDomain);
            }
            return new HtmlJsonReBean((Object)umUserinfoQuaReDomain);
        }
        return new HtmlJsonReBean("error", "\u8be5\u5382\u5bb6\u6ca1\u6709\u7ed1\u5b9a\u54c1\u724c");
    }

    @RequestMapping(value={"updateBrandFac.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean updateBrandFac(HttpServletRequest request, String url, String memo, String userinfoQuaCode) {
        UmUserinfoQuaReDomain umUserinfoQuaReDomain = this.umUserinfoQuaServiceRepository.getUserinfoQuaByCode(this.getTenantCode(request), userinfoQuaCode);
        umUserinfoQuaReDomain.setUserinfoQuaUrl1(url);
        umUserinfoQuaReDomain.setUserinfoQuaVaule4(memo);
        return this.umUserinfoQuaServiceRepository.updateUserinfoQua((UmUserinfoQuaDomain)umUserinfoQuaReDomain);
    }

    @RequestMapping(value={"queryBrandFromMsc.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromMsc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisGys.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u4f9b\u5e94\u5546")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisGys(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisGysBySer.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u4f9b\u5e94\u5546 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisGysBySer(HttpServletRequest request) {
        String tenantCode;
        HashMap<String, Boolean> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        if (null == (tenantCode = String.valueOf(param.get("tenantCode"))) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"param is null");
            return null;
        }
        param.put("order", true);
        SupQueryResult supQueryResult = this.rsBrandServiceRepository.queryBrandPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"result is null");
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"queryBrandFromDisZx.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u76f4\u9500")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisZx(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisSale.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u9500\u552e\u6e20\u9053")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisSale(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisStore.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisStore(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBraFromDisZxBySer.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u76f4\u9500 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public List<RsBrandReDomain> queryBraFromDisZxBySer(HttpServletRequest request) {
        String tenantCode;
        HashMap<String, Boolean> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Boolean>();
        }
        if (null == (tenantCode = String.valueOf(param.get("tenantCode"))) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"param is null");
            return null;
        }
        param.put("order", true);
        SupQueryResult supQueryResult = this.rsBrandServiceRepository.queryBrandPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"result is null");
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"queryBrandFromQy.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6743\u76ca")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromQy(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromRs.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6bcd\u5b50\u5546\u54c1")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromRs(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromQyForPlat.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6743\u76ca\u7ed9\u5e73\u53f0")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromQyForPlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromTc.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromTc(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"checkBrandName.json"}, name="\u68c0\u67e5\u5546\u54c1\u540d\u79f0")
    @ResponseBody
    public RsBrandReDomain checkBrandName(HttpServletRequest request, String brandName) {
        if (StringUtils.isBlank((String)brandName)) {
            this.logger.error(CODE + ".checkBrandName", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        return this.rsBrandServiceRepository.getBrandByName(brandName, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryBrandPageForC.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875-C\u7aef)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageByMem.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageByMem(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageForRet.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u5206\u9500\u5546")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForRet(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"brandStateStop.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001-\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean brandStateStop(String brandId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.updateBrandState(Integer.valueOf(brandId), Integer.valueOf(-1), Integer.valueOf(0));
    }

    @RequestMapping(value={"brandStateStart.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001-\u542f\u7528")
    @ResponseBody
    public HtmlJsonReBean brandStateStart(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.updateBrandState(Integer.valueOf(brandId), Integer.valueOf(0), Integer.valueOf(-1));
    }

    @RequestMapping(value={"brandStateStartEdit.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001-\u542f\u7528\u63a5\u53e32")
    @ResponseBody
    public HtmlJsonReBean brandStateStartEdit(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandServiceRepository.updateBrandState(Integer.valueOf(brandId), Integer.valueOf(0), Integer.valueOf(-1));
    }

    @RequestMapping(value={"queryBrandPageByDisRetail.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u5206\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageByDisRetail(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        return this.queryBrandMain(param, request);
    }
}

