/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ge.domain.GeGextempReDomain;
import com.qjsoft.laser.controller.facade.ge.repository.GeGextempServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsBrandRelationReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPntreeReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecGroupReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecOptionDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandRelationServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsBrandServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPntreeServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsPropertiesServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSpecServiceRepository;
import com.qjsoft.laser.controller.resources.excel.ResourcesGoodsInfo;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/pntree"}, name="\u5546\u54c1\u7c7b\u578b")
public class RsPntreeCon
extends SpringmvcController {
    private static String CODE = "rs.pntree.con";
    @Autowired
    private RsPntreeServiceRepository rsPntreeServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private GeGextempServiceRepository geGextempServiceRepository;
    @Autowired
    private RsBrandRelationServiceRepository rsBrandRelationServiceRepository;
    @Autowired
    private RsBrandServiceRepository rsBrandServiceRepository;
    @Autowired
    private RsSpecServiceRepository rsSpecServiceRepository;
    @Autowired
    private RsPropertiesServiceRepository rsPropertiesServiceRepository;

    protected String getContext() {
        return "pntree";
    }

    @RequestMapping(value={"savePntree.json"}, name="\u589e\u52a0\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean savePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".savePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<String> checklist = new ArrayList<String>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.rsPntreeServiceRepository.queryPntreePage(param);
        List list = result.getList();
        for (RsPntreeReDomain rsPntreeReDomain : list) {
            checklist.add(rsPntreeReDomain.getPntreeName());
        }
        if (checklist.contains(rsPntreeDomain.getPntreeName())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u91cd\u590d");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeServiceRepository.savePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"getPntree.json"}, name="\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u4fe1\u606f")
    @ResponseBody
    public RsPntreeReDomain getPntree(String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".getPntree", (Object)"param is null");
            return null;
        }
        return this.rsPntreeServiceRepository.getPntree(Integer.valueOf(pntreeId));
    }

    @RequestMapping(value={"updatePntree.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean updatePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".updatePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeServiceRepository.updatePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"deletePntree.json"}, name="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean deletePntree(HttpServletRequest request, String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsPntreeReDomain pntreeReDomain = this.rsPntreeServiceRepository.getPntree(Integer.valueOf(pntreeId));
        String pntreeCode = pntreeReDomain.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pntreeCode", pntreeCode);
        param.put("tenantCode", tenantCode);
        param.put("validFlag", true);
        SupQueryResult rsResourceGoodsReDomainList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(param);
        if (null != rsResourceGoodsReDomainList.getList() && rsResourceGoodsReDomainList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u4f7f\u7528\u4e2d");
        }
        HtmlJsonReBean htmlJsonReBean = this.rsPntreeServiceRepository.deletePntree(Integer.valueOf(pntreeId));
        SupQueryResult supQueryResult = this.rsBrandRelationServiceRepository.queryBrandRelationPage(param);
        this.rsBrandRelationServiceRepository.deleteBrandRelationByPntree(pntreeCode);
        SupQueryResult supQueryResult1 = this.rsSpecServiceRepository.querySpecGroupPage(param);
        if (null != supQueryResult1 && ListUtil.isNotEmpty((Collection)supQueryResult1.getList())) {
            RsSpecGroupReDomain rsSpecGroupReDomain = (RsSpecGroupReDomain)supQueryResult1.getList().get(0);
            rsSpecGroupReDomain.setPntreeCode("");
            this.rsSpecServiceRepository.updateSpecGroup((RsSpecGroupDomain)rsSpecGroupReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryPntreeTree.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreeTreeFromMsc.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTreeFromMsc(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreeTreeFromGift.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868-\u793c\u5305\u5206\u7c7b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTreeFromGift(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreePageCard.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868(\u5206\u9875)-\u5361\u5238")
    @ResponseBody
    public SupQueryResult<RsPntreeReDomain> queryPntreePageCard(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryPntreeByParam(param, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryPntreePage.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsPntreeReDomain> queryPntreePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryPntreeByParam(param, this.getTenantCode(request));
    }

    public SupQueryResult<RsPntreeReDomain> queryPntreeByParam(Map<String, Object> param, String tenantCode) {
        SupQueryResult supQueryResult = this.rsPntreeServiceRepository.queryPntreePage(param);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        ArrayList<RsPntreeReDomain> reList = new ArrayList<RsPntreeReDomain>();
        Map<String, String> brandCodeMap = this.getRelBrandCode(map);
        if (null == brandCodeMap) {
            return null;
        }
        Map<String, String> specGroupMap = this.getSpecGroupCode(map);
        if (null == specGroupMap) {
            return null;
        }
        for (RsPntreeReDomain rsPntreeReDomain : supQueryResult.getList()) {
            if (brandCodeMap.containsKey(rsPntreeReDomain.getPntreeCode())) {
                rsPntreeReDomain.setBrandCodeStr(brandCodeMap.get(rsPntreeReDomain.getPntreeCode()));
            }
            if (specGroupMap.containsKey(rsPntreeReDomain.getPntreeCode())) {
                rsPntreeReDomain.setSpecGroupCodeStr(specGroupMap.get(rsPntreeReDomain.getPntreeCode()));
            }
            reList.add(rsPntreeReDomain);
        }
        supQueryResult.setList(reList);
        supQueryResult.setRows(reList);
        return supQueryResult;
    }

    private Map<String, String> getRelBrandCode(Map<String, Object> map) {
        map.put("fuzzy", true);
        HashMap<String, String> reMap = new HashMap<String, String>();
        SupQueryResult supQueryResult1 = this.rsBrandRelationServiceRepository.queryBrandRelationPage(map);
        if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) {
            return null;
        }
        for (RsBrandRelationReDomain rsBrandRelationReDomain : supQueryResult1.getList()) {
            StringBuilder brandCode = new StringBuilder(rsBrandRelationReDomain.getBrandCode());
            if (reMap.containsKey(rsBrandRelationReDomain.getPntreeCode())) {
                brandCode.append(",");
                brandCode.append((String)reMap.get(rsBrandRelationReDomain.getPntreeCode()));
            }
            reMap.put(rsBrandRelationReDomain.getPntreeCode(), brandCode.toString());
        }
        return reMap;
    }

    private Map<String, String> getSpecGroupCode(Map<String, Object> map) {
        HashMap<String, String> reMap = new HashMap<String, String>();
        SupQueryResult supQueryResult1 = this.rsSpecServiceRepository.querySpecGroupPage(map);
        if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) {
            return null;
        }
        for (RsSpecGroupReDomain rsSpecGroupReDomain : supQueryResult1.getList()) {
            reMap.put(rsSpecGroupReDomain.getPntreeCode(), rsSpecGroupReDomain.getSpecGroupCode());
        }
        return reMap;
    }

    @RequestMapping(value={"getChildByPntree.json"}, name="\u83b7\u53d6\u7c7b\u578b\u5b50\u7c7b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> getChildByPntree(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeServiceRepository.getChildByPntree(param);
    }

    @RequestMapping(value={"updatePntreeState.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePntreeState(String pntreeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".updatePntreeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsPntreeServiceRepository.updatePntreeState(Integer.valueOf(pntreeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryPntreePageByTenantCode.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTenantCode(String tenantCode) {
        return this.fetchPntreePageByParam(tenantCode, "");
    }

    @RequestMapping(value={"queryPntreePageByTCodeAndPCode.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b-\u8fc7\u6ee4\u5df2\u7ecf\u5173\u8054\u7684\u7c7b\u578b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTCodeAndPCode(String tenantCode, String pntreeCode) {
        return this.fetchPntreePageByParam(tenantCode, pntreeCode);
    }

    public List<RsPntreeReDomain> fetchPntreePageByParam(String tenantCode, String pntreeCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".fetchPntreePageByParam", (Object)"param is null");
            return null;
        }
        ArrayList<RsPntreeReDomain> resultList = new ArrayList<RsPntreeReDomain>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        List pntreeReDomains = this.rsPntreeServiceRepository.queryPntreeTree(param);
        SupQueryResult geGextempReDomainSupQueryResult = this.geGextempServiceRepository.queryGextempPage(param);
        if (null == geGextempReDomainSupQueryResult || null == geGextempReDomainSupQueryResult.getList() || geGextempReDomainSupQueryResult.getList().size() <= 0) {
            return pntreeReDomains;
        }
        Map<String, Object> beanMap = this.transformation(geGextempReDomainSupQueryResult.getList());
        for (RsPntreeReDomain rsPntreeReDomain : pntreeReDomains) {
            if (rsPntreeReDomain.getPntreeCode().equals(beanMap.get(rsPntreeReDomain.getPntreeCode())) && !rsPntreeReDomain.getPntreeCode().equals(pntreeCode)) continue;
            resultList.add(rsPntreeReDomain);
        }
        return resultList;
    }

    @RequestMapping(value={"queryPntreePageByTenantCodePicType.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b-\u5546\u54c1\u56fe\u7247\u5206\u7c7b\u9875")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTenantCodePicType(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryPntreePageByTenantCodePicType", (Object)"param is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        return this.rsPntreeServiceRepository.queryPntreeTree(param);
    }

    @RequestMapping(value={"checkPntreeName.json"}, name="\u68c0\u67e5\u7c7b\u578b\u540d\u79f0")
    @ResponseBody
    public RsPntreeReDomain checkPntreeName(HttpServletRequest request, String pntreeCode) {
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".checkPntreeName", (Object)"param is null");
            return null;
        }
        return this.rsPntreeServiceRepository.getPntreeByCode(this.getQueryMapParam("tenantCode,pntreeCode", new Object[]{this.getTenantCode(request), pntreeCode}));
    }

    public Map<String, Object> transformation(List<GeGextempReDomain> geGextempReDomains) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GeGextempReDomain geGextempReDomain : geGextempReDomains) {
            map.put(geGextempReDomain.getPntreeCode(), geGextempReDomain.getPntreeCode());
        }
        return map;
    }

    @RequestMapping(value={"saveGoodsInfo.json"}, name="\u5bfc\u5165\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveGoodsInfo(HttpServletRequest request, String goodInfoJson) {
        if (StringUtils.isBlank((String)goodInfoJson)) {
            return new HtmlJsonReBean("error", "\u6587\u4ef6\u4e3a\u7a7a\u7684\uff0c\u8bf7\u786e\u8ba4\u4e0a\u4f20\u6587\u4ef6\u3002");
        }
        ArrayList<ResourcesGoodsInfo> errorList = new ArrayList<ResourcesGoodsInfo>();
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(goodInfoJson, ResourcesGoodsInfo.class);
        if (ListUtil.isEmpty((Collection)list)) {
            return new HtmlJsonReBean("error", "\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u4e0a\u4f20\u6587\u4ef6\u3002");
        }
        UserSession userSession = this.getUserSession(request);
        String tenantCode = userSession.getTenantCode();
        for (ResourcesGoodsInfo resourcesGoodsInfo : list) {
            String specGroupCode = "";
            String specPntreeName = "";
            HashMap<String, String> querySpecGroupMap = new HashMap<String, String>();
            querySpecGroupMap.put("specGroupName", resourcesGoodsInfo.getSpecGroupName());
            querySpecGroupMap.put("tenantCode", tenantCode);
            List rsSpecGroupReDomainList = this.rsSpecServiceRepository.querySpecGroupPage(querySpecGroupMap).getList();
            if (ListUtil.isEmpty((Collection)rsSpecGroupReDomainList)) {
                RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
                rsSpecGroupDomain.setSpecGroupName(resourcesGoodsInfo.getSpecGroupName());
                rsSpecGroupDomain.setTenantCode(tenantCode);
                specGroupCode = (String)this.rsSpecServiceRepository.saveSpecGroup(rsSpecGroupDomain).getDataObj();
            } else {
                RsPntreeReDomain pntreeReDomain;
                specGroupCode = ((RsSpecGroupReDomain)rsSpecGroupReDomainList.get(0)).getSpecGroupCode();
                String pntreeCode = ((RsSpecGroupReDomain)rsSpecGroupReDomainList.get(0)).getPntreeCode();
                if (StringUtils.isNotBlank((String)pntreeCode) && null != (pntreeReDomain = this.rsPntreeServiceRepository.getPntreeByCode(this.getQueryMapParam("pntreeCode,tenantCode", new Object[]{pntreeCode, tenantCode})))) {
                    specPntreeName = pntreeReDomain.getPntreeName();
                }
            }
            String specCode = "";
            HashMap<String, String> querySpecMap = new HashMap<String, String>();
            querySpecMap.put("specName", resourcesGoodsInfo.getSpecName());
            querySpecMap.put("tenantCode", tenantCode);
            List rsSpecReDomainList = this.rsSpecServiceRepository.querySpecPage(querySpecMap).getList();
            if (ListUtil.isEmpty((Collection)rsSpecReDomainList)) {
                RsSpecDomain rsSpecDomain = new RsSpecDomain();
                rsSpecDomain.setSpecGroupCode(specGroupCode);
                rsSpecDomain.setSpecName(resourcesGoodsInfo.getSpecName());
                rsSpecDomain.setSpecDefault("0");
                rsSpecDomain.setTenantCode(tenantCode);
                specCode = (String)this.rsSpecServiceRepository.saveSpec(rsSpecDomain).getDataObj();
            } else {
                specCode = ((RsSpecReDomain)rsSpecReDomainList.get(0)).getSpecCode();
            }
            HashMap<String, String> querySpecValueMap = new HashMap<String, String>();
            querySpecValueMap.put("specGroupCode", specGroupCode);
            querySpecValueMap.put("specCode", specCode);
            querySpecValueMap.put("specOptionName", resourcesGoodsInfo.getSpecValue());
            querySpecValueMap.put("tenantCode", tenantCode);
            List specOptionReDomainList = this.rsSpecServiceRepository.querySpecOptionPage(querySpecValueMap).getList();
            if (ListUtil.isEmpty((Collection)specOptionReDomainList)) {
                RsSpecOptionDomain rsSpecOptionDomain = new RsSpecOptionDomain();
                rsSpecOptionDomain.setSpecCode(specCode);
                rsSpecOptionDomain.setSpecGroupCode(specGroupCode);
                rsSpecOptionDomain.setSpecOptionName(resourcesGoodsInfo.getSpecValue());
                rsSpecOptionDomain.setTenantCode(tenantCode);
                this.rsSpecServiceRepository.saveSpecOption(rsSpecOptionDomain);
            }
            if (!resourcesGoodsInfo.getPntreeName().equals(specPntreeName)) {
                resourcesGoodsInfo.setReason("\u5f53\u524d" + resourcesGoodsInfo.getSpecGroupName() + "\u89c4\u683c\u7ec4" + "\u5df2\u7ecf\u7ed1\u5b9a\u4e86" + specPntreeName + "\u7c7b\u578b\u3002");
                errorList.add(resourcesGoodsInfo);
                continue;
            }
            String brandCode = "";
            RsBrandReDomain rsBrandReDomain = this.rsBrandServiceRepository.getBrandByName(resourcesGoodsInfo.getBrandName(), tenantCode);
            if (null == rsBrandReDomain) {
                RsBrandDomain rsBrandDomain = new RsBrandDomain();
                rsBrandDomain.setBrandName(resourcesGoodsInfo.getBrandName());
                rsBrandDomain.setTenantCode(tenantCode);
                String memberCode = StringUtils.isBlank((String)userSession.getUserPcode()) ? "20000210342477" : userSession.getUserPcode();
                rsBrandDomain.setMemberCode(memberCode);
                rsBrandDomain.setBrandLogo(resourcesGoodsInfo.getBrandLogo());
                brandCode = (String)this.rsBrandServiceRepository.saveBrand(rsBrandDomain).getDataObj();
            } else {
                brandCode = rsBrandReDomain.getBrandCode();
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("pntreeName", resourcesGoodsInfo.getPntreeName());
            param.put("tenantCode", tenantCode);
            List pntreeReDomainList = this.rsPntreeServiceRepository.queryPntreePage(param).getList();
            if (ListUtil.isNotEmpty((Collection)pntreeReDomainList)) {
                String specGroupCodeStr;
                HashMap<String, String> querySpecGroupStrMap = new HashMap<String, String>();
                querySpecGroupStrMap.put("pntreeCode", ((RsPntreeReDomain)pntreeReDomainList.get(0)).getPntreeCode());
                querySpecGroupStrMap.put("tenantCode", tenantCode);
                List rsSpecGroupReDomainListStr = this.rsSpecServiceRepository.querySpecGroupPage(querySpecGroupStrMap).getList();
                if (ListUtil.isNotEmpty((Collection)rsSpecGroupReDomainListStr) && StringUtils.isNotBlank((String)(specGroupCodeStr = ((RsSpecGroupReDomain)rsSpecGroupReDomainListStr.get(0)).getSpecGroupCode())) && specGroupCodeStr.equals(specGroupCode)) {
                    resourcesGoodsInfo.setReason("\u5f53\u524d" + ((RsPntreeReDomain)pntreeReDomainList.get(0)).getPntreeName() + "\u7c7b\u578b\u5df2\u7ecf\u7ed1\u5b9a" + ((RsSpecGroupReDomain)rsSpecGroupReDomainListStr.get(0)).getSpecGroupName() + "\u89c4\u683c\u7ec4\u3002");
                    errorList.add(resourcesGoodsInfo);
                    continue;
                }
                RsPntreeDomain rsPntromain = new RsPntreeDomain();
                BeanUtils.copyProperties(pntreeReDomainList.get(0), (Object)rsPntromain);
                rsPntromain.setBrandCodeStr(StringUtils.isBlank((String)rsPntromain.getBrandCodeStr()) ? brandCode : rsPntromain.getBrandCodeStr() + "," + brandCode);
                this.rsPntreeServiceRepository.updatePntree(rsPntromain);
            } else {
                RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
                rsPntreeDomain.setPntreeName(resourcesGoodsInfo.getPntreeName());
                rsPntreeDomain.setBrandCodeStr(brandCode);
                rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
                rsPntreeDomain.setTenantCode(tenantCode);
                this.rsPntreeServiceRepository.savePntree(rsPntreeDomain);
            }
            RsPropertiesDomain rsPropertiesDomain = new RsPropertiesDomain();
            rsPropertiesDomain.setTenantCode(tenantCode);
            rsPropertiesDomain.setPropertiesName(resourcesGoodsInfo.getPropertiesName());
            rsPropertiesDomain.setPropertiesType("1");
            rsPropertiesDomain.setPntreeCode("");
            this.rsPropertiesServiceRepository.saveProperties(rsPropertiesDomain);
        }
        return new HtmlJsonReBean((Object)"success");
    }
}

