/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.resources.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rs.domain.RsLaundryGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsLaundryGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsStoreRuleReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsLaundryGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsStoreRuleServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmUserinfoQuaServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/laundryGoods"}, name="\u6d17\u8863\u5546\u54c1")
public class LaundryGoodsCon
extends SpringmvcController {
    private static String CODE = "rs.laundryGoods.con";
    @Autowired
    private RsLaundryGoodsServiceRepository rsLaundryGoodsServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UmUserinfoQuaServiceRepository umUserinfoQuaServiceRepository;
    @Autowired
    private RsStoreRuleServiceRepository rsStoreRuleServiceRepository;

    protected String getContext() {
        return "laundryGoods";
    }

    @RequestMapping(value={"saveLaundryGoods.json"}, name="\u589e\u52a0\u6d17\u8863\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveLaundryGoods(HttpServletRequest request, RsLaundryGoodsDomain rsLaundryGoodsDomain) {
        SupQueryResult rsStoreRuleReDomainSupQueryResult;
        if (null == rsLaundryGoodsDomain) {
            this.logger.error(CODE + ".saveLaundryGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsLaundryGoodsDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", rsLaundryGoodsDomain.getTenantCode());
        map.put("skuCode", rsLaundryGoodsDomain.getSkuCode());
        map.put("cityCode", rsLaundryGoodsDomain.getCityCode());
        if (StringUtils.isNotBlank((String)rsLaundryGoodsDomain.getAreaCode())) {
            map.put("areaCode", rsLaundryGoodsDomain.getAreaCode());
        }
        if (ListUtil.isNotEmpty((Collection)(rsStoreRuleReDomainSupQueryResult = this.rsStoreRuleServiceRepository.queryStoreRulePage(map)).getList())) {
            RsStoreRuleReDomain rsStoreRuleReDomain = (RsStoreRuleReDomain)rsStoreRuleReDomainSupQueryResult.getList().get(0);
            rsLaundryGoodsDomain.setPricesetNprice(rsStoreRuleReDomain.getPricesetNprice());
        } else {
            rsLaundryGoodsDomain.setPricesetNprice(new BigDecimal("99999"));
        }
        return this.rsLaundryGoodsServiceRepository.saveLaundryGoods(rsLaundryGoodsDomain);
    }

    @RequestMapping(value={"batchSaveLaundryGoods.json"}, name="\u6279\u91cf\u589e\u52a0\u6d17\u8863\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean batchSaveLaundryGoods(HttpServletRequest request, String param) {
        if (StringUtils.isBlank((String)param)) {
            this.logger.error(CODE + ".batchSaveLaundryGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<RsLaundryGoodsDomain> errList = new ArrayList<RsLaundryGoodsDomain>();
        String tenantCode = this.getTenantCode(request);
        List RsLaundryGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(param, RsLaundryGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)RsLaundryGoodsDomainList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (RsLaundryGoodsDomain RsLaundryGoodsDomainStr : RsLaundryGoodsDomainList) {
                SupQueryResult rsStoreRuleReDomainSupQueryResult;
                RsLaundryGoodsDomainStr.setTenantCode(tenantCode);
                map.put("tenantCode", RsLaundryGoodsDomainStr.getTenantCode());
                map.put("skuCode", RsLaundryGoodsDomainStr.getSkuCode());
                map.put("cityCode", RsLaundryGoodsDomainStr.getCityCode());
                if (StringUtils.isNotBlank((String)RsLaundryGoodsDomainStr.getAreaCode())) {
                    map.put("areaCode", RsLaundryGoodsDomainStr.getAreaCode());
                }
                if (ListUtil.isNotEmpty((Collection)(rsStoreRuleReDomainSupQueryResult = this.rsStoreRuleServiceRepository.queryStoreRulePage(map)).getList())) {
                    RsStoreRuleReDomain rsStoreRuleReDomain = (RsStoreRuleReDomain)rsStoreRuleReDomainSupQueryResult.getList().get(0);
                    RsLaundryGoodsDomainStr.setPricesetNprice(rsStoreRuleReDomain.getPricesetNprice());
                } else {
                    RsLaundryGoodsDomainStr.setPricesetNprice(new BigDecimal("99999"));
                }
                try {
                    HtmlJsonReBean htmlJsonReBean = this.rsLaundryGoodsServiceRepository.saveLaundryGoods(RsLaundryGoodsDomainStr);
                    if (null != htmlJsonReBean.getDataObj()) continue;
                    errList.add(RsLaundryGoodsDomainStr);
                }
                catch (Exception e) {
                    errList.add(RsLaundryGoodsDomainStr);
                }
            }
        }
        return new HtmlJsonReBean(errList);
    }

    @RequestMapping(value={"getLaundryGoods.json"}, name="\u83b7\u53d6\u6d17\u8863\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public RsLaundryGoodsReDomain getLaundryGoods(Integer laundryId) {
        if (StringUtils.isBlank((Integer)laundryId)) {
            this.logger.error(CODE + ".getLaundryGoods", (Object)"param is null");
            return null;
        }
        return this.rsLaundryGoodsServiceRepository.getLaundryGoods(laundryId);
    }

    @RequestMapping(value={"updateLaundryGoods.json"}, name="\u66f4\u65b0\u6d17\u8863\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateLaundryGoods(HttpServletRequest request, RsLaundryGoodsDomain rsLaundryGoodsDomain) {
        if (null == rsLaundryGoodsDomain) {
            this.logger.error(CODE + ".updateLaundryGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsLaundryGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.rsLaundryGoodsServiceRepository.updateLaundryGoods(rsLaundryGoodsDomain);
    }

    @RequestMapping(value={"deleteLaundryGoods.json"}, name="\u5220\u9664\u6d17\u8863\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteLaundryGoods(Integer laundryId) {
        if (StringUtils.isBlank((Integer)laundryId)) {
            this.logger.error(CODE + ".deleteLaundryGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsLaundryGoodsServiceRepository.deleteLaundryGoods(laundryId);
    }

    @RequestMapping(value={"queryLaundryGoodsPage.json"}, name="\u67e5\u8be2\u6d17\u8863\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsLaundryGoodsReDomain> queryLaundryGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsLaundryGoodsServiceRepository.queryLaundryGoodsPage(param);
    }

    @RequestMapping(value={"queryLaundryGoodsStorePage.json"}, name="\u67e5\u8be2\u6d17\u8863\u5546\u54c1\u548c\u95e8\u5e97\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsLaundryGoodsReDomain> queryLaundryGoodsStorePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        SupQueryResult rsLaundryGoodsReDomainSupQueryResult = this.rsLaundryGoodsServiceRepository.queryLaundryGoodsPage(param);
        if (ListUtil.isNotEmpty((Collection)rsLaundryGoodsReDomainSupQueryResult.getList())) {
            for (RsLaundryGoodsDomain rsLaundryGoodsDomainStr : rsLaundryGoodsReDomainSupQueryResult.getList()) {
                UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(rsLaundryGoodsDomainStr.getMemberCode(), rsLaundryGoodsDomainStr.getTenantCode());
                map.put("userinfoCode", umUserinfoReDomainBean.getUserinfoCode());
                map.put("tenantCode", this.getTenantCode(request));
                umUserinfoReDomainBean.setUmUserinfoQuaDomainList(this.umUserinfoQuaServiceRepository.queryUserinfoQuaPage(map).getList());
                rsLaundryGoodsDomainStr.setUmUserinfoReDomainBean(umUserinfoReDomainBean);
            }
        }
        return rsLaundryGoodsReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateLaundryGoodsState.json"}, name="\u66f4\u65b0\u6d17\u8863\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateLaundryGoodsState(String laundryId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)laundryId)) {
            this.logger.error(CODE + ".updateLaundryGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsLaundryGoodsServiceRepository.updateLaundryGoodsState(Integer.valueOf(laundryId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"updateLaundryGoodsPrice.json"}, name="\u66f4\u65b0\u6d17\u8863\u5546\u54c1\u7684\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateLaundryGoodsPrice(HttpServletRequest request, String skuCode, String provinceCode, String cityCode, String areaCode, String subMoney, String memberCode, String remark) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)subMoney)) {
            this.logger.error(CODE + ".updateLaundryGoodsPrice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsLaundryGoodsServiceRepository.updateLaundryGoodsPrice(skuCode, this.getTenantCode(request), provinceCode, cityCode, areaCode, subMoney, memberCode, remark, null);
    }

    @RequestMapping(value={"queryLaundryGoodsPageByMemberCode.json"}, name="\u95e8\u5e97\u67e5\u8be2\u81ea\u5df1\u6d17\u8863\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsLaundryGoodsReDomain> queryLaundryGoodsPageByMemberCodeBuy(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String memberCcode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)memberCcode)) {
            this.logger.error(CODE + ".queryLaundryGoodsPageByMemberCode", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
            param.put("userinfoParentCode", memberCcode);
            param.put("tenantCode", this.getTenantCode(request));
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(memberCcode);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(param);
        if (ListUtil.isNotEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            for (UmUserinfoReDomainBean UmUserReDomainBeanStr : umUserinfoReDomainBeanSupQueryResult.getList()) {
                if (StringUtils.isNotBlank((String)sb.toString())) {
                    sb.append(",");
                    sb.append(UmUserReDomainBeanStr.getUserinfoCode());
                    continue;
                }
                return new SupQueryResult();
            }
        } else {
            return new SupQueryResult();
        }
        param.put("memberCodeStr", sb.toString());
        return this.rsLaundryGoodsServiceRepository.queryLaundryGoodsPage(param);
    }

    @RequestMapping(value={"queryLaundryGoodsPageByMemberCode.json"}, name="\u95e8\u5e97\u67e5\u8be2\u81ea\u5df1\u6d17\u8863\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsLaundryGoodsReDomain> queryLaundryGoodsPageByMemberCode(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String memberCode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryLaundryGoodsPageByMemberCode", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("userinfoQuality", "store");
            param.put("userinfoCode", memberCode);
            param.put("tenantCode", this.getTenantCode(request));
        }
        StringBuffer sb = new StringBuffer();
        sb.append(memberCode);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(param);
        if (ListUtil.isNotEmpty((Collection)umUserinfoReDomainBeanSupQueryResult.getList())) {
            for (UmUserinfoReDomainBean UmUserReDomainBeanStr : umUserinfoReDomainBeanSupQueryResult.getList()) {
                if (StringUtils.isNotBlank((String)sb.toString())) {
                    sb.append(",");
                    sb.append(UmUserReDomainBeanStr.getUserinfoCode());
                    continue;
                }
                return new SupQueryResult();
            }
        } else {
            return new SupQueryResult();
        }
        param.put("memberCodeStr", sb.toString());
        return this.rsLaundryGoodsServiceRepository.queryLaundryGoodsPage(param);
    }

    @RequestMapping(value={"updateBatchLaundryGoodsState.json"}, name="\u6d17\u8863\u5546\u54c1\u6279\u91cf\u4e0a\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateBatchLaundryGoodsState(String goodsIdStr, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsIdStr)) {
            this.logger.error(CODE + ".updateBatchLaundryGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> goodsIdList = this.getGoodsIdList(goodsIdStr);
        for (Integer goodsId : goodsIdList) {
            this.rsLaundryGoodsServiceRepository.updateLaundryGoodsState(goodsId, dataState, oldDataState, null);
        }
        return new HtmlJsonReBean();
    }

    private List<Integer> getGoodsIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            goodsIdList.add(Integer.parseInt(id));
        }
        return goodsIdList;
    }
}

