/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wo.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractFileDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractFileReDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractGoodsDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractGoodsReDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractReDomain;
import com.qjsoft.laser.controller.facade.sp.repository.SpScontractServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserBaseServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvcController {
    private static String CODE = "sp.scontract.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private SpScontractServiceRepository spScontractServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private UserBaseServiceRepository userBaseServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;

    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontract(spScontractDomain);
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, String> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, String>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsSpec5(skuDomain.getSkuId().toString());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractPage(param);
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(String scontractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error(CODE + ".updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error(CODE + ".saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error(CODE + ".updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error(CODE + ".updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }

    @RequestMapping(value={"saveScontractStrNew1.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractNew1(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map map = this.assemMapParam(request);
        this.logger.error("\u65b0\u589e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractPageNew.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param.get("memberGcode") && !"".equals(param.get("memberGcode"))) {
            if ("0".equals(param.get("memberGcode")) || "1".equals(param.get("memberGcode"))) {
                param.put("order", true);
            } else {
                param.put("order", true);
                param.put("fuzzy", true);
            }
        } else {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.spScontractServiceRepository.queryScontractPage(param);
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", (Object)result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null == spScontractReDomain.getContractDepositdate() || null == spScontractReDomain.getContractEffectivedate()) continue;
            Date endDate = spScontractReDomain.getContractDepositdate();
            Date startDate = spScontractReDomain.getContractEffectivedate();
            double times = endDate.getTime() - startDate.getTime();
            times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
            DecimalFormat df = new DecimalFormat("#0.0");
            String years = df.format(times);
            if (years.endsWith(".0")) {
                years = years.substring(0, years.length() - 2);
            }
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
            spScontractReDomain.setAreaName(years);
        }
        return result;
    }

    @RequestMapping(value={"updateScontractStr.json"}, name="\u4fee\u6539\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean updateScontractStr(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map map = this.assemMapParam(request);
        this.logger.error("\u4fee\u6539\u9500\u552e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SupQueryResult spScontractReDomainSupQueryResult;
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    cal.setTime(scontractStr.getContractEffectivedate());
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            if (map.get("sconId") != null && !"".equals(map.get("sconId"))) {
                this.spScontractServiceRepository.deleteScontract(Integer.valueOf(map.get("sconId").toString()));
            }
            scontractStr.setDataState(Integer.valueOf(1));
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractCode", htmlJsonReBean.getDataObj().toString());
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
            }
            if (null == (spScontractReDomainSupQueryResult = this.spScontractServiceRepository.queryScontractPage(param)) || ListUtil.isEmpty((Collection)spScontractReDomainSupQueryResult.getList())) {
                this.logger.error("result=================>", (Object)spScontractReDomainSupQueryResult);
            } else {
                Integer scontractId = ((SpScontractReDomain)spScontractReDomainSupQueryResult.getList().get(0)).getScontractId();
                this.spScontractServiceRepository.updateScontractState(scontractId, Integer.valueOf(1), null, null);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryBuyerScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryBuyerScontractPage(HttpServletRequest request) {
        SupQueryResult result;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (result = this.spScontractServiceRepository.queryScontractPage(param)) || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", (Object)result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                Date endDate = spScontractReDomain.getContractDepositdate();
                Date startDate = spScontractReDomain.getContractEffectivedate();
                double times = endDate.getTime() - startDate.getTime();
                times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
                DecimalFormat df = new DecimalFormat("#0.0");
                String years = df.format(times);
                if (years.endsWith(".0")) {
                    years = years.substring(0, years.length() - 2);
                }
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
                spScontractReDomain.setAreaName(years);
            }
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                long endDate = spScontractReDomain.getContractDepositdate().getTime();
                long startDate = spScontractReDomain.getContractEffectivedate().getTime();
                long nowDate = new Date().getTime();
                Integer buttonState = 0;
                Integer dataState = spScontractReDomain.getDataState();
                if ("0".equals(spScontractReDomain.getMemberGcode()) && dataState != 5) {
                    if (startDate > nowDate) {
                        dataState = 0;
                        buttonState = 1;
                    } else if (nowDate >= startDate && nowDate <= endDate) {
                        if (dataState == 2) {
                            dataState = 2;
                            buttonState = 4;
                        } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                            if (Double.valueOf(spScontractReDomain.getMemberCname()) == 0.0) {
                                dataState = 4;
                                buttonState = 1;
                            } else {
                                dataState = 1;
                                buttonState = 2;
                            }
                        }
                    } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                        if (Double.valueOf(spScontractReDomain.getMemberCname()) > 0.0) {
                            dataState = 3;
                            buttonState = 3;
                        } else {
                            dataState = 4;
                            buttonState = 1;
                        }
                    }
                }
                spScontractReDomain.setDataState(dataState);
                spScontractReDomain.setContractUserurl(buttonState.toString());
            }
            if (!spScontractReDomain.getMemberGcode().startsWith("2")) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("scontractCode", spScontractReDomain.getScontractCode());
            params.put("dataState", 1);
            SupQueryResult spScontractFileReDomainSupQueryResult = this.spScontractServiceRepository.queryScontractFilePage(params);
            if (null == spScontractFileReDomainSupQueryResult || ListUtil.isEmpty((Collection)spScontractFileReDomainSupQueryResult.getList())) {
                spScontractReDomain.setContractUserurl("5");
                continue;
            }
            spScontractReDomain.setContractUserurl("6");
        }
        return result;
    }

    @RequestMapping(value={"updateScontractNew.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontractNew(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        SpScontractReDomain scontract = this.spScontractServiceRepository.getScontract(spScontractDomain.getScontractId());
        scontract.setContractDepositdate(spScontractDomain.getContractDepositdate());
        return this.spScontractServiceRepository.updateScontract((SpScontractDomain)scontract);
    }

    @RequestMapping(value={"updateScontractFileNew.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileNew(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scontractCode", goodsClassDomain.getScontractCode());
        SupQueryResult result = this.spScontractServiceRepository.queryScontractFilePage(param);
        goodsClassDomain.setScontractFileId(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        goodsClassDomain.setScontractFileCode(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileCode());
        this.logger.error("ScontractFileId----------------------------------------" + ((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        return this.spScontractServiceRepository.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"saveBuyerScontractExcelStr.json"}, name="\u5bfc\u5165\u4e70\u5bb6\u5408\u540c\u8868\u683c")
    @ResponseBody
    public HtmlJsonReBean saveBuyerScontractExcel(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractObillcode", scontractStr.getScontractObillcode());
            param.put("contractInvstate", 2);
            SupQueryResult result = this.spScontractServiceRepository.queryScontractPage(param);
            HtmlJsonReBean htmlJsonReBean = null;
            if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
                scontractStr.setContractInvstate(Integer.valueOf(1));
                htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            } else {
                SpScontractReDomain spScontractReDomain = (SpScontractReDomain)result.getList().get(0);
                spScontractReDomain.setMemberCcode(scontractStr.getMemberCcode());
                spScontractReDomain.setMemberCname(scontractStr.getMemberCname());
                htmlJsonReBean = this.spScontractServiceRepository.updateScontract((SpScontractDomain)spScontractReDomain);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractGoodsPageNew1.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868\uff08\u65b0\uff09")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryScontractGoodsPageNew1(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.spScontractServiceRepository.queryScontractGoodsPage(param);
        this.logger.error("\u5408\u540c\u5546\u54c11---------------------------------" + result.getList());
        SupQueryResult rsSkuResult = new SupQueryResult();
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            for (SpScontractGoodsReDomain spScontractGoodsReDomain : result.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", spScontractGoodsReDomain.getSkuCode());
                SupQueryResult rsSkuReDomainSupQueryResult = this.rsSkuServiceRepository.querySkuOnePage(map);
                this.logger.error("\u5408\u540c\u5546\u54c12---------------------------------" + rsSkuReDomainSupQueryResult.getRows());
                if (null != rsSkuReDomainSupQueryResult && !ListUtil.isEmpty((Collection)rsSkuReDomainSupQueryResult.getRows())) continue;
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)rsSkuReDomainSupQueryResult.getRows().get(0);
                rsSkuReDomain.setPricesetInsideprice(spScontractGoodsReDomain.getPricesetNprice());
                rsSkuResult.getRows().add(rsSkuReDomain);
                rsSkuResult.getList().add(rsSkuReDomain);
            }
        }
        this.logger.error("\u5408\u540c\u5546\u54c13---------------------------------" + rsSkuResult.getRows());
        return rsSkuResult;
    }

    private List<Map<String, Object>> type1() {
        HashMap map = new HashMap(){
            {
                this.put("SCONTRACT_BCODE", "2021030400000001");
                this.put("CONTRACT_ECURL", "\u5c60\u5e78\u8fd0");
                this.put("CONTRACT_TYPEPRO", "18656965766");
            }
        };
        ArrayList<Map<String, Object>> type1 = new ArrayList<Map<String, Object>>();
        type1.add(map);
        return type1;
    }

    private List<Map<String, Object>> type2() {
        HashMap map = new HashMap(){
            {
                this.put("COMPANY_CODE", "20000210312991");
                this.put("CONTRACT_ECURL", "\u6f58\u67cf\u6797");
                this.put("CONTRACT_TYPEPRO", "18656965766");
            }
        };
        ArrayList<Map<String, Object>> type2 = new ArrayList<Map<String, Object>>();
        type2.add(map);
        return type2;
    }

    private List<Map<String, Object>> type3() {
        HashMap map = new HashMap(){
            {
                this.put("AREA_CODE", "150103");
                this.put("CONTRACT_ECURL", "\u53f2\u65b0\u5b87");
                this.put("CONTRACT_TYPEPRO", "18656965766");
            }
        };
        HashMap map2 = new HashMap(){
            {
                this.put("AREA_CODE", "150104");
                this.put("CONTRACT_ECURL", "\u738b\u7434");
                this.put("CONTRACT_TYPEPRO", "18656965766");
            }
        };
        ArrayList<Map<String, Object>> type3 = new ArrayList<Map<String, Object>>();
        type3.add(map);
        type3.add(map2);
        return type3;
    }

    @RequestMapping(value={"forwardQueryScontractPageNew.json"}, name="\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e")
    @ResponseBody
    public HtmlJsonReBean forwardQueryScontractPageNew(HttpServletRequest request) {
        boolean flag = true;
        Map param = this.assemMapParam(request);
        Map check = this.assemMapParam(request);
        check.put("contractInvstate", 2);
        SupQueryResult checkResult = this.spScontractServiceRepository.queryScontractPage(check);
        if (!ListUtil.isEmpty((Collection)checkResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u60a8\u5df2\u9884\u7ea6\u8be5\u5408\u540c");
        }
        if (StringUtils.isBlank((String)param.get("scontractCode").toString()) || StringUtils.isBlank((String)param.get("userinfoPhone").toString())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        param.put("contractInvstate", 0);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        this.logger.error("scontractCode:" + param.get("scontractCode").toString());
        this.logger.error("userinfoPhone:" + param.get("userinfoPhone").toString());
        HashMap<String, Comparable<Boolean>> checkSp = new HashMap<String, Comparable<Boolean>>();
        checkSp.put("order", Boolean.valueOf(true));
        checkSp.put("fuzzy", Boolean.valueOf(false));
        checkSp.put("contractInvstate", Integer.valueOf(0));
        checkSp.put("scontractCode", (Comparable<Boolean>)param.get("scontractCode"));
        SupQueryResult supQueryResult = this.spScontractServiceRepository.queryScontractPage(checkSp);
        if (ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u5408\u540c\u53f7\u4e0d\u5b58\u5728");
        }
        UmUserDomainBean umUserDomainBean = this.userServiceRepository.getuserByPhone(param.get("userinfoPhone").toString(), this.getTenantCode(request));
        if (null == umUserDomainBean.getUserPcode()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> checkUserinfo = new HashMap<String, Object>();
        checkUserinfo.put("order", true);
        checkUserinfo.put("fuzzy", false);
        checkUserinfo.put("userinfoCode", umUserDomainBean.getUserPcode());
        SupQueryResult UserinfoResult = this.userServiceRepository.queryUserinfoPage(checkUserinfo);
        if (ListUtil.isEmpty((Collection)UserinfoResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SpScontractDomain spScontractDomain = (SpScontractDomain)supQueryResult.getList().get(0);
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)UserinfoResult.getList().get(0);
        List<Map<String, Object>> type1 = this.type1();
        for (int i = 0; i < this.type1().size(); ++i) {
            if (!type1.get(i).get("SCONTRACT_BCODE").equals(param.get("scontractCode")) && !flag) continue;
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            spScontractDomain.setContractType(type1.get(i).get("CONTRACT_ECURL").toString());
            spScontractDomain.setContractTypepro(type1.get(i).get("CONTRACT_TYPEPRO").toString());
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoDischannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoDischannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            this.logger.error("**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
            HtmlJsonReBean htmlJsonReBean1 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBean1;
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        if (((UmUserinfoReDomainBean)UserinfoResult.getList().get(0)).getUserinfoType().equals("2") || flag) {
            map2.put("companyCode", ((UmUserinfoReDomainBean)UserinfoResult.getList().get(0)).getCompanyCode());
            List<Map<String, Object>> type2 = this.type2();
            for (int i = 0; i < type2.size(); ++i) {
                if (!type2.get(i).get("COMPANY_CODE").equals(map2.get("companyCode"))) continue;
                spScontractDomain.setContractInvstate(Integer.valueOf(2));
                spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
                spScontractDomain.setScontractId(null);
                spScontractDomain.setScontractCode(null);
                spScontractDomain.setContractType(type2.get(i).get("CONTRACT_ECURL").toString());
                spScontractDomain.setContractTypepro(type2.get(i).get("CONTRACT_TYPEPRO").toString());
                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                spScontractDomain.setGoodsPmbillno(sm.format(date));
                spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
                spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
                spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
                spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
                spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoDischannelcode());
                spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoDischannelname());
                spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
                this.logger.error("**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
                HtmlJsonReBean htmlJsonReBean2 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
                return htmlJsonReBean2;
            }
        }
        HashMap map3 = new HashMap();
        if (param.containsKey("areaCode")) {
            map3.put("areaCode", param.get("areaCode"));
            List<Map<String, Object>> type3 = this.type3();
            for (int i = 0; i < type3.size(); ++i) {
                if (!type3.get(i).get("AREA_CODE").equals(map3.get("areaCode")) && !flag) continue;
                spScontractDomain.setContractInvstate(Integer.valueOf(2));
                spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
                spScontractDomain.setScontractId(null);
                spScontractDomain.setScontractCode(null);
                spScontractDomain.setContractType(type3.get(i).get("CONTRACT_ECURL").toString());
                spScontractDomain.setContractTypepro(type3.get(i).get("CONTRACT_TYPEPRO").toString());
                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                spScontractDomain.setGoodsPmbillno(sm.format(date));
                spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
                spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
                spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
                spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
                spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoDischannelcode());
                spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoDischannelname());
                spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
                this.logger.error("**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
                HtmlJsonReBean htmlJsonReBean3 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
                return htmlJsonReBean3;
            }
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u80fd\u5339\u914d\u5230\u5408\u9002\u7684\u9500\u552e");
    }

    @RequestMapping(value={"talkOverWithSell.json"}, name="\u9500\u552e\u6d3d\u8c08\u72b6\u6001\u66f4\u6539")
    @ResponseBody
    public HtmlJsonReBean talkOverWithSell(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        param.put("tenantCode", tenantCode);
        SpScontractReDomain spScontractReDomainUpdate = this.spScontractServiceRepository.getScontractByCode(tenantCode, param.get("scontractCode").toString());
        SpScontractReDomain spScontractReDomain = (SpScontractReDomain)JsonUtil.buildNormalBinder().getJsonToList(paramStr, SpScontractReDomain.class);
        return this.spScontractServiceRepository.updateScontract((SpScontractDomain)spScontractReDomainUpdate);
    }

    @RequestMapping(value={"contractList.json"}, name="\u5c55\u793a\u9500\u552e\u5408\u540c\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean contractList(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        return null;
    }

    @RequestMapping(value={"ImportBuyerContracts.json"}, name="\u5bfc\u5165\u7ebf\u4e0b\u4e70\u5bb6\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr) {
        if (StringUtils.isBlank((String)scontractDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "params is null");
        }
        this.logger.error(scontractDomainStr);
        List spScontractDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        String msg = "";
        int errCount = 0;
        HtmlJsonReBean htmlJsonReBean = null;
        for (SpScontractDomain spScontractDomain : spScontractDomainList) {
            spScontractDomain.setTenantCode(this.getTenantCode(request));
            spScontractDomain.getScontractCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String scontractNcode = spScontractDomain.getScontractNcode();
            String scontractObillcode = spScontractDomain.getScontractObillcode();
            map.put("scontractObillcode", spScontractDomain.getScontractObillcode());
            this.logger.error("scontractObillcode---------------------------------" + spScontractDomain.getScontractObillcode());
            map.put("tenantCode", this.getTenantCode(request));
            map.put("contractInvstate", 0);
            List SpScontractReDomain2 = this.spScontractServiceRepository.queryScontractPage(map).getList();
            if (ListUtil.isEmpty((Collection)SpScontractReDomain2)) {
                msg = msg + scontractObillcode + "\u8be5\u5408\u540c\u4e0d\u5b58\u5728;";
                this.logger.error(scontractObillcode + "\uff1a11111111111\u5408\u540c\u4e0d\u5b58\u5728");
                ++errCount;
                continue;
            }
            SpScontractReDomain SpScontractReDomain22 = (SpScontractReDomain)SpScontractReDomain2.get(0);
            map.put("contractInvstate", 1);
            map.put("memberBcode", spScontractDomain.getMemberBcode());
            List SpScontractReDomain1 = this.spScontractServiceRepository.queryScontractPage(map).getList();
            if (ListUtil.isEmpty((Collection)SpScontractReDomain1)) {
                SpScontractReDomain22.setScontractObillcode(spScontractDomain.getScontractObillcode());
                SpScontractReDomain22.setScontractNcode(spScontractDomain.getScontractNcode());
                SpScontractReDomain22.setGoodsMoney(spScontractDomain.getGoodsMoney());
                SpScontractReDomain22.setContractEffectivedate(spScontractDomain.getContractEffectivedate());
                SpScontractReDomain22.setContractDepositdate(spScontractDomain.getContractDepositdate());
                SpScontractReDomain22.setDataState(spScontractDomain.getDataState());
                SpScontractReDomain22.setMemberCname(spScontractDomain.getMemberCname());
                SpScontractReDomain22.setMemberCcode(spScontractDomain.getMemberCcode());
                SpScontractReDomain22.setMemberBcode(spScontractDomain.getMemberBcode());
                SpScontractReDomain22.setScontractBcode(spScontractDomain.getScontractBcode());
                SpScontractReDomain22.setContractInvstate(Integer.valueOf(1));
                this.logger.error("\u4e2a\u4eba\u5408\u540c\u4e0d\u5b58\u5728\uff0c\u65b0\u589e" + scontractObillcode);
                SpScontractReDomain22.setScontractId(null);
                SpScontractReDomain22.setScontractCode(null);
                htmlJsonReBean = this.spScontractServiceRepository.saveScontract((SpScontractDomain)SpScontractReDomain22);
                continue;
            }
            spScontractDomain.setScontractId(((SpScontractReDomain)SpScontractReDomain1.get(0)).getScontractId());
            if (StringUtils.isNotBlank((String)((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode())) {
                if (((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode().equals(scontractNcode)) {
                    this.logger.error("\u5916\u90e8\u5408\u540c\u6821\u9a8c\u901a\u8fc7\uff1a" + ((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode());
                    htmlJsonReBean = this.spScontractServiceRepository.updateScontract(spScontractDomain);
                    continue;
                }
                msg = msg + scontractObillcode + "\u5916\u90e8\u5408\u540c\u7f16\u53f7\u4e0d\u6b63\u786e;";
                this.logger.error(spScontractDomain.getScontractObillcode() + "\u5916\u90e8\u5408\u540c\u7f16\u53f7\u6821\u9a8c\u4e0d\u901a\u8fc7");
                ++errCount;
                continue;
            }
            this.logger.error("msg", (Object)("\u5916\u90e8\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a" + spScontractDomain.getScontractObillcode()));
            this.logger.error("msg", (Object)("id" + spScontractDomain.getScontractObillcode()));
            htmlJsonReBean = this.spScontractServiceRepository.updateScontract(spScontractDomain);
        }
        if (errCount == 0) {
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u5165\u5931\u8d25\uff1a" + errCount + "\u6761," + msg);
    }
}

