/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.wo.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractFileDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractFileReDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractGoodsDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractGoodsReDomain;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractReDomain;
import com.qjsoft.laser.controller.facade.sp.repository.SpScontractServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserBaseServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvcController {
    private static String CODE = "sp.scontract.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private SpScontractServiceRepository spScontractServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private UserBaseServiceRepository userBaseServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;

    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontract(spScontractDomain);
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, String> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, String>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsSpec5(skuDomain.getSkuId().toString());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractPage(param);
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(String scontractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error(CODE + ".updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error(CODE + ".saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error(CODE + ".updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractServiceRepository.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractServiceRepository.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error(CODE + ".updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractServiceRepository.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractServiceRepository.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }

    @RequestMapping(value={"saveScontractStrNew1.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractNew1(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map map = this.assemMapParam(request);
        this.logger.error("\u65b0\u589e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractPageNew.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageNew(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param.get("memberGcode") && !"".equals(param.get("memberGcode"))) {
            if ("0".equals(param.get("memberGcode")) || "1".equals(param.get("memberGcode"))) {
                param.put("order", true);
            } else {
                param.put("order", true);
                param.put("fuzzy", true);
            }
        } else {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.spScontractServiceRepository.queryScontractPage(param);
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", (Object)result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null == spScontractReDomain.getContractDepositdate() || null == spScontractReDomain.getContractEffectivedate()) continue;
            Date endDate = spScontractReDomain.getContractDepositdate();
            Date startDate = spScontractReDomain.getContractEffectivedate();
            double times = endDate.getTime() - startDate.getTime();
            times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
            DecimalFormat df = new DecimalFormat("#0.0");
            String years = df.format(times);
            if (years.endsWith(".0")) {
                years = years.substring(0, years.length() - 2);
            }
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
            spScontractReDomain.setAreaName(years);
        }
        return result;
    }

    @RequestMapping(value={"updateScontractStr.json"}, name="\u4fee\u6539\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean updateScontractStr(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map map = this.assemMapParam(request);
        this.logger.error("\u4fee\u6539\u9500\u552e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SupQueryResult spScontractReDomainSupQueryResult;
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    cal.setTime(scontractStr.getContractEffectivedate());
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            if (map.get("sconId") != null && !"".equals(map.get("sconId"))) {
                this.spScontractServiceRepository.deleteScontract(Integer.valueOf(map.get("sconId").toString()));
            }
            scontractStr.setDataState(Integer.valueOf(1));
            HtmlJsonReBean htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractCode", htmlJsonReBean.getDataObj().toString());
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
            }
            if (null == (spScontractReDomainSupQueryResult = this.spScontractServiceRepository.queryScontractPage(param)) || ListUtil.isEmpty((Collection)spScontractReDomainSupQueryResult.getList())) {
                this.logger.error("result=================>", (Object)spScontractReDomainSupQueryResult);
            } else {
                Integer scontractId = ((SpScontractReDomain)spScontractReDomainSupQueryResult.getList().get(0)).getScontractId();
                this.spScontractServiceRepository.updateScontractState(scontractId, Integer.valueOf(1), null, null);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryBuyerScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryBuyerScontractPage(HttpServletRequest request) {
        SupQueryResult result;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (result = this.spScontractServiceRepository.queryScontractPage(param)) || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", (Object)result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                Date endDate = spScontractReDomain.getContractDepositdate();
                Date startDate = spScontractReDomain.getContractEffectivedate();
                double times = endDate.getTime() - startDate.getTime();
                times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
                DecimalFormat df = new DecimalFormat("#0.0");
                String years = df.format(times);
                if (years.endsWith(".0")) {
                    years = years.substring(0, years.length() - 2);
                }
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
                spScontractReDomain.setAreaName(years);
            }
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                long endDate = spScontractReDomain.getContractDepositdate().getTime();
                long startDate = spScontractReDomain.getContractEffectivedate().getTime();
                long nowDate = new Date().getTime();
                Integer buttonState = 0;
                Integer dataState = spScontractReDomain.getDataState();
                if ("0".equals(spScontractReDomain.getMemberGcode()) && dataState != 5) {
                    if (startDate > nowDate) {
                        dataState = 0;
                        buttonState = 1;
                    } else if (nowDate >= startDate && nowDate <= endDate) {
                        if (dataState == 2) {
                            dataState = 2;
                            buttonState = 4;
                        } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                            if (Double.valueOf(spScontractReDomain.getMemberCname()) == 0.0) {
                                dataState = 4;
                                buttonState = 1;
                            } else {
                                dataState = 1;
                                buttonState = 2;
                            }
                        }
                    } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                        if (Double.valueOf(spScontractReDomain.getMemberCname()) > 0.0) {
                            dataState = 3;
                            buttonState = 3;
                        } else {
                            dataState = 4;
                            buttonState = 1;
                        }
                    }
                }
                spScontractReDomain.setDataState(dataState);
                spScontractReDomain.setContractUserurl(buttonState.toString());
            }
            if (!spScontractReDomain.getMemberGcode().startsWith("2")) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("scontractCode", spScontractReDomain.getScontractCode());
            params.put("dataState", 1);
            SupQueryResult spScontractFileReDomainSupQueryResult = this.spScontractServiceRepository.queryScontractFilePage(params);
            if (null == spScontractFileReDomainSupQueryResult || ListUtil.isEmpty((Collection)spScontractFileReDomainSupQueryResult.getList())) {
                spScontractReDomain.setContractUserurl("5");
                continue;
            }
            spScontractReDomain.setContractUserurl("6");
        }
        return result;
    }

    @RequestMapping(value={"updateScontractNew.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontractNew(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        SpScontractReDomain scontract = this.spScontractServiceRepository.getScontract(spScontractDomain.getScontractId());
        scontract.setContractDepositdate(spScontractDomain.getContractDepositdate());
        return this.spScontractServiceRepository.updateScontract((SpScontractDomain)scontract);
    }

    @RequestMapping(value={"updateScontractFileNew.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileNew(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scontractCode", goodsClassDomain.getScontractCode());
        SupQueryResult result = this.spScontractServiceRepository.queryScontractFilePage(param);
        goodsClassDomain.setScontractFileId(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        goodsClassDomain.setScontractFileCode(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileCode());
        this.logger.error("ScontractFileId----------------------------------------" + ((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        return this.spScontractServiceRepository.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"saveBuyerScontractExcelStr.json"}, name="\u5bfc\u5165\u4e70\u5bb6\u5408\u540c\u8868\u683c")
    @ResponseBody
    public HtmlJsonReBean saveBuyerScontractExcel(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator i$ = scontract.iterator();
        if (i$.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)i$.next();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractObillcode", scontractStr.getScontractObillcode());
            param.put("contractInvstate", 2);
            SupQueryResult result = this.spScontractServiceRepository.queryScontractPage(param);
            HtmlJsonReBean htmlJsonReBean = null;
            if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
                scontractStr.setContractInvstate(Integer.valueOf(1));
                htmlJsonReBean = this.spScontractServiceRepository.saveScontract(scontractStr);
            } else {
                SpScontractReDomain spScontractReDomain = (SpScontractReDomain)result.getList().get(0);
                spScontractReDomain.setMemberCcode(scontractStr.getMemberCcode());
                spScontractReDomain.setMemberCname(scontractStr.getMemberCname());
                htmlJsonReBean = this.spScontractServiceRepository.updateScontract((SpScontractDomain)spScontractReDomain);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractGoodsPageNew1.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868\uff08\u65b0\uff09")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryScontractGoodsPageNew1(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult result = this.spScontractServiceRepository.queryScontractGoodsPage(param);
        this.logger.error("\u5408\u540c\u5546\u54c11---------------------------------" + result.getList());
        SupQueryResult rsSkuResult = new SupQueryResult();
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            for (SpScontractGoodsReDomain spScontractGoodsReDomain : result.getList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", spScontractGoodsReDomain.getSkuCode());
                SupQueryResult rsSkuReDomainSupQueryResult = this.rsSkuServiceRepository.querySkuOnePage(map);
                this.logger.error("\u5408\u540c\u5546\u54c12---------------------------------" + rsSkuReDomainSupQueryResult.getRows());
                if (null != rsSkuReDomainSupQueryResult && !ListUtil.isEmpty((Collection)rsSkuReDomainSupQueryResult.getRows())) continue;
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)rsSkuReDomainSupQueryResult.getRows().get(0);
                rsSkuReDomain.setPricesetInsideprice(spScontractGoodsReDomain.getPricesetNprice());
                rsSkuResult.getRows().add(rsSkuReDomain);
                rsSkuResult.getList().add(rsSkuReDomain);
            }
        }
        this.logger.error("\u5408\u540c\u5546\u54c13---------------------------------" + rsSkuResult.getRows());
        return rsSkuResult;
    }

    public String readJsonFile(String fileName) {
        String jsonStr = "";
        this.logger.error("fileName---------------------------------" + fileName);
        try {
            File jsonFile = new File(fileName);
            FileReader fileReader = new FileReader(jsonFile);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
            int ch = 0;
            StringBuffer sb = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
            fileReader.close();
            ((Reader)reader).close();
            jsonStr = sb.toString();
            return jsonStr;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Map<String, Object>> type1() {
        HashMap map = new HashMap(){
            {
                this.put("SCONTRACT_BCODE", "2021030400000001");
                this.put("CONTRACT_ECURL", "\u5c60\u5e78\u8fd0");
                this.put("HCCONTRACT_TYPEPRO", "18326154207");
                this.put("LPJCONTRACT_TYPEPRO", "18326154207");
            }
        };
        ArrayList<Map<String, Object>> type1 = new ArrayList<Map<String, Object>>();
        type1.add(map);
        return type1;
    }

    private List<Map<String, Object>> type3() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n{\"AREA_CODE\":110101,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110106,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":110107,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110108,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110109,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110111,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":110112,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":110113,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110114,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110115,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":110116,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110117,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110118,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":110119,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":120113,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120114,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120115,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120116,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120117,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120118,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120119,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120101,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120106,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120110,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120111,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":120112,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130181,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130183,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130184,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130105,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130107,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130108,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130109,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130110,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130111,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130121,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130123,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130125,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130126,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130127,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130128,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130129,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130130,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130131,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130132,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130133,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130171,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130172,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130203,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130204,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130205,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130207,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130208,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130209,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130223,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130224,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130225,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130227,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130229,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130271,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130272,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130273,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130274,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130281,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130283,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130372,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130304,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130306,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130321,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130322,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130324,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130371,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130404,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130406,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130407,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130408,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130424,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130425,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130426,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130427,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130430,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130431,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130432,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130433,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130434,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130435,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130471,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130473,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130481,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130526,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130527,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130528,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130529,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130530,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130531,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130532,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130533,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130534,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130535,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130571,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130581,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130582,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130503,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130521,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130523,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130524,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130525,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130635,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130636,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130637,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130638,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130671,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130672,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130681,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130682,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130683,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130684,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130606,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130607,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130608,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130609,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130623,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130624,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130626,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130627,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130628,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130629,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130630,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130631,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130632,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130633,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130634,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130773,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130703,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130705,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130706,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130708,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130709,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130722,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130723,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130724,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130725,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130726,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130727,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130728,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130730,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130731,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130732,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130771,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130772,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130802,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130803,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130804,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130821,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130822,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130824,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130825,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130826,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130827,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130828,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130871,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130881,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130982,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130983,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130984,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130902,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130903,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130921,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130922,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130923,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130924,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130925,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130926,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130927,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130928,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130929,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130930,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130971,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130972,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130973,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":130981,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131002,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131003,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131022,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131023,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131024,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131025,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131026,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131028,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131071,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131081,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131082,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131125,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131126,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131127,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131128,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131172,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":131182,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":140402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140411,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140421,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140424,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140425,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140426,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140427,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140428,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140429,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140430,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140431,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140471,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140481,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140521,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140524,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140525,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140581,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140603,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140621,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140622,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140623,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140624,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140671,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140722,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140723,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140724,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140725,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140726,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140727,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140728,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140729,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140781,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140721,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140802,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140821,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140822,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140823,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140824,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140825,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140826,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140827,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140828,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140829,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140830,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140881,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140882,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140926,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140927,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140928,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140929,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140930,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140931,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140932,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140971,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140981,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140902,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140921,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140922,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140923,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140924,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140925,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141002,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141021,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141022,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141023,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141024,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141025,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141026,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141027,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141028,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141029,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141030,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141031,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141032,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141033,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141034,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141081,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141082,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141123,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141124,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141125,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141121,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141126,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141127,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141128,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141129,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141130,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141181,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":141182,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140106,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140107,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140108,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140109,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140110,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140121,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140123,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140171,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140181,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140105,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140203,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140211,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140212,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140221,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140222,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140223,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140224,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140225,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140226,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140227,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140271,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140311,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140321,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140322,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":140371,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150125,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150172,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150204,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150205,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150206,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150207,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150271,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150303,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150304,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150403,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150404,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150421,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150423,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150424,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150425,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150426,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150428,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150429,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150430,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150525,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150526,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150571,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150581,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150623,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150624,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150625,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150626,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150627,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150602,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150603,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150621,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150622,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150703,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150721,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150723,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150724,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150725,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150726,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150727,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150781,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150782,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150783,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150784,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150785,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150802,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150821,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150822,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150823,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150824,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150825,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150826,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150923,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150924,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150925,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150926,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150927,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150928,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150929,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150981,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150902,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150921,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":150922,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152201,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152501,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152525,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152526,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152527,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152528,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152529,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152530,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152531,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152571,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152922,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152923,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152971,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":152921,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":210902,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210903,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210904,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210905,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210911,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210921,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210922,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211002,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211003,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211004,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211005,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211011,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211021,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211081,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211103,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211223,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211224,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211281,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211282,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211204,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211221,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211321,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211322,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211324,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211381,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211382,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211404,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211421,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211422,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":211481,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210103,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210105,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},");
        sb.append("{\"AREA_CODE\":210106,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210111,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210112,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210113,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210114,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210115,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210123,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210124,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210181,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210203,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210204,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210211,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210212,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210213,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210214,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210224,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210281,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210283,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210311,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210321,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210323,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210381,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210304,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210404,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210411,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210421,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210422,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210503,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210504,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210505,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210521,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210603,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210604,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210624,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210681,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210682,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210781,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210782,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210703,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210711,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210726,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210727,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210802,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210803,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210804,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210811,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210881,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":210882,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":220174,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220182,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220183,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220106,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220112,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220113,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220172,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220173,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220204,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220211,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220271,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220272,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220273,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220281,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220282,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220283,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220284,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220303,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220322,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220381,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220382,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220403,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220421,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220581,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220582,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220503,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220602,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220605,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220621,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220622,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220623,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220681,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220721,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220723,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220771,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220781,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220802,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220821,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220822,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220871,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220881,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":220882,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222426,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222401,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222403,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222404,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222405,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222406,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":222424,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230108,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230109,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230110,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230111,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230112,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230113,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230125,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230126,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230127,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230128,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230129,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230183,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230184,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230227,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230229,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230230,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230231,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230281,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230204,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230205,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230206,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230207,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230208,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230303,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230304,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230305,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230306,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230321,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230381,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230382,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230403,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230404,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230405,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230406,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230407,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230421,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230503,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230505,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230506,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230602,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230603,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230604,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230605,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230606,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230621,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230622,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230623,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230624,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230671,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230703,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230704,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230705,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230706,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230707,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230708,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230709,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230710,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230711,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230712,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230713,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230714,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230715,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230716,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230781,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230804,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230805,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230811,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230822,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230826,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230828,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230881,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230882,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230883,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230803,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230902,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230903,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230904,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":230921,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231002,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231003,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231004,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231005,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231025,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231071,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231081,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231083,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231084,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231085,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231086,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231182,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231181,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231226,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231281,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231282,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":231283,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232701,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232703,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232704,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232721,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":232723,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":310115,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310116,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310117,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310118,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310120,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310151,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310101,\"HCCONTRACT_TYPEPRO\":18862517820,\"LPJCONTRACT_TYPEPRO\":18862517820},\n{\"AREA_CODE\":310104,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310105,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310106,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310107,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310109,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310110,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310112,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310113,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":310114,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320102,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320104,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320105,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320106,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320111,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320113,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320114,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320115,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320116,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320117,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320118,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320205,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320206,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320211,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320213,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320214,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320281,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320282,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320321,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320322,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320324,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320371,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320381,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320382,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320302,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320303,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320305,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320311,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320312,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320402,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320404,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320411,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320412,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320413,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320481,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320505,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320506,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320507,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320508,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320509,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320571,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320581,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320582,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320583,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320585,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320681,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320682,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320684,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320602,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320611,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320612,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320621,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320623,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320671,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320703,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320706,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320707,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320722,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320723,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320724,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320771,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320772,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320803,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320804,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320812,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320813,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320826,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320830,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320831,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320871,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320902,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320903,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320904,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320921,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320922,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320923,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320924,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320925,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320971,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":320981,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321002,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321003,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321012,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321023,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321071,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321081,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321084,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321102,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321111,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321112,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321171,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321181,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321182,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321183,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321202,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321203,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321204,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321271,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321281,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321282,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321283,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321302,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321311,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321322,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321323,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321324,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":321371,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"AREA_CODE\":330103,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330104,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330105,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330106,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330108,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330109,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330110,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330111,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330112,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330122,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330127,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330182,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330102,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330203,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330205,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330206,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330211,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330212,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330213,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330225,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330226,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330281,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330282,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330327,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330328,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330329,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330371,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330381,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330382,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330302,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330303,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330304,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330305,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330324,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330326,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330402,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330411,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330421,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330424,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330481,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330482,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330483,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330502,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330503,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330521,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330522,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330523,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330602,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330603,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330604,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330624,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330681,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330683,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330781,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330782,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330783,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330784,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330702,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330703,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330723,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330726,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330727,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330802,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330803,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330822,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330824,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330825,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330881,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330902,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330903,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330921,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":330922,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331002,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331003,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331004,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331022,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331023,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331024,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331081,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331082,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331083,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331125,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331126,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331127,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331181,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331102,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331121,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331122,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331123,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":331124,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"AREA_CODE\":340503,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340504,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340506,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340521,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340522,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340523,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340602,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340603,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340604,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340621,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340705,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340706,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340711,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340722,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340824,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340825,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340826,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340827,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340828,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340871,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340881,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340802,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340803,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340811,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340822,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341002,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341003,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},");
        sb.append("{\"AREA_CODE\":341004,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341021,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341022,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341023,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341024,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341102,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341103,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341122,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341124,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341125,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341126,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341171,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341172,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341181,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341182,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341222,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341225,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341226,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341271,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341272,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341282,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341202,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341203,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341204,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341221,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341302,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341321,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341322,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341323,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341324,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341371,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341372,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341502,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341503,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341504,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341522,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341523,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341524,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341525,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341602,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341621,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341622,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341623,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341702,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341721,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341722,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341723,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341802,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341821,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341822,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341823,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341824,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341825,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341871,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":341881,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340102,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340103,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340104,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340111,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340121,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340122,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340123,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340124,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340171,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340172,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340173,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340181,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340202,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340203,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340207,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340208,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340221,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340222,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340223,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340225,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340271,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340272,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340311,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340321,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340322,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340323,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340371,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340372,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340302,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340303,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340304,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340402,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340403,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340404,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340405,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340406,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340421,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":340422,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":350102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350104,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350111,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350122,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350125,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350128,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350181,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350182,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350205,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350206,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350211,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350212,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350213,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350305,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350421,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350424,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350425,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350426,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350427,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350428,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350429,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350430,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350481,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350503,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350504,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350505,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350524,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350525,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350526,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350527,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350581,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350582,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350583,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350603,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350623,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350624,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350625,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350626,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350627,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350628,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350629,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350681,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350703,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350721,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350722,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350723,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350724,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350725,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350781,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350782,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350783,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350803,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350824,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350825,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350925,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350926,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350981,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350982,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":350921,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360803,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360822,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360824,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360825,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360826,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360827,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360828,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360829,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360830,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360921,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360925,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360926,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360981,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360982,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360983,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361003,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361021,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361022,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361023,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361024,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361025,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361026,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361027,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361030,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361002,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361125,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361126,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361127,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361128,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361129,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361130,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":361181,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360104,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360111,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360112,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360281,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360313,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360424,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360425,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360426,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360428,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360429,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360430,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360481,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360482,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360483,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360404,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360681,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360733,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360734,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360735,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360781,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360703,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360704,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360722,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360723,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360724,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360725,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360726,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360727,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360728,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360729,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360730,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360731,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":360732,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":370124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370125,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370126,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370112,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370113,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370114,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370211,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370212,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370213,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370214,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370215,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370271,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370281,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370283,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370285,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370303,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370304,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370305,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370306,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370321,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370322,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370481,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370403,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370404,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370405,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370406,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370503,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370505,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370571,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370572,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370602,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370611,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370612,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370613,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370634,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370671,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370672,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370681,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370682,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370683,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370684,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370685,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370686,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370687,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370772,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370781,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370782,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370783,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370784,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370785,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370786,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370703,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370704,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370705,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370724,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370725,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370811,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370812,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370826,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370827,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370828,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370829,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370830,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370831,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370832,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370871,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370881,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370883,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370982,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370983,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370902,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370911,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370921,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":370923,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371002,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371003,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371071,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371072,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371073,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371082,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371083,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371172,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371311,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371312,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371321,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371322,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371324,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371325,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371326,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371327,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371328,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371329,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371371,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371372,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371373,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371427,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371428,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371471,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371472,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371481,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371482,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371403,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371423,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371424,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371425,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371426,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371525,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371526,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371581,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371602,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371603,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371621,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371622,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371623,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371625,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371626,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371728,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371771,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371772,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371703,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371721,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371723,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371724,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371725,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":371726,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":410902,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410922,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410923,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410926,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410927,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410928,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410971,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410972,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411002,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411003,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411024,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411025,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411071,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411081,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411082,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411103,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411121,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411171,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411203,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411221,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411224,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411271,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411281,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411282,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411321,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411322,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411323,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411324,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411325,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411326,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411327,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411328,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411329,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411330,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411371,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411372,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411381,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411421,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411422,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411424,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411425,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411426,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411471,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411472,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411481,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411503,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411521,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411523,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411524,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411525,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411526,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411527,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411528,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411571,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},");
        sb.append("{\"AREA_CODE\":411628,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411671,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411681,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411621,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411622,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411623,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411624,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411625,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411626,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411627,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411721,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411722,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411723,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411724,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411725,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411726,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411727,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411728,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411729,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":411771,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":419001,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410103,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410105,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410106,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410108,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410171,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410172,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410173,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410181,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410182,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410183,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410184,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410185,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410203,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410204,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410205,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410212,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410221,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410222,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410223,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410225,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410304,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410305,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410306,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410311,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410322,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410323,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410324,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410325,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410326,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410327,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410328,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410329,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410371,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410381,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410404,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410411,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410421,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410422,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410425,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410471,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410472,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410481,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410482,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410503,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410505,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410506,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410523,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410526,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410527,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410571,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410581,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410603,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410611,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410621,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410622,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410671,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410782,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410703,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410704,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410711,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410721,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410724,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410725,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410726,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410727,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410728,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410771,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410772,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410773,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410781,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410802,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410803,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410804,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410811,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410821,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410822,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410823,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410825,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410871,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410882,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":410883,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":13801283404},\n{\"AREA_CODE\":420102,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420103,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420104,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420105,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420106,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420107,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420111,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420112,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420113,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420114,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420115,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420116,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420117,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420203,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420204,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420205,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420222,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420281,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420202,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420302,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420303,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420304,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420322,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420323,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420324,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420325,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420381,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420502,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420503,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420504,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420505,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420506,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420525,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420526,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420527,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420528,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420529,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420581,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420582,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420583,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420607,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420624,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420625,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420626,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420682,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420683,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420684,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420602,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420606,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420702,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420703,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420704,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420802,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420804,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420821,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420822,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420881,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420902,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420921,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420922,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420923,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420981,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420982,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":420984,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421083,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421087,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421002,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421003,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421022,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421023,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421024,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421071,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421081,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421102,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421121,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421122,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421123,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421124,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421125,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421126,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421127,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421171,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421181,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421182,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421202,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421221,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421222,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421223,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421224,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421281,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421303,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421321,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":421381,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422801,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422802,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422822,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422823,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422825,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422826,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422827,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":422828,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":429004,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":429005,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":429006,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":429021,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"AREA_CODE\":430502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430503,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430511,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430522,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430523,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430524,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430525,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430527,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430528,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430529,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430581,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430621,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430623,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430624,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430626,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430671,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430681,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430682,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430603,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430611,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430703,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430721,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430722,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430723,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430724,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430725,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430726,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430771,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430781,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430811,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430822,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430981,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430903,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430921,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430971,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430972,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431002,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431003,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431021,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431022,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431023,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431024,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431025,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431026,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431027,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431081,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431122,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431125,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431126,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431127,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431128,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431129,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431171,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431172,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431173,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431226,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431227,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431228,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431229,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431230,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431271,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431281,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431221,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431381,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":431382,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433101,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433122,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433125,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433126,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433127,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433130,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433172,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":433173,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430104,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430111,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430112,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430181,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430182,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430204,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430211,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430221,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430271,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430281,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430371,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430372,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430373,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430381,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430382,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430406,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430407,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430408,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430412,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430421,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430424,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430426,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430471,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430472,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430473,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430481,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430482,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":430405,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445281,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445381,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440106,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440111,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440112,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440113,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440114,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440115,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440117,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440118,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440104,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440204,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440205,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440229,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440232,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440233,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440281,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440282,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440305,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440306,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440307,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440308,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440309,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440310,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440404,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440507,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440511,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440512,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440513,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440514,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440515,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440523,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440604,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440605,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440606,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440607,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440608,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440703,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440704,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440705,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440781,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440783,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440784,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440785,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440803,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440804,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440811,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440825,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440882,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440883,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440904,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440981,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440982,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":440983,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441204,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441226,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441284,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441324,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441424,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441426,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441427,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441481,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441523,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441581,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441621,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441623,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441624,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441625,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441704,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441721,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441781,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441803,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441825,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441826,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441882,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":441900,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":442000,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":445122,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450107,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450108,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450109,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450110,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450125,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450126,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450127,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450204,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450205,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},");
        sb.append("{\"AREA_CODE\":450206,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450226,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450305,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450311,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450312,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450324,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450325,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450326,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450327,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450328,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450329,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450330,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450331,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450332,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450405,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450406,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450421,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450481,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450503,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450512,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450603,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450621,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450681,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450703,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450721,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450722,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450803,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450804,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450881,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450903,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450921,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":450981,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451002,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451021,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451022,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451023,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451024,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451026,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451027,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451029,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451030,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451031,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451081,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451122,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451224,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451226,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451227,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451228,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451229,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451221,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451222,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451223,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451324,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451381,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451421,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451424,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451425,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":451481,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460105,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460106,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460107,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460108,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460202,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460203,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460204,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460205,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":460400,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469001,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469002,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469005,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469006,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469007,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469021,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469022,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469023,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469024,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469025,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469026,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469027,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469028,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469029,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":469030,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":500112,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500113,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500114,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500115,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500116,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500117,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500118,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500119,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500120,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500151,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500152,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500153,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500154,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500155,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500156,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500101,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500102,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500103,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500104,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500105,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500106,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500107,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500108,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500109,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500110,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500111,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500229,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500230,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500231,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500233,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500235,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500236,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500237,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500238,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500240,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500241,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500242,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":500243,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510703,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510704,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510705,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510722,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510723,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510725,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510726,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510727,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510781,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510823,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510824,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510802,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510811,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510812,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510821,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510822,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510903,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510904,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510921,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510922,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510923,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511002,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511011,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511024,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511025,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511071,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511083,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511102,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511111,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511112,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511113,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511123,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511124,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511126,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511129,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511132,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511133,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511181,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511322,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511323,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511324,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511325,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511381,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511302,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511303,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511304,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511321,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511402,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511403,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511421,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511423,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511424,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511425,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511502,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511503,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511521,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511523,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511524,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511525,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511526,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511527,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511528,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511529,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511602,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511603,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511621,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511622,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511623,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511681,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511722,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511723,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511724,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511725,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511771,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511781,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511702,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511703,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":\"\",\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511902,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511903,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511921,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511922,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511923,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":511971,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":512002,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":512021,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":512022,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513225,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513226,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513227,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513228,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513230,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513231,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513232,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513233,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513201,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513221,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513222,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513223,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513224,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513301,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513322,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513323,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513324,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513325,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513326,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513327,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513328,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513329,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513330,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513331,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513332,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513333,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513334,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513335,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513336,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513337,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513338,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513424,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513425,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513426,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513427,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513428,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513429,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513430,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513431,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513432,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513433,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513434,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513435,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513436,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513437,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513401,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513422,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":513423,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510105,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510106,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510107,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510108,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510112,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510113,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510114,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510115,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510116,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510117,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510121,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510129,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510131,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510132,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510181,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510182,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510183,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510184,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510185,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510104,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510302,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510303,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510304,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510311,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510321,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510322,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510422,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510402,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510403,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510411,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510421,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510502,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510503,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510504,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510521,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510522,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510524,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510525,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510603,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510604,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510623,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510681,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510682,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":510683,\"HCCONTRACT_TYPEPRO\":13679038688,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520102,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520103,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520111,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520112,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520113,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520115,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520121,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520122,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520123,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520181,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520201,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520203,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520221,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520281,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520302,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520303,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520304,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520322,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520323,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520324,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520325,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520326,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520327,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520328,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520329,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520330,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520381,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520382,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520402,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520403,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520422,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520423,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520424,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520425,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520502,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520521,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520522,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520523,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520524,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520525,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520526,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520527,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520602,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520603,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520621,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520622,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520623,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520624,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520625,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520626,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520627,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":520628,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522301,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522322,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522323,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522324,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522325,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522326,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522327,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522328,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522632,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522633,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522634,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522635,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522636,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522601,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522622,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522623,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522624,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522625,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522626,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522627,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522628,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522629,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522630,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522631,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522701,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522702,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522722,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522723,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522725,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522726,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522727,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522728,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522729,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522730,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522731,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":522732,\"HCCONTRACT_TYPEPRO\":13541258242,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":530623,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530624,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530625,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530626,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530627,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530628,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530629,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530630,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530602,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530621,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530702,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530721,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530722,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530723,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530724,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530802,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530821,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530822,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530824,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530825,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530826,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530827,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530828,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530829,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530925,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530926,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530927,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530902,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530921,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532301,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532324,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532325,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532326,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532327,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532328,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532329,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532331,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532501,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532503,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532504,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532523,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532524,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532525,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532527,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532528,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532529,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532530,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532531,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532532,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532623,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532624,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532625,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532626,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532627,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532628,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532601,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532622,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532801,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532822,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532823,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532901,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532922,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532923,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532924,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532925,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},");
        sb.append("{\"AREA_CODE\":532926,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532927,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532928,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532929,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532930,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532931,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":532932,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533122,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533123,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533325,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533301,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533324,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533401,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":533423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530128,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530129,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530181,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530102,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530103,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530111,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530112,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530113,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530114,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530115,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530124,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530125,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530126,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530127,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530302,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530303,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530322,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530323,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530324,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530325,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530326,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530381,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530402,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530403,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530422,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530423,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530424,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530425,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530426,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530427,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530428,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530502,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530521,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530523,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530524,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":530581,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"AREA_CODE\":540102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540126,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540127,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540172,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540173,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540174,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540232,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540233,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540234,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540235,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540236,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540237,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540226,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540227,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540228,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540229,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540230,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540231,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540321,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540322,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540324,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540325,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540326,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540327,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540328,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540329,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540330,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540421,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540423,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540424,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540425,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540426,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540525,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540526,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540527,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540528,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540529,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540530,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540531,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":540524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542421,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542423,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542424,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542425,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542426,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542427,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542428,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542429,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542430,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542431,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542525,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542526,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":542527,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":611002,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":611021,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":611022,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":611023,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":611024,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":611025,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":611026,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610111,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610112,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610113,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610114,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610115,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610116,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610117,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610118,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610124,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610103,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610203,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610204,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610222,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610303,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610304,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610322,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610323,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610324,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610326,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610327,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610328,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610329,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610330,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610331,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610422,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610424,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610425,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610426,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610427,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610428,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610429,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610430,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610431,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610481,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610404,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610503,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610523,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610524,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610525,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610526,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610527,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610528,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610581,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610582,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610626,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610627,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610628,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610629,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610630,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610631,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610632,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610603,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610621,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610622,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610623,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610625,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610703,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610722,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610723,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610724,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610725,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610726,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610727,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610728,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610729,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610730,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610831,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610881,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610830,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610802,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610803,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610822,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610824,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610825,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610826,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610827,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610828,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610829,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610902,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610921,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610922,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610923,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610924,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610925,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610926,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610927,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610928,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":610929,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620103,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620104,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620105,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620111,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620121,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620123,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620171,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620201,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620302,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620321,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620402,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620403,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620421,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620422,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620423,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620502,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620503,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620521,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620522,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620523,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620524,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620525,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620602,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620621,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620622,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620623,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620702,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620721,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620722,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620723,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620724,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620725,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620824,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620825,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620826,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620871,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620802,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620821,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620822,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620823,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620902,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620921,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620922,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620923,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620924,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620981,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":620982,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621002,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621021,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621022,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621023,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621024,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621025,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621026,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621027,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621102,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621121,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621122,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621123,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621124,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621125,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621126,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621222,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621223,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621224,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621225,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621226,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621227,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621228,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621202,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":621221,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622901,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622921,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622922,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622923,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622924,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622925,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622926,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":622927,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623001,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623021,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623022,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623023,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623024,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623025,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623026,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":623027,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"AREA_CODE\":630123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":630225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632321,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632322,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632324,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632523,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632524,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632525,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632621,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632622,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632623,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632624,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632625,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632626,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632723,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632724,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632725,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632726,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632701,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632801,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632802,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632821,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632822,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632823,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632857,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632858,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":632859,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640106,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640181,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640205,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640303,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640324,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640381,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640424,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640425,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640423,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":640522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654301,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654321,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654322,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654324,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654325,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654326,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":659001,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":659002,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":659003,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":659004,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":659006,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650203,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650204,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650205,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650402,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650421,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650422,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650502,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650521,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650522,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652324,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652325,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652327,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652328,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652301,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652302,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652323,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652701,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652702,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652722,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652723,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652801,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652822,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652823,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652824,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652825,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652826,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652827,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652828,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652829,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652871,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652901,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652922,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652923,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652924,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652925,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652926,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652927,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652928,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":652929,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653023,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653024,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653001,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653022,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653101,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653122,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653123,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653124,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653125,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653126,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653127,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653128,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653129,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653130,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653131,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653201,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653222,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653226,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":653227,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654024,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654025,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654026,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654027,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654028,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654002,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654003,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654004,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654021,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654022,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654023,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654201,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654202,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654221,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654223,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654224,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":654226,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650102,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650103,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650104,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650105,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650106,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650107,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650109,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650121,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650171,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"AREA_CODE\":650172,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955}\n]");
        String json = sb.toString();
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(json, Map.class);
        this.logger.error("list------------------------------" + list);
        return list;
    }

    private List<Map<String, Object>> type2() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n{\"COMPANY_CODE\":14424793,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14424942,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429449,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14429800,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14464359,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14475139,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475210,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14482404,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14490790,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491373,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14491557,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14494028,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14495873,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14496679,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496900,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14498022,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14499701,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14502114,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14502313,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14502586,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504219,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14504766,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14507441,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300861,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80300929,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80303277,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304579,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307011,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307150,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307846,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308091,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308271,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308285,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308585,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14423673,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14423750,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14423872,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14424563,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14424877,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14425303,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425431,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14425445,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14425449,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14425546,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14425839,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14429027,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14429460,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14429669,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14429934,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14429993,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14434005,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14434446,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14434449,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14434905,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14435202,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14435262,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14435395,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14435859,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14444578,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14455870,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14456193,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14456452,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14456499,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14456788,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14456808,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14456936,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14457446,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14457951,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457968,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14457969,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14458104,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14458133,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14458138,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14458539,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14458697,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14458727,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14460894,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14460968,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14460988,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461212,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14461281,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14461534,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14461610,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14461656,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14461774,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14462106,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462362,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14462372,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462911,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14462951,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14463068,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14463219,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14463364,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463380,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14463538,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14464134,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464135,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464151,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14464234,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464410,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14464412,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464509,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14464540,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14464605,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14464696,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14465480,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14465481,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14465513,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14465630,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14465631,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14465867,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14466068,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466206,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466322,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14466394,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466556,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466797,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14466799,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14466850,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14467064,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467322,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467572,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14467613,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14468723,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468738,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468751,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468767,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14468834,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468915,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14468925,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14468944,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14468946,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14468956,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14474826,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14474842,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14474866,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14474974,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14475246,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14475317,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14475393,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14475395,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14475508,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14475561,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14475586,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14475719,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14475787,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476046,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14476147,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14476151,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14476350,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14476491,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14476728,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14476847,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14477021,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14477085,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14477465,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14477482,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14477990,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478043,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14478079,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14478122,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478324,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14478635,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14478659,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482613,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14482648,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14482721,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482810,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482836,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14482903,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14482957,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14483190,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14483575,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483716,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483892,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14483894,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14487951,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14488317,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14488318,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488390,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14488471,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488666,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14488974,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14489012,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14489025,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14489297,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14489868,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14489921,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14490085,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14490126,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490370,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490430,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490505,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490517,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490582,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14490617,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14490741,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14490826,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14490876,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14490930,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14491083,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14491143,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14491191,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491193,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491245,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14491421,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14491677,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14491680,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14491681,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14491751,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14492035,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14492087,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492092,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14492301,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14492303,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14492325,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492575,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14492611,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14492636,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14492690,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493298,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493309,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14493457,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493471,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493495,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14493539,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14493705,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494232,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14494347,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14494379,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14494522,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494596,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14494650,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494854,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14494882,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14494977,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495250,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495368,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14495495,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14495639,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14495645,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495736,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14495884,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14495929,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14495940,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496554,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496582,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496622,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496627,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496641,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14496649,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14496674,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496722,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496724,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14496762,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496879,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14496922,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14496923,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14497095,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14497137,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14497149,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497177,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14497207,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497441,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14497483,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14497738,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14497964,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14498023,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14498156,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14498509,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14498575,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14498890,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14499045,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14499137,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14499146,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14499292,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14499459,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14499526,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14499647,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14499703,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14499791,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14499932,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14500532,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14500584,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14500778,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14501083,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14501206,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14501238,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14501441,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14502140,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502203,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14502889,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14502906,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14502956,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14502979,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503017,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503040,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14503134,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503161,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14503184,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503211,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14503413,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503414,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503430,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503585,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14503643,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14503645,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503718,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14503719,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14503815,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504217,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504302,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14504472,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504598,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14504761,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14504769,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14505082,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14505238,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14505274,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14505299,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14505601,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14505882,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14507926,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14508414,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14508490,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14508757,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14508856,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14509050,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509619,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509678,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14509720,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509745,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14509859,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14510519,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510582,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14510802,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14510843,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14511015,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14511048,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14511059,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14512230,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14512369,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14512430,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14512487,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512529,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512571,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14512635,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14512797,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":14512832,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513069,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513165,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513191,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513223,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14513392,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513404,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14513428,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513458,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14513538,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513845,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14513890,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513980,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14513986,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14514042,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514073,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":14514074,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":14514277,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14514290,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":14514331,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14514435,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14514910,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":14515358,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":14515463,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80300003,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80300659,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300725,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80300846,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80300862,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80300890,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80300915,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80300916,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80300957,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80300965,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80300968,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80300980,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301010,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301035,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301096,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301118,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301122,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301220,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301251,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301261,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301291,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80301298,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301300,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80301305,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301324,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301406,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301453,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301508,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301531,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301555,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80301626,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80301813,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80301857,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301866,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301870,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80301907,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80301933,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80302069,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302070,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302073,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80302137,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80302145,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302172,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302190,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302199,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302201,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80302697,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80302722,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302734,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80302753,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80303295,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303319,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80303322,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303364,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303371,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303393,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303400,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303409,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303411,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303413,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303446,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303455,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80303471,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303483,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303487,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80303502,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303507,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303518,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80303519,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80303550,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80303578,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304087,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80304245,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304257,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80304278,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304290,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304302,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304305,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304307,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304312,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304315,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304320,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304323,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80304349,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80304447,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304504,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80304542,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304547,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304555,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304559,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80304634,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80306651,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306655,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80306657,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306695,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306703,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306711,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80306730,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80306778,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80306885,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80306988,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307003,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307034,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307093,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307138,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307158,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307191,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307230,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307294,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307323,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307347,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80307470,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307627,\"HCCONTRACT_TYPEPRO\":13826545973,\"LPJCONTRACT_TYPEPRO\":13826545973},\n{\"COMPANY_CODE\":80307657,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307678,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307726,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80307739,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307769,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307804,\"HCCONTRACT_TYPEPRO\":18823198701,\"LPJCONTRACT_TYPEPRO\":18823198701},\n{\"COMPANY_CODE\":80307842,\"HCCONTRACT_TYPEPRO\":13512759555,\"LPJCONTRACT_TYPEPRO\":13512759555},\n{\"COMPANY_CODE\":80307844,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307893,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80307968,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80307970,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308029,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308162,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308209,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},");
        sb.append("{\"COMPANY_CODE\":80308218,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308228,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308230,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308258,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308281,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308294,\"HCCONTRACT_TYPEPRO\":13728741346,\"LPJCONTRACT_TYPEPRO\":13728741346},\n{\"COMPANY_CODE\":80308300,\"HCCONTRACT_TYPEPRO\":13512739555,\"LPJCONTRACT_TYPEPRO\":13512739555},\n{\"COMPANY_CODE\":80308308,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308350,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308374,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308380,\"HCCONTRACT_TYPEPRO\":13632624369,\"LPJCONTRACT_TYPEPRO\":13632624369},\n{\"COMPANY_CODE\":80308580,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":80308641,\"HCCONTRACT_TYPEPRO\":13922137866,\"LPJCONTRACT_TYPEPRO\":13922137866},\n{\"COMPANY_CODE\":14456131,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14477877,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14482409,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14484163,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14494209,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14498704,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14498756,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14501167,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502597,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14503803,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14504530,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14512669,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80300012,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301846,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80304010,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80304022,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80306918,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307607,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307806,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14423586,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14423659,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14423755,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14423841,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14423889,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14423919,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14424155,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14424394,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14424522,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14424710,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14425010,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14425084,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14425171,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14425363,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14425389,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14425396,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14425566,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14428909,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14429500,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14429729,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14429736,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14429737,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14429992,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14432456,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14432469,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14433036,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14433111,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14434004,\"HCCONTRACT_TYPEPRO\":18862517820,\"LPJCONTRACT_TYPEPRO\":18862517820},\n{\"COMPANY_CODE\":14434156,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14434285,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14434520,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14434555,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14434606,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14434860,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14434916,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14435027,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14435328,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14435511,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14444229,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14444451,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14444573,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14444656,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"COMPANY_CODE\":14444659,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14444746,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14455549,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14455709,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14455843,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14456257,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14456304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14456825,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14457089,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14457333,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14457335,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14457445,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14457556,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14457640,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14457651,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14457747,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14457799,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14457842,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14458323,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14458451,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14458478,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14458855,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14458916,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14460892,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14461214,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14461318,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14461461,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14461694,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14461792,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"COMPANY_CODE\":14461881,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14461892,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14461893,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14461953,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14462023,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14462033,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14462131,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14462133,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14462176,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14462188,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14462434,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14462616,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14462847,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14463016,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14463126,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14463159,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14463235,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14463282,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14463293,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14463424,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14463756,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14464152,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14464212,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14464216,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14464372,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14464484,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14464505,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14464529,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14464632,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14464697,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14464866,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14465460,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14465461,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14465557,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14465578,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14465623,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14465836,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14465847,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14465869,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14465918,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14466041,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14466136,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14466162,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466164,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466198,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14466199,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14466278,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466304,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14466405,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466533,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466809,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466952,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14466967,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14467056,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14467096,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14467130,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14467285,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14467386,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14467471,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14467649,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14468504,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14468544,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14468583,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14468724,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14468804,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14468856,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14468889,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14469009,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14469188,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14469254,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14471641,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14474791,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14474818,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14474852,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14474895,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14474908,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475136,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14475137,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475140,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14475267,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475309,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14475315,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14475360,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14475509,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475571,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475615,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14475624,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475800,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475890,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475893,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14475956,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14475996,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14476100,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14476324,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14476344,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14476395,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14476466,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14476545,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14476603,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14476606,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14476751,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14476858,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14477020,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14477024,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14477033,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14477096,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14477283,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14477335,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14477503,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14477819,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14477965,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14478078,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14478380,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14478596,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14478597,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14482288,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14482406,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14482465,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14482578,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14482879,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14482896,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14482901,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14482980,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14483256,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14483440,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14483591,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14483611,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14483677,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14483758,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14483926,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14484034,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14484121,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14487725,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14487780,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14487818,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14488034,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14488212,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14488457,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14488458,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14488588,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14488785,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14489002,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14489102,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14489143,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14489307,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14489349,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14489657,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14489732,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14489815,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14489826,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14489936,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14490029,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14490045,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14490093,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14490094,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14490191,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14490196,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14490225,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14490388,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14490487,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14490509,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14490837,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14491211,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14491510,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14491555,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492036,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14492052,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14492135,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492374,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492400,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492507,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14492515,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492542,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492552,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492683,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14492993,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14493036,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14493065,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14493148,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14493311,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14493521,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14493773,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14493920,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14493933,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14493990,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14494338,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14494359,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14494376,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14494544,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14495194,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14495198,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14495211,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14495222,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14495225,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14495474,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14495566,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14495590,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14495689,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14495800,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14495810,\"HCCONTRACT_TYPEPRO\":13501063691,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14495854,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14495889,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14496175,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14496199,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14496609,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14496613,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14496637,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14497001,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14497062,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14497156,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14497213,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14497327,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14497337,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14497674,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14497953,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14498185,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14498290,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14498359,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14498418,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14498684,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14498763,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14498764,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14498826,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14498864,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14498887,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14498888,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14499085,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14499238,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499293,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499481,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499487,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499527,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14499651,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499799,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499872,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14499915,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14499951,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14500434,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14500599,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14500804,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14501057,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14501207,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14501321,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14501462,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14501587,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14501913,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14502020,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14502032,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502168,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502384,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502420,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502438,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502439,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14502544,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502555,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14502610,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14502632,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14502682,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502908,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14502914,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14502924,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14502971,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14502972,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14503163,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14503171,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14503579,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14503630,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14503650,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14503814,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14503844,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14504164,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14504184,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14504464,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14504536,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14504538,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14504625,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14504662,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14504663,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14504686,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14504968,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14505011,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14505083,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14505249,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14505268,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14505282,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14505321,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14505322,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14505335,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14505423,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14505438,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":14505493,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14505494,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14505768,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14505880,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14505881,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14505920,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14506457,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14506459,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14507868,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14507869,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14507924,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14507993,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508001,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508091,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508247,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508248,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508305,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14508306,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508373,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14508650,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508753,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14508870,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14508923,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14509763,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14510248,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":14510587,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14511057,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14511075,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14511181,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":14512219,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14512838,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14513534,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14513926,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":14513964,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14514071,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14514295,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":14515035,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80300014,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80300554,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80300561,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80300567,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80300571,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80300621,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80300625,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80300635,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80300641,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80300731,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301182,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80301565,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"COMPANY_CODE\":80301631,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301637,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80301646,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301653,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301655,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301658,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301661,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301670,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301684,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301688,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80301710,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301711,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301715,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301717,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80301720,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301774,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":80301832,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301844,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80301974,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":80302022,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302030,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302033,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302041,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302049,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302054,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302090,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302117,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302180,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302203,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302205,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302211,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302213,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302216,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302226,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302266,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302386,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302401,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302411,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302426,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302429,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302442,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302450,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302452,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302463,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302474,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302477,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302480,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302481,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302483,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302488,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302489,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302490,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302491,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80302797,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302801,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302803,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302813,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302837,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},");
        sb.append("{\"COMPANY_CODE\":80302842,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302849,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302852,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302872,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302899,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302907,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302931,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302938,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302947,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302975,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80302981,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303003,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303009,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303010,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303012,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303022,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303023,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303035,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303041,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303043,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303045,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303069,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303084,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303086,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303089,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303110,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303147,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303152,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303154,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303155,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303195,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303218,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303239,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303240,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303248,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303731,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303734,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303739,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303743,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303747,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303752,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303886,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303944,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80303964,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303966,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80303989,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80304014,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80304029,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80304031,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80304177,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80304193,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80304209,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80304347,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80304359,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304363,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304369,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304382,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304383,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304404,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304408,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304413,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304414,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80304429,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80304451,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306672,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306675,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306676,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306677,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306678,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306683,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306686,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306725,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306727,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306762,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80306788,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306792,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306843,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306888,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306889,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306933,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306943,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"COMPANY_CODE\":80306952,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306960,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80306990,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80306992,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307076,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307079,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307080,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307110,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307127,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307130,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307131,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307195,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":80307202,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307234,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307304,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307355,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307419,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307475,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307484,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307535,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307540,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307554,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"COMPANY_CODE\":80307632,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307662,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307723,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307724,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80307728,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18600675683},\n{\"COMPANY_CODE\":80307768,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307798,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307882,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307883,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307895,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80307903,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80307918,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308010,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308026,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308069,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80308077,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308100,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308108,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308113,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308292,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308323,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308343,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308344,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308345,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308364,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308440,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308444,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308446,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":80308462,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308513,\"HCCONTRACT_TYPEPRO\":13020190963,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308520,\"HCCONTRACT_TYPEPRO\":13901985338,\"LPJCONTRACT_TYPEPRO\":18817877536},\n{\"COMPANY_CODE\":80308525,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":18610158955},\n{\"COMPANY_CODE\":80308532,\"HCCONTRACT_TYPEPRO\":13911750401,\"LPJCONTRACT_TYPEPRO\":\"\"},\n{\"COMPANY_CODE\":80308562,\"HCCONTRACT_TYPEPRO\":\"\",\"LPJCONTRACT_TYPEPRO\":13437190699},\n{\"COMPANY_CODE\":80308569,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228},\n{\"COMPANY_CODE\":80308605,\"HCCONTRACT_TYPEPRO\":13901753988,\"LPJCONTRACT_TYPEPRO\":15161630228}\n]");
        String json = sb.toString();
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(json, Map.class);
        this.logger.error("list------------------------------" + list);
        return list;
    }

    @RequestMapping(value={"forwardQueryScontractPageNew.json"}, name="\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e")
    @ResponseBody
    public HtmlJsonReBean forwardQueryScontractPageNew(HttpServletRequest request) {
        boolean flag = true;
        Map param = this.assemMapParam(request);
        Map check = this.assemMapParam(request);
        check.put("contractInvstate", 2);
        SupQueryResult checkResult = this.spScontractServiceRepository.queryScontractPage(check);
        if (!ListUtil.isEmpty((Collection)checkResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u60a8\u5df2\u9884\u7ea6\u8be5\u5408\u540c");
        }
        if (StringUtils.isBlank((String)param.get("scontractCode").toString()) || StringUtils.isBlank((String)param.get("userinfoPhone").toString())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        param.put("contractInvstate", 0);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        this.logger.error("scontractCode:" + param.get("scontractCode").toString());
        this.logger.error("userinfoPhone:" + param.get("userinfoPhone").toString());
        HashMap<String, Comparable<Boolean>> checkSp = new HashMap<String, Comparable<Boolean>>();
        checkSp.put("order", Boolean.valueOf(true));
        checkSp.put("fuzzy", Boolean.valueOf(false));
        checkSp.put("contractInvstate", Integer.valueOf(0));
        checkSp.put("scontractCode", (Comparable<Boolean>)param.get("scontractCode"));
        SupQueryResult supQueryResult = this.spScontractServiceRepository.queryScontractPage(checkSp);
        if (ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u5408\u540c\u53f7\u4e0d\u5b58\u5728");
        }
        UmUserDomainBean umUserDomainBean = this.userServiceRepository.getuserByPhone(param.get("userinfoPhone").toString(), this.getTenantCode(request));
        if (null == umUserDomainBean.getUserPcode()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> checkUserinfo = new HashMap<String, Object>();
        checkUserinfo.put("order", true);
        checkUserinfo.put("fuzzy", false);
        checkUserinfo.put("userinfoCode", umUserDomainBean.getUserPcode());
        SupQueryResult UserinfoResult = this.userServiceRepository.queryUserinfoPage(checkUserinfo);
        if (ListUtil.isEmpty((Collection)UserinfoResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        SpScontractDomain spScontractDomain = (SpScontractDomain)supQueryResult.getList().get(0);
        this.logger.error("\u6253\u5370spScontractDomain****************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)UserinfoResult.getList().get(0);
        this.logger.error("\u6253\u5370umUserinfoReDomainBean*****************" + JsonUtil.buildNormalBinder().toJson((Object)umUserinfoReDomainBean));
        if (param.containsKey("contractTypepro") && null != param.get("contractTypepro")) {
            HashMap<String, Object> salesmap = new HashMap<String, Object>();
            salesmap.put("userinfoPhone", param.get("contractTypepro").toString());
            salesmap.put("order", true);
            salesmap.put("fuzzy", false);
            SupQueryResult Salesinfo = this.userServiceRepository.queryUserinfoPage(salesmap);
            if (null == umUserDomainBean.getUserPcode()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
            }
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            spScontractDomain.setContractType(((UmUserinfoReDomainBean)Salesinfo.getList().get(0)).getUserinfoCompname());
            spScontractDomain.setContractTypepro(param.get("contractTypepro").toString());
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            this.logger.error("**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
            HtmlJsonReBean htmlJsonReBeanS = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBeanS;
        }
        List<Map<String, Object>> type1 = this.type1();
        for (int i = 0; i < this.type1().size(); ++i) {
            SupQueryResult UserinfoRes;
            HashMap<String, Object> map;
            if (!type1.get(i).get("SCONTRACT_BCODE").toString().equals(param.get("scontractCode").toString())) continue;
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            if (spScontractDomain.getFchannelCode().equals("1")) {
                map = new HashMap<String, Object>();
                map.put("order", true);
                map.put("fuzzy", false);
                map.put("userinfoPhone", type1.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCorp());
                spScontractDomain.setContractTypepro(type1.get(i).get("LPJCONTRACT_TYPEPRO").toString());
            } else if (spScontractDomain.getFchannelCode().equals("2")) {
                map = new HashMap();
                map.put("order", true);
                map.put("fuzzy", false);
                map.put("userinfoPhone", type1.get(i).get("HCCONTRACT_TYPEPRO").toString());
                UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCompname());
                spScontractDomain.setContractTypepro(type1.get(i).get("HCCONTRACT_TYPEPRO").toString());
            } else {
                spScontractDomain.setContractTypepro(type1.get(i).get("HCCONTRACT_TYPEPRO").toString());
            }
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            this.logger.error("\u7b2c\u4e00\u79cd**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
            HtmlJsonReBean htmlJsonReBean1 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBean1;
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        if ("2".equals(umUserinfoReDomainBean.getUserinfoType().toString())) {
            map2.put("companyCode", ((UmUserinfoReDomainBean)UserinfoResult.getList().get(0)).getCompanyCode());
            List<Map<String, Object>> type2 = this.type2();
            for (int i = 0; i < type2.size(); ++i) {
                SupQueryResult UserinfoRes;
                HashMap<String, Object> map;
                if (!type2.get(i).get("COMPANY_CODE").toString().equals(map2.get("companyCode").toString())) continue;
                this.logger.error("\u8fdb\u5165\u5faa\u73af\u5224\u65ad************************************" + type2.get(i).get("COMPANY_CODE"));
                spScontractDomain.setContractInvstate(Integer.valueOf(2));
                spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
                spScontractDomain.setScontractId(null);
                spScontractDomain.setScontractCode(null);
                if (spScontractDomain.getFchannelCode().equals("1")) {
                    map = new HashMap<String, Object>();
                    map.put("order", true);
                    map.put("fuzzy", false);
                    map.put("userinfoPhone", type2.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                    UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                    this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                    if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                    }
                    spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCompname());
                    spScontractDomain.setContractTypepro(type2.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                } else if (spScontractDomain.getFchannelCode().equals("2")) {
                    map = new HashMap();
                    map.put("order", true);
                    map.put("fuzzy", false);
                    map.put("userinfoPhone", type2.get(i).get("HCCONTRACT_TYPEPRO").toString());
                    UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                    this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                    if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                    }
                    spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCompname());
                    spScontractDomain.setContractTypepro(type2.get(i).get("HCCONTRACT_TYPEPRO").toString());
                } else {
                    this.logger.error("\u672a\u5339\u914d\u8017\u6750/\u96f6\u914d\u4ef6*******************************************");
                    spScontractDomain.setContractTypepro(type2.get(i).get("HCCONTRACT_TYPEPRO").toString());
                }
                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = new Date();
                spScontractDomain.setGoodsPmbillno(sm.format(date));
                spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
                spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
                spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
                spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
                spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
                spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
                spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
                this.logger.error("\u7b2c\u4e8c\u79cd**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
                HtmlJsonReBean htmlJsonReBean2 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
                return htmlJsonReBean2;
            }
        }
        HashMap map3 = new HashMap();
        if (param.containsKey("areaCode")) {
            map3.put("areaCode", param.get("areaCode"));
        } else {
            map3.put("areaCode", umUserinfoReDomainBean.getAreaCode());
        }
        List<Map<String, Object>> type3 = this.type3();
        for (int i = 0; i < type3.size(); ++i) {
            SupQueryResult UserinfoRes;
            HashMap<String, Object> map;
            this.logger.error("\u8fdb\u5165\u5faa\u73af\u5224\u65ad****************************************" + type3.get(i).get("AREA_CODE"));
            if (!type3.get(i).get("AREA_CODE").toString().equals(map3.get("areaCode").toString())) continue;
            spScontractDomain.setContractInvstate(Integer.valueOf(2));
            spScontractDomain.setDataStatestr(spScontractDomain.getScontractCode());
            spScontractDomain.setScontractId(null);
            spScontractDomain.setScontractCode(null);
            if (spScontractDomain.getFchannelCode().equals("1")) {
                map = new HashMap<String, Object>();
                map.put("order", true);
                map.put("fuzzy", false);
                map.put("userinfoPhone", type3.get(i).get("LPJCONTRACT_TYPEPRO").toString());
                UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCompname());
                spScontractDomain.setContractTypepro(type3.get(i).get("LPJCONTRACT_TYPEPRO").toString());
            } else if (spScontractDomain.getFchannelCode().equals("2")) {
                map = new HashMap();
                map.put("order", true);
                map.put("fuzzy", false);
                map.put("userinfoPhone", type3.get(i).get("HCCONTRACT_TYPEPRO").toString());
                UserinfoRes = this.userServiceRepository.queryUserinfoPage(map);
                this.logger.error("UserinfoRes" + JsonUtil.buildNormalBinder().toJson((Object)UserinfoRes));
                if (null == UserinfoRes || ListUtil.isEmpty((Collection)UserinfoRes.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u9500\u552e\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
                }
                spScontractDomain.setContractType(((UmUserinfoReDomainBean)UserinfoRes.getList().get(0)).getUserinfoCompname());
                spScontractDomain.setContractTypepro(type3.get(i).get("HCCONTRACT_TYPEPRO").toString());
            } else {
                spScontractDomain.setContractTypepro(type3.get(i).get("HCCONTRACT_TYPEPRO").toString());
            }
            SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            spScontractDomain.setGoodsPmbillno(sm.format(date));
            spScontractDomain.setGoodsPbillno(umUserinfoReDomainBean.getUserinfoPhone());
            spScontractDomain.setContractUserurl(umUserinfoReDomainBean.getUserinfoCompname());
            spScontractDomain.setContractBlance(umUserinfoReDomainBean.getUserinfoType().toString());
            spScontractDomain.setContractInvoice(umUserinfoReDomainBean.getCompanyCode());
            spScontractDomain.setEmployeeCode(umUserinfoReDomainBean.getUserinfoChannelcode());
            spScontractDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoChannelname());
            spScontractDomain.setMschannelName(umUserinfoReDomainBean.getUserinfoCorp());
            this.logger.error("\u7b2c\u4e09\u79cd**************" + JsonUtil.buildNormalBinder().toJson((Object)spScontractDomain));
            HtmlJsonReBean htmlJsonReBean3 = this.spScontractServiceRepository.saveScontract(spScontractDomain);
            return htmlJsonReBean3;
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u80fd\u5339\u914d\u5230\u5408\u9002\u7684\u9500\u552e");
    }

    @RequestMapping(value={"talkOverWithSell.json"}, name="\u9500\u552e\u66f4\u6539\u6d3d\u8c08\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean talkOverWithSell(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        String tenantCode = this.getTenantCode(request);
        param.put("tenantCode", tenantCode);
        this.logger.error("param++++++++++++++++++++++++++++++++" + JsonUtil.buildNormalBinder().toJson((Object)param));
        SupQueryResult spScontractReDomainResult = this.spScontractServiceRepository.queryScontractPage(param);
        if (ListUtil.isEmpty((Collection)spScontractReDomainResult.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\u4fe1\u606f");
        }
        SpScontractReDomain spScontractReDomainUpdate = (SpScontractReDomain)spScontractReDomainResult.getList().get(0);
        spScontractReDomainUpdate.setDataState(Integer.valueOf(Integer.parseInt(param.get("dataState").toString())));
        this.logger.error("param++++++++++++++++++++++++++++++++" + JsonUtil.buildNormalBinder().toJson((Object)param));
        return this.spScontractServiceRepository.updateScontractState(Integer.valueOf(Integer.parseInt(param.get("scontractId").toString())), Integer.valueOf(Integer.parseInt(param.get("dataState").toString())), Integer.valueOf(Integer.parseInt(param.get("oldDataState").toString())), param);
    }

    @RequestMapping(value={"contractList.json"}, name="\u5c55\u793a\u9500\u552e\u5408\u540c\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean contractList(HttpServletRequest request, String paramStr) {
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        return null;
    }

    @RequestMapping(value={"ImportBuyerContracts.json"}, name="\u5bfc\u5165\u7ebf\u4e0b\u4e70\u5bb6\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr) {
        if (StringUtils.isBlank((String)scontractDomainStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "params is null");
        }
        this.logger.error(scontractDomainStr);
        List spScontractDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        String msg = "";
        int errCount = 0;
        HtmlJsonReBean htmlJsonReBean = null;
        for (SpScontractDomain spScontractDomain : spScontractDomainList) {
            spScontractDomain.setTenantCode(this.getTenantCode(request));
            spScontractDomain.getScontractCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String scontractNcode = spScontractDomain.getScontractNcode();
            String scontractObillcode = spScontractDomain.getScontractObillcode();
            map.put("scontractObillcode", spScontractDomain.getScontractObillcode());
            this.logger.error("scontractObillcode---------------------------------" + spScontractDomain.getScontractObillcode());
            map.put("tenantCode", this.getTenantCode(request));
            map.put("contractInvstate", 0);
            List SpScontractReDomain2 = this.spScontractServiceRepository.queryScontractPage(map).getList();
            if (ListUtil.isEmpty((Collection)SpScontractReDomain2)) {
                msg = msg + scontractObillcode + "\u8be5\u5408\u540c\u4e0d\u5b58\u5728;";
                this.logger.error(scontractObillcode + "\uff1a11111111111\u5408\u540c\u4e0d\u5b58\u5728");
                ++errCount;
                continue;
            }
            SpScontractReDomain SpScontractReDomain22 = (SpScontractReDomain)SpScontractReDomain2.get(0);
            map.put("contractInvstate", 1);
            map.put("memberBcode", spScontractDomain.getMemberBcode());
            List SpScontractReDomain1 = this.spScontractServiceRepository.queryScontractPage(map).getList();
            if (ListUtil.isEmpty((Collection)SpScontractReDomain1)) {
                SpScontractReDomain22.setScontractObillcode(spScontractDomain.getScontractObillcode());
                SpScontractReDomain22.setScontractNcode(spScontractDomain.getScontractNcode());
                SpScontractReDomain22.setGoodsMoney(spScontractDomain.getGoodsMoney());
                SpScontractReDomain22.setContractEffectivedate(spScontractDomain.getContractEffectivedate());
                SpScontractReDomain22.setContractDepositdate(spScontractDomain.getContractDepositdate());
                SpScontractReDomain22.setDataState(spScontractDomain.getDataState());
                SpScontractReDomain22.setMemberCname(spScontractDomain.getMemberCname());
                SpScontractReDomain22.setMemberCcode(spScontractDomain.getMemberCcode());
                SpScontractReDomain22.setMemberBcode(spScontractDomain.getMemberBcode());
                SpScontractReDomain22.setScontractBcode(spScontractDomain.getScontractBcode());
                SpScontractReDomain22.setContractInvstate(Integer.valueOf(1));
                this.logger.error("\u4e2a\u4eba\u5408\u540c\u4e0d\u5b58\u5728\uff0c\u65b0\u589e" + scontractObillcode);
                SpScontractReDomain22.setScontractId(null);
                SpScontractReDomain22.setScontractCode(null);
                htmlJsonReBean = this.spScontractServiceRepository.saveScontract((SpScontractDomain)SpScontractReDomain22);
                continue;
            }
            spScontractDomain.setScontractId(((SpScontractReDomain)SpScontractReDomain1.get(0)).getScontractId());
            if (StringUtils.isNotBlank((String)((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode())) {
                if (((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode().equals(scontractNcode)) {
                    this.logger.error("\u5916\u90e8\u5408\u540c\u6821\u9a8c\u901a\u8fc7\uff1a" + ((SpScontractReDomain)SpScontractReDomain2.get(0)).getScontractNcode());
                    htmlJsonReBean = this.spScontractServiceRepository.updateScontract(spScontractDomain);
                    continue;
                }
                msg = msg + scontractObillcode + "\u5916\u90e8\u5408\u540c\u7f16\u53f7\u4e0d\u6b63\u786e;";
                this.logger.error(spScontractDomain.getScontractObillcode() + "\u5916\u90e8\u5408\u540c\u7f16\u53f7\u6821\u9a8c\u4e0d\u901a\u8fc7");
                ++errCount;
                continue;
            }
            this.logger.error("msg", (Object)("\u5916\u90e8\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a" + spScontractDomain.getScontractObillcode()));
            this.logger.error("msg", (Object)("id" + spScontractDomain.getScontractObillcode()));
            htmlJsonReBean = this.spScontractServiceRepository.updateScontract(spScontractDomain);
        }
        if (errCount == 0) {
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bfc\u5165\u5931\u8d25\uff1a" + errCount + "\u6761," + msg);
    }
}

