/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.tenant.controller;

import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.am.domain.AmDepartReDomain;
import com.qjsoft.laser.controller.facade.am.repository.AmDepartServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmTenantDomain;
import com.qjsoft.laser.controller.facade.tm.domain.TmTenantReDomain;
import com.qjsoft.laser.controller.facade.tm.repository.TmTenantServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.qjsoft.laser.controller.tenant.tenantexcetemplate.ExcelExportTemplate;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tm/tenant"}, name="\u79df\u6237\u4fe1\u606f")
public class TenantCon
extends SpringmvcController {
    private static String CODE = "tm.tenant.con";
    @Autowired
    private TmTenantServiceRepository tmTenantServiceRepository;
    @Autowired
    private AmDepartServiceRepository amDepartServiceRepository;

    protected String getContext() {
        return "tenant";
    }

    @RequestMapping(value={"saveTenant.json"}, name="\u589e\u52a0\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            this.logger.error(CODE + ".saveTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.logger.error(CODE + ".saveTenant", (Object)tmTenantDomain.getProappCode());
        return this.tmTenantServiceRepository.saveTenant(tmTenantDomain);
    }

    @RequestMapping(value={"getTenant.json"}, name="\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public TmTenantReDomain getTenant(String tenantId) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".getTenant", (Object)"param is null");
            return null;
        }
        return this.tmTenantServiceRepository.getTenant(Integer.valueOf(tenantId));
    }

    @RequestMapping(value={"getTenantByNow.json"}, name="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public TmTenantReDomain getTenantByNow(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        return this.tmTenantServiceRepository.getTenantByCode(map);
    }

    @RequestMapping(value={"updateTenant.json"}, name="\u66f4\u65b0\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            this.logger.error(CODE + ".updateTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.updateTenant(tmTenantDomain);
    }

    @RequestMapping(value={"deleteTenant.json"}, name="\u5220\u9664\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteTenant(String tenantId) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".deleteTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.deleteTenant(Integer.valueOf(tenantId));
    }

    @RequestMapping(value={"queryTenantPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPage(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantPageFromFilesort.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u56fe\u7247\u5206\u7c7b")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageFromFilesort(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantPageFromGe.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u8fdb\u5ea6\u5b9a\u4e49")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageFromGe(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantPageFromMsc.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageFromMsc(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantFromDisBySer.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u6280\u672f\u4e2d\u53f0\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantFromDisBySer(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    public SupQueryResult<TmTenantReDomain> fetchQuery(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmTenantServiceRepository.queryTenantPage(param);
    }

    @RequestMapping(value={"updateTenantState.json"}, name="\u66f4\u65b0\u79df\u6237\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTenantState(String tenantId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".updateTenantState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantServiceRepository.updateTenantState(Integer.valueOf(tenantId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryTenantCache.json"}, name="\u79df\u6237\u52a0\u8f7d\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean queryTenantCache() {
        return this.tmTenantServiceRepository.queryTenantCache();
    }

    @RequestMapping(value={"queryTenantPageStr.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageStr(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        UserInfo userInfo = this.getUserInfo(request);
        Object page = param.get("page");
        Object rows = param.get("rows");
        if (null != param) {
            param.put("order", true);
        }
        param.put("userCode", userInfo.getUserCode());
        SupQueryResult departReDomainSupQueryNewResult = new SupQueryResult();
        param.put("page", null);
        param.put("rows", null);
        SupQueryResult departReDomainList = this.amDepartServiceRepository.queryDepartPage(param);
        if (ListUtil.isEmpty((Collection)departReDomainList.getList())) {
            this.logger.error(CODE + ".queryTenantPageStr", (Object)"departReDomainList is null");
            return departReDomainSupQueryNewResult;
        }
        param.put("page", page);
        param.put("rows", rows);
        StringBuilder tenantCodes = new StringBuilder();
        for (AmDepartReDomain depart : departReDomainList.getList()) {
            tenantCodes.append(depart.getTenantCode() + ",");
        }
        param.put("tenantCode", tenantCodes);
        departReDomainSupQueryNewResult = this.tmTenantServiceRepository.queryToTenantCodes(param);
        return departReDomainSupQueryNewResult;
    }

    @RequestMapping(value={"queryTenantPageStrToParam.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageStrToParam(HttpServletRequest request, String tenantCode, String tenantCompname, Integer dataState) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("tenantCompname", tenantCompname);
            param.put("dataState", dataState);
            param.put("order", true);
        }
        SupQueryResult<TmTenantReDomain> departReDomainSupQuer = new SupQueryResult<TmTenantReDomain>();
        if (StringUtils.isBlank((String)tenantCode)) {
            departReDomainSupQuer = this.queryTenantPageStr(request);
        }
        if (StringUtils.isNotBlank((String)tenantCode)) {
            return this.tmTenantServiceRepository.queryToTenantCodes(param);
        }
        return departReDomainSupQuer;
    }

    @RequestMapping(value={"queryTenantPageTm.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageTm(HttpServletRequest request, String tenantCode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isBlank((String)tenantCode)) {
                param.remove("tenantCode");
            } else {
                param.put("tenantCode", tenantCode);
            }
        }
        return this.queryTenantPageExport(param, request);
    }

    private SupQueryResult<TmTenantReDomain> queryTenantPageExport(Map<String, Object> param, HttpServletRequest request) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        String fileName = null == param || null == param.get("fileName") ? "\u79df\u6237\u5217\u8868" : (String)param.get("fileName");
        Boolean flag = Boolean.valueOf(exportFlag);
        SupQueryResult tmTenantReDomainSupQueryResult = this.tmTenantServiceRepository.queryTenantPage(param);
        if (flag.booleanValue()) {
            UserSession userSession = this.getUserSession(request);
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isBlank((String)excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertTenantHeadExcelParam());
            }
            List jsonToList = null;
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.error(CODE + ".queryTenantPageReDomain.1111", (Object)(param + "=:=" + infoMap));
            try {
                List list = tmTenantReDomainSupQueryResult.getList();
                String str = JsonUtil.buildNormalBinder().toJson((Object)list);
                jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(str, Map.class);
                this.exportExcel(request, param, infoMap, jsonToList);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryTenantPageReDomain.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.tmTenantServiceRepository.queryTenantPage(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, List<Map<String, Object>> fromDataList) {
        this.logger.info("=======================\u4f20\u5165\u7684\u6570\u91cf===================" + fromDataList.size());
        this.logger.error("paramMap-_=+is", paramMap);
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return;
        }
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return;
        }
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("gmtModified".equals(beanName)) {
                        Object date = map.get(beanName);
                        this.logger.info("\u65f6\u95f4:" + date);
                        String string2 = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    }
                    if ("dataState".equals(beanName)) {
                        this.logger.error("---------------\u79df\u6237\u72b6\u6001=" + value);
                        if ("-1".equals(value.trim())) {
                            this.logger.error("---------------\u79df\u6237\u72b6\u6001=========1111" + value);
                            value = "\u5df2\u505c\u7528";
                        }
                        if ("0".equals(value.trim())) {
                            this.logger.error("---------------\u79df\u6237\u72b6\u6001=========" + value);
                            value = "\u4f7f\u7528\u4e2d";
                        }
                    }
                    if ("tenantFeestatus".equals(beanName)) {
                        if ("0".equals(value)) {
                            value = "\u6b20\u8d39";
                        }
                        if ("1".equals(value)) {
                            value = "\u6b63\u5e38";
                        }
                    } else {
                        String string3 = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    }
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
            this.logger.info("================================\u6570\u91cf==================================" + dataList.size());
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
            return;
        }
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    public void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        tenantCode = "2021020200000001";
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", (FmFileDomainBean)fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List tmTenantReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TmTenantReDomain.class);
        if (ListUtil.isEmpty((Collection)tmTenantReDomainList)) {
            return null;
        }
        if (StringUtils.isBlank((String)excelTemplate)) {
            for (TmTenantReDomain tm : tmTenantReDomainList) {
                Map<String, Object> objectDetailToMap = this.covertMap(tm);
                mapList.add(objectDetailToMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> covertMap(TmTenantReDomain tmTenantReDomain) {
        HashMap<String, Object> tenantDetaiMap = new HashMap<String, Object>();
        tenantDetaiMap.put("tenantCode", tmTenantReDomain.getTenantCode());
        tenantDetaiMap.put("tenantCompname", tmTenantReDomain.getTenantCompname());
        tenantDetaiMap.put("tenantCon", tmTenantReDomain.getTenantCon());
        tenantDetaiMap.put("tenantPhone", tmTenantReDomain.getTenantPhone());
        tenantDetaiMap.put("tenantEmail", tmTenantReDomain.getTenantEmail());
        tenantDetaiMap.put("tenantEdate", tmTenantReDomain.getTenantEdate());
        if (tmTenantReDomain.getDataState() == 0) {
            tenantDetaiMap.put("dataState", "\u4f7f\u7528\u4e2d");
        }
        if (tmTenantReDomain.getDataState() == -1) {
            tenantDetaiMap.put("dataState", "\u5df2\u505c\u7528");
        }
        if (tmTenantReDomain.getTenantFeestatus() == 0) {
            tenantDetaiMap.put("tenantFeestatus", "\u6b20\u8d39");
        }
        if (tmTenantReDomain.getTenantFeestatus() == 1) {
            tenantDetaiMap.put("tenantFeestatus", "\u6b63\u5e38");
        }
        tenantDetaiMap.put("tenantFeeedate", tmTenantReDomain.getTenantFeeedate());
        tenantDetaiMap.put("memo", tmTenantReDomain.getMemo());
        return tenantDetaiMap;
    }
}

