/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmFootprintDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmFootprintReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmFootprintServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/footprint"}, name="\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
public class FootprintCon
extends SpringmvcController {
    private static String CODE = "um.footprint.con";
    @Autowired
    private UmFootprintServiceRepository umFootprintServiceRepository;

    protected String getContext() {
        return "footprint";
    }

    @RequestMapping(value={"saveFootprint.json"}, name="\u589e\u52a0\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveFootprint(HttpServletRequest request, UmFootprintDomain umFootprintDomain) {
        if (null == umFootprintDomain) {
            this.logger.error(CODE + ".saveFootprint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveFootprint", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umFootprintDomain.setUserCode(userSession.getUserCode());
        umFootprintDomain.setUserinfoCode(userSession.getUserPcode());
        umFootprintDomain.setUserName(userSession.getMerberCompname());
        umFootprintDomain.setTenantCode(this.getTenantCode(request));
        return this.umFootprintServiceRepository.saveFootprint(umFootprintDomain);
    }

    @RequestMapping(value={"getFootprint.json"}, name="\u83b7\u53d6\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmFootprintReDomain getFootprint(Integer footprintId) {
        if (StringUtils.isBlank((Integer)footprintId)) {
            this.logger.error(CODE + ".getFootprint", (Object)"param is null");
            return null;
        }
        return this.umFootprintServiceRepository.getFootprint(footprintId);
    }

    @RequestMapping(value={"updateFootprint.json"}, name="\u66f4\u65b0\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateFootprint(HttpServletRequest request, UmFootprintDomain umFootprintDomain) {
        if (null == umFootprintDomain) {
            this.logger.error(CODE + ".updateFootprint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateFootprint", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umFootprintDomain.setUserCode(userSession.getUserCode());
        umFootprintDomain.setUserinfoCode(userSession.getUserPcode());
        umFootprintDomain.setUserName(userSession.getMerberCompname());
        umFootprintDomain.setTenantCode(this.getTenantCode(request));
        return this.umFootprintServiceRepository.updateFootprint(umFootprintDomain);
    }

    @RequestMapping(value={"deleteFootprint.json"}, name="\u5220\u9664\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteFootprint(Integer footprintId) {
        if (StringUtils.isBlank((Integer)footprintId)) {
            this.logger.error(CODE + ".deleteFootprint", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umFootprintServiceRepository.deleteFootprint(footprintId);
    }

    @RequestMapping(value={"deleteFootprintByCode.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u8db3\u8ff9\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteFootprintByCode(HttpServletRequest request, String collectCode) {
        if (StringUtils.isBlank((String)collectCode)) {
            this.logger.error(CODE + ".deleteFootprintByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umFootprintServiceRepository.deleteFootprintByCode(this.getTenantCode(request), collectCode);
    }

    @RequestMapping(value={"queryFootprintPage.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmFootprintReDomain> queryFootprintPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umFootprintServiceRepository.queryFootprintPage(param);
    }

    @RequestMapping(value={"queryFootprintPagePlat.json"}, name="\u67e5\u8be2\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmFootprintReDomain> queryFootprintPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umFootprintServiceRepository.queryFootprintPage(param);
    }

    @RequestMapping(value={"updateFootprintState.json"}, name="\u66f4\u65b0\u7528\u6237\u8db3\u8ff9\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateFootprintState(String footprintId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)footprintId)) {
            this.logger.error(CODE + ".updateFootprintState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umFootprintServiceRepository.updateFootprintState(Integer.valueOf(footprintId), dataState, oldDataState);
    }
}

