/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmCollectDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmCollectReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmCollectServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/collect"}, name="\u7528\u6237\u6536\u85cf\u4fe1\u606f")
public class CollectCon
extends SpringmvcController {
    private static String CODE = "um.collect.con";
    @Autowired
    private UmCollectServiceRepository umCollectServiceRepository;

    protected String getContext() {
        return "collect";
    }

    @RequestMapping(value={"saveCollect.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveCollect(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", new Object[]{userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()}));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getNowChannel(request));
        return this.umCollectServiceRepository.saveCollect(umCollectDomain);
    }

    @RequestMapping(value={"getCollect.json"}, name="\u83b7\u53d6\u7528\u6237\u6536\u85cf\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmCollectReDomain getCollect(Integer collectId) {
        if (StringUtils.isBlank((Integer)collectId)) {
            this.logger.error(CODE + ".getCollect", (Object)"param is null");
            return null;
        }
        return this.umCollectServiceRepository.getCollect(collectId);
    }

    @RequestMapping(value={"updateCollect.json"}, name="\u66f4\u65b0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateCollect(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".updateCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        return this.umCollectServiceRepository.updateCollect(umCollectDomain);
    }

    @RequestMapping(value={"deleteCollect.json"}, name="\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollect(Integer collectId) {
        if (StringUtils.isBlank((Integer)collectId)) {
            this.logger.error(CODE + ".deleteCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umCollectServiceRepository.deleteCollect(collectId);
    }

    @RequestMapping(value={"deleteCollectByCode.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByCode(HttpServletRequest request, String collectCode) {
        if (StringUtils.isBlank((String)collectCode)) {
            this.logger.error(CODE + ".deleteCollectByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umCollectServiceRepository.deleteCollectByCode(this.getTenantCode(request), collectCode);
    }

    @RequestMapping(value={"deleteCollectByCodeStr.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByCodeStr(HttpServletRequest request, String collectCodeStr) {
        if (StringUtils.isBlank((String)collectCodeStr)) {
            this.logger.error(CODE + ".deleteCollectByCodeStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        List<String> codeList = this.getCodeList(collectCodeStr);
        for (String collectCode : codeList) {
            htmlJsonReBean = this.umCollectServiceRepository.deleteCollectByCode(this.getTenantCode(request), collectCode);
        }
        return htmlJsonReBean;
    }

    private List<String> getCodeList(String str) {
        ArrayList<String> codeList = null;
        if (null != str && str.length() > 0) {
            String[] codeStr = str.split(",");
            codeList = new ArrayList<String>();
            for (String code : codeStr) {
                codeList.add(code);
            }
        }
        return codeList;
    }

    @RequestMapping(value={"queryCollectPage.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPage(HttpServletRequest request, String goodsType, String order) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        String channelCode = this.getNowChannel(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)goodsType)) {
                param.put("goodsType", goodsType);
            }
            if (StringUtils.isNotBlank((String)order)) {
                param.put("orderStr", "GMT_MODIFIED " + order);
            }
            if (StringUtils.isNotBlank((String)channelCode)) {
                param.put("channelCode", channelCode);
            }
        }
        return this.umCollectServiceRepository.queryCollectPage(param);
    }

    @RequestMapping(value={"checkCollectExit.json"}, name="\u68c0\u6d4b\u5f53\u524d\u8d44\u6e90\u662f\u5426\u5df2\u6536\u85cf")
    @ResponseBody
    public HtmlJsonReBean checkCollectExit(HttpServletRequest request, String collectType, String collectOpcode) {
        SupQueryResult qlist;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("collectType", collectType);
            param.put("collectOpcode", collectOpcode.trim());
        }
        if (null == (qlist = this.umCollectServiceRepository.queryCollectPage(param)) || null == qlist.getList() || qlist.getList().isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u6536\u85cf");
        }
        return new HtmlJsonReBean((Object)((UmCollectReDomain)qlist.getList().get(0)).getCollectCode());
    }

    @RequestMapping(value={"queryCollectPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umCollectServiceRepository.queryCollectPage(param);
    }

    @RequestMapping(value={"updateCollectState.json"}, name="\u66f4\u65b0\u7528\u6237\u6536\u85cf\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCollectState(String collectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)collectId)) {
            this.logger.error(CODE + ".updateCollectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umCollectServiceRepository.updateCollectState(Integer.valueOf(collectId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveCollectFromBx.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u5317\u65b0")
    @ResponseBody
    public HtmlJsonReBean saveCollectFromBx(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollectFromBx", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollectFromBx", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", new Object[]{userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()}));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getNowChannel(request));
        return this.umCollectServiceRepository.saveCollect(umCollectDomain);
    }
}

