/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmQualityReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmQualityServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/quality"}, name="\u8d44\u8d28\u7ba1\u7406")
public class QualityCon
extends SpringmvcController {
    private static String CODE = "um.quality.con";
    @Autowired
    private UmQualityServiceRepository umQualityServiceRepository;

    protected String getContext() {
        return "quality";
    }

    @RequestMapping(value={"saveQuality.json"}, name="\u589e\u52a0\u8d44\u8d28\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveQuality(HttpServletRequest request, UmQualityDomain umQualityDomain) {
        if (null == umQualityDomain) {
            this.logger.error(CODE + ".saveQuality", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umQualityDomain.setTenantCode(this.getTenantCode(request));
        return this.umQualityServiceRepository.saveQuality(umQualityDomain);
    }

    @RequestMapping(value={"getQuality.json"}, name="\u83b7\u53d6\u8d44\u8d28\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public UmQualityReDomain getQuality(Integer qualityId) {
        if (StringUtils.isBlank((Integer)qualityId)) {
            this.logger.error(CODE + ".getQuality", (Object)"param is null");
            return null;
        }
        return this.umQualityServiceRepository.getQuality(qualityId);
    }

    @RequestMapping(value={"updateQuality.json"}, name="\u66f4\u65b0\u8d44\u8d28\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateQuality(HttpServletRequest request, UmQualityDomain umQualityDomain) {
        if (null == umQualityDomain) {
            this.logger.error(CODE + ".updateQuality", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umQualityDomain.setTenantCode(this.getTenantCode(request));
        return this.umQualityServiceRepository.updateQuality(umQualityDomain);
    }

    @RequestMapping(value={"deleteQuality.json"}, name="\u5220\u9664\u8d44\u8d28\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteQuality(Integer qualityId) {
        if (StringUtils.isBlank((Integer)qualityId)) {
            this.logger.error(CODE + ".deleteQuality", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umQualityServiceRepository.deleteQuality(qualityId);
    }

    @RequestMapping(value={"queryQualityPage.json"}, name="\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityPage(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    @RequestMapping(value={"queryTQualityPage.json"}, name="\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868\u7248\u672c\u4e8c")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryTQualityPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult qualityList = this.umQualityServiceRepository.queryQualityPage(param);
        return qualityList;
    }

    @RequestMapping(value={"queryBatchQuality.json"}, name="\u6279\u91cf\u67e5\u8be2\u8d44\u8d28")
    @ResponseBody
    public List<UmQualityReDomain> queryTQualityPage(HttpServletRequest request, String qualityCodes) {
        String tenantCode = this.getTenantCode(request);
        ArrayList<UmQualityReDomain> qualityList = new ArrayList<UmQualityReDomain>();
        for (String qualityCode : qualityCodes.split(",")) {
            UmQualityReDomain qualityByCode = this.umQualityServiceRepository.getQualityByCode(tenantCode, qualityCode);
            if (null == qualityByCode) continue;
            qualityList.add(qualityByCode);
        }
        return qualityList;
    }

    @RequestMapping(value={"updateQualityState.json"}, name="\u66f4\u65b0\u8d44\u8d28\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateQualityState(String qualityId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)qualityId)) {
            this.logger.error(CODE + ".updateQualityState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umQualityServiceRepository.updateQualityState(Integer.valueOf(qualityId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryQualityByRights.json"}, name="\u7528\u6237\u6743\u76ca\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityByRights(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    @RequestMapping(value={"queryQualityByRightsForPlat.json"}, name="\u7528\u6237\u6743\u76ca\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityByRightsForPlat(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    @RequestMapping(value={"queryQualityByUserInfo.json"}, name="\u7528\u6237\u8d44\u8d28\u5217\u8868\u67e5\u8be2\u8d44\u8d28\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmQualityReDomain> queryQualityByUserInfo(HttpServletRequest request) {
        return this.queryQualityByCommon(request);
    }

    private SupQueryResult<UmQualityReDomain> queryQualityByCommon(HttpServletRequest request) {
        SupQueryResult qualityList = new SupQueryResult();
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (qualityList = this.umQualityServiceRepository.queryQualityPage(param)) || qualityList.getList().size() <= 0) {
            param.remove("tenantCode");
            param.put("tenantCode", "00000000");
            qualityList = this.umQualityServiceRepository.queryQualityPage(param);
        }
        return qualityList;
    }
}

