/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmMemoauthDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmMemoauthReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmMemoauthServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/memoauth"}, name="\u7528\u6237\u6388\u6743")
public class MemoauthCon
extends SpringmvcController {
    private static String CODE = "um.memoauth.con";
    @Autowired
    private UmMemoauthServiceRepository umMemoauthServiceRepository;

    protected String getContext() {
        return "memoauth";
    }

    @RequestMapping(value={"saveMemoauth.json"}, name="\u589e\u52a0\u7528\u6237\u6388\u6743")
    @ResponseBody
    public HtmlJsonReBean saveMemoauth(HttpServletRequest request, UmMemoauthDomain umMemoauthDomain) {
        if (null == umMemoauthDomain) {
            this.logger.error(CODE + ".saveMemoauth", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveMemoauth", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        umMemoauthDomain.setMemberCode(userSession.getUserPcode());
        umMemoauthDomain.setMemberName(userSession.getMerberCompname());
        umMemoauthDomain.setMemoauthContphone(userSession.getUserPhone());
        umMemoauthDomain.setTenantCode(this.getTenantCode(request));
        return this.umMemoauthServiceRepository.saveMemoauth(umMemoauthDomain);
    }

    @RequestMapping(value={"getMemoauth.json"}, name="\u83b7\u53d6\u7528\u6237\u6388\u6743\u4fe1\u606f")
    @ResponseBody
    public UmMemoauthReDomain getMemoauth(Integer memoauthId) {
        if (StringUtils.isBlank((Integer)memoauthId)) {
            this.logger.error(CODE + ".getMemoauth", (Object)"param is null");
            return null;
        }
        return this.umMemoauthServiceRepository.getMemoauth(memoauthId);
    }

    @RequestMapping(value={"updateMemoauth.json"}, name="\u66f4\u65b0\u7528\u6237\u6388\u6743")
    @ResponseBody
    public HtmlJsonReBean updateMemoauth(HttpServletRequest request, UmMemoauthDomain umMemoauthDomain) {
        if (null == umMemoauthDomain) {
            this.logger.error(CODE + ".updateMemoauth", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umMemoauthDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveMemoauth", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        umMemoauthDomain.setMemberCode(userSession.getUserPcode());
        umMemoauthDomain.setMemberName(userSession.getUserName());
        return this.umMemoauthServiceRepository.updateMemoauth(umMemoauthDomain);
    }

    @RequestMapping(value={"deleteMemoauth.json"}, name="\u5220\u9664\u7528\u6237\u6388\u6743")
    @ResponseBody
    public HtmlJsonReBean deleteMemoauth(Integer memoauthId) {
        if (StringUtils.isBlank((Integer)memoauthId)) {
            this.logger.error(CODE + ".deleteMemoauth", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umMemoauthServiceRepository.deleteMemoauth(memoauthId);
    }

    @RequestMapping(value={"queryMemoauthPage.json"}, name="\u67e5\u8be2\u7528\u6237\u6388\u6743\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmMemoauthReDomain> queryMemoauthPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umMemoauthServiceRepository.queryMemoauthPage(param);
    }

    @RequestMapping(value={"updateMemoauthState.json"}, name="\u66f4\u65b0\u7528\u6237\u6388\u6743\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateMemoauthState(HttpServletRequest request, String memoauthId, Integer dataState, Integer oldDataState, String memoauthAuremark) {
        if (StringUtils.isBlank((String)memoauthId)) {
            this.logger.error(CODE + ".updateMemoauthState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userSession.getUserPcode());
        map.put("userName", userSession.getUserName());
        if (memoauthAuremark != null) {
            map.put("memoauthAuremark", memoauthAuremark);
        }
        return this.umMemoauthServiceRepository.updateMemoauthState(Integer.valueOf(memoauthId), dataState, oldDataState, map);
    }

    @RequestMapping(value={"queryMemoauthPageForAt.json"}, name="\u67e5\u8be2\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<UmMemoauthReDomain> queryMemoauthPageForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("dataState", 1);
        }
        this.logger.error("======", (Object)param.toString());
        return this.umMemoauthServiceRepository.queryMemoauthPage(param);
    }

    @RequestMapping(value={"getMemoauthDateState.json"}, name="\u83b7\u53d6\u7528\u6237\u6388\u6743\u4fe1\u606f")
    @ResponseBody
    public UmMemoauthReDomain getMemoauthDateState(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("memberCode", userSession.getUserPcode());
        map.put("order", true);
        map.put("fuzzy", true);
        SupQueryResult umMemoauthReDomainSupQueryResult = this.umMemoauthServiceRepository.queryMemoauthPage(map);
        if (ListUtil.isEmpty((Collection)umMemoauthReDomainSupQueryResult.getList())) {
            return null;
        }
        return (UmMemoauthReDomain)umMemoauthReDomainSupQueryResult.getList().get(0);
    }
}

