/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmRoleDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmRolePermissionDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmRoleReDomain;
import com.qjsoft.laser.controller.facade.um.repository.UmRolePermissionServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UmRoleServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/umRole"}, name="\u89d2\u8272\u7ba1\u7406")
public class UmRoleCon
extends SpringmvcController {
    private static String CODE = "um.umRole.con";
    @Autowired
    private UmRoleServiceRepository umRoleServiceRepository;
    @Autowired
    private UmRolePermissionServiceRepository umRolePermissionServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "umRole";
    }

    @RequestMapping(value={"saveUmRole.json"}, name="\u589e\u52a0\u89d2\u8272\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveUmRole(HttpServletRequest request, UmRoleDomain umRoleDomain, String paramStr) {
        this.logger.error(CODE + ".saveUmRole--\u4fdd\u5b58\u5f00\u59cb---", (Object)JsonUtil.buildNormalBinder().toJson((Object)umRoleDomain));
        if (null == umRoleDomain) {
            this.logger.error(CODE + ".saveUmRole", (Object)"umRoleDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "umRoleDomain is null");
        }
        UserSession Session = this.getUserSession(request);
        if (1 == Session.getUserType()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u8d26\u53f7\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u53ef\u521b\u5efa");
        }
        umRoleDomain.setTenantCode(this.getTenantCode(request));
        umRoleDomain.setMemberCode(Session.getUserPcode());
        umRoleDomain.setMemberName(Session.getMerberCompname());
        HtmlJsonReBean htmlJsonReBean = this.umRoleServiceRepository.saveRole(umRoleDomain);
        String roleCode = htmlJsonReBean.getDataObj().toString();
        return this.saveRoleByGG(request, roleCode, paramStr);
    }

    @RequestMapping(value={"getUmRole.json"}, name="\u83b7\u53d6\u89d2\u8272\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public UmRoleReDomain getUmRole(HttpServletRequest request, Integer roleId) {
        if (StringUtils.isBlank((Integer)roleId)) {
            this.logger.error(CODE + ".getUmRole", (Object)"roleId is null");
            return null;
        }
        UmRoleReDomain role = this.umRoleServiceRepository.getRole(roleId);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("roleCode", role.getRoleCode());
        param.put("tenantCode", this.getTenantCode(request));
        List list = this.umRolePermissionServiceRepository.queryRolePermissionPage(param).getList();
        if (!list.isEmpty()) {
            role.setUmRolePermissionReDomainList(list);
        }
        return role;
    }

    @RequestMapping(value={"updateUmRole.json"}, name="\u66f4\u65b0\u89d2\u8272\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateUmRole(HttpServletRequest request, String paramStr, UmRoleDomain umRoleDomain) {
        this.logger.error(CODE + ".updateUmRole--\u4fee\u6539\u5f00\u59cb---", (Object)JsonUtil.buildNormalBinder().toJson((Object)umRoleDomain));
        if (null == umRoleDomain) {
            this.logger.error(CODE + ".updateUmRole", (Object)"umRoleDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "umRoleDomain is null");
        }
        umRoleDomain.setTenantCode(this.getTenantCode(request));
        return this.updateRoleByGG(request, paramStr, umRoleDomain);
    }

    @RequestMapping(value={"deleteUmRole.json"}, name="\u5220\u9664\u89d2\u8272\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteUmRole(HttpServletRequest request, Integer roleId) {
        if (StringUtils.isBlank((Integer)roleId)) {
            this.logger.error(CODE + ".deleteUmRole", (Object)"roleId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "roleId is null");
        }
        return this.deleteRoleByGG(request, roleId);
    }

    @RequestMapping(value={"queryUmRolePage.json"}, name="\u67e5\u8be2\u89d2\u8272\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmRoleReDomain> queryUmRolePage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umRoleServiceRepository.queryRolePage(param);
    }

    @RequestMapping(value={"updateUmRoleState.json"}, name="\u66f4\u65b0\u89d2\u8272\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUmRoleState(String roleId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)roleId)) {
            this.logger.error(CODE + ".updateUmRoleState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umRoleServiceRepository.updateRoleState(Integer.valueOf(roleId), dataState, oldDataState, null);
    }

    public HtmlJsonReBean saveRoleByGG(HttpServletRequest request, String roleCode, String paramStr) {
        if (StringUtils.isBlank((String)roleCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6dfb\u52a0\u89d2\u8272\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveRole", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, UmRolePermissionDomain.class);
        for (UmRolePermissionDomain umRolePermissionDomain : list) {
            umRolePermissionDomain.setRoleCode(roleCode);
            umRolePermissionDomain.setPermissionType("pc");
            umRolePermissionDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.umRolePermissionServiceRepository.saveRolePermissionBatch(list);
    }

    public HtmlJsonReBean deleteRoleByGG(HttpServletRequest request, Integer roleId) {
        UmRoleReDomain role = this.umRoleServiceRepository.getRole(roleId);
        if (null == role) {
            this.logger.error(CODE + ".deleteRole", (Object)"\u89d2\u8272\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u89d2\u8272\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        String roleCode = role.getRoleCode();
        this.logger.error(CODE + ".deleteRole.roleCode", (Object)roleCode);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("employeeCode", roleCode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult umUserReDomainBeanSupQueryResult = this.userServiceRepository.queryUserPage(param);
        if (null != umUserReDomainBeanSupQueryResult.getRows() && umUserReDomainBeanSupQueryResult.getRows().size() > 0) {
            this.logger.error(CODE + ".deleteRole", (Object)"\u89d2\u8272\u5df2\u88ab\u5173\u8054\uff0c\u65e0\u6cd5\u5220\u9664");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u89d2\u8272\u5df2\u88ab\u5173\u8054\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        HtmlJsonReBean htmlJsonReBean = this.umRolePermissionServiceRepository.deleteRolePerByRoleCode(this.getTenantCode(request), roleCode);
        this.logger.error(CODE + ".\u5220\u9664\u89d2\u8272\u6743\u9650----", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
        return this.umRoleServiceRepository.deleteRole(roleId);
    }

    public HtmlJsonReBean updateRoleByGG(HttpServletRequest request, String paramStr, UmRoleDomain umRoleDomain) {
        if (null == umRoleDomain || null == umRoleDomain.getRoleId() || StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25\uff01");
        }
        UserSession userSession = this.getUserSession(request);
        umRoleDomain.setMemberCode(userSession.getUserPcode());
        umRoleDomain.setMemberName(userSession.getMerberCompname());
        umRoleDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.umRoleServiceRepository.updateRole(umRoleDomain);
        if (null == htmlJsonReBean) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25");
        }
        if (!htmlJsonReBean.getSysRecode().equals("success")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, UmRolePermissionDomain.class);
        if (null == list) {
            this.logger.error(CODE + ".updateUserPermission", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (UmRolePermissionDomain umRolePermissionDomain : list) {
            umRolePermissionDomain.setRoleCode(umRoleDomain.getRoleCode());
            umRolePermissionDomain.setPermissionType("pc");
            umRolePermissionDomain.setTenantCode(this.getTenantCode(request));
        }
        HtmlJsonReBean htmlJsonReBean1 = this.umRolePermissionServiceRepository.deleteRolePerByRoleCode(this.getTenantCode(request), umRoleDomain.getRoleCode());
        this.logger.error(CODE + ".\u5220\u9664\u89d2\u8272\u6743\u9650----", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean1));
        return this.umRolePermissionServiceRepository.saveRolePermissionBatch(list);
    }
}

