/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.um.controller;

import com.qjsoft.laser.controller.common.bean.DisChannel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmCollectDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmCollectReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoDataReDomin;
import com.qjsoft.laser.controller.facade.um.repository.UmCollectServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/collect"}, name="\u7528\u6237\u6536\u85cf\u4fe1\u606f")
public class CollectCon
extends SpringmvcController {
    private static String CODE = "um.collect.con";
    @Autowired
    private UmCollectServiceRepository umCollectServiceRepository;

    protected String getContext() {
        return "collect";
    }

    @RequestMapping(value={"saveCollect.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveCollect(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", new Object[]{userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()}));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getCompanyChannel(request));
        return this.umCollectServiceRepository.saveCollect(umCollectDomain);
    }

    public String getCompanyChannel(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String channelCode = "";
        String userinfoCode = "";
        if ("buy".equals(userSession.getUserinfoQuality())) {
            userinfoCode = userSession.getUserinfoParentCode();
        }
        if ("company".equals(userSession.getUserinfoQuality())) {
            userinfoCode = userSession.getUserPcode();
        }
        if (StringUtils.isNotBlank((String)userinfoCode) && StringUtils.isNotBlank((String)userSession.getUserPcode())) {
            String tenantCode = this.getTenantCode(request);
            DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(userinfoCode + "-0-" + tenantCode), DisChannel.class);
            if (null == disChannel) {
                this.logger.error(CODE + ".find.childFlagstr", (Object)(" is null" + userinfoCode));
                return null;
            }
            if (!"032".equals(this.getProappCode(request))) {
                channelCode = this.getTginfoChannel(request);
            }
            if (StringUtils.isBlank((String)channelCode)) {
                channelCode = disChannel.getChannelCode();
            }
        }
        return channelCode;
    }

    @RequestMapping(value={"saveCollectBatch.json"}, name="\u6279\u91cf\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveCollectBatch(HttpServletRequest request, String umCollectDomainList) {
        if (null == umCollectDomainList) {
            this.logger.error(CODE + ".saveCollectBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        String nowChannel = this.getCompanyChannel(request);
        List umCollectDomains = (List)JsonUtil.buildNormalBinder().getJsonToList(umCollectDomainList, UmCollectDomain.class);
        for (UmCollectDomain umCollectDomain : umCollectDomains) {
            SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", new Object[]{userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()}));
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) continue;
            umCollectDomain.setUserCode(userSession.getUserCode());
            umCollectDomain.setUserinfoCode(userSession.getUserPcode());
            umCollectDomain.setUserName(userSession.getMerberCompname());
            umCollectDomain.setTenantCode(tenantCode);
            umCollectDomain.setProappCode(proappCode);
            umCollectDomain.setOauthEnvCode(oauthEnvCode);
            umCollectDomain.setChannelCode(nowChannel);
            this.umCollectServiceRepository.saveCollect(umCollectDomain);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getCollect.json"}, name="\u83b7\u53d6\u7528\u6237\u6536\u85cf\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmCollectReDomain getCollect(HttpServletRequest request, Integer collectId) {
        if (StringUtils.isBlank((Integer)collectId)) {
            this.logger.error(CODE + ".getCollect", (Object)"param is null");
            return null;
        }
        UmCollectReDomain umCollectReDomain = this.umCollectServiceRepository.getCollect(collectId);
        if (null == umCollectReDomain) {
            return null;
        }
        if (!umCollectReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".getCollect.user", (Object)"user is error");
            return null;
        }
        return umCollectReDomain;
    }

    @RequestMapping(value={"updateCollect.json"}, name="\u66f4\u65b0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateCollect(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".updateCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmCollectReDomain umCollectReDomain = this.umCollectServiceRepository.getCollect(umCollectDomain.getCollectId());
        if (null == umCollectReDomain) {
            return null;
        }
        if (!umCollectReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".updateCollect.user", (Object)"user is error");
            return null;
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        return this.umCollectServiceRepository.updateCollect(umCollectDomain);
    }

    @RequestMapping(value={"deleteCollect.json"}, name="\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollect(HttpServletRequest request, Integer collectId) {
        if (StringUtils.isBlank((Integer)collectId)) {
            this.logger.error(CODE + ".deleteCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == this.getCollect(request, collectId)) {
            this.logger.error(CODE + ".deleteCollect.user", (Object)"user is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        return this.umCollectServiceRepository.deleteCollect(collectId);
    }

    @RequestMapping(value={"deleteCollectByCode.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByCode(HttpServletRequest request, String collectCode) {
        if (StringUtils.isBlank((String)collectCode)) {
            this.logger.error(CODE + ".deleteCollectByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmCollectReDomain umCollectReDomain = this.umCollectServiceRepository.getCollectByCode(this.getTenantCode(request), collectCode);
        if (null == umCollectReDomain || !umCollectReDomain.getUserinfoCode().equals(this.getUserSession(request).getUserPcode())) {
            this.logger.error(CODE + ".deleteCollectByCode.user", (Object)"user is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        return this.umCollectServiceRepository.deleteCollectByCode(this.getTenantCode(request), collectCode);
    }

    @RequestMapping(value={"deleteCollectByCodeStr.json"}, name="\u901a\u8fc7CODE\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByCodeStr(HttpServletRequest request, String collectCodeStr) {
        if (StringUtils.isBlank((String)collectCodeStr)) {
            this.logger.error(CODE + ".deleteCollectByCodeStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        List<String> codeList = this.getCodeList(collectCodeStr);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        for (String collectCode : codeList) {
            UmCollectReDomain collectByCode = this.umCollectServiceRepository.getCollectByCode(tenantCode, collectCode);
            if (null == collectByCode || !collectByCode.getUserinfoCode().equals(userSession.getUserPcode())) {
                this.logger.error(CODE + ".deleteCollectByCodeStr.collectByCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)collectByCode));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            htmlJsonReBean = this.umCollectServiceRepository.deleteCollectByCode(tenantCode, collectCode);
        }
        return htmlJsonReBean;
    }

    private List<String> getCodeList(String str) {
        ArrayList<String> codeList = null;
        if (null != str && str.length() > 0) {
            String[] codeStr = str.split(",");
            codeList = new ArrayList<String>();
            for (String code : codeStr) {
                codeList.add(code);
            }
        }
        return codeList;
    }

    @RequestMapping(value={"queryCollectPage.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPage(HttpServletRequest request, String goodsType, String order) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            String channelCode = this.getCompanyChannel(request);
            if (StringUtils.isNotBlank((String)channelCode)) {
                param.put("channelCode", channelCode);
            }
            if (StringUtils.isNotBlank((String)goodsType)) {
                param.put("goodsType", goodsType);
            }
            if (StringUtils.isNotBlank((String)order)) {
                param.put("orderStr", "GMT_MODIFIED " + order);
            }
        }
        return this.umCollectServiceRepository.queryCollectPage(param);
    }

    @RequestMapping(value={"queryCollectPagechannelCode.json"}, name="\u7528\u6237\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868\u52a0\u5165\u6e20\u9053\u8fc7\u6ee4")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPagechannelCode(HttpServletRequest request, String goodsType, String order) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryFootprintPage", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("channelCode", this.getNowChannel(request));
            if (StringUtils.isNotBlank((String)goodsType)) {
                param.put("goodsType", goodsType);
            }
            if (StringUtils.isNotBlank((String)order)) {
                param.put("orderStr", "GMT_MODIFIED " + order);
            }
        }
        return this.umCollectServiceRepository.queryCollectPage(param);
    }

    @RequestMapping(value={"checkCollectExit.json"}, name="\u68c0\u6d4b\u5f53\u524d\u8d44\u6e90\u662f\u5426\u5df2\u6536\u85cf")
    @ResponseBody
    public HtmlJsonReBean checkCollectExit(HttpServletRequest request, String collectType, String collectOpcode) {
        SupQueryResult qlist;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("collectType", collectType);
            param.put("collectOpcode", collectOpcode.trim());
        }
        if (null == (qlist = this.umCollectServiceRepository.queryCollectPage(param)) || null == qlist.getList() || qlist.getList().isEmpty()) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"\u672a\u6536\u85cf");
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean((Object)((UmCollectReDomain)qlist.getList().get(0)).getCollectCode());
    }

    @RequestMapping(value={"checkBatchCollectExit.json"}, name="\u6279\u91cf\u68c0\u6d4b\u5f53\u524d\u8d44\u6e90\u662f\u5426\u5df2\u6536\u85cf")
    @ResponseBody
    public List<UmCollectReDomain> checkBatchCollectExit(HttpServletRequest request, String collectListStr) {
        if (StringUtils.isBlank((String)collectListStr)) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        List collectList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(collectListStr, Map.class);
        if (ListUtil.isEmpty((Collection)collectList)) {
            this.logger.error(CODE + ".checkBatchCollectExit.ListUtil.null");
            return null;
        }
        if (null == userSession) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"UserSession is null");
            return null;
        }
        ArrayList<UmCollectReDomain> reList = new ArrayList<UmCollectReDomain>();
        for (Map map : collectList) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantCode", this.getTenantCode(request));
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("collectType", (String)map.get("collectType"));
            param.put("collectOpcode", String.valueOf(map.get("collectOpcode")).trim());
            SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(param);
            if (null == qlist || null == qlist.getList() || qlist.getList().isEmpty()) {
                this.logger.error(CODE + ".checkBatchCollectExit", param);
                continue;
            }
            reList.add((UmCollectReDomain)qlist.getList().get(0));
        }
        return reList;
    }

    @RequestMapping(value={"queryCollectPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u7528\u6237\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umCollectServiceRepository.queryCollectPage(param);
    }

    @RequestMapping(value={"updateCollectState.json"}, name="\u66f4\u65b0\u7528\u6237\u6536\u85cf\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCollectState(String collectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)collectId)) {
            this.logger.error(CODE + ".updateCollectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umCollectServiceRepository.updateCollectState(Integer.valueOf(collectId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveCollectFromBx.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u5317\u65b0")
    @ResponseBody
    public HtmlJsonReBean saveCollectFromBx(HttpServletRequest request, UmCollectDomain umCollectDomain) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollectFromBx", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollectFromBx", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", new Object[]{userSession.getUserPcode(), umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()}));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getNowChannel(request));
        return this.umCollectServiceRepository.saveCollect(umCollectDomain);
    }

    @RequestMapping(value={"queryCollectTypeBigDataPage.json"}, name="\u6839\u636etype\u67e5\u8be2\u6536\u85cf\u6570\u636e")
    @ResponseBody
    public SupQueryResult<UmUserinfoDataReDomin> queryCollectTypeBigDataPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("collectType", "0");
        }
        return this.umCollectServiceRepository.queryCollectTypeBigDataPage(param);
    }

    @RequestMapping(value={"queryCollectPageByOpcode.json"}, name="\u6839\u636eOpCode\u67e5\u8be2\u5546\u54c1\u6536\u85cf\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmCollectReDomain> queryCollectPageByOpcode(HttpServletRequest request, String collectOpcode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("collectOpcode", collectOpcode);
        param.put("collectType", "0");
        return this.umCollectServiceRepository.queryCollectPage(param);
    }

    public static void main(String[] args) {
        ArrayList collectList = new ArrayList();
        HashMap<String, String> MAP = new HashMap<String, String>();
        MAP.put("collectType", "11111");
        MAP.put("collectOpcode", "2222");
        collectList.add(MAP);
        collectList.add(MAP);
        String s = JsonUtil.buildNonDefaultBinder().toJson(collectList);
        System.out.println(s);
    }

    @RequestMapping(value={"saveCollectByMemberBcode.json"}, name="\u589e\u52a0\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveCollect(HttpServletRequest request, UmCollectDomain umCollectDomain, String memberBcode) {
        if (null == umCollectDomain) {
            this.logger.error(CODE + ".saveCollect", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveCollect", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umCollectDomain.setUserCode(userSession.getUserCode());
        umCollectDomain.setUserinfoCode(userSession.getUserPcode());
        if (StringUtils.isNotBlank((String)memberBcode)) {
            umCollectDomain.setUserinfoCode(memberBcode);
            SupQueryResult qlist = this.umCollectServiceRepository.queryCollectPage(this.getQueryMapParam("userinfoCode,collectType,collectOpcode", new Object[]{memberBcode, umCollectDomain.getCollectType(), umCollectDomain.getCollectOpcode().trim()}));
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u52ff\u91cd\u590d\u6536\u85cf");
            }
        }
        umCollectDomain.setUserName(userSession.getMerberCompname());
        umCollectDomain.setTenantCode(this.getTenantCode(request));
        umCollectDomain.setProappCode(this.getProappCode(request));
        umCollectDomain.setOauthEnvCode(this.getOauthEnvCode(request));
        umCollectDomain.setChannelCode(this.getNowChannel(request));
        return this.umCollectServiceRepository.saveCollect(umCollectDomain);
    }

    @RequestMapping(value={"checkCollectExitByuserinfoCode.json"}, name="\u6839\u636euserinfoCode\u68c0\u6d4b\u5f53\u524d\u8d44\u6e90\u662f\u5426\u5df2\u6536\u85cf")
    @ResponseBody
    public HtmlJsonReBean checkCollectExitByuserinfoCode(HttpServletRequest request, String collectType, String collectOpcode, String userinfoCode) {
        SupQueryResult qlist;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"UserSession is null");
            return null;
        }
        if (null != param) {
            param.put("userinfoCode", userSession.getUserPcode());
            param.put("collectType", collectType);
            param.put("collectOpcode", collectOpcode.trim());
            if (StringUtils.isNotBlank((String)userinfoCode)) {
                param.remove("userinfoCode");
                param.put("userinfoCode", userinfoCode);
            }
        }
        if (null == (qlist = this.umCollectServiceRepository.queryCollectPage(param)) || null == qlist.getList() || qlist.getList().isEmpty()) {
            this.logger.error(CODE + ".checkCollectExit", (Object)"\u672a\u6536\u85cf");
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean((Object)((UmCollectReDomain)qlist.getList().get(0)).getCollectCode());
    }

    @RequestMapping(value={"deleteCollectByuserinfoCodeStr.json"}, name="\u901a\u8fc7userinfoCode\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByuserinfoCodeStr(HttpServletRequest request, String collectCodeStr, String userinfoCode) {
        if (StringUtils.isBlank((String)collectCodeStr)) {
            this.logger.error(CODE + ".deleteCollectByCodeStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        List<String> codeList = this.getCodeList(collectCodeStr);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        for (String collectCode : codeList) {
            UmCollectReDomain collectByCode = this.umCollectServiceRepository.getCollectByCode(tenantCode, collectCode);
            if (StringUtils.isNotBlank((String)userinfoCode) && (null == collectByCode || !collectByCode.getUserinfoCode().equals(userinfoCode))) {
                this.logger.error(CODE + ".deleteCollectByCodeStr.collectByCode", (Object)JsonUtil.buildNormalBinder().toJson((Object)collectByCode));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            htmlJsonReBean = this.umCollectServiceRepository.deleteCollectByCode(tenantCode, collectCode);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deleteCollectByuserinfoCode.json"}, name="\u901a\u8fc7userinfoCode\u5220\u9664\u7528\u6237\u6536\u85cf\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteCollectByuserinfoCode(HttpServletRequest request, String collectCode, String userinfoCode) {
        if (StringUtils.isBlank((String)collectCode)) {
            this.logger.error(CODE + ".deleteCollectByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmCollectReDomain umCollectReDomain = this.umCollectServiceRepository.getCollectByCode(this.getTenantCode(request), collectCode);
        if (StringUtils.isNotBlank((String)userinfoCode) && (null == umCollectReDomain || !umCollectReDomain.getUserinfoCode().equals(userinfoCode))) {
            this.logger.error(CODE + ".deleteCollectByCode.user", (Object)"user is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        return this.umCollectServiceRepository.deleteCollectByCode(this.getTenantCode(request), collectCode);
    }
}

