/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.upm.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.upm.domain.UpmPointsDomain;
import com.qjsoft.laser.controller.facade.upm.domain.UpmPointsReDomain;
import com.qjsoft.laser.controller.facade.upm.repository.UpmPointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/upm/upmpoints"}, name="\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
public class UpmpointsCon
extends SpringmvcController {
    private static String CODE = "upm.upmpoints.con";
    @Autowired
    private UpmPointsServiceRepository upmPointsServiceRepository;

    protected String getContext() {
        return "upmpoints";
    }

    @RequestMapping(value={"saveUpmpoints.json"}, name="\u589e\u52a0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsServiceRepository.savePoints(upmpointsDomain);
    }

    @RequestMapping(value={"getUpmpoints.json"}, name="\u83b7\u53d6\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public UpmPointsReDomain getUpmpoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getUpmpoints", (Object)"param is null");
            return null;
        }
        return this.upmPointsServiceRepository.getPoints(pointsId);
    }

    @RequestMapping(value={"updateUpmpoints.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".updateUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsServiceRepository.updatePoints(upmpointsDomain);
    }

    @RequestMapping(value={"deleteUpmpoints.json"}, name="\u5220\u9664\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteUpmpoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deleteUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryUpmpointsPage.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmPointsReDomain> queryUpmpointsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.upmPointsServiceRepository.queryPointsPage(param);
    }

    @RequestMapping(value={"updateUpmpointsState.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpmpointsState(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updateUpmpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState);
    }
}

