/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.upm.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.upm.domain.PreviewReDomain;
import com.qjsoft.laser.controller.facade.upm.domain.UpmPointsDomain;
import com.qjsoft.laser.controller.facade.upm.domain.UpmPointsReDomain;
import com.qjsoft.laser.controller.facade.upm.repository.UpmPointsRuleServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmPointsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/upm/upmpoints"}, name="\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
public class UpmpointsCon
extends SpringmvnNewController {
    private static String CODE = "upm.upmpoints.con";
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private UpmPointsServiceRepository upmPointsServiceRepository;
    @Autowired
    private UpmPointsRuleServiceRepository upmPointsRuleServiceRepository;
    private String cachekey = "UpmPoints-type";
    private static String DDF_KEY = "DdFalgSetting-key";
    private static String tenant_Code = "00000000";
    private static String flagSettingType = "ratio";

    protected String getContext() {
        return "upmpoints";
    }

    @RequestMapping(value={"saveUpmpoints.json"}, name="\u589e\u52a0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        upmpointsDomain.setMemberCode(userSession.getUserPcode());
        upmpointsDomain.setUpointsType("0");
        return this.upmPointsServiceRepository.savePoints(upmpointsDomain);
    }

    @RequestMapping(value={"addorupdateUpmpoints.json"}, name="\u79ef\u5206\u8bbe\u7f6e\u65b0\u589e\u6216\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean addorupdateUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == upmpointsDomain.getPointsLimit()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == upmpointsDomain.getPointsRatio()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == upmpointsDomain.getPointsId()) {
            UserSession userSession = this.getUserSession(request);
            if (null == userSession) {
                this.logger.error(CODE + ".saveUpmpoints", (Object)"userSession is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            upmpointsDomain.setTenantCode(this.getTenantCode(request));
            upmpointsDomain.setMemberCode(userSession.getUserPcode());
            upmpointsDomain.setUpointsType("0");
            return this.upmPointsServiceRepository.savePoints(upmpointsDomain);
        }
        upmpointsDomain.setUpointsType("0");
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsServiceRepository.updatePoints(upmpointsDomain);
    }

    @RequestMapping(value={"getUpmpoints.json"}, name="\u83b7\u53d6\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public UpmPointsReDomain getUpmpoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getUpmpoints", (Object)"param is null");
            return null;
        }
        return this.upmPointsServiceRepository.getPoints(pointsId);
    }

    @RequestMapping(value={"getPointsByCode.json"}, name="\u6839\u636eCODE\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public UpmPointsReDomain getPointsByCode(HttpServletRequest request, String pointsCode) {
        if (StringUtils.isBlank((String)pointsCode)) {
            this.logger.error(CODE + ".getPointsByCode", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.upmPointsServiceRepository.getPointsByCode(tenantCode, pointsCode);
    }

    @RequestMapping(value={"getRulePreview.json"}, name="\u79ef\u5206\u89c4\u5219\u9884\u89c8")
    @ResponseBody
    public PreviewReDomain getRulePreview(HttpServletRequest request) {
        SupQueryResult upmPoints;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (upmPoints = this.upmPointsServiceRepository.queryPointsPage(param)) || upmPoints.getList().size() < 0) {
            this.logger.error(CODE + ".getRulePreview", (Object)"param is null");
            return null;
        }
        PreviewReDomain previewReDomain = new PreviewReDomain();
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)upmPoints.getList().get(0);
        previewReDomain.setPointsRatio(upmPointsReDomain.getPointsRatio());
        previewReDomain.setPointsLimit(upmPointsReDomain.getPointsLimit());
        SupQueryResult upmPointsRule = this.upmPointsRuleServiceRepository.queryPointsRulePage(param);
        if (null == upmPointsRule || upmPointsRule.getList().size() <= 0) {
            this.logger.error(CODE + ".getRulePreview", (Object)"param is null");
            return null;
        }
        List upmPointsRuleList = upmPointsRule.getList();
        previewReDomain.setPointsRuleRatioList(upmPointsRuleList);
        return previewReDomain;
    }

    @RequestMapping(value={"updateUpmpoints.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".updateUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsServiceRepository.updatePoints(upmpointsDomain);
    }

    @RequestMapping(value={"getUpmpointsCom.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean getUpmpoints(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        String upointsType = "1";
        String memberMcode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String upmPointskey = upointsType + "-" + memberMcode + "-" + null + "-" + tenantCode;
        UpmPointsReDomain upmPoints = (UpmPointsReDomain)DisUtil.getMapJson((String)"UpmPoints-type", (String)upmPointskey, UpmPointsReDomain.class);
        if (null == upmPoints) {
            upmPointskey = "0-all-" + null + "-" + tenantCode;
            upmPoints = (UpmPointsReDomain)DisUtil.getMapJson((String)"UpmPoints-type", (String)upmPointskey, UpmPointsReDomain.class);
        }
        return new HtmlJsonReBean((Object)upmPoints);
    }

    @RequestMapping(value={"deleteUpmpoints.json"}, name="\u5220\u9664\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteUpmpoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deleteUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryUpmpointsPage.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmPointsReDomain> queryUpmpointsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.upmPointsServiceRepository.queryPointsPage(param);
    }

    @RequestMapping(value={"queryUserinfoPageBySupplier.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmUserinfoReDomainBean> queryUserinfoPageBySupplier(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("userinfoQuality", "supplier");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult queryResult = this.upmPointsServiceRepository.queryPointsPage(map);
        ArrayList<String> list = new ArrayList<String>();
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            for (UpmPointsReDomain upmPointsReDomain : queryResult.getList()) {
                list.add(upmPointsReDomain.getMemberMcode());
            }
        }
        ArrayList<UmUserinfoReDomainBean> umlist = new ArrayList<UmUserinfoReDomainBean>();
        SupQueryResult umUserinfo = this.userServiceRepository.queryUserinfoPage(param);
        if (null != umUserinfo && ListUtil.isNotEmpty((Collection)umUserinfo.getList())) {
            for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfo.getList()) {
                if (list.contains(umUserinfoReDomainBean.getUserinfoCode())) continue;
                umlist.add(umUserinfoReDomainBean);
            }
            umUserinfo.setRows(umlist);
            umUserinfo.setList(umlist);
        }
        return umUserinfo;
    }

    @RequestMapping(value={"queryUpmpointsPageByPalt.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmPointsReDomain> queryUpmpointsPageByPalt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.upmPointsServiceRepository.queryPointsPage(param);
    }

    @RequestMapping(value={"queryUpmpointsTPage.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868\u7248\u672c2")
    @ResponseBody
    public UpmPointsReDomain queryUpmpointsTPage(HttpServletRequest request) {
        SupQueryResult upmPointsResult;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            this.logger.error(HtmlJsonReBean.ERRORCODE, (Object)("-------\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868\u7248\u672c2------" + userSession.getUserPcode()));
            param.put("memberMcode", userSession.getUserPcode());
            param.put("tenantCode", userSession.getTenantCode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (ListUtil.isEmpty((Collection)(upmPointsResult = this.upmPointsServiceRepository.queryPointsPage(param)).getList())) {
            param.put("memberMname", userSession.getMerberCompname());
            HtmlJsonReBean htmlJsonReBean = this.upmPointsServiceRepository.savePointsInitialization(param);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
                upmPointsResult = this.upmPointsServiceRepository.queryPointsPage(param);
            }
            if (ListUtil.isEmpty((Collection)upmPointsResult.getList())) {
                return null;
            }
        }
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)upmPointsResult.getList().get(0);
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        pMap.put("order", true);
        pMap.put("fuzzy", true);
        pMap.put("tenantCode", userSession.getTenantCode());
        pMap.put("upointsType", upmPointsReDomain.getUpointsType());
        pMap.put("memberMcode", userSession.getUserPcode());
        SupQueryResult upmPointsRuleResult = this.upmPointsRuleServiceRepository.queryPointsRulePage(pMap);
        if (ListUtil.isEmpty((Collection)upmPointsRuleResult.getList())) {
            return null;
        }
        upmPointsReDomain.setUpmPointsRuleReDomains(upmPointsRuleResult.getList());
        return upmPointsReDomain;
    }

    @RequestMapping(value={"queryUpmpointsForC.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e-\u5c0f\u7a0b\u5e8f")
    @ResponseBody
    public UpmPointsReDomain queryUpmpointsForC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryUpmpointsForC", (Object)"\u672a\u767b\u9646");
            return null;
        }
        param.put("memberMcode", userSession.getUserinfoParentCode());
        param.put("tenantCode", userSession.getTenantCode());
        param.put("fuzzy", false);
        SupQueryResult upmPointsResult = this.upmPointsServiceRepository.queryPointsPage(param);
        if (ListUtil.isEmpty((Collection)upmPointsResult.getList())) {
            param.put("memberMname", userSession.getMerberCompname());
            HtmlJsonReBean htmlJsonReBean = this.upmPointsServiceRepository.savePointsInitialization(param);
            this.logger.info(HtmlJsonReBean.ERRORCODE + ".htmlJsonReBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
                upmPointsResult = this.upmPointsServiceRepository.queryPointsPage(param);
            }
            if (ListUtil.isEmpty((Collection)upmPointsResult.getList())) {
                this.logger.error(CODE + ".queryUpmpointsForC.upmPointsResult.null", (Object)param);
                return null;
            }
        }
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)upmPointsResult.getList().get(0);
        param.put("upointsType", upmPointsReDomain.getUpointsType());
        SupQueryResult upmPointsRuleResult = this.upmPointsRuleServiceRepository.queryPointsRulePage(param);
        if (ListUtil.isEmpty((Collection)upmPointsRuleResult.getList())) {
            this.logger.error(CODE + ".queryUpmpointsForC.upmPointsRuleResult.null", (Object)param);
            return null;
        }
        upmPointsReDomain.setUpmPointsRuleReDomains(upmPointsRuleResult.getList());
        return upmPointsReDomain;
    }

    @RequestMapping(value={"updateUpmpointsState.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpmpointsState(String pointsId) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updateUpmpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.updatePointsState(Integer.valueOf(pointsId), Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"stoppedUpmpointsState.json"}, name="\u505c\u7528\u79ef\u5206\u83b7\u53d6")
    @ResponseBody
    public HtmlJsonReBean stoppedUpmpointsState(String pointsId) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".stoppedUpmpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.updatePointsState(Integer.valueOf(pointsId), Integer.valueOf(0), Integer.valueOf(1));
    }

    @RequestMapping(value={"loadCache.json"}, name="\u73b0\u91d1\u79ef\u5206\u540c\u6b65")
    @ResponseBody
    public HtmlJsonReBean loadCache() {
        return this.upmPointsServiceRepository.loadCache();
    }

    @RequestMapping(value={"queryPointsCache.json"}, name="\u79ef\u5206\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean queryPointsCache() {
        return this.upmPointsServiceRepository.queryPointsCache();
    }

    @RequestMapping(value={"saveUpmpointsStr.json"}, name="\u589e\u52a0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmpointsStr(HttpServletRequest request, String upmpointsDomainStr) {
        if (StringUtils.isBlank((String)upmpointsDomainStr)) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UpmPointsDomain upmPointsDomain = (UpmPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(upmpointsDomainStr, UpmPointsDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmPointsDomain.setTenantCode(this.getTenantCode(request));
        upmPointsDomain.setMemberMcode(userSession.getUserPcode());
        upmPointsDomain.setMemberMname(userSession.getUserName());
        upmPointsDomain.setUpointsType("0");
        return this.upmPointsServiceRepository.savePoints(upmPointsDomain);
    }

    @RequestMapping(value={"updateUpmpointsRemark.json"}, name="\u4fee\u6539\u552e\u4ef7\u6362\u7b97\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updateUpmpointsRemark(HttpServletRequest request, String pointsRemark) {
        if (StringUtils.isBlank((String)pointsRemark)) {
            this.logger.error(CODE + ".updateUpmpointsRemark", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult queryResult = this.upmPointsServiceRepository.queryPointsPage(null);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            for (UpmPointsReDomain upmPointsReDomain : queryResult.getList()) {
                if (upmPointsReDomain.getPointsRemark().equals(pointsRemark)) continue;
                upmPointsReDomain.setPointsRemark(pointsRemark);
                this.upmPointsServiceRepository.updatePoints((UpmPointsDomain)upmPointsReDomain);
            }
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5e73\u53f0\u6bd4\u4f8b\u5f02\u5e38");
    }

    @RequestMapping(value={"saveUpmpointsByPlat.json"}, name="\u589e\u52a0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmpointsByPlat(HttpServletRequest request, String parmStr) {
        if (StringUtils.isBlank((String)parmStr)) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UpmPointsDomain upmPointsDomain = (UpmPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(parmStr, UpmPointsDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || null == upmPointsDomain) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3anull");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("memberMcode", "all");
        map.put("upointsType", "0");
        SupQueryResult queryResult = this.upmPointsServiceRepository.queryPointsPage(map);
        upmPointsDomain.setTenantCode(tenantCode);
        if (StringUtils.isBlank((String)upmPointsDomain.getUpointsType())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        }
        if ("0".equals(upmPointsDomain.getUpointsType())) {
            upmPointsDomain.setMemberMcode("all");
            upmPointsDomain.setMemberMname("all");
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)queryResult.getList().get(0);
                upmPointsDomain.setPointsId(upmPointsReDomain.getPointsId());
                upmPointsDomain.setPointsCode(upmPointsReDomain.getPointsCode());
                return this.upmPointsServiceRepository.updatePoints(upmPointsDomain);
            }
        } else if ("1".equals(upmPointsDomain.getUpointsType()) && StringUtils.isBlank((String)upmPointsDomain.getMemberMcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3anull");
        }
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            upmPointsDomain.setPointsRemark(((UpmPointsReDomain)queryResult.getList().get(0)).getPointsRemark());
        }
        return this.upmPointsServiceRepository.savePoints(upmPointsDomain);
    }

    private String getUrl(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingType);
        String value = SupDisUtil.getMap((String)DDF_KEY, (String)field);
        if (StringUtils.isEmpty((String)value)) {
            field = tenant_Code.concat("-").concat(flagSettingType).concat("-").concat(flagSettingType);
            value = SupDisUtil.getMap((String)DDF_KEY, (String)field);
        }
        return value;
    }

    @RequestMapping(value={"updateUpmpointsByPlat.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateUpmpointsByPlat(HttpServletRequest request, String parmStr) {
        if (null == parmStr) {
            this.logger.error(CODE + ".updateUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)parmStr)) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UpmPointsDomain upmPointsDomain = (UpmPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(parmStr, UpmPointsDomain.class);
        upmPointsDomain.setPointsRemark(this.getUrl(this.getTenantCode(request)));
        upmPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsServiceRepository.updatePoints(upmPointsDomain);
    }

    @RequestMapping(value={"deleteUpmpointsByPlat.json"}, name="\u5220\u9664\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteUpmpointsByPlat(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deleteUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.deletePoints(pointsId);
    }

    @RequestMapping(value={"updateUpmpointsStateByPlat.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpmpointsStateByPlat(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updateUpmpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsServiceRepository.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryUpmpointsPageStr.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmPointsReDomain> queryUpmpointsPageStr(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberMcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        param.put("upointsType", "0");
        return this.upmPointsServiceRepository.queryPointsPage(param);
    }

    @RequestMapping(value={"queryUpmpointResulPageStr.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public UpmPointsReDomain queryUpmpointResulPageStr(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberMcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        param.put("upointsType", "0");
        SupQueryResult result = this.upmPointsServiceRepository.queryPointsPage(param);
        if (ListUtil.isEmpty((Collection)result.getList())) {
            return null;
        }
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)result.getList().get(0);
        SupQueryResult ruleResult = this.upmPointsRuleServiceRepository.queryPointsRulePage(param);
        upmPointsReDomain.setUpmPointsRuleReDomains(ruleResult.getList());
        return upmPointsReDomain;
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        return null;
    }
}

