/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.reactorgrpc.stub;

import com.google.common.base.Preconditions;
import com.salesforce.reactorgrpc.stub.ReactorServerStreamObserverAndPublisher;
import com.salesforce.reactorgrpc.stub.ReactorSubscriberAndServerProducer;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.CallStreamObserver;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerCalls {
    private ServerCalls() {
    }

    public static <TRequest, TResponse> void oneToOne(TRequest request, StreamObserver<TResponse> responseObserver, Function<Mono<TRequest>, Mono<TResponse>> delegate) {
        try {
            Mono rxRequest = Mono.just(request);
            Mono rxResponse = (Mono)Preconditions.checkNotNull(delegate.apply(rxRequest));
            rxResponse.subscribe(value -> {
                if (responseObserver instanceof ServerCallStreamObserver && ((ServerCallStreamObserver)responseObserver).isCancelled()) {
                    return;
                }
                responseObserver.onNext(value);
                responseObserver.onCompleted();
            }, throwable -> responseObserver.onError(ServerCalls.prepareError(throwable)));
        }
        catch (Throwable throwable2) {
            responseObserver.onError(ServerCalls.prepareError(throwable2));
        }
    }

    public static <TRequest, TResponse> void oneToMany(TRequest request, StreamObserver<TResponse> responseObserver, Function<Mono<TRequest>, Flux<TResponse>> delegate) {
        try {
            Mono rxRequest = Mono.just(request);
            Flux rxResponse = (Flux)Preconditions.checkNotNull(delegate.apply(rxRequest));
            ReactorSubscriberAndServerProducer server = (ReactorSubscriberAndServerProducer)rxResponse.subscribeWith(new ReactorSubscriberAndServerProducer());
            server.subscribe((CallStreamObserver)((ServerCallStreamObserver)responseObserver));
        }
        catch (Throwable throwable) {
            responseObserver.onError(ServerCalls.prepareError(throwable));
        }
    }

    public static <TRequest, TResponse> StreamObserver<TRequest> manyToOne(StreamObserver<TResponse> responseObserver, Function<Flux<TRequest>, Mono<TResponse>> delegate) {
        ReactorServerStreamObserverAndPublisher streamObserverPublisher = new ReactorServerStreamObserverAndPublisher((ServerCallStreamObserver)responseObserver, null);
        try {
            Mono rxResponse = (Mono)Preconditions.checkNotNull(delegate.apply(Flux.from(streamObserverPublisher)));
            rxResponse.subscribe(value -> {
                if (!streamObserverPublisher.isCancelled()) {
                    responseObserver.onNext(value);
                    responseObserver.onCompleted();
                }
            }, throwable -> {
                if (!streamObserverPublisher.isCancelled()) {
                    streamObserverPublisher.abortPendingCancel();
                    responseObserver.onError(ServerCalls.prepareError(throwable));
                }
            });
        }
        catch (Throwable throwable2) {
            responseObserver.onError(ServerCalls.prepareError(throwable2));
        }
        return streamObserverPublisher;
    }

    public static <TRequest, TResponse> StreamObserver<TRequest> manyToMany(StreamObserver<TResponse> responseObserver, Function<Flux<TRequest>, Flux<TResponse>> delegate) {
        ReactorServerStreamObserverAndPublisher streamObserverPublisher = new ReactorServerStreamObserverAndPublisher((ServerCallStreamObserver)responseObserver, null);
        try {
            Flux rxResponse = (Flux)Preconditions.checkNotNull(delegate.apply(Flux.from(streamObserverPublisher)));
            ReactorSubscriberAndServerProducer subscriber = new ReactorSubscriberAndServerProducer();
            subscriber.subscribe((CallStreamObserver)((ServerCallStreamObserver)responseObserver));
            rxResponse.subscribe(subscriber);
        }
        catch (Throwable throwable) {
            responseObserver.onError(ServerCalls.prepareError(throwable));
        }
        return streamObserverPublisher;
    }

    private static Throwable prepareError(Throwable throwable) {
        if (throwable instanceof StatusException || throwable instanceof StatusRuntimeException) {
            return throwable;
        }
        return Status.fromThrowable((Throwable)throwable).asException();
    }
}

