/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.util;

import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class MacAddressUtil {
    public static String getMacAddress() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                byte[] mac;
                if (intf.isLoopback() || intf.isVirtual() || !intf.isUp() || (mac = intf.getHardwareAddress()) == null) continue;
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02X:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "00:00:00:00:00:00";
    }

    public static void main(String[] args) {
        System.out.println(MacAddressUtil.getMacAddress());
    }
}

