/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ge.GeGextempReDomain;
import cn.com.qj.bff.domain.rs.RsBrandRelationReDomain;
import cn.com.qj.bff.domain.rs.RsPntreeDomain;
import cn.com.qj.bff.domain.rs.RsPntreeReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSpecGroupReDomain;
import cn.com.qj.bff.service.ge.GeGextempService;
import cn.com.qj.bff.service.rs.RsBrandRelationService;
import cn.com.qj.bff.service.rs.RsPntreeService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSpecService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/pntree"}, name="\u5546\u54c1\u7c7b\u578b")
public class RsPntreeCon
extends SpringmvcController {
    private static String CODE = "rs.pntree.con";
    @Autowired
    private RsPntreeService rsPntreeService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private GeGextempService geGextempService;
    @Autowired
    private RsBrandRelationService rsBrandRelationService;
    @Autowired
    private RsSpecService rsSpecService;

    @Override
    protected String getContext() {
        return "pntree";
    }

    @RequestMapping(value={"savePntree.json"}, name="\u589e\u52a0\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean savePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".savePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<String> checklist = new ArrayList<String>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult<RsPntreeReDomain> result = this.rsPntreeService.queryPntreePage(param);
        List list = result.getList();
        for (RsPntreeReDomain rsPntreeReDomain : list) {
            checklist.add(rsPntreeReDomain.getPntreeName());
        }
        if (checklist.contains(rsPntreeDomain.getPntreeName())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u91cd\u590d");
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeService.savePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"getPntree.json"}, name="\u83b7\u53d6\u5546\u54c1\u7c7b\u578b\u4fe1\u606f")
    @ResponseBody
    public RsPntreeReDomain getPntree(String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".getPntree", (Object)"param is null");
            return null;
        }
        return this.rsPntreeService.getPntree(Integer.valueOf(pntreeId));
    }

    @RequestMapping(value={"updatePntree.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean updatePntree(HttpServletRequest request, RsPntreeDomain rsPntreeDomain) {
        if (null == rsPntreeDomain) {
            this.logger.error(CODE + ".updatePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isNotBlank((String)rsPntreeDomain.getSpecGroupCodeStr())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("specGroupCodeStr", rsPntreeDomain.getSpecGroupCodeStr());
            param.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<RsPntreeReDomain> supQueryResult = this.rsPntreeService.queryPntreePage(param);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f53\u524d\u89c4\u683c\u7ec4\u5df2\u5173\u8054");
            }
        }
        rsPntreeDomain.setTenantCode(this.getTenantCode(request));
        return this.rsPntreeService.updatePntree(rsPntreeDomain);
    }

    @RequestMapping(value={"deletePntree.json"}, name="\u5220\u9664\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean deletePntree(HttpServletRequest request, String pntreeId) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsPntreeReDomain pntreeReDomain = this.rsPntreeService.getPntree(Integer.valueOf(pntreeId));
        String pntreeCode = pntreeReDomain.getPntreeCode();
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".deletePntree", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pntreeCode", pntreeCode);
        param.put("tenantCode", tenantCode);
        param.put("validFlag", true);
        SupQueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainList = this.rsResourceGoodsService.queryResourceGoodsPage(param);
        if (null != rsResourceGoodsReDomainList.getList() && rsResourceGoodsReDomainList.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u7c7b\u578b\u4f7f\u7528\u4e2d");
        }
        HtmlJsonReBean htmlJsonReBean = this.rsPntreeService.deletePntree(Integer.valueOf(pntreeId));
        SupQueryResult<RsBrandRelationReDomain> supQueryResult = this.rsBrandRelationService.queryBrandRelationPage(param);
        this.rsBrandRelationService.deleteBrandRelationByPntree(pntreeCode);
        SupQueryResult<RsSpecGroupReDomain> supQueryResult1 = this.rsSpecService.querySpecGroupPage(param);
        if (null != supQueryResult1 && ListUtil.isNotEmpty((Collection)supQueryResult1.getList())) {
            RsSpecGroupReDomain rsSpecGroupReDomain = (RsSpecGroupReDomain)supQueryResult1.getList().get(0);
            rsSpecGroupReDomain.setPntreeCode("");
            this.rsSpecService.updateSpecGroup(rsSpecGroupReDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryPntreeTree.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTree(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeService.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreeTreeFromMsc.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTreeFromMsc(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsPntreeService.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreeTreeFromGift.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868-\u793c\u5305\u5206\u7c7b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreeTreeFromGift(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", this.getTenantCode(request));
        return this.rsPntreeService.queryPntreeTree(param);
    }

    @RequestMapping(value={"queryPntreePageCard.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868(\u5206\u9875)-\u5361\u5238")
    @ResponseBody
    public SupQueryResult<RsPntreeReDomain> queryPntreePageCard(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryPntreeByParam(param, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryPntreePage.json"}, name="\u5546\u54c1\u7c7b\u578b\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsPntreeReDomain> queryPntreePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryPntreeByParam(param, this.getTenantCode(request));
    }

    public SupQueryResult<RsPntreeReDomain> queryPntreeByParam(Map<String, Object> param, String tenantCode) {
        SupQueryResult<RsPntreeReDomain> supQueryResult = this.rsPntreeService.queryPntreePage(param);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        ArrayList<RsPntreeReDomain> reList = new ArrayList<RsPntreeReDomain>();
        Map<String, String> brandCodeMap = this.getRelBrandCode(map);
        if (null == brandCodeMap) {
            return null;
        }
        Map<String, String> specGroupMap = this.getSpecGroupCode(map);
        if (null == specGroupMap) {
            return null;
        }
        for (RsPntreeReDomain rsPntreeReDomain : supQueryResult.getList()) {
            if (brandCodeMap.containsKey(rsPntreeReDomain.getPntreeCode())) {
                rsPntreeReDomain.setBrandCodeStr(brandCodeMap.get(rsPntreeReDomain.getPntreeCode()));
            }
            if (specGroupMap.containsKey(rsPntreeReDomain.getPntreeCode())) {
                rsPntreeReDomain.setSpecGroupCodeStr(specGroupMap.get(rsPntreeReDomain.getPntreeCode()));
            }
            reList.add(rsPntreeReDomain);
        }
        supQueryResult.setList(reList);
        supQueryResult.setRows(reList);
        return supQueryResult;
    }

    private Map<String, String> getRelBrandCode(Map<String, Object> map) {
        map.put("fuzzy", true);
        HashMap<String, String> reMap = new HashMap<String, String>();
        SupQueryResult<RsBrandRelationReDomain> supQueryResult1 = this.rsBrandRelationService.queryBrandRelationPage(map);
        if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) {
            return null;
        }
        for (RsBrandRelationReDomain rsBrandRelationReDomain : supQueryResult1.getList()) {
            StringBuilder brandCode = new StringBuilder(rsBrandRelationReDomain.getBrandCode());
            if (reMap.containsKey(rsBrandRelationReDomain.getPntreeCode())) {
                brandCode.append(",");
                brandCode.append((String)reMap.get(rsBrandRelationReDomain.getPntreeCode()));
            }
            reMap.put(rsBrandRelationReDomain.getPntreeCode(), brandCode.toString());
        }
        return reMap;
    }

    private Map<String, String> getSpecGroupCode(Map<String, Object> map) {
        HashMap<String, String> reMap = new HashMap<String, String>();
        SupQueryResult<RsSpecGroupReDomain> supQueryResult1 = this.rsSpecService.querySpecGroupPage(map);
        if (null == supQueryResult1 || null == supQueryResult1.getList() || supQueryResult1.getList().size() <= 0) {
            return null;
        }
        for (RsSpecGroupReDomain rsSpecGroupReDomain : supQueryResult1.getList()) {
            reMap.put(rsSpecGroupReDomain.getPntreeCode(), rsSpecGroupReDomain.getSpecGroupCode());
        }
        return reMap;
    }

    @RequestMapping(value={"getChildByPntree.json"}, name="\u83b7\u53d6\u7c7b\u578b\u5b50\u7c7b\u5217\u8868")
    @ResponseBody
    public List<RsPntreeReDomain> getChildByPntree(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsPntreeService.getChildByPntree(param);
    }

    @RequestMapping(value={"updatePntreeState.json"}, name="\u7f16\u8f91\u5546\u54c1\u7c7b\u578b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePntreeState(String pntreeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pntreeId)) {
            this.logger.error(CODE + ".updatePntreeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsPntreeService.updatePntreeState(Integer.valueOf(pntreeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryPntreePageByTenantCode.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTenantCode(String tenantCode) {
        return this.fetchPntreePageByParam(tenantCode, "");
    }

    @RequestMapping(value={"queryPntreePageByTCodeAndPCode.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b-\u8fc7\u6ee4\u5df2\u7ecf\u5173\u8054\u7684\u7c7b\u578b")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTCodeAndPCode(String tenantCode, String pntreeCode) {
        return this.fetchPntreePageByParam(tenantCode, pntreeCode);
    }

    public List<RsPntreeReDomain> fetchPntreePageByParam(String tenantCode, String pntreeCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".fetchPntreePageByParam", (Object)"param is null");
            return null;
        }
        ArrayList<RsPntreeReDomain> resultList = new ArrayList<RsPntreeReDomain>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        List<RsPntreeReDomain> pntreeReDomains = this.rsPntreeService.queryPntreeTree(param);
        SupQueryResult<GeGextempReDomain> geGextempReDomainSupQueryResult = this.geGextempService.queryGextempPage(param);
        if (null == geGextempReDomainSupQueryResult || null == geGextempReDomainSupQueryResult.getList() || geGextempReDomainSupQueryResult.getList().size() <= 0) {
            return pntreeReDomains;
        }
        Map<String, Object> beanMap = this.transformation(geGextempReDomainSupQueryResult.getList());
        for (RsPntreeReDomain rsPntreeReDomain : pntreeReDomains) {
            if (rsPntreeReDomain.getPntreeCode().equals(beanMap.get(rsPntreeReDomain.getPntreeCode())) && !rsPntreeReDomain.getPntreeCode().equals(pntreeCode)) continue;
            resultList.add(rsPntreeReDomain);
        }
        return resultList;
    }

    @RequestMapping(value={"queryPntreePageByTenantCodePicType.json"}, name="\u6839\u636e\u79df\u6237CODE\u67e5\u8be2\u5546\u54c1\u7c7b\u578b-\u5546\u54c1\u56fe\u7247\u5206\u7c7b\u9875")
    @ResponseBody
    public List<RsPntreeReDomain> queryPntreePageByTenantCodePicType(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryPntreePageByTenantCodePicType", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        return this.rsPntreeService.queryPntreeTree(param);
    }

    @RequestMapping(value={"checkPntreeName.json"}, name="\u68c0\u67e5\u7c7b\u578b\u540d\u79f0")
    @ResponseBody
    public RsPntreeReDomain checkPntreeName(HttpServletRequest request, String pntreeCode) {
        if (StringUtils.isBlank((String)pntreeCode)) {
            this.logger.error(CODE + ".checkPntreeName", (Object)"param is null");
            return null;
        }
        return this.rsPntreeService.getPntreeByCode(this.getQueryMapParam("tenantCode,pntreeCode", this.getTenantCode(request), pntreeCode));
    }

    public Map<String, Object> transformation(List<GeGextempReDomain> geGextempReDomains) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GeGextempReDomain geGextempReDomain : geGextempReDomains) {
            map.put(geGextempReDomain.getPntreeCode(), geGextempReDomain.getPntreeCode());
        }
        return map;
    }
}

