/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.gt;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.bs.BsAreaReDomain;
import cn.com.qj.bff.domain.gt.GtGiftRelDomain;
import cn.com.qj.bff.domain.gt.GtGiftRelReDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.wl.WlFreightExpReDomain;
import cn.com.qj.bff.domain.wl.WlFreightExpallDomain;
import cn.com.qj.bff.service.gt.GtGiftRelService;
import cn.com.qj.bff.service.rs.RsGoodsOtherService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.wl.WlFreightTemService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.com.qj.bff.util.FirstLetterUtils;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/giftRel"}, name="\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f")
public class GiftRelCon
extends SpringmvcController {
    private static String CODE = "gt.giftRel.con";
    @Autowired
    private GtGiftRelService gtGiftRelService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private WlFreightTemService wlFreightTemService;
    @Autowired
    private RsGoodsOtherService rsGoodsOtherService;
    final String provinceAndAreaCache_key = "provinceAndAreaCache_key";
    final String cityCache_key = "cityCache_key";

    @Override
    protected String getContext() {
        return "giftRel";
    }

    @RequestMapping(value={"saveGiftRel.json"}, name="\u589e\u52a0\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveGiftRel(HttpServletRequest request, GtGiftRelDomain gtGiftRelDomain) {
        if (null == gtGiftRelDomain) {
            this.logger.error(CODE + ".saveGiftRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        gtGiftRelDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftRelService.saveGiftRel(gtGiftRelDomain);
    }

    @RequestMapping(value={"getGiftRel.json"}, name="\u83b7\u53d6\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public GtGiftRelReDomain getGiftRel(Integer giftRelId) {
        if (StringUtils.isBlank((Integer)giftRelId)) {
            this.logger.error(CODE + ".getGiftRel", (Object)"param is null");
            return null;
        }
        return this.gtGiftRelService.getGiftRel(giftRelId);
    }

    @RequestMapping(value={"updateGiftRel.json"}, name="\u66f4\u65b0\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateGiftRel(HttpServletRequest request, GtGiftRelDomain gtGiftRelDomain) {
        if (null == gtGiftRelDomain) {
            this.logger.error(CODE + ".updateGiftRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        gtGiftRelDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftRelService.updateGiftRel(gtGiftRelDomain);
    }

    @RequestMapping(value={"deleteGiftRel.json"}, name="\u5220\u9664\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteGiftRel(Integer giftRelId) {
        if (StringUtils.isBlank((Integer)giftRelId)) {
            this.logger.error(CODE + ".deleteGiftRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftRelService.deleteGiftRel(giftRelId);
    }

    @RequestMapping(value={"queryGiftRelPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftRelReDomain> queryGiftRelPage(HttpServletRequest request) throws Exception {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<GtGiftRelReDomain> giftRelPage = this.gtGiftRelService.queryGiftRelPage(param);
        HashMap<String, Object> skuParam = new HashMap<String, Object>();
        skuParam.put("tenantCode", this.getTenantCode(request));
        for (GtGiftRelReDomain giftRelReDomain : giftRelPage.getList()) {
            skuParam.put("skuCode", giftRelReDomain.getSkuCode());
            RsSkuReDomain skuByCode = this.rsSkuService.getSkuByCode(skuParam);
            if (null != skuByCode) {
                giftRelReDomain.setGoodsDataState(skuByCode.getDataOpbillstate());
                giftRelReDomain.setSkuName(skuByCode.getSkuName());
                giftRelReDomain.setGoodsName(skuByCode.getGoodsName());
                giftRelReDomain.setPricesetBaseprice(skuByCode.getPricesetNprice());
                giftRelReDomain.setDataPic(skuByCode.getDataPic());
                if (StringUtils.isNotBlank((String)skuByCode.getGoodsPro()) && skuByCode.getGoodsPro().equals("5")) {
                    BigDecimal bigDecimal = this.makersSkuReDomain(skuByCode);
                    giftRelReDomain.setGoodsSupplynum(bigDecimal);
                    continue;
                }
                giftRelReDomain.setGoodsSupplynum(skuByCode.getGoodsSupplynum());
                continue;
            }
            giftRelReDomain.setGoodsSupplynum(BigDecimal.ZERO);
        }
        this.logger.error(CODE + ".queryGiftRelPage.giftRelPage222222", (Object)JsonUtil.buildNormalBinder().toJson(giftRelPage));
        return giftRelPage;
    }

    public BigDecimal makersSkuReDomain(RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".makersSkuReDomain", (Object)"is null");
            return BigDecimal.ZERO;
        }
        LinkedList<BigDecimal> list = new LinkedList<BigDecimal>();
        list.add(rsSkuReDomain.getGoodsSupplynum());
        HashMap<String, Object> rsGoodsRelMap = new HashMap<String, Object>();
        HashMap<String, Object> skuParam = new HashMap<String, Object>();
        skuParam.put("tenantCode", rsSkuReDomain.getTenantCode());
        if (StringUtils.isNotBlank((String)rsSkuReDomain.getGoodsPro()) && rsSkuReDomain.getGoodsPro().equals("5")) {
            rsGoodsRelMap.put("tenantCode", rsSkuReDomain.getTenantCode());
            rsGoodsRelMap.put("goodsCode", rsSkuReDomain.getGoodsCode());
            rsGoodsRelMap.put("goodsRelType", "3");
            SupQueryResult<RsGoodsRelReDomain> queryResutl = this.rsGoodsOtherService.queryGoodsRelPage(rsGoodsRelMap);
            if (ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
                for (RsGoodsRelReDomain rsGoodsRel : queryResutl.getList()) {
                    skuParam.put("skuCode", rsGoodsRel.getSkuCode());
                    RsSkuReDomain skuByCode = this.rsSkuService.getSkuByCode(skuParam);
                    if (null == skuByCode) continue;
                    list.add(skuByCode.getGoodsSupplynum());
                }
            }
        }
        return (BigDecimal)Collections.min(list);
    }

    private String filterGoodsParam(Map<String, Object> param) throws Exception {
        StringBuffer ginfoCodeBuffer = new StringBuffer();
        String cityCode = (String)param.get("cityCode");
        String addressName = (String)param.get("addressName");
        if (StringUtils.isNotBlank((String)addressName)) {
            this.logger.error(CODE + ".filterGoodsParam.addressName", (Object)addressName);
            Map all = DisUtil.getMapAll((String)"cityCache_key");
            if (MapUtil.isNotEmpty((Map)all)) {
                FirstLetterUtils firstLetterUtils = new FirstLetterUtils();
                String firstLetter = firstLetterUtils.getFirstLetter(addressName.substring(0, 1));
                if (StringUtils.isBlank((String)firstLetter)) {
                    this.logger.error(CODE + ".firstLetter.addressName", (Object)addressName);
                    return null;
                }
                for (String key : all.keySet()) {
                    if (!key.equals(firstLetter.toUpperCase())) continue;
                    String value = (String)all.get(key);
                    List bsAreaReDomainList = JsonUtil.buildNormalBinder().getJsonToList(value, BsAreaReDomain.class);
                    for (BsAreaReDomain bsArea : bsAreaReDomainList) {
                        if (!addressName.contains(bsArea.getAreaName())) continue;
                        this.logger.error(CODE + ".filterGoods.areaNme = ", (Object)bsArea.getAreaName());
                        cityCode = bsArea.getAreaCode();
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((String)cityCode)) {
            String substring;
            this.logger.error(CODE + ".queryGiftRelPage.filterGoods", (Object)cityCode);
            HashMap<String, Object> paramWl = new HashMap<String, Object>();
            paramWl.put("freightTemType", "3");
            paramWl.put("dataState", "0");
            paramWl.put("freightExpPayer", "NotSale");
            SupQueryResult<WlFreightExpReDomain> freightExpSup = this.wlFreightTemService.queryFreightExpPage(paramWl);
            if (ListUtil.isNotEmpty((Collection)freightExpSup.getList())) {
                block2: for (WlFreightExpReDomain freightExp : freightExpSup.getList()) {
                    WlFreightExpallDomain freightExpallDomain = freightExp.getFreightExpallList().get(0);
                    if (freightExpallDomain.getFreightExpallArea().contains(",")) {
                        String[] split;
                        for (String str : split = freightExpallDomain.getFreightExpallArea().split(",")) {
                            if (!str.equals(cityCode)) continue;
                            ginfoCodeBuffer.append(freightExpallDomain.getFreightExpCode() + ",");
                            continue block2;
                        }
                        continue;
                    }
                    if (!freightExpallDomain.getFreightExpallArea().equals(cityCode)) continue;
                    ginfoCodeBuffer.append(freightExpallDomain.getFreightExpCode() + ",");
                    break;
                }
            }
            if (StringUtils.isNotBlank((String)ginfoCodeBuffer.toString()) && StringUtils.isNotBlank((String)(substring = ginfoCodeBuffer.substring(0, ginfoCodeBuffer.length() - 1)))) {
                return substring;
            }
        }
        return null;
    }

    @RequestMapping(value={"queryGiftRelToC.json"}, name="wap\u7aef \u5458\u5de5\u67e5\u770b\u793c\u5305\u91cc\u7684\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<GtGiftRelReDomain> queryGiftRelToC(String giftCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null == giftCode) {
            this.logger.error(CODE + ".queryGiftRelToC", (Object)"giftCode is null");
            return null;
        }
        param.put("order", true);
        param.put("fuzzy", false);
        param.put("giftCode", giftCode);
        return this.gtGiftRelService.queryGiftRelPage(param);
    }

    @RequestMapping(value={"updateGiftRelState.json"}, name="\u66f4\u65b0\u793c\u54c1\u5173\u8054\u5546\u54c1\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftRelState(String giftRelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)giftRelId)) {
            this.logger.error(CODE + ".updateGiftRelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftRelService.updateGiftRelState(Integer.valueOf(giftRelId), dataState, oldDataState);
    }
}

