/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractSubDomain;
import cn.com.qj.bff.domain.oc.OcContractSubReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionReDomain;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcContractSubService;
import cn.com.qj.bff.service.pm.PmPromotionService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractSub"}, name="\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
public class ContractSubCon
extends SpringmvcController {
    private static String CODE = "oc.contractSub.con";
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private OcContractSubService ocContractSubService;
    @Autowired
    private PmPromotionService pmPromotionService;

    @Override
    protected String getContext() {
        return "contractSub";
    }

    @RequestMapping(value={"addContractSub.json"}, name="\u65b0\u589e\u4ed8\u6b3e\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean addContractSub(HttpServletRequest request, String contractBillcode, BigDecimal contractSubGmoney) {
        OcContractSubDomain ocContractSubDomain;
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSubGmoney) {
            this.logger.error(CODE + ".addContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("ocContractReDomain is null : " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userSession: " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u9646");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userPcode: " + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        if (null != ocContractReDomain.getContractType() && "80".equals(ocContractReDomain.getContractType()) && null != ocContractReDomain.getGoodsSupplierCode()) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("goodsSupplierCode: " + ocContractReDomain.getGoodsSupplierCode()));
            PmPromotionReDomain promotionByCode = this.pmPromotionService.getPromotionByCode(this.getTenantCode(request), ocContractReDomain.getGoodsSupplierCode());
            this.logger.error(CODE + ".addContractSub.pmPromotionService", (Object)("promotionByCode: " + JsonUtil.buildNonDefaultBinder().toJson((Object)promotionByCode)));
            Integer moling = promotionByCode.getPromotionMoling();
            if (moling == 0) {
                ocContractReDomain.setDeposit(false);
            } else {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("contractBillcode", contractBillcode);
                paramMap.put("tenantCode", this.getTenantCode(request));
                SupQueryResult<OcContractSubReDomain> supQueryResult = this.ocContractSubService.queryContractSubPage(paramMap);
                if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0) {
                    ocContractReDomain.setDeposit(false);
                } else {
                    ocContractReDomain.setDeposit(true);
                }
            }
        }
        if (null == (ocContractSubDomain = this.make(request, contractSubGmoney, ocContractReDomain))) {
            this.logger.error(CODE + ".addContractSub.ocContractSubDomain", (Object)"ocContractSubDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubService.saveContractSub(ocContractSubDomain);
    }

    private OcContractSubDomain make(HttpServletRequest request, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain || null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        OcContractSubDomain ocContractSubDomain = new OcContractSubDomain();
        ocContractSubDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSubDomain.setContractSubGmoney(contractSubGmoney);
        ocContractSubDomain.setContractSubPmode("0");
        ocContractSubDomain.setContractSubPmoney(contractSubGmoney);
        ocContractSubDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSubDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSubDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSubDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSubDomain.setMemberBcode(userSession.getUserPcode());
        ocContractSubDomain.setMemberBname(userSession.getMerberCompname());
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        if (null != ocContractReDomain.getContractType() && "80".equals(ocContractReDomain.getContractType()) && null != ocContractReDomain.getDeposit()) {
            if (ocContractReDomain.getDeposit().booleanValue()) {
                ocContractSubDomain.setMemo("deposit");
            } else {
                ocContractSubDomain.setMemo("balance");
            }
        }
        return ocContractSubDomain;
    }

    @RequestMapping(value={"saveContractSub.json"}, name="\u589e\u52a0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractSub(HttpServletRequest request, OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".saveContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractSubService.saveContractSub(ocContractSubDomain);
    }

    @RequestMapping(value={"getContractSub.json"}, name="\u83b7\u53d6\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractSubReDomain getContractSub(Integer contractSubId) {
        if (StringUtils.isBlank((Integer)contractSubId)) {
            this.logger.error(CODE + ".getContractSub", (Object)"param is null");
            return null;
        }
        return this.ocContractSubService.getContractSub(contractSubId);
    }

    @RequestMapping(value={"updateContractSub.json"}, name="\u66f4\u65b0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContractSub(HttpServletRequest request, OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".updateContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractSubService.updateContractSub(ocContractSubDomain);
    }

    @RequestMapping(value={"deleteContractSub.json"}, name="\u5220\u9664\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContractSub(Integer contractSubId) {
        if (StringUtils.isBlank((Integer)contractSubId)) {
            this.logger.error(CODE + ".deleteContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubService.deleteContractSub(contractSubId);
    }

    @RequestMapping(value={"queryContractSubPage.json"}, name="\u67e5\u8be2\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractSubReDomain> queryContractSubPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractSubService.queryContractSubPage(param);
    }

    @RequestMapping(value={"updateContractSubState.json"}, name="\u66f4\u65b0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractSubState(String contractSubId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractSubId)) {
            this.logger.error(CODE + ".updateContractSubState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubService.updateContractSubState(Integer.valueOf(contractSubId), dataState, oldDataState, null);
    }
}

