/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.oc;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcRefundDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/ocrefund"}, name="\u9000\u6b3e")
public class OcRefundCon
extends SpringmvcController {
    private static String CODE = "oc.ocrefund.con";
    @Autowired
    private OcRefundService ocRefundService;

    @Override
    protected String getContext() {
        return "ocrefund";
    }

    @RequestMapping(value={"saveOcRefund.json"}, name="\u589e\u52a0\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean saveOcrefund(HttpServletRequest request, OcRefundDomain ocrefundDomain) {
        if (null == ocrefundDomain) {
            this.logger.error(CODE + ".saveOcRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocrefundDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundService.saveRefund(ocrefundDomain);
    }

    @RequestMapping(value={"getOcRefund.json"}, name="\u83b7\u53d6\u9000\u6b3e\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getOcRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getOcRefund", (Object)"param is null");
            return null;
        }
        return this.ocRefundService.getRefund(refundId);
    }

    @RequestMapping(value={"updateOcRefund.json"}, name="\u66f4\u65b0\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean updateOcRefund(HttpServletRequest request, OcRefundDomain ocrefundDomain) {
        if (null == ocrefundDomain) {
            this.logger.error(CODE + ".updateOcRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocrefundDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundService.updateRefund(ocrefundDomain);
    }

    @RequestMapping(value={"deleteOcRefund.json"}, name="\u5220\u9664\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean deleteOcRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".deleteOcRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundService.deleteRefund(refundId);
    }

    @RequestMapping(value={"queryOcRefundPage.json"}, name="\u67e5\u8be2\u9000\u6b3e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryOcRefundPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundService.queryRefundPage(param);
    }

    @RequestMapping(value={"updateOcRefundState.json"}, name="\u66f4\u65b0\u9000\u6b3e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcRefundState(String refundId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refundId)) {
            this.logger.error(CODE + ".updateOcRefundState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundService.updateRefundState(Integer.valueOf(refundId), dataState, oldDataState);
    }
}

