/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.um;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.pm.PmCheckBean;
import cn.com.qj.bff.domain.pm.PmPtaskexBean;
import cn.com.qj.bff.domain.pm.UserBean;
import cn.com.qj.bff.domain.um.UmSignDomain;
import cn.com.qj.bff.domain.um.UmSignReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoDomainBean;
import cn.com.qj.bff.service.pm.PmPtasklistService;
import cn.com.qj.bff.service.um.UmSignService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/sign"}, name="\u7528\u6237\u7b7e\u5230\u4fe1\u606f")
public class SignCon
extends SpringmvcController {
    private static String CODE = "um.sign.con";
    @Autowired
    private UmSignService umSignService;
    @Autowired
    private UserService userService;
    @Autowired
    private PmPtasklistService pmPtasklistService;

    @Override
    protected String getContext() {
        return "sign";
    }

    @RequestMapping(value={"saveSign.json"}, name="\u589e\u52a0\u7528\u6237\u7b7e\u5230\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveSign(HttpServletRequest request, UmSignDomain umSignDomain) {
        if (null == umSignDomain) {
            this.logger.error(CODE + ".saveSign", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveSign", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umSignDomain.setUserCode(userSession.getUserPcode());
        umSignDomain.setUserName(userSession.getMerberCompname());
        umSignDomain.setTenantCode(this.getTenantCode(request));
        userSession.setChannelCode(this.getNowChannel(request));
        HtmlJsonReBean htmlJsonReBean = this.umSignService.saveSign(umSignDomain);
        if (htmlJsonReBean == null || !"success".equals(htmlJsonReBean.getSysRecode())) {
            return htmlJsonReBean;
        }
        PmPtaskexBean pmPtaskexBean = new PmPtaskexBean();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskexBean, (Object)umSignDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        pmPtaskexBean.setChannelCode(userSession.getChannelCode());
        pmPtaskexBean.setMemberBname(userName);
        pmPtaskexBean.setUserCode(userCode);
        pmPtaskexBean.setPbCode("0034");
        pmPtaskexBean.setTenantCode(umSignDomain.getTenantCode());
        UserBean userBean = new UserBean();
        userBean.setMemberCode(umSignDomain.getUserCode());
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setUserBean(userBean);
        pmPtaskexBean.setPmCheckBean(pmCheckBean);
        return this.pmPtasklistService.sendSavePtasklistEx(pmPtaskexBean);
    }

    @RequestMapping(value={"getSign.json"}, name="\u83b7\u53d6\u7528\u6237\u7b7e\u5230\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmSignReDomain getSign(HttpServletRequest request, Integer signId) {
        if (StringUtils.isBlank((Integer)signId)) {
            this.logger.error(CODE + ".getSign", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getSign", (Object)"UserSession is null");
            return null;
        }
        UmSignReDomain umSignReDomain = this.umSignService.getSign(signId);
        if (null == umSignReDomain) {
            return null;
        }
        if (!umSignReDomain.getUserCode().equals(userSession.getUserPcode())) {
            return null;
        }
        return umSignReDomain;
    }

    @RequestMapping(value={"updateSign.json"}, name="\u66f4\u65b0\u7528\u6237\u7b7e\u5230\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateSign(HttpServletRequest request, UmSignDomain umSignDomain) {
        if (null == umSignDomain) {
            this.logger.error(CODE + ".updateSign", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateSign", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmSignReDomain sign = this.umSignService.getSign(umSignDomain.getSignId());
        if (null == sign || !sign.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateSign", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umSignDomain.setUserCode(userSession.getUserPcode());
        umSignDomain.setUserName(userSession.getMerberCompname());
        umSignDomain.setTenantCode(this.getTenantCode(request));
        return this.umSignService.updateSign(umSignDomain);
    }

    @RequestMapping(value={"deleteSign.json"}, name="\u5220\u9664\u7528\u6237\u7b7e\u5230\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteSign(HttpServletRequest request, Integer signId) {
        if (StringUtils.isBlank((Integer)signId)) {
            this.logger.error(CODE + ".deleteSign", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".deleteSign", (Object)"UserSession is null");
            return null;
        }
        UmSignReDomain umSignReDomain = this.umSignService.getSign(signId);
        if (null == umSignReDomain) {
            return null;
        }
        if (!umSignReDomain.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteSign", (Object)"getUserCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f02\u5e38\u64cd\u4f5c");
        }
        return this.umSignService.deleteSign(signId);
    }

    @RequestMapping(value={"querySignPage.json"}, name="\u67e5\u8be2\u7528\u6237\u7b7e\u5230\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmSignReDomain> querySignPage(HttpServletRequest request, Integer year, Integer month) {
        if (month != null && (month < 1 || month > 12)) {
            throw new IllegalArgumentException("month is invalid");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String userPcode = this.getUserSession(request).getUserPcode();
        if (StringUtils.isBlank((String)userPcode)) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"userCode is null");
            throw new IllegalArgumentException("userCode is null");
        }
        params.put("userCode", userPcode);
        LocalDate now = LocalDate.now();
        int queryYear = year != null ? year.intValue() : now.getYear();
        int queryMonth = month != null ? month.intValue() : now.getMonthValue();
        YearMonth yearMonth = YearMonth.of(queryYear, queryMonth);
        LocalDate firstDay = yearMonth.atDay(1);
        LocalDate lastDay = yearMonth.atEndOfMonth();
        params.put("startDate", firstDay.atStartOfDay().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        params.put("endDate", lastDay.atTime(23, 59, 59).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        if (null != params) {
            params.put("order", true);
            params.put("orderStr", "GMT_CREATE");
        }
        return this.umSignService.querySignPage(params);
    }

    @RequestMapping(value={"updateSignState.json"}, name="\u66f4\u65b0\u7528\u6237\u7b7e\u5230\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSignState(String signId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)signId)) {
            this.logger.error(CODE + ".updateSignState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umSignService.updateSignState(Integer.valueOf(signId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveSignForUser.json"}, name="\u589e\u52a0\u7528\u6237\u7b7e\u5230\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveSignForUser(HttpServletRequest request, UmSignDomain umSignDomain) {
        if (null == umSignDomain) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        if (StringUtils.isBlank((String)umSignDomain.getSignAddr())) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"signAddr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "signAddr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u767b\u5f55\u8fc7\u671f");
        }
        if (StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"userPcode is null");
            throw new IllegalArgumentException("userPcode is null");
        }
        LocalDate now = LocalDate.now();
        LocalDateTime startDate = now.atStartOfDay();
        LocalDateTime endDate = now.atTime(23, 59, 59);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userCode", userSession.getUserPcode());
        params.put("startDate", startDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        params.put("endDate", endDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        SupQueryResult<UmSignReDomain> umSignReDomainSupQueryResult = this.umSignService.querySignPage(params);
        if (umSignReDomainSupQueryResult != null && umSignReDomainSupQueryResult.getList() != null && umSignReDomainSupQueryResult.getList().size() != 0 && ((UmSignReDomain)umSignReDomainSupQueryResult.getList().get(0)).getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"already signed");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u60a8\u5df2\u7b7e\u5230\u6210\u529f");
        }
        umSignDomain.setUserCode(userSession.getUserPcode());
        if (StringUtils.isBlank((String)userSession.getUserName())) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"userName is null");
            throw new IllegalArgumentException("userName is null");
        }
        umSignDomain.setUserName(userSession.getUserName());
        if (StringUtils.isBlank((String)this.getTenantCode(request))) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"tenantCode is null");
            throw new IllegalArgumentException("tenantCode is null");
        }
        umSignDomain.setTenantCode(this.getTenantCode(request));
        if (StringUtils.isBlank((String)userSession.getUserPhone())) {
            this.logger.error(CODE + ".saveSignForUser", (Object)"userPhone is null");
            throw new IllegalArgumentException("userPhone is null");
        }
        umSignDomain.setUserPhone(userSession.getUserPhone());
        userSession.setChannelCode(this.getNowChannel(request));
        HtmlJsonReBean htmlJsonReBean = this.umSignService.saveSign(umSignDomain);
        if (htmlJsonReBean == null || !"success".equals(htmlJsonReBean.getSysRecode())) {
            return htmlJsonReBean;
        }
        PmPtaskexBean pmPtaskexBean = new PmPtaskexBean();
        try {
            BeanUtils.copyAllPropertys((Object)pmPtaskexBean, (Object)umSignDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String userCode = userSession.getUserCode();
        String userName = userSession.getUserName();
        pmPtaskexBean.setChannelCode(userSession.getChannelCode());
        pmPtaskexBean.setMemberBname(userName);
        pmPtaskexBean.setUserCode(userCode);
        pmPtaskexBean.setPbCode("0034");
        pmPtaskexBean.setTenantCode(umSignDomain.getTenantCode());
        UserBean userBean = new UserBean();
        userBean.setMemberCode(umSignDomain.getUserCode());
        PmCheckBean pmCheckBean = new PmCheckBean();
        pmCheckBean.setUserBean(userBean);
        pmPtaskexBean.setPmCheckBean(pmCheckBean);
        return this.pmPtasklistService.sendSavePtasklistEx(pmPtaskexBean);
    }

    @RequestMapping(value={"updateSignNotice.json"}, name="\u7b7e\u5230\u63d0\u9192\u529f\u80fd\u5f00\u5173(0,1)")
    @ResponseBody
    public HtmlJsonReBean updateSignNotice(HttpServletRequest request, String switchTag) {
        if (StringUtils.isBlank((String)switchTag)) {
            this.logger.error(CODE + ".updateSignNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (!"0".equals(switchTag) && !"1".equals(switchTag)) {
            this.logger.error(CODE + ".updateSignNotice", (Object)("invalid switchTag value: " + switchTag));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u503c\u5fc5\u987b\u662f0\u62161");
        }
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".updateSignNotice", (Object)"tenantCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        if (StringUtils.isBlank((String)userPcode)) {
            this.logger.error(CODE + ".updateSignNotice", (Object)"userPcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        umUserinfoDomainBean.setTenantCode(tenantCode);
        umUserinfoDomainBean.setUserinfoCode(userPcode);
        umUserinfoDomainBean.setFax(switchTag);
        return this.userService.updateUserinfohlj(umUserinfoDomainBean);
    }
}

