/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.ext.bus.jushuitan.api.InventoryMessageService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.requestin.InventoryMessageRequestIn;
import com.yqbsoft.laser.service.ext.bus.jushuitan.requestin.InventoryMessageRequestInDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.returnout.OrderMessageReturn;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InventoryMessageServiceImpl
extends DateBaseService
implements InventoryMessageService {
    private static final String SYS_CODE = "jst.InventoryMessageServiceImpl";

    @Override
    public OrderMessageReturn inventoryUpload(Map<String, Object> resStream, String tenantCode) {
        this.logger.error("jst.InventoryMessageServiceImpl.inventoryUpload start==", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        OrderMessageReturn orderMessageReturn = new OrderMessageReturn();
        if (MapUtil.isEmpty(resStream)) {
            this.logger.error("jst.InventoryMessageServiceImpl.inventoryUpload param is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u53c2\u6570\u4e3a\u7a7a");
            return orderMessageReturn;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("jst.InventoryMessageServiceImpl.inventoryUpload tenantCode is null");
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u79df\u6237\u4e3a\u7a7a");
            return orderMessageReturn;
        }
        String json = JsonUtil.buildNormalBinder().toJson(resStream);
        this.logger.error("jst.InventoryMessageServiceImplinventoryUpload json", (Object)json);
        InventoryMessageRequestIn inventoryMessageRequestIn = (InventoryMessageRequestIn)JsonUtil.buildNormalBinder().getJsonToObject(json, InventoryMessageRequestIn.class);
        if (null == inventoryMessageRequestIn) {
            this.logger.error("jst.InventoryMessageServiceImpl.inventoryUpload inventoryMessageRequestIn is null");
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e381");
            return orderMessageReturn;
        }
        List<InventoryMessageRequestInDatas> datas = inventoryMessageRequestIn.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("jst.InventoryMessageServiceImpl.inventoryUpload datas is null", (Object)json);
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e382");
            return orderMessageReturn;
        }
        HashMap<String, Object> stockmap = new HashMap<String, Object>();
        for (InventoryMessageRequestInDatas data : datas) {
            String shop_sku_id = data.getShop_sku_id();
            Integer qty = data.getQty();
            if (StringUtils.isBlank((String)shop_sku_id)) {
                this.logger.error("jst.InventoryMessageServiceImpl.inventoryUpload datas is error", (Object)json);
                orderMessageReturn.setCode("-1");
                orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e383");
            }
            stockmap.put(data.getShop_sku_id(), data.getQty());
        }
        try {
            this.updateStockJst(stockmap, tenantCode);
            this.updateGiftRelStockBySkuCode(stockmap, tenantCode);
            this.sendOrdSkuByStock(stockmap, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("jst.InventoryMessageServiceImpl.updateStockJst datas is error", (Object)e.getMessage());
            orderMessageReturn.setMsg("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25");
            orderMessageReturn.setCode("-1");
            return orderMessageReturn;
        }
        orderMessageReturn.setMsg("\u6267\u884c\u6210\u529f");
        orderMessageReturn.setCode("0");
        return orderMessageReturn;
    }

    public void updateStockJst(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "rs.resourceGoods.updateStockJst";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    public void updateGiftRelStockBySkuCode(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "gt.gtgiftrel.updateGiftRelStockBySkuCode";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.inAsyncInvoke(apiCode, param);
    }

    public void sendOrdSkuByStock(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "rs.RsOrdsku.sendOrdSkuByStock";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.inAsyncInvoke(apiCode, param);
    }
}

