/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.CpRechargeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.CpRechargeReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.VdFaccountInfo;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusUserService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "busdata.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String url = umUserinfo.getWebSiteUrl();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.indexOf("http") != 0) {
                url = "http://" + url;
            }
            url = url + "/laserEr/http/post/{apiCode}/1.0/" + tenantCode + "/utf-8/shangshu";
            umUserinfo.setWebSiteUrl(url);
        }
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        umUserinfoRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        String t = this.getTenantCodeBuUrl(umUserinfoRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            umUserinfo.setTenantCode(t);
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
            if (StringUtils.isBlank((String)t)) {
                umUserinfoRequest.setTenantCode(umUserinfoRequest.getToTenantCode());
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String saveRechargeForm(String dataStr) throws ApiException {
        logger.error(this.SYS_CODE + ".saveRechargeForm.dataStr", (Object)dataStr);
        if (StringUtils.isEmpty((String)dataStr)) {
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "\u53c2\u6570\u4e3a\u7a7a");
        }
        CpRechargeReDomain cpRechargeReDomain = (CpRechargeReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(dataStr, CpRechargeReDomain.class);
        if (null == cpRechargeReDomain) {
            logger.error(this.SYS_CODE + ".saveRechargeForm", (Object)dataStr);
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)cpRechargeReDomain.getTenantCode())) {
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "tenantCode\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)cpRechargeReDomain.getUserinfoCode())) {
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "userinfoCode\u4e3a\u7a7a");
        }
        if (null == cpRechargeReDomain.getRechargeMoney()) {
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "rechargeMoney\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getUmUserinfoDomainBean(cpRechargeReDomain.getTenantCode(), cpRechargeReDomain.getUserinfoCode());
        if (null == umUserinfoDomainBean) {
            logger.error(this.SYS_CODE + ".saveRechargeForm", (Object)dataStr);
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String merchantCode = umUserinfoDomainBean.getUserinfoCode();
        String type = merchantCode.substring(0, 1);
        String fundType = "01";
        String faccountType = type + fundType;
        VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(merchantCode, faccountType, cpRechargeReDomain.getTenantCode());
        if (null == vdFaccountInfo) {
            logger.error(this.SYS_CODE + ".saveRechargeForm.1", (Object)("tenantCode" + cpRechargeReDomain.getTenantCode() + "merchantCode" + merchantCode + "faccountType" + faccountType));
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        HashMap<String, String> reMap = new HashMap<String, String>();
        try {
            CpRechargeDomain rechargeDomain = new CpRechargeDomain();
            rechargeDomain.setFundType(fundType);
            rechargeDomain.setUserinfoCode(umUserinfoDomainBean.getUserinfoCode());
            rechargeDomain.setFaccountId(vdFaccountInfo.getFaccountOuterNo());
            rechargeDomain.setUserbankNo(vdFaccountInfo.getFaccountOuterNo());
            rechargeDomain.setRechargeOpcode(cpRechargeReDomain.getRechargeOpcode());
            rechargeDomain.setRechargeRemark(cpRechargeReDomain.getRechargeRemark());
            rechargeDomain.setAppmanageIcode(cpRechargeReDomain.getAppmanageIcode());
            rechargeDomain.setFchannelCode("ctest");
            rechargeDomain.setTenantCode(cpRechargeReDomain.getTenantCode());
            rechargeDomain.setFchannelPmodeCode("web");
            if (StringUtils.isBlank((String)rechargeDomain.getRechargeType())) {
                rechargeDomain.setRechargeType("01");
            }
            rechargeDomain.setRechargeType(fundType);
            if (StringUtils.isBlank((String)rechargeDomain.getRechargeMode())) {
                rechargeDomain.setRechargeMode("1");
            }
            rechargeDomain.setRechargeMoney(cpRechargeReDomain.getRechargeMoney());
            reMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)rechargeDomain));
            String result = (String)this.getInternalRouter().inInvoke("cp.recharge.saveRechargeOneNew", reMap);
            logger.error(this.SYS_CODE + "saveRechargeForm", (Object)("\u8c03\u7528\u7ed3\u675f,\u7ed3\u679c\u4e3a:" + result + "reMap" + reMap));
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".saveRechargeForm.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".saveRechargeForm.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".saveRechargeForm.e1", e.getMessage());
        }
        return this.makeSuccessReturn(cpRechargeReDomain.getUserinfoCode());
    }

    private VdFaccountInfo getOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    public UmUserinfoDomainBean getUmUserinfoDomainBean(String tenantCode, String userinfoCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCompname", userinfoCode);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult quresult = this.getQueryResutl("um.user.queryUserinfoPage", invokeMap, UmUserinfoDomainBean.class);
        if (quresult == null || ListUtil.isEmpty((Collection)quresult.getList())) {
            logger.error(this.SYS_CODE + ".getUmUserinfoDomainBean", (Object)((Object)invokeMap).toString());
            return null;
        }
        return (UmUserinfoDomainBean)quresult.getList().get(0);
    }
}

