/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.alibaba.fastjson.JSON;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.UserSellerGetRequest;
import com.taobao.api.response.UserSellerGetResponse;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractEditDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.DataDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.OrderExpress;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.QueryResultDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RefundResult;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RefundResultDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsRelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoods;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhGoodsBean;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhFreightFeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhStockStateFeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhFreightFeeResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhStockStateResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusOrderService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.HttpClientUtil;
import com.yqbsoft.laser.service.ext.bus.data.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        this.makeOcContractReDomain(ocContractDomain);
        ocContractRequest.setOrgTenantCode(ocContractDomain.getTenantCode());
        String t = this.getTenantCodeBuUrl(ocContractRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            ocContractDomain.setTenantCode(t);
        }
        ocContractRequest.getSendMap().put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        logger.info(this.SYS_CODE + ".sendSaveExGoods.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String s = this.restTempfacade.internalInvoke("app.exOrder.sendSaveExOrder", paramMap);
        logger.info(this.SYS_CODE + ".sendSaveExGoods.res", (Object)s);
        return "success";
    }

    public static void mainccc(String[] args) {
    }

    @Override
    public String getFreight(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws com.yqbsoft.laser.service.esb.core.ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getFreight.param");
            return "error";
        }
        WhFreightFeeRequest whFreightFeeRequest = new WhFreightFeeRequest();
        whFreightFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        whFreightFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whFreightFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whFreightFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whFreightFeeRequest.getSendMap().put("areaStr", areaStr);
        whFreightFeeRequest.getSendMap().put("memberCode", memberCode);
        whFreightFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhFreightFeeResponse whFreightFeeResponse = this.restTempfacade.execute(whFreightFeeRequest);
        if (null == whFreightFeeResponse) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponse");
            return "error";
        }
        if (!whFreightFeeResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponsemsg", (Object)whFreightFeeResponse.getMsg());
            return whFreightFeeResponse.getMsg();
        }
        return whFreightFeeResponse.getFreightFee().toString();
    }

    @Override
    public List<WhGoodsBean> getNewStockById(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws com.yqbsoft.laser.service.esb.core.ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getNewStockById.param");
            return null;
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        whStockStateFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whStockStateFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whStockStateFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whStockStateFeeRequest.getSendMap().put("areaStr", areaStr);
        whStockStateFeeRequest.getSendMap().put("memberCode", memberCode);
        whStockStateFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhStockStateResponse whStockStateResponse = this.restTempfacade.execute(whStockStateFeeRequest);
        if (null == whStockStateResponse) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse");
            return null;
        }
        if (!whStockStateResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse", (Object)whStockStateResponse.getMsg());
            return null;
        }
        return whStockStateResponse.getWhGoodsBeanList();
    }

    private void makeOcContractReDomain(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return;
        }
        String memberCcode = ocContractDomain.getMemberCcode();
        if (StringUtils.isBlank((String)memberCcode)) {
            return;
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannelByMemberCcode(memberCcode, ocContractDomain.getTenantCode());
        if (null == disChannelReDomain) {
            return;
        }
        ocContractDomain.setChannelCode(disChannelReDomain.getChannelOcode());
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        Long startTime = System.currentTimeMillis();
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain", (Object)"isnull");
            return "error";
        }
        String url = "";
        url = this.getdd(ocRefundDomain.getTenantCode(), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.url", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(ocRefundDomain.getTenantCode(), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(ocRefundDomain.getTenantCode(), "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(ocRefundDomain.getTenantCode(), "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(ocRefundDomain.getTenantCode(), "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkRefundAdd");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "1722319224");
        String data = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        map.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocRefundDomain.getChannelCode())) {
            map.put("shop_code", NshopCode);
        }
        if ("B01".equals(ocRefundDomain.getRefundType())) {
            map.put("refund_type", "40");
        }
        if ("B02".equals(ocRefundDomain.getRefundType())) {
            map.put("refund_type", "20");
        }
        map.put("refund_id", ocRefundDomain.getRefundCode());
        map.put("tid", ocRefundDomain.getContractBbillcode());
        map.put("refund_fee", ocRefundDomain.getRefundMoney());
        map.put("refund_express_code", "");
        map.put("status", "1");
        map.put("c_status", "1");
        if (0 == ocRefundDomain.getDataState()) {
            map.put("c_status", "1");
        }
        if (3 == ocRefundDomain.getDataState()) {
            map.put("c_status", "2");
        }
        if (-1 == ocRefundDomain.getDataState()) {
            map.put("c_status", "4");
        }
        map.put("refund_express_no", "");
        map.put("warehouse_code", "");
        map.put("refund_mode", "");
        map.put("refundment_type", "");
        map.put("refund_reason", "");
        map.put("refund_remarks", ocRefundDomain.getContractRemark());
        map.put("refund_person_account", "");
        map.put("refund_person_name", "");
        map.put("refund_postage", "");
        map.put("install_price", "");
        map.put("delivery_price", "");
        map.put("demolition_price", "");
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsList) {
            HashMap<String, Object> hashmap = new HashMap<String, Object>();
            hashmap.put("sku", ocRefundGoodsDomain.getSkuNo());
            hashmap.put("num", ocRefundDomain.getGoodsNum());
            hashmap.put("refund_fee", ocRefundGoodsDomain.getContractGoodsMoney());
            hashmap.put("is_change", "");
            hashmap.put("is_gift", "0");
            if ("1".equals(ocRefundGoodsDomain.getContractGoodsGtype())) {
                hashmap.put("is_gift", "1");
            }
            list.add(hashmap);
        }
        map.put("detail", list);
        mapStr.put("refund", JsonUtil.buildNormalBinder().toJson(map));
        logger.error(this.SYS_CODE + ".sendSaveBusRefund.returnResultsMap.map" + JsonUtil.buildNormalBinder().toJson(map));
        try {
            data = HttpClientUtil.doGet(url, mapStr);
            System.out.println(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.error(this.SYS_CODE + ".sendSaveBusRefund.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    public OcContractReDomain getContractDomain(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.getContractByCode";
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String OcContractReDomainStr = this.internalInvoke(apiCode, param);
        if (StringUtils.isBlank((String)OcContractReDomainStr)) {
            return null;
        }
        return (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(OcContractReDomainStr, OcContractReDomain.class);
    }

    public static void mains(String[] args) {
        String tenantCode = "2023072819990101";
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=oms.OrderQueryInfoByTid";
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.OrderQueryInfoByTid");
        mapStr.put("app_key", "1722319224");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", "CS37");
        mapStr.put("tid", "876409685609480290");
        String data = HttpClientUtil.doGet(url, mapStr);
        QueryResultDomain queryResultDomain = (QueryResultDomain)JSON.parseObject((String)data, QueryResultDomain.class);
        List<DataDomain> data1 = queryResultDomain.getData();
        BusOrderServiceImpl busOrderService = new BusOrderServiceImpl();
        for (DataDomain dataDomain : data1) {
            if (!ListUtil.isNotEmpty(dataDomain.getOrder_express())) continue;
            String orderNo = dataDomain.getTid();
            OcContractReDomain contractDomain = busOrderService.getContractDomain(orderNo, tenantCode);
            for (OrderExpress orderExpress : dataDomain.getOrder_express()) {
                String string = busOrderService.saveSgSendGoods(busOrderService.makeSgSendGoodsDomain(orderExpress, tenantCode, contractDomain));
            }
        }
    }

    public static void mainffff(String[] args) {
        String tenantCode = "2023072819990101";
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=Platform.GoodsSearch";
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "Platform.GoodsSearch");
        mapStr.put("app_key", "1722319224");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("skus", "ET701AS4200B01");
        mapStr.put("owner_code", "HEGII");
        mapStr.put("shop_code", "CS01");
        String data = HttpClientUtil.doGet(url, mapStr);
        int item_id = data.indexOf("item_id");
        String substring = data.substring(item_id);
        String s = substring.toString();
        String[] split = s.split(",");
        System.out.println(split[0]);
        String s1 = split[0];
        String[] split1 = s1.split(":");
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    private String saveSgSendGoods(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".saveSgSendGoods", (Object)"isnull");
            return null;
        }
        String apiCode = "sg.sendgoodsEngine.sendsaveSgSendgoods";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    public static void main66666(String[] args) {
        String json = "{\"status\":1,\"data\":[{\"shop_id\":\"37\",\"order_no\":\"24090760000001\",\"warehouse_code\":\"HGH2004\",\"express_code\":\"OTHER\",\"express_no\":\"24090760000001\",\"goods_total\":\"5\",\"sku_total\":\"3\",\"order_status\":\"50\",\"no_stock_status\":\"10\",\"question_status\":\"0\",\"lock_status\":\"0\",\"refund_status\":\"0\",\"urgent_status\":\"0\",\"pre_sale_status\":\"0\",\"delivery_time\":\"2024-09-07 10:07:08\",\"write_back_time\":\"1970-01-01 00:00:00\",\"write_back_status\":\"0\",\"notice_time\":\"2024-09-07 10:05:30\",\"check_time\":\"2024-09-07 10:05:27\",\"cancel_time\":\"1970-01-01 00:00:00\",\"cancel_reason\":\"\",\"lock_user\":\"\",\"part_refund_status\":\"0\",\"owner_id\":\"1\",\"modified\":\"2024-09-07 10:09:41\",\"notice_send_date\":\"2024-09-12\",\"latest_delivery_time\":\"1970-01-01 00:00:00\",\"cancel_reason_name\":\"\",\"order_type\":\"0\",\"platform_code\":\"HT\",\"tid\":\"884739947250516053\",\"user_nick\":\"omsff\",\"consignee\":\"FF\",\"phone\":\"\",\"mobile\":\"13202930948\",\"email\":\"\",\"address\":\"\u5e7f\u4e1c-\u4f5b\u5c71\u5e02-\u7985\u57ce\u533a-\u667a\u6167\u65b0\u57ceT5\u680b1004A\u5ba4\",\"state\":\"\u4e2d\u56fd\",\"province\":\"\u5e7f\u4e1c\u7701\",\"city\":\"\u4f5b\u5c71\u5e02\",\"area\":\"\u7985\u57ce\u533a\",\"town\":\"\",\"state_code\":\"1\",\"province_code\":\"440000\",\"city_code\":\"440600\",\"area_code\":\"440604\",\"town_code\":\"\",\"zipcode\":\"\",\"remark\":\"\",\"seller_flag\":\"0\",\"is_buyer_remark\":\"0\",\"is_seller_remark\":\"0\",\"buyer_remark\":\"\",\"seller_remark\":\"\",\"order_price\":\"29.70\",\"postage\":\"0.00\",\"pre_tax_price\":\"0.00\",\"tax_price\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"order_time\":\"2024-09-07 10:00:41\",\"payment_time\":\"2024-09-07 10:00:51\",\"invoice_type\":\"0\",\"invoice_title\":\"\",\"invoice_content\":\"\",\"invoice_amount\":\"0.00\",\"payment_type\":\"0\",\n\"payment_way\":\"WEIXIN\",\"weight\":\"3.40\",\"real_weight\":\"0.00\",\"volume\":\"0.36\",\"distribution_status\":\"1\",\"copy_order_status\":\"0\",\"split_order_status\":\"0\",\"merge_order_status\":\"0\",\"change_order_status\":\"0\",\"split_order_no\":\"\",\"merge_order_no\":\"\",\"copy_order_no\":\"\",\"change_order_no\":\"\",\"distribution_mode\":\"0\",\"distribution_name\":\"\",\"copy_order_num\":\"0\",\"cod_price\":\"0.00\",\"consignee_doc_type\":\"1\",\"consignee_doc_no\":\"\",\"cert_name\":\"\",\"invoice_register_no\":\"\",\"created\":\"2024-09-07 10:03:41\",\"oaid\":\"\",\"demolition_price\":\"0.00\",\"wms_order_no\":\"\",\"detail\":[{\"id\":\"5545306\",\"order_no\":\"24090760000001\",\"tid\":\"884739947250516053\",\"oid\":\"57cfe46c4999489da81a3901f3e94af6\",\"goods_no\":\"CT967EN2210B01\",\"sku\":\"CT967EN2210B01\",\"num\":\"2\",\"lock_num\":\"2\",\"goods_price\":\"598.32\",\"avg_money\":\"3.40\",\"order_avg_money\":\"3.40\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.16\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"HE812B305\",\"replace_status\":\"0\",\"sku_id\":\"HE812B305\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u667a\u80fd\u4e00\u4f53\u673a\u9676\u74f7\u4f53HC0967\\\\\u5730\u6392305\",\"category_code\":\"101060000\",\"category_name\":\"\u667a\u80fd\u4e00\u4f53\u673a\u9676\u74f7\u4f53-\u4f9b\u5e94\u94fe\",\"is_package\":\"n\"},{\"id\":\"5545307\",\"order_no\":\"24090760000001\",\"tid\":\"884739947250516053\",\"oid\":\"57cfe46c4999489da81a3901f3e94af6\",\"goods_no\":\"EE812B00200B01\",\"sku\":\"EE812B00200B01\",\"num\":\"2\",\"lock_num\":\"2\",\"goods_price\":\"2900.68\",\"avg_money\":\"16.40\",\"order_avg_money\":\"16.40\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.00\",\"weight\":\"0.00\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"HE812B305\",\"replace_status\":\"0\",\"sku_id\":\"HE812B305\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u667a\u80fd\u4e00\u4f53\u673a\u76d6\u677fHE812B\",\"category_code\":\"101050\",\"category_name\":\"\u667a\u80fd\u4e00\u4f53\u673a\u76d6\u677f-\u4f9b\u5e94\u94fe\",\"is_package\":\"n\"},{\"id\":\"5545308\",\"order_no\":\"24090760000001\",\"tid\":\"884739947250516053\",\"oid\":\"37d92dcd79094b278d82083721fef97e\",\"goods_no\":\"FB2062000CPB4E\",\"sku\":\"FB2062000CPB4E\",\"num\":\"1\",\"lock_num\":\"1\",\"goods_price\":\"1599.00\",\"avg_money\":\"9.90\",\"order_avg_money\":\"9.90\",\"postage_avg_money\":\"0.00\",\"discount_price\":\"0.00\",\"install_price\":\"0.00\",\"delivery_price\":\"0.00\",\"demolition_price\":\"0.00\",\"is_gift\":\"0\",\"volume\":\"0.05\",\"weight\":\"3.41\",\"return_status\":\"0\",\"return_num\":\"0\",\"return_fee\":\"0.00\",\"pre_sale_status\":\"0\",\"payment_number\":\"\",\"package_sku\":\"\",\"replace_status\":\"0\",\"sku_id\":\"FB2062000CPB4E\",\"item_id\":\"\",\"ean\":\"\",\"attribute_value_name\":\"\",\"goods_name\":\"\u6dcb\u6d74\u5927\u82b1\u6d12HMF2000-624E\\\\\u58c1\u5f0f\u660e\u88c5\\\\\u4e09\u529f\u80fd\\\\\u6052\u6e29\u578b\",\"category_code\":\"104020110130\",\"category_name\":\"\u660e\u88c5\u5927\u82b1\u6d12-\u4e09\u529f\u80fd\",\"is_package\":\"n\"}],\"batch_detail\":[],\"order_label\":[\"NOTICE_SEND\"],\"order_express\":[{\"sku\":\"CT967EN2210B01\",\"num\":\"2\",\"express_code\":\"OTHER\",\"express_no\":\"24090760000001\",\"package_no\":null},{\"sku\":\"EE812B00200B01\",\"num\":\"2\",\"express_code\":\"OTHER\",\"express_no\":\"24090760000001\",\"package_no\":null},{\"sku\":\"FB2062000CPB4E\",\"num\":\"1\",\"express_code\":\"OTHER\",\"express_no\":\"24090760000001\",\"package_no\":null}],\"shop_code\":\"CS37\",\"shop_name\":\"\u6052\u6d01\u5b98\u65b9\u5546\u57ce\u5e97\u94fa\",\"express_name\":\"OTHER\",\"warehouse_name\":\"\u83dc\u9e1f3W\u534e\u4e1c\u5609\u5174\u53d1\u8d27\u4ed3\"}],\"msg\":\"\"}\n";
        QueryResultDomain jsonToObject = (QueryResultDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResultDomain.class);
        QueryResultDomain queryResultDomain = (QueryResultDomain)JSON.parseObject((String)json, QueryResultDomain.class);
        List<DataDomain> data = queryResultDomain.getData();
        for (DataDomain datum : data) {
            List<OrderExpress> order_express = datum.getOrder_express();
            for (OrderExpress orderExpress : order_express) {
                String expressNo = orderExpress.getExpressNo();
                System.out.println(expressNo.toString());
            }
        }
    }

    private SgSendgoodsDomain makeSgSendGoodsDomain(OrderExpress orderExpress, String tenantCode, OcContractReDomain contractReDomain) {
        if (null == contractReDomain || null == orderExpress) {
            logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain", (Object)"isnull");
            return null;
        }
        logger.error(this.SYS_CODE + "orderexpress chakan", (Object)JsonUtil.buildNormalBinder().toJson((Object)orderExpress));
        logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain.contractReDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)contractReDomain));
        SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
        ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
        BigDecimal sendNum = BigDecimal.ZERO;
        BigDecimal money = BigDecimal.ZERO;
        try {
            OcContractGoodsDomain ocContractGoodsDomain2;
            BeanUtils.copyAllPropertys((Object)sgSendgoodsDomain, (Object)contractReDomain);
            HashMap<String, OcContractGoodsDomain> ocContractGoodsDomainMap = new HashMap<String, OcContractGoodsDomain>();
            List<OcContractGoodsDomain> goodsList = contractReDomain.getGoodsList();
            for (OcContractGoodsDomain ocContractGoodsDomain2 : goodsList) {
                if (StringUtils.isNotBlank((String)ocContractGoodsDomain2.getGoodsPro()) && ocContractGoodsDomain2.getGoodsPro().equals("0")) {
                    ocContractGoodsDomainMap.put(ocContractGoodsDomain2.getSkuNo(), ocContractGoodsDomain2);
                    continue;
                }
                ocContractGoodsDomainMap.put(ocContractGoodsDomain2.getSkuNo(), ocContractGoodsDomain2);
            }
            logger.error(this.SYS_CODE + "occontractgoodsdomainmap", (Object)JsonUtil.buildNormalBinder().toJson(ocContractGoodsDomainMap));
            SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = null;
            sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
            if (StringUtils.isBlank((String)orderExpress.getNum())) {
                orderExpress.setNum("0");
            }
            sendNum = sendNum.add(new BigDecimal(orderExpress.getNum()));
            ocContractGoodsDomain2 = (OcContractGoodsDomain)ocContractGoodsDomainMap.get(orderExpress.getSku());
            if (null == ocContractGoodsDomain2) {
                logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain.ocContractGoodsDomain.1", (Object)orderExpress.getSku());
                return null;
            }
            BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)ocContractGoodsDomain2);
            if (ocContractGoodsDomain2.getContractGoodsRefnum() == null) {
                ocContractGoodsDomain2.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain2.getContractGoodsSendnum() == null) {
                ocContractGoodsDomain2.setContractGoodsSendnum(BigDecimal.ZERO);
            }
            if (ocContractGoodsDomain2.getGoodsCamount() == null) {
                ocContractGoodsDomain2.setGoodsCamount(BigDecimal.ZERO);
            }
            sgSendgoodsGoodsDomain.setContractGoodsMoney(ocContractGoodsDomain2.getContractGoodsPrice().multiply(new BigDecimal(orderExpress.getNum())));
            money = money.add(sgSendgoodsGoodsDomain.getContractGoodsMoney());
            sgSendgoodsGoodsDomain.setSendgoodsGoodsCamount(new BigDecimal(orderExpress.getNum()));
            sgSendgoodsGoodsDomain.setGoodsNum(new BigDecimal(orderExpress.getNum()));
            sgSendgoodsGoodsDomain.setGoodsCamount(new BigDecimal(orderExpress.getNum()));
            sgSendgoodsGoodsDomain.setContractNbbillcode(orderExpress.getExpressNo());
            sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
            sgSendgoodsDomain.setContractSendnum(sendNum);
            sgSendgoodsDomain.setGoodsNum(sendNum);
            sgSendgoodsDomain.setGoodsMoney(money);
            sgSendgoodsDomain.setDataBmoney(money);
            sgSendgoodsDomain.setDataBnum(sendNum);
            sgSendgoodsDomain.setContractType("03");
            sgSendgoodsDomain.setGoodsClass("welfare");
            sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
            sgSendgoodsDomain.setPackageBillno(orderExpress.getExpressNo());
            sgSendgoodsDomain.setPackageName(orderExpress.getExpressCode());
            if (StringUtils.isNotBlank((String)orderExpress.getExpressCode())) {
                sgSendgoodsDomain.setPackageMode(BusOrderServiceImpl.getMessage(orderExpress.getExpressCode()));
            } else {
                logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain.sgSendgoodsDomain.orderExpress", (Object)JSON.toJSONString((Object)orderExpress));
            }
            logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain.sgSendgoodsDomain", (Object)JSON.toJSONString((Object)sgSendgoodsDomain));
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain.makeSgSendGoodsDomain" + contractReDomain.getContractBillcode(), (Object)JsonUtil.buildNormalBinder().toJson((Object)contractReDomain));
            throw new com.yqbsoft.laser.service.esb.core.ApiException(this.SYS_CODE + ".makeSgSendGoodsDomain.copy.e", (Throwable)e);
        }
        return sgSendgoodsDomain;
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbRefundUrl", "EsbRefundUrl");
        String EsbWarehouseCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, String> entryOrder = new HashMap<String, String>();
        entryOrder.put("entryOrderCode", ocRefundDomain.getRefundCode());
        entryOrder.put("orderType", "THRK");
        entryOrder.put("warehouseCode", EsbWarehouseCode);
        entryOrder.put("ownerCode", EsbOwnerCode);
        HashMap orderLines = new HashMap();
        ArrayList orderLineList = new ArrayList();
        List<OcRefundGoodsDomain> refundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain goods : refundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ownerCode", EsbOwnerCode);
                    orderLine.put("itemName", rsGoodsRelReDomain.getGoodsName());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("ownerCode", EsbOwnerCode);
            orderLine.put("itemName", goods.getGoodsName());
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getRefundGoodsNum());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("entryOrder", entryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundConfirmToEsb(OcRefundReDomain ocRefundDomain) {
        BigDecimal multiply;
        logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        String DLSBM = "";
        if (StringUtils.isNotBlank((String)ocRefundDomain.getMemberGcode())) {
            UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocRefundDomain.getMemberGcode(), ocRefundDomain.getTenantCode());
            DLSBM = userinfoByCode.getUserinfoOcode();
        }
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocSapContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        BigDecimal goodsmoney = ocRefundDomain.getContractMoney().subtract(ocRefundDomain.getGoodsLogmoney());
        BigDecimal totalCost = BigDecimal.ZERO;
        HashMap<String, BigDecimal> skuCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, List> goodsRelList = new HashMap<String, List>();
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                Iterator relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult || ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    RsSkuReDomain skuByCode = this.getSkuByCode(rsGoodsRelReDomain.getSkuCode(), ocRefundDomain.getTenantCode());
                    if (null == skuByCode) {
                        logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,skuByCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                        return "error";
                    }
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    BigDecimal skuCost = skuByCode.getPricesetAsprice().multiply(multiply);
                    totalCost = totalCost.add(skuCost);
                    skuCostMap.put(rsGoodsRelReDomain.getSkuCode(), skuCost);
                }
                goodsRelList.put(goods.getGoodsCode(), relQueryResult.getList());
                continue;
            }
            BigDecimal skuCost = goods.getPricesetAsprice().multiply(goods.getGoodsCamount());
            totalCost = totalCost.add(skuCost);
            skuCostMap.put(goods.getSkuCode(), skuCost);
        }
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                List rsGoodsRelReDomains = (List)goodsRelList.get(goods.getGoodsCode());
                for (RsGoodsRelReDomain rsGoodsRelReDomain : rsGoodsRelReDomains) {
                    BigDecimal skuCost = (BigDecimal)skuCostMap.get(rsGoodsRelReDomain.getSkuCode());
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG02");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("KUNNR2", DLSBM);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
                    orderLine.put("ACTPR", WRBTR.divide(multiply, 2, 5));
                    orderLine.put("WRBTR", WRBTR.setScale(2, 5));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            BigDecimal skuCost = (BigDecimal)skuCostMap.get(goods.getSkuCode());
            BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", WRBTR.divide(goods.getGoodsCamount(), 2, 5));
            orderLine.put("WRBTR", WRBTR.setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        if (ocRefundDomain.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", "9100000273");
            orderLine.put("ARKTX", "\u4ef7\u5916\u8d39\u7528");
            orderLine.put("KWMENG", 1);
            orderLine.put("ACTPR", ocRefundDomain.getGoodsLogmoney());
            orderLine.put("WRBTR", ocRefundDomain.getGoodsLogmoney().setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocSapContractRequest.setMap(map);
        ocSapContractRequest.setClientsecret(esbSecret);
        ocSapContractRequest.setClientid(esbKey);
        ocSapContractRequest.setHost(url);
        SapContractResponse sapContractResponse = invoicefacade.execute(ocSapContractRequest);
        if (null == sapContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse");
            return "error";
        }
        if (!sapContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        String[] split;
        logger.error(this.SYS_CODE + ".sendContractDomainToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractproDomainList())) {
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                String[] umAddressReDomain;
                if (!"address".equals(ocContractproDomain.getContractproKey()) || null == (umAddressReDomain = (UmAddressReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractproDomain.getContractproValue(), UmAddressReDomain.class))) continue;
                receiverInfo.put("province", umAddressReDomain.getProvinceName());
                receiverInfo.put("city", umAddressReDomain.getCityName());
                String detailAddress = "";
                if (StringUtils.isNotBlank((String)umAddressReDomain.getProvinceName())) {
                    detailAddress = umAddressReDomain.getProvinceName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getCityName())) {
                    detailAddress = detailAddress + umAddressReDomain.getCityName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAreaName())) {
                    detailAddress = detailAddress + umAddressReDomain.getAreaName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getRoadName())) {
                    detailAddress = detailAddress + umAddressReDomain.getRoadName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAddressDetail())) {
                    detailAddress = detailAddress + umAddressReDomain.getAddressDetail();
                }
                receiverInfo.put("detailAddress", detailAddress);
            }
        }
        if (null == receiverInfo.get("detailAddress") && (split = ocContractDomain.getGoodsReceiptArrdess().split(",")).length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainEndToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendSaveOmsBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveOmsBusRefund.ocRefundDomain");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocRefundDomain.getTenantCode());
        map.put("contractNbbillcode", ocRefundDomain.getContractNbbillcode());
        return this.cancelOrder(map);
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        BigDecimal multiply;
        logger.error(this.SYS_CODE + ".sendContractDomainConfirmToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String DLSBM = "";
        if (StringUtils.isNotBlank((String)ocContractDomain.getMemberGcode())) {
            UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocContractDomain.getMemberGcode(), ocContractDomain.getTenantCode());
            DLSBM = userinfoByCode.getUserinfoOcode();
        }
        String KUNNR = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        BigDecimal goodsmoney = ocContractDomain.getDataBmoney().subtract(ocContractDomain.getGoodsLogmoney());
        BigDecimal totalCost = BigDecimal.ZERO;
        HashMap<String, BigDecimal> skuCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, List> goodsRelList = new HashMap<String, List>();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                Iterator relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult || ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    RsSkuReDomain skuByCode = this.getSkuByCode(rsGoodsRelReDomain.getSkuCode(), ocContractDomain.getTenantCode());
                    if (null == skuByCode) {
                        logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,skuByCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        return "error";
                    }
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    BigDecimal skuCost = skuByCode.getPricesetAsprice().multiply(multiply);
                    totalCost = totalCost.add(skuCost);
                    skuCostMap.put(rsGoodsRelReDomain.getSkuCode(), skuCost);
                }
                goodsRelList.put(goods.getGoodsCode(), relQueryResult.getList());
                continue;
            }
            BigDecimal skuCost = goods.getPricesetAsprice().multiply(goods.getGoodsCamount());
            totalCost = totalCost.add(skuCost);
            skuCostMap.put(goods.getSkuCode(), skuCost);
        }
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                List rsGoodsRelReDomains = (List)goodsRelList.get(goods.getGoodsCode());
                for (RsGoodsRelReDomain rsGoodsRelReDomain : rsGoodsRelReDomains) {
                    BigDecimal skuCost = (BigDecimal)skuCostMap.get(rsGoodsRelReDomain.getSkuCode());
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG01");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("KUNNR2", DLSBM);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
                    orderLine.put("ACTPR", WRBTR.divide(multiply, 2, 5));
                    orderLine.put("WRBTR", WRBTR.setScale(2, 5));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            BigDecimal skuCost = (BigDecimal)skuCostMap.get(goods.getSkuCode());
            BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", WRBTR.divide(goods.getGoodsCamount(), 2, 5));
            orderLine.put("WRBTR", WRBTR.setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        if (ocContractDomain.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", "9100000273");
            orderLine.put("ARKTX", "\u4ef7\u5916\u8d39\u7528");
            orderLine.put("KWMENG", 1);
            orderLine.put("ACTPR", ocContractDomain.getGoodsLogmoney());
            orderLine.put("WRBTR", ocContractDomain.getGoodsLogmoney().setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        logger.error(this.SYS_CODE + "ocEsbContractRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocEsbContractRequest));
        SapContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void mainww(String[] args) {
        HashMap<String, String> orderMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> hashmap = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        map.put("shop_code", "");
        map.put("refund_id", "");
        map.put("tid", "");
        map.put("c_status", "");
        map.put("refund_fee", "");
        map.put("created", "");
        hashmap.put("sku", "");
        hashmap.put("num", "");
        list.add(hashmap);
        map.put("list", list);
        String app_key = "1521596792";
        String timestamp = "2024-07-2610:50:44";
        String app_sign = "D01EBF3E6081711E9DAF788651D781CF";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.RefundAdd&app_key=1521596792&timestamp=2024-07-2610:50:44&app_sign=D01EBF3E6081711E9DAF788651D781CF";
        orderMap.put("refund", JsonUtil.buildNormalBinder().toJson(map));
        System.out.println(JsonUtil.buildNormalBinder().toJson(orderMap) + "======");
        try {
            String data = HttpClientUtil.doGet(url, orderMap);
            System.out.println(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mainfffff(String[] args) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("app_key", "1722319224");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "CABAEE47A484A85FFC7CC217B61B4228");
        mapStr.put("start_modified", "2024-07-31 11:00:00");
        mapStr.put("owner_code", "HEGII");
        mapStr.put("skus", "");
        mapStr.put("warehouse_code", "");
        mapStr.put("start_created", "");
        mapStr.put("end_created", "");
        mapStr.put("end_modified", "");
        mapStr.put("page_size", "40");
        mapStr.put("page_no", "1");
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=Stock.Search";
        String data = "";
        data = HttpClientUtil.doGet(url, mapStr);
        System.out.println(data);
    }

    public static void main9(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "B36B4EAAD7341B87FD4006C8EC386107";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=Stock.Search";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("owner_code", "CS39"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    public static void main1(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "1F7D16577F8DA71B474E518FC309A299";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.InstallOrderQueryList";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    public static void main5(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "0A11C404C27B4DAC4555AA659C606892";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.RefundQueryInfoByTid";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("shop_code", "CS39"));
        paramlist.add(new BasicNameValuePair("tid", "103152853719"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    public static void main4(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "026C944021187BDB4A353B52E687AE8F";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.SdkOrderChangeStatus";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("shop_code", "CS39"));
        paramlist.add(new BasicNameValuePair("tid", "103152853719"));
        paramlist.add(new BasicNameValuePair("c_status", "1"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    @Override
    public String sendCreateBusOrder(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = "";
        url = this.getdd(ocContractDomain.getTenantCode(), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(ocContractDomain.getTenantCode(), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(ocContractDomain.getTenantCode(), "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(ocContractDomain.getTenantCode(), "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String json = "";
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        map.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocContractDomain.getChannelCode())) {
            map.put("shop_code", NshopCode);
        }
        map.put("warehouse_code", "");
        map.put("seller_nick", ocContractDomain.getMemberCname());
        map.put("tid", ocContractDomain.getContractBillcode());
        map.put("c_status", "1");
        map.put("status", ocContractDomain.getDataState());
        map.put("express_code", "");
        map.put("designated_express", "0");
        map.put("user_nick", ocContractDomain.getMemberBname());
        map.put("consignee", ocContractDomain.getGoodsReceiptMem());
        map.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        map.put("address", ocContractDomain.getGoodsReceiptArrdess());
        map.put("state", "\u4e2d\u56fd");
        String goodsReceiptArrdess = ocContractDomain.getGoodsReceiptArrdess();
        boolean status = goodsReceiptArrdess.contains("-");
        if (status) {
            String[] split = goodsReceiptArrdess.split("-");
            if (null != split && split.length != 0) {
                map.put("province", split[0]);
            }
            map.put("city", split[1]);
            map.put("area", split[2]);
        }
        map.put("town", "");
        map.put("zipcode", "");
        map.put("consignee_doc_type", "");
        map.put("consignee_doc_no", "");
        map.put("notice_send_date", ocContractDomain.getContractDepositdate());
        map.put("trans_priority", "");
        map.put("seller_flag", "");
        map.put("buyer_remark", ocContractDomain.getContractRemark());
        map.put("seller_remark", "");
        map.put("order_price", ocContractDomain.getDataBmoney());
        map.put("postage", ocContractDomain.getGoodsLogmoney());
        map.put("cod_price", ocContractDomain.getDataBmoney());
        map.put("pre_tax_price", "");
        map.put("tax_price", "");
        map.put("discount_price", ocContractDomain.getGoodsPmoney());
        map.put("order_time", ocContractDomain.getGmtCreate());
        map.put("payment_type", "0");
        map.put("payment_time", ComConstants.requestTimestamp());
        map.put("invoice_type", "");
        map.put("invoice_title", "");
        map.put("invoice_content", "");
        map.put("invoice_amount", "");
        map.put("payment_way", "WEIXIN");
        map.put("distribution_status", "1");
        map.put("plat_lastchanged", ocContractDomain.getGmtModified());
        map.put("distribution_mode", "");
        map.put("distribution_name", "");
        map.put("express_no", "");
        map.put("payment_number", "");
        map.put("gross_weight", ocContractDomain.getGoodsWeight());
        map.put("paint_marker", "");
        map.put("express_print_data", "");
        map.put("pre_sale_status", "0");
        map.put("invtno", "");
        map.put("order_flag", "");
        BigDecimal packageBoxpriceMoney = BigDecimal.ZERO;
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                HashMap<String, Object> hashmap = new HashMap<String, Object>();
                if (null == ocContractGoodsDomain.getContractGoodsBoxprice()) {
                    ocContractGoodsDomain.setContractGoodsBoxprice(BigDecimal.ZERO);
                }
                packageBoxpriceMoney = packageBoxpriceMoney.add(ocContractGoodsDomain.getContractGoodsBoxprice());
                hashmap.put("oid", ocContractGoodsDomain.getContractGoodsCode());
                hashmap.put("title", ocContractGoodsDomain.getGoodsName());
                hashmap.put("sku", ocContractGoodsDomain.getSkuNo());
                hashmap.put("num", ocContractGoodsDomain.getGoodsCamount());
                hashmap.put("goods_price", ocContractGoodsDomain.getContractGoodsPrice());
                hashmap.put("tax_price", "");
                hashmap.put("discount_price", "");
                hashmap.put("install_price", ocContractGoodsDomain.getContractGoodsBoxamt());
                hashmap.put("return_status", "");
                if (null != ocContractGoodsDomain.getGoodsProperty2() && "1".equals(ocContractGoodsDomain.getGoodsProperty2())) {
                    hashmap.put("is_install", "1");
                } else {
                    hashmap.put("is_install", "0");
                }
                hashmap.put("sku_properties", "");
                hashmap.put("net_weight", ocContractGoodsDomain.getGoodsWeight());
                list.add(hashmap);
            }
        }
        map.put("demolition_price", packageBoxpriceMoney);
        map.put("detail", list);
        ArrayList customlist = new ArrayList();
        HashMap<String, String> hashmap1 = new HashMap<String, String>();
        hashmap1.put("_custom_fld", "");
        customlist.add(hashmap1);
        ArrayList detaillist = new ArrayList();
        HashMap<String, String> hashmap2 = new HashMap<String, String>();
        hashmap2.put("sku", "");
        hashmap2.put("_custom_fld", "");
        detaillist.add(hashmap2);
        map.put("detaillist", detaillist);
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkOrderAdd");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("order", JsonUtil.buildNormalBinder().toJson(map));
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap.map" + JsonUtil.buildNormalBinder().toJson(map));
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(mapStr) + "e" + e));
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    public static String getMessage(String code) {
        switch (code) {
            case "ZTO": {
                return "zhongtong";
            }
            case "SF": {
                return "shunfeng";
            }
            case "SN": {
                return "suning";
            }
            case "JD": {
                return "jd";
            }
            case "JDCPWL": {
                return "JDCPWL";
            }
        }
        return code;
    }

    public static void main1q(String[] args) {
    }

    @Override
    public String queryContractDomainPage(Map<String, Object> map) {
        String app_key = "1521596792";
        String timestamp = "2024-07-23 15:59:28";
        String app_sign = "980CF4F3334F775B0300C9975FB62EE3";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.InstallOrderQueryList&app_key=1521596792&timestamp=2024-07-23 15:59:28&app_sign=980CF4F3334F775B0300C9975FB62EE3";
        String data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        return data;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String queryNewStock(Map<String, Object> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String makeErrorReturn(String code, String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("errorCode", code);
        result.put("errorDesc", msg);
        result.put("requestMethod", "gy.erp.stock.query");
        return JsonUtil.buildNormalBinder().toJson(result);
    }

    private String makeErrorReturn(String code, String msg, String subCode, String subMsg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("errorCode", code);
        result.put("errorDesc", msg);
        result.put("subErrorCode", subCode);
        result.put("subErrorDesc", subMsg);
        result.put("requestMethod", "gy.erp.stock.query");
        return JsonUtil.buildNormalBinder().toJson(result);
    }

    @Override
    public String queryInstallOrderQueryList(Map<String, Object> map) {
        logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        Long startTime = System.currentTimeMillis();
        if (null == map) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = "";
        url = this.getdd((String)map.get("tenantCode"), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd((String)map.get("tenantCode"), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd((String)map.get("tenantCode"), "appSecret", "appSecret");
        String tid = (String)map.get("contractBillcode");
        if (StringUtils.isBlank((String)tid)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0ctid", (Object)"tid\u4e3a\u7a7a");
            return "error";
        }
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.InstallOrderQueryList");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("tid", tid);
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            return "error";
        }
        logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return data;
        }
        return "error";
    }

    public static void mainvvvv(String[] args) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.RefundQueryInfoByTid");
        mapStr.put("app_key", "1722319224");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=oms.RefundQueryInfoByTid";
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", "CS37");
        mapStr.put("tid", "876764034902720612");
        String data = HttpClientUtil.doGet(url, mapStr);
        System.out.println(data);
        RefundResultDomain refundResultDomain1 = (RefundResultDomain)JSON.parseObject((String)data, RefundResultDomain.class);
        List<RefundResult> data1 = refundResultDomain1.getData();
        List collect = data1.stream().map(qj -> qj.getReceiptStatus()).collect(Collectors.toList());
        for (Integer integer : collect) {
            if (integer == 20) {
                System.out.println("\u5df2\u6536\u8d27");
                continue;
            }
            System.out.println("\u672a\u6536\u8d27");
        }
    }

    @Override
    public String sendSaveBusRefundOms(String tenantCode, String tid) {
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2023072819990101";
        }
        if (StringUtils.isBlank((String)tid)) {
            return "error";
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(tenantCode, "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(tenantCode, "NshopCode", "NshopCode");
        String GshopCode = "";
        GshopCode = this.getdd(tenantCode, "GshopCode", "GshopCode");
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.RefundQueryInfoByTid");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", appSecret);
        mapStr.put("shop_code", GshopCode);
        mapStr.put("tid", tid);
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            return "error";
        }
        RefundResultDomain refundResultDomain1 = (RefundResultDomain)JSON.parseObject((String)data, RefundResultDomain.class);
        List<RefundResult> data1 = refundResultDomain1.getData();
        List collect = data1.stream().map(qj -> qj.getReceiptStatus()).collect(Collectors.toList());
        for (Integer integer : collect) {
            if (integer != 20) continue;
            return "success";
        }
        return "error";
    }

    @Override
    public String sendCreateBusOrderStatus(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        Long startTime = System.currentTimeMillis();
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(ocContractDomain.getTenantCode(), "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(ocContractDomain.getTenantCode(), "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String url = "";
        url = this.getdd(ocContractDomain.getTenantCode(), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(ocContractDomain.getTenantCode(), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(ocContractDomain.getTenantCode(), "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkOrderChangeStatus");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocContractDomain.getChannelCode())) {
            mapStr.put("shop_code", NshopCode);
        }
        mapStr.put("tid", ocContractDomain.getContractBillcode());
        if (2 == ocContractDomain.getDataState()) {
            mapStr.put("c_status", "1");
        }
        if (3 == ocContractDomain.getDataState()) {
            mapStr.put("c_status", "2");
        }
        if (-1 == ocContractDomain.getDataState()) {
            mapStr.put("c_status", "3");
        }
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    @Override
    public String taobaoProductsSearch() {
        String sessionKey = "#########################";
        String url = "http://gw.api.taobao.com/router/rest";
        String appkey = "25896040";
        String secret = "bcc992f0c8808fbe412c27995a44ec4c";
        DefaultTaobaoClient client = new DefaultTaobaoClient(url, appkey, secret);
        UserSellerGetRequest req = new UserSellerGetRequest();
        req.setFields("nick,sex");
        UserSellerGetResponse response = null;
        try {
            response = (UserSellerGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        logger.error(this.SYS_CODE + ".taobaoProductsSearch.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson((Object)response), (Object)response);
        System.out.println(response.getBody());
        System.out.println(response.getMsg());
        return response.toString();
    }

    public static void main88888(String[] args) {
        Long startTime = System.currentTimeMillis();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", "2023072819990101");
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=oms.InstallOrderQueryList";
        String appKey = "1722319224";
        String appSecret = "";
        String tid = "876409685609480290";
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("tid", tid);
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
            System.out.println(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main8(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "0A11C404C27B4DAC4555AA659C606892";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.RefundQueryInfoByTid";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("shop_code", "CS39"));
        paramlist.add(new BasicNameValuePair("tid", "103152853719"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getdd(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public static void main3333333(String[] args) {
        List<DataDomain> data1;
        String data = "{\n\t\"status\": 1,\n\t\"data\": [{\n\t\t\"shop_id\": \"37\",\n\t\t\"order_no\": \"24091070000002\",\n\t\t\"warehouse_code\": \"4101\",\n\t\t\"express_code\": \"SF\",\n\t\t\"express_no\": \"\",\n\t\t\"goods_total\": \"11\",\n\t\t\"sku_total\": \"1\",\n\t\t\"order_status\": \"5\",\n\t\t\"no_stock_status\": \"10\",\n\t\t\"question_status\": \"0\",\n\t\t\"lock_status\": \"0\",\n\t\t\"refund_status\": \"0\",\n\t\t\"urgent_status\": \"0\",\n\t\t\"pre_sale_status\": \"0\",\n\t\t\"delivery_time\": \"1970-01-01 00:00:00\",\n\t\t\"write_back_time\": \"1970-01-01 00:00:00\",\n\t\t\"write_back_status\": \"0\",\n\t\t\"notice_time\": \"1970-01-01 00:00:00\",\n\t\t\"check_time\": \"1970-01-01 00:00:00\",\n\t\t\"cancel_time\": \"1970-01-01 00:00:00\",\n\t\t\"cancel_reason\": \"\",\n\t\t\"lock_user\": \"\",\n\t\t\"part_refund_status\": \"0\",\n\t\t\"owner_id\": \"1\",\n\t\t\"modified\": \"2024-09-10 18:18:53\",\n\t\t\"notice_send_date\": \"1970-01-01\",\n\t\t\"latest_delivery_time\": \"1970-01-01 00:00:00\",\n\t\t\"cancel_reason_name\": \"\",\n\t\t\"order_type\": \"0\",\n\t\t\"platform_code\": \"HT\",\n\t\t\"tid\": \"885685263646785568\",\n\t\t\"user_nick\": \"\u9ec4\u6210\",\n\t\t\"consignee\": \"\u6d4b\u8bd5\u4e0d\u53d1\u8d27\",\n\t\t\"phone\": \"\",\n\t\t\"mobile\": \"13790005410\",\n\t\t\"email\": \"\",\n\t\t\"address\": \"\u5e7f\u4e1c-\u4f5b\u5c71\u5e02-\u7985\u57ce\u533a-\u667a\u6167\u65b0\u57ceT5\u6052\u6d01\u536b\u6d74\",\n\t\t\"state\": \"\u4e2d\u56fd\",\n\t\t\"province\": \"\u5e7f\u4e1c\u7701\",\n\t\t\"city\": \"\u4f5b\u5c71\u5e02\",\n\t\t\"area\": \"\u7985\u57ce\u533a\",\n\t\t\"town\": \"\",\n\t\t\"state_code\": \"1\",\n\t\t\"province_code\": \"440000\",\n\t\t\"city_code\": \"440600\",\n\t\t\"area_code\": \"440604\",\n\t\t\"town_code\": \"\",\n\t\t\"zipcode\": \"\",\n\t\t\"remark\": \"\",\n\t\t\"seller_flag\": \"\",\n\t\t\"is_buyer_remark\": \"0\",\n\t\t\"is_seller_remark\": \"0\",\n\t\t\"buyer_remark\": \"\",\n\t\t\"seller_remark\": \"\",\n\t\t\"order_price\": \"78.90\",\n\t\t\"postage\": \"0.00\",\n\t\t\"pre_tax_price\": \"0.00\",\n\t\t\"tax_price\": \"0.00\",\n\t\t\"discount_price\": \"30.00\",\n\t\t\"install_price\": \"0.00\",\n\t\t\"delivery_price\": \"0.00\",\n\t\t\"order_time\": \"2024-09-10 17:18:43\",\n\t\t\"payment_time\": \"2024-09-10 17:18:50\",\n\t\t\"invoice_type\": \"0\",\n\t\t\"invoice_title\": \"\",\n\t\t\"invoice_content\": \"\",\n\t\t\"invoice_amount\": \"0.00\",\n\t\t\"payment_type\": \"0\",\n\t\t\"payment_way\": \"WEIXIN\",\n\t\t\"weight\": \"4.84\",\n\t\t\"real_weight\": \"0.00\",\n\t\t\"volume\": \"0.01\",\n\t\t\"distribution_status\": \"1\",\n\t\t\"copy_order_status\": \"0\",\n\t\t\"split_order_status\": \"0\",\n\t\t\"merge_order_status\": \"0\",\n\t\t\"change_order_status\": \"0\",\n\t\t\"split_order_no\": \"\",\n\t\t\"merge_order_no\": \"\",\n\t\t\"copy_order_no\": \"\",\n\t\t\"change_order_no\": \"\",\n\t\t\"distribution_mode\": \"0\",\n\t\t\"distribution_name\": \"\",\n\t\t\"copy_order_num\": \"0\",\n\t\t\"cod_price\": \"0.00\",\n\t\t\"consignee_doc_type\": \"0\",\n\t\t\"consignee_doc_no\": \"\",\n\t\t\"cert_name\": \"\",\n\t\t\"invoice_register_no\": \"\",\n\t\t\"created\": \"2024-09-10 18:16:53\",\n\t\t\"oaid\": \"\",\n\t\t\"demolition_price\": \"0.00\",\n\t\t\"wms_order_no\": \"\",\n\t\t\"detail\": [{\n\t\t\t\"id\": \"5545322\",\n\t\t\t\"order_no\": \"24091070000002\",\n\t\t\t\"tid\": \"885685263646785568\",\n\t\t\t\"oid\": \"d34257e038e1474aac3cd23042193654\",\n\t\t\t\"goods_no\": \"N-01172600-12\",\n\t\t\t\"sku\": \"FF2612000CPB0A\",\n\t\t\t\"num\": \"11\",\n\t\t\t\"lock_num\": \"11\",\n\t\t\t\"goods_price\": \"149.00\",\n\t\t\t\"avg_money\": \"78.90\",\n\t\t\t\"order_avg_money\": \"78.90\",\n\t\t\t\"postage_avg_money\": \"0.00\",\n\t\t\t\"discount_price\": \"30.00\",\n\t\t\t\"install_price\": \"0.00\",\n\t\t\t\"delivery_price\": \"0.00\",\n\t\t\t\"demolition_price\": \"0.00\",\n\t\t\t\"is_gift\": \"0\",\n\t\t\t\"volume\": \"0.00\",\n\t\t\t\"weight\": \"0.44\",\n\t\t\t\"return_status\": \"0\",\n\t\t\t\"return_num\": \"0\",\n\t\t\t\"return_fee\": \"0.00\",\n\t\t\t\"pre_sale_status\": \"0\",\n\t\t\t\"payment_number\": \"\",\n\t\t\t\"package_sku\": \"\",\n\t\t\t\"replace_status\": \"0\",\n\t\t\t\"sku_id\": \"FF2612000CPB0A\",\n\t\t\t\"item_id\": \"\",\n\t\t\t\"ean\": \"XN260012\",\n\t\t\t\"attribute_value_name\": \"\",\n\t\t\t\"goods_name\": \"\u6052\u6d01HMF2600-12\u5355\u51b7\u9f99\u5934\",\n\t\t\t\"category_code\": \"104010110110\",\n\t\t\t\"category_name\": \"\u5355\u5b54\u9762\u76c6\u9f99\u5934\",\n\t\t\t\"is_package\": \"n\"\n\t\t}],\n\t\t\"batch_detail\": [],\n\t\t\"order_label\": [],\n\t\t\"shop_code\": \"CS37\",\n\t\t\"shop_name\": \"\u6052\u6d01\u5b98\u65b9\u5546\u57ce\u5e97\u94fa\",\n\t\t\"express_name\": \"\u987a\u4e30\u901f\u8fd0\",\n\t\t\"warehouse_name\": \"\u7535\u5546\u4e2d\u5fc3\u4ed3\"\n\t}],\n\t\"msg\": \"\"\n}";
        QueryResultDomain queryResultDomain = (QueryResultDomain)JSON.parseObject((String)data, QueryResultDomain.class);
        if (null == queryResultDomain) {
            // empty if block
        }
        if (ListUtil.isEmpty(data1 = queryResultDomain.getData())) {
            // empty if block
        }
        for (DataDomain dataDomain : data1) {
            if (!ListUtil.isNotEmpty(dataDomain.getOrder_express())) continue;
            String orderNo = dataDomain.getTid();
            for (OrderExpress orderExpress : dataDomain.getOrder_express()) {
            }
        }
    }

    protected SupQueryResult<SgSendgoodsGoods> querySendgoodsByGoodsPage(Map<String, Object> param) {
        String apiCode = "sg.sendgoods.querySendgoodsGoodsPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        return this.getQueryResutl(apiCode, paramMap, SgSendgoodsGoods.class);
    }

    public static void main122222(String[] args) {
        List<DataDomain> data1;
        String data = "{\n\t\"status\": 0,\n\t\"data\": \"\",\n\t\"msg\": \"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\"\n}";
        QueryResultDomain queryResultDomain = (QueryResultDomain)JSON.parseObject((String)data, QueryResultDomain.class);
        if (null == queryResultDomain) {
            // empty if block
        }
        if (ListUtil.isEmpty(data1 = queryResultDomain.getData())) {
            // empty if block
        }
        for (DataDomain dataDomain : data1) {
            if (null == dataDomain) continue;
            String string = dataDomain.getTid();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String cancelOrder(Map<String, Object> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String orderAdd(Map<String, Object> map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String sendSaveCreateBusOrder(OcContractReDomain ocContractDomain) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String updateContract(List<OcContractEditDomain> ocContractEditDomainList) {
        String apiCode = "oc.contractEngine.sendSaveContractEditBatch";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("ocContractEditDomainList", JsonUtil.buildNormalBinder().toJson(ocContractEditDomainList));
        try {
            this.internalInvoke(apiCode, param);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".orderAdd.updateContract", (Throwable)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveExSendgoods(Map<String, Object> resStream) {
        logger.error(this.SYS_CODE + ".sendSaveExSendgoods.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        if (MapUtil.isEmpty(resStream)) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsDomain");
            return this.makeErrorReturn1(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        SgSendgoodsDomain sendgoodsDomain = (SgSendgoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), SgSendgoodsDomain.class);
        if (null == sendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsDomain", (Object)"sendgoodsDomain is null");
            return this.makeErrorReturn1(null, "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractReDomain ocContractReDomain = this.getOrderByCode(sendgoodsDomain.getContractBillcode(), sendgoodsDomain.getTenantCode());
        if (null == ocContractReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.ocContractReDomain", (Object)"ocContractReDomain is null");
            return this.makeErrorReturn1(sendgoodsDomain.getContractBillcode(), "\u8ba2\u5355\u5355\u636e\u53f7\u4e0d\u5b58\u5728");
        }
        List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.ocContractReDomain.goodsList", (Object)"ocContractReDomain is null");
            return this.makeErrorReturn1(sendgoodsDomain.getContractBillcode(), "\u8ba2\u5355\u5355\u636e\u53f7\u5546\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
        HashMap<String, Object> refundMap = new HashMap<String, Object>();
        refundMap.put("contractBillcode", ocContractReDomain.getContractBillcode());
        refundMap.put("tenantCode", ocContractReDomain.getTenantCode());
        refundMap.put("dataState", "0,1,4,3,8");
        QueryResult<OcRefundReDomain> queryResult = this.queryRefundReDoaminPage(refundMap);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.ocContractReDomain.goodsList", (Object)"ocContractReDomain is null");
            return this.makeErrorReturn1(sendgoodsDomain.getContractBillcode(), "\u8be5\u8ba2\u5355\u5305\u542b\u552e\u540e");
        }
        this.makeSgSendGoodsDomain(sendgoodsDomain, ocContractReDomain);
        try {
            String string = this.saveSgSendGoods(sendgoodsDomain);
        }
        catch (com.yqbsoft.laser.service.esb.core.ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e", (Throwable)e);
            return this.makeErrorReturn1(sendgoodsDomain.getSendgoodsCode(), e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e1", (Throwable)e);
            return this.makeErrorReturn1(sendgoodsDomain.getSendgoodsCode(), e.getMessage());
        }
        return this.makeSuccessReturn1(sendgoodsDomain.getSendgoodsCode());
    }

    private void makeSgSendGoodsDomain(SgSendgoodsDomain sendgoodsDomain, OcContractReDomain ocContractReDomain) {
        HashMap<String, OcContractGoodsDomain> ocContractGoodsDomainMap = new HashMap<String, OcContractGoodsDomain>();
        List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
        if (!CollectionUtils.isEmpty(goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                ocContractGoodsDomainMap.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
            }
            BigDecimal sendNum = BigDecimal.ZERO;
            BigDecimal money = BigDecimal.ZERO;
            BigDecimal goodsMoney = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(sendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
                for (SgSendgoodsGoodsDomain sendgoodsGoodsDomain : sendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                    String skuNo = sendgoodsGoodsDomain.getSkuNo();
                    if ("33".equals(ocContractReDomain.getPricesetCurrency1())) {
                        skuNo = "C" + sendgoodsGoodsDomain.getSkuNo();
                    }
                    BigDecimal mount = sendgoodsGoodsDomain.getSendgoodsGoodsCamount();
                    OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractGoodsDomainMap.get(skuNo);
                    if (null == ocContractGoodsDomain) continue;
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)sendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
                        if (EmptyUtil.isEmpty((Object)sendgoodsGoodsDomain.getPricesetNprice())) {
                            sendgoodsGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                        }
                        if (EmptyUtil.isEmpty((Object)sendgoodsGoodsDomain.getContractGoodsPrice())) {
                            sendgoodsGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                        }
                        sendgoodsGoodsDomain.setSendgoodsGoodsCamount(mount);
                        sendgoodsGoodsDomain.setGoodsCamount(mount);
                        sendgoodsGoodsDomain.setGoodsNum(mount);
                        sendgoodsGoodsDomain.setContractGoodsMoney(sendgoodsGoodsDomain.getContractGoodsPrice().multiply(mount));
                        sendgoodsGoodsDomain.setContractGoodsInmoney(sendgoodsGoodsDomain.getPricesetNprice().multiply(mount));
                        sendNum = sendNum.add(sendgoodsGoodsDomain.getSendgoodsGoodsCamount());
                        money = money.add(sendgoodsGoodsDomain.getContractGoodsInmoney());
                        goodsMoney = goodsMoney.add(sendgoodsGoodsDomain.getContractGoodsMoney());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)sendgoodsDomain, (Object)ocContractReDomain);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sendgoodsDomain.setContractType("03");
                sendgoodsDomain.setContractSendnum(sendNum);
                sendgoodsDomain.setGoodsNum(sendNum);
                sendgoodsDomain.setGoodsMoney(goodsMoney);
                sendgoodsDomain.setDataBmoney(goodsMoney);
                sendgoodsDomain.setContractMoney(goodsMoney);
                sendgoodsDomain.setContractInmoney(money);
                sendgoodsDomain.setDataBnum(sendNum);
            }
        }
    }

    public static void main(String[] args) {
        String st = "{\n\t\"contractBillcode\": \"804648451949924393\",\n\t\"sendgoodsCode\": \"8046484519499243931\",\n\t\"packageMode\": \"\u5feb\u9012\",\n\t\"packageName\": \"\u4eac\u4e1c\u5feb\u9012\",\n\t\"packageBillno\": \"JDX023598729319\",\n\t\"tenantCode\": \"2023072819990101\",\n\t\"sgSendgoodsGoodsDomainList\": [{\n\t\t\t\"contractGoodsCode\": \"123456\",\n\t\t\t\"skuNo\": \"10315505\",\n\t\t\t\"sendgoodsGoodsCamount\": 100\n\t\t}, {\n\t\t\t\"contractGoodsCode\": \"123456\",\n\t\t\t\"skuNo\": \"103155051\",\n\t\t\t\"sendgoodsGoodsCamount\": 100\n\t\t}\n\n\n\t]\n}";
        SgSendgoodsDomain sendgoodsDomain = (SgSendgoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(st, SgSendgoodsDomain.class);
        System.out.println(sendgoodsDomain);
    }

    protected String makeErrorReturn1(String errorCode, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "-1");
        map.put("success", false);
        map.put("dataObj", errorCode);
        map.put("msg", msg);
        return JsonUtil.buildNormalBinder().toJson(map);
    }

    protected String makeSuccessReturn1(Object dataObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", "200");
        map.put("success", true);
        map.put("dataObj", dataObj);
        map.put("msg", "\u6210\u529f");
        return JsonUtil.buildNormalBinder().toJson(map);
    }
}

