/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.supbase;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLog;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhQoh;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhStoreSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.bus.data.supbase.BusBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.StringConvertUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public abstract class StoreBaseService
extends BusBaseService {
    public static final String SYS_CODE = "busdata.StoreBaseService";

    protected String saveWarehouse(WhWarehouseDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            this.logger.error("busdata.StoreBaseService.saveWarehouse.whWarehouseDomain");
            return null;
        }
        String apiCode = "wh.warehouse.saveWarehouse";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("whWarehouseDomain", JsonUtil.buildNormalBinder().toJson((Object)whWarehouseDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected QueryResult<WhWarehouseReDomain> queryWarehousePage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("busdata.StoreBaseService.queryWarehousePage.map");
            return null;
        }
        String apiCode = "wh.warehouse.queryWarehousePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, WhWarehouseReDomain.class);
    }

    protected WhWarehouseReDomain getWarehouseByCode(String warehouseCode, String tenantCode) {
        if (StringUtils.isBlank((String)warehouseCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "wh.warehouse.getWarehouseByCode";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("warehouseCode", warehouseCode);
        param.put("tenantCode", tenantCode);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        return (WhWarehouseReDomain)this.getForObject(apiCode, WhWarehouseReDomain.class, paramMap);
    }

    protected String makeOpstore(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("busdata.StoreBaseService.makeOpstore.whOpstoreDomain");
            return "error";
        }
        return null;
    }

    protected String sendSaveOpstore(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("busdata.StoreBaseService.sendSaveOpstore.whOpstoreDomain");
            return "error";
        }
        String apiCode = "wh.whStoreGoodsBase.sendSaveOpstore";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected String sendSaveOpstoreTwo(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            this.logger.error("busdata.StoreBaseService.sendSaveOpstore.whOpstoreDomain");
            return "error";
        }
        String apiCode = "wh.whStoreGoodsBase.sendSaveOpstoreTwo";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    protected QueryResult<WhOpstoreReDomain> queryOpstorePage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("busdata.StoreBaseService.queryOpstorePage.map");
            return null;
        }
        String apiCode = "wh.WhOpstore.queryOpstorePage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, WhOpstoreReDomain.class);
    }

    protected void makeWhOpstoreDomain1(final WhQoh whQoh, String storeGoodsType, String storeGoodsBtype) {
        HashMap<String, WhWarehouseReDomain> whWarehouseReDomainMap = new HashMap<String, WhWarehouseReDomain>();
        ArrayList<WhOpstoreDomain> whOpstoreDomains = new ArrayList<WhOpstoreDomain>();
        try {
            BigDecimal goodsNum = BigDecimal.ZERO;
            if (!StringUtils.isEmpty((String)whQoh.getStoreQty())) {
                goodsNum = new BigDecimal(whQoh.getStoreQty());
            }
            WhWarehouseReDomain whWarehouseDomain = null;
            if (whWarehouseReDomainMap.get(whQoh.getWhCode()) == null) {
                whWarehouseDomain = this.getWarehouseByCode(whQoh.getOrgCode() + "_" + whQoh.getWhCode(), ComConstants.tenantCode);
                if (null == whWarehouseDomain) {
                    return;
                }
                whWarehouseReDomainMap.put(whQoh.getOrgCode() + "_" + whQoh.getWhCode(), whWarehouseDomain);
            } else {
                whWarehouseDomain = (WhWarehouseReDomain)whWarehouseReDomainMap.get(whQoh.getOrgCode() + "_" + whQoh.getWhCode());
            }
            final WhWarehouseReDomain finalWhWarehouseDomain = whWarehouseDomain;
            HashMap<String, Object> queryMap = new HashMap<String, Object>(){
                {
                    this.put("warehouseCode", finalWhWarehouseDomain.getWarehouseCode());
                    this.put("skuNo", whQoh.getItemInfo_ItemCode());
                    this.put("tenantCode", ComConstants.tenantCode);
                }
            };
            QueryResult<WhStoreSkuDomain> queryWhSku = this.queryWhSku((Map<String, Object>)queryMap);
            if (queryWhSku != null && queryWhSku.getList() != null && queryWhSku.getList().size() > 0) {
                BigDecimal stockGoodsNum = ((WhStoreSkuDomain)queryWhSku.getList().get(0)).getGoodsNum();
                if (null == stockGoodsNum) {
                    stockGoodsNum = BigDecimal.ZERO;
                }
                if (stockGoodsNum.compareTo(goodsNum) == 0) {
                    return;
                }
            }
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setMemberBcode(whWarehouseDomain.getWarehouseMobile());
            whOpstoreDomain.setWarehouseCode(whWarehouseDomain.getWarehouseCode());
            whOpstoreDomain.setWarehouseName(whWarehouseDomain.getWarehouseName());
            whOpstoreDomain.setGoodsNum(goodsNum);
            whOpstoreDomain.setStoreGoodsBtype(storeGoodsBtype);
            whOpstoreDomain.setStoreGoodsType(storeGoodsType);
            whOpstoreDomain.setStoreType("0");
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
            ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            whOpstoreGoodsDomain.setWarehouseCode(whWarehouseDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whWarehouseDomain.getWarehouseName());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuNo", whQoh.getItemInfo_ItemCode());
            map.put("tenantCode", ComConstants.tenantCode);
            map.put("channelCode", ComConstants.channelCode);
            QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage(map);
            if (rsSkuDomainQueryResult == null || CollectionUtils.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
                this.logger.error("busdata.StoreBaseService.assWhOpstoreSkuDomain.queryRsSkuPage.param", (Object)("\u5e93\u5b58\u5546\u54c1\u7f16\u7801" + whQoh.getItemInfo_ItemCode() + "\u672a\u67e5\u8be2\u5230\u5546\u54c1"));
                return;
            }
            RsSkuDomain rsSkuDomain = (RsSkuDomain)rsSkuDomainQueryResult.getList().get(0);
            this.assWhOpstoreSkuDomain(whQoh, whOpstoreSkuDomainList, whOpstoreDomain, whOpstoreGoodsDomain, "1", rsSkuDomain);
            whOpstoreGoodsDomain.setOpstoreDir("1");
            whOpstoreGoodsDomain.setStoreType("0");
            whOpstoreGoodsDomain.setStoreGoodsType("0");
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
            whOpstoreGoodsDomain.setPartsnameNumunit1("0");
            whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
            whOpstoreDomain.setTenantCode(ComConstants.tenantCode);
            whOpstoreDomains.add(whOpstoreDomain);
            this.saveWhOpstoreDomians(whOpstoreDomains);
        }
        catch (Exception e) {
            this.saveLogError(whQoh, e.getMessage());
            this.logger.error("busdata.StoreBaseService.timingStock.sendSaveOpstoreBatch.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)whQoh), (Throwable)e);
        }
    }

    private void saveWhOpstoreDomians(final List<WhOpstoreDomain> whOpstoreSkuDomainList) {
        HashMap<String, Object> sendMap = new HashMap<String, Object>(){
            {
                this.put("whOpstoreDomainList", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreSkuDomainList));
            }
        };
        this.internalInvoke("wh.whStoreGoodsBase.sendSaveOpstoreBatch", sendMap);
    }

    private void assWhOpstoreSkuDomain(WhQoh whQoh, List<WhOpstoreSkuDomain> whOpstoreSkuDomainList, WhOpstoreDomain whOpstoreDomain, WhOpstoreGoodsDomain whOpstoreGoodsDomain, String opStoreDir, RsSkuDomain rsSkuDomain) {
        whOpstoreGoodsDomain.setMemberBcode(rsSkuDomain.getMemberBcode());
        whOpstoreGoodsDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
        whOpstoreGoodsDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
        whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        if (null == whQoh || null == whOpstoreDomain || null == whOpstoreGoodsDomain) {
            return;
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            whOpstoreDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsWeight()) {
            whOpstoreDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreDomain.getGoodsAmt()) {
            whOpstoreDomain.setGoodsAmt(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        whOpstoreSkuDomain.setMemberBcode(rsSkuDomain.getMemberBcode());
        whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
        whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
        whOpstoreSkuDomain.setGoodsNum(StringConvertUtil.getBigDecimal(whQoh.getStoreQty()));
        whOpstoreSkuDomain.setClasstreeCode(rsSkuDomain.getClasstreeCode());
        whOpstoreSkuDomain.setClasstreeName(rsSkuDomain.getClasstreeName());
        whOpstoreSkuDomain.setGoodsNo(rsSkuDomain.getGoodsNo());
        whOpstoreSkuDomain.setGoodsCode(rsSkuDomain.getGoodsCode());
        whOpstoreSkuDomain.setSkuEocode(rsSkuDomain.getSkuEocode());
        whOpstoreSkuDomain.setGoodsEocode(rsSkuDomain.getGoodsEocode());
        whOpstoreSkuDomain.setSpuCode(rsSkuDomain.getSpuCode());
        whOpstoreSkuDomain.setSkuNo(rsSkuDomain.getSkuNo());
        whOpstoreSkuDomain.setSkuCode(rsSkuDomain.getSkuCode());
        whOpstoreSkuDomain.setSkuName(rsSkuDomain.getGoodsName());
        whOpstoreSkuDomain.setOperatorCode(rsSkuDomain.getMschannelName());
        whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
        whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
        whOpstoreSkuDomain.setMemberCode(rsSkuDomain.getMemberCode());
        whOpstoreSkuDomain.setMemberName(rsSkuDomain.getMemberName());
        whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        whOpstoreSkuDomain.setChannelCode(rsSkuDomain.getChannelCode());
        whOpstoreSkuDomain.setChannelName(rsSkuDomain.getChannelName());
        whOpstoreSkuDomain.setStoreType("0");
        whOpstoreGoodsDomain.setStoreType("0");
        whOpstoreDomain.setChannelCode(whOpstoreSkuDomain.getChannelCode());
        whOpstoreDomain.setChannelName(whOpstoreSkuDomain.getChannelName());
        whOpstoreDomain.setMemberMcode(whOpstoreSkuDomain.getMemberCode());
        whOpstoreDomain.setMemberMname(whOpstoreSkuDomain.getMemberName());
        whOpstoreDomain.setMemberCode(ComConstants.membercode);
        whOpstoreDomain.setMemberName(ComConstants.membername);
        whOpstoreDomain.setTenantCode(ComConstants.tenantCode);
        if (null == whOpstoreSkuDomain.getGoodsNum()) {
            whOpstoreSkuDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreSkuDomain.getGoodsWeight()) {
            whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsNum()) {
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whOpstoreGoodsDomain.getGoodsWeight()) {
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        whOpstoreDomain.setGoodsNum(whOpstoreDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreDomain.setGoodsWeight(whOpstoreDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum().add(whOpstoreSkuDomain.getGoodsNum()));
        whOpstoreGoodsDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight().add(whOpstoreSkuDomain.getGoodsWeight()));
        whOpstoreGoodsDomain.setMemberCode(ComConstants.membercode);
        whOpstoreGoodsDomain.setMemberName(ComConstants.membername);
        whOpstoreGoodsDomain.setTenantCode(ComConstants.tenantCode);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("goodsNo", rsSkuDomain.getGoodsNo());
        map1.put("tenantCode", ComConstants.tenantCode);
        map1.put("channelCode", ComConstants.channelCode);
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainQueryResult = this.queryRsResourceGoodsPage(map1);
        if (rsResourceGoodsReDomainQueryResult == null || CollectionUtils.isEmpty((Collection)rsResourceGoodsReDomainQueryResult.getList())) {
            this.logger.error("busdata.StoreBaseService.assWhOpstoreSkuDomain.rsResourceGoodsReDomainQueryResult.param", map1);
            return;
        }
        RsResourceGoodsReDomain rsResourceGoods = (RsResourceGoodsReDomain)rsResourceGoodsReDomainQueryResult.getList().get(0);
        whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
        whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
        whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
        whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
        whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
        whOpstoreGoodsDomain.setGoodsProperty1(rsResourceGoods.getGoodsProperty1());
        whOpstoreGoodsDomain.setGoodsProperty2(rsResourceGoods.getGoodsProperty2());
        whOpstoreGoodsDomain.setGoodsProperty3(rsResourceGoods.getGoodsProperty3());
        whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
        whOpstoreGoodsDomain.setMemberCode(rsResourceGoods.getMemberCode());
        whOpstoreGoodsDomain.setMemberName(rsResourceGoods.getMemberName());
        whOpstoreSkuDomain.setMemberCode(ComConstants.membercode);
        whOpstoreSkuDomain.setMemberName(ComConstants.membername);
        whOpstoreSkuDomain.setTenantCode(ComConstants.tenantCode);
        whOpstoreSkuDomain.setMemberBcode(whOpstoreGoodsDomain.getMemberBcode());
        whOpstoreSkuDomain.setPartsnameNumunit1("0");
        whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
    }

    private QueryResult<WhStoreSkuDomain> queryWhSku(final Map<String, Object> queryMap) {
        HashMap<String, Object> sendMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)queryMap));
            }
        };
        QueryResult queryResutl = this.getQueryResutl("wh.whStoreGoods.queryStoreSkuPage", sendMap, WhStoreSkuDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error("busdata.StoreBaseService.queryWhSku.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)sendMap));
            return null;
        }
        return queryResutl;
    }

    protected QueryResult<RsResourceGoodsReDomain> queryRsResourceGoodsPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("busdata.StoreBaseService.queryRsResourceGoodsPage.map");
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("rs.resourceGoods.queryResourceGoodsPage", paramMap, RsResourceGoodsReDomain.class);
    }

    private void saveLogError(final WhQoh whQoh, String memo) {
        final HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("clientType", "SKUSTORE");
                this.put("userCode", whQoh.getItemInfo_ItemCode());
            }
        };
        HashMap<String, Object> logParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)logMap));
            }
        };
        String logStr = this.internalInvoke("log.log.queryErrorLogPage", logParamMap);
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(logStr, SupQueryResult.class);
        final List logList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), LogErrorLog.class);
        if (!ListUtil.isEmpty((Collection)logList)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(){
                {
                    this.put("logErrorId", ((LogErrorLog)logList.get(0)).getLogErrorId());
                }
            };
            this.internalInvoke("log.log.deleteErrorLog", paramMap);
        }
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(ComConstants.tenantCode);
        logErrorLogDomain.setUserCode(whQoh.getItemInfo_ItemCode());
        logErrorLogDomain.setClientType("SKUSTORE");
        logErrorLogDomain.setErrorType("\u6599\u53f7\u5e93\u5b58");
        logErrorLogDomain.setClientExecuteMethod(memo);
        logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)whQoh));
        HashMap<String, Object> logSaveMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", JsonUtil.buildNormalBinder().toJson((Object)logErrorLogDomain));
            }
        };
        try {
            this.internalInvoke("log.log.saveErrorLog", logSaveMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

