/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.api.ExStoreService;
import com.yqbsoft.laser.service.ext.bus.data.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.log.LogErrorLogDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.U9SkuStore;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhQoh;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhStoreSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.bus.data.supbase.StoreBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ExStoreServiceImpl
extends StoreBaseService
implements ExStoreService {
    private String SYS_CODE = "busdata.ExStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExStoreServiceImpl.class);
    public static ThreadPoolExecutor itemThreadPoolExecutor = new ThreadPoolExecutor(16, 32, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public String sendSaveExWarehouse(WhWarehouseDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkWarehouse(whWarehouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.msg");
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.msg", msg);
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        whWarehouseDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        whWarehouseDomain.setMemberName("\u5e73\u53f0");
        try {
            String warehouseCode = this.saveWarehouse(whWarehouseDomain);
            if (StringUtils.isBlank((String)warehouseCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode");
                throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(warehouseCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e1", (Throwable)e);
            throw new ApiException(this.SYS_CODE + ".sendSaveExWarehouse.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExOpstore(WhOpstoreDomain whOpstoreDomain) {
        LogRouterlogDomain logRouterlogDomain = this.creteLogRouterlogDomain(JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain), "busdata.exStore.sendSaveExOpstore", null, "\u8c03\u62e8\u5355\u63a5\u53e3");
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            logRouterlogDomain.setRouterlogReturn("whOpstoreDomain\u53c2\u6570\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException("whOpstoreDomain\u53c2\u6570\u4e3a\u7a7a");
        }
        logRouterlogDomain.setAppmanageOicode(whOpstoreDomain.getOpstoreNcode());
        whOpstoreDomain.setTenantCode(ComConstants.tenantCode);
        whOpstoreDomain.setChannelCode(ComConstants.channelCode);
        whOpstoreDomain.setStoreGoodsBtype(ComConstants.storeGoodsBtype_d);
        whOpstoreDomain.setStoreType(ComConstants.storeType_1);
        String msg = this.checkOpstore(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.checkOpstore");
            logRouterlogDomain.setRouterlogReturn(msg);
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(msg);
        }
        try {
            msg = this.makeWhOpstoreDomain(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.makeWhOpstoreDomain", (Object)msg);
                logRouterlogDomain.setRouterlogReturn(msg);
                logRouterlogDomain.setRouterlogReturnstate("-1");
                logRouterlogDomain.setRouterlogReturnstates("error");
                this.sendLog(logRouterlogDomain);
                throw new ApiException(msg);
            }
            String opstoreCode = this.sendSaveOpstore(whOpstoreDomain);
            if (StringUtils.isBlank((String)opstoreCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.opstoreCode");
                logRouterlogDomain.setRouterlogReturn("opstoreCode.isnull");
                logRouterlogDomain.setRouterlogReturnstate("-1");
                logRouterlogDomain.setRouterlogReturnstates("error");
                this.sendLog(logRouterlogDomain);
                throw new ApiException("\u4fdd\u5b58\u5f02\u5e38");
            }
            logRouterlogDomain.setRouterlogReturn(this.makeSuccessReturn("success"));
            logRouterlogDomain.setRouterlogReturnstate("200");
            logRouterlogDomain.setRouterlogReturnstates("OK");
            this.sendLog(logRouterlogDomain);
            return this.makeSuccessReturn("success");
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e", (Throwable)e);
            logRouterlogDomain.setRouterlogReturn(e.getErrMsg());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            return this.makeErrorReturn("erorr", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e1", (Throwable)e);
            logRouterlogDomain.setRouterlogReturn(e.getMessage());
            logRouterlogDomain.setRouterlogReturnstate("-1");
            logRouterlogDomain.setRouterlogReturnstates("error");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(e.getMessage());
        }
    }

    @Override
    public WhWarehouseReDomain queryExOpstore(String warehouseCode, String warehouseOcode, String tenantCode) {
        return this.getWarehouse(warehouseCode, warehouseOcode, tenantCode, null);
    }

    private LocalDateTime getLocalDateTime(String datetimeStr) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return (LocalDateTime)df.parse(datetimeStr);
    }

    private String getStringlocalDateTime() {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime time = LocalDateTime.now();
        return df.format(time);
    }

    private LocalDateTime getInstantTime(Integer instantMins) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime sevenMinutesAgo = now.minusMinutes(instantMins.intValue());
        return sevenMinutesAgo;
    }

    @Override
    public String sendSaveBusOpstoreU9(String businessType) {
        if (StringUtils.isBlank((String)businessType)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.businessType", (Object)"businessType is null");
            throw new ApiException("businessType is null");
        }
        boolean pageIndex = true;
        int pageSize = 100000;
        LocalDateTime args = null;
        List<Object> whsFromU9 = new ArrayList();
        if ("1".equals(businessType)) {
            try {
                Date date = DateUtils.getDateToString((String)"2000-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
                ZoneId zoneId = ZoneId.systemDefault();
                Instant instant = date.toInstant();
                args = instant.atZone(zoneId).toLocalDateTime();
                whsFromU9 = SqlServerUtils.getForU9SaveStoreList("SELECT\n\titeminfo_itemcode,\n\tWhCode,\n\tWhName,\n\tOrgCode,\n\tSUM ( StoreQty ) StoreQty\nFROM\n\tCJ_V_WhQoh \nWHERE\n\tCreatedOn >= ? \n\t and StoreQty >0 \nGROUP BY\n\titeminfo_itemcode,\n\tWhCode,WhName,OrgCode;", args);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898+e: " + e));
                throw new ApiException("sql is error");
            }
        }
        args = this.getInstantTime(4);
        try {
            List<U9SkuStore> list = SqlServerUtils.getForU9SaveStoreSkuList("SELECT\n\titeminfo_itemcode,WhCode\nFROM\n\tCJ_V_WhQoh \nWHERE\n\tCreatedOn >= ? \nGROUP BY\n\titeminfo_itemcode,WhCode;\n", args);
            if (CollectionUtils.isNotEmpty(list)) {
                List<String> list2 = list.stream().map(u -> u.getSkuNo()).collect(Collectors.toList());
                String sql = this.pullSkuSaveBySql(list2);
                List<WhQoh> whsFromU91 = SqlServerUtils.getForU9SaveStoreListNew(sql);
                for (WhQoh whQoh : whsFromU91) {
                    List collect = list.stream().filter(u -> u.getSkuNo().equals(whQoh.getItemInfo_ItemCode()) && u.getWhCode().equals(whQoh.getWhCode())).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(collect)) continue;
                    whsFromU9.add(whQoh);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898add +e: " + e));
            throw new ApiException("sql is error");
        }
        ArrayList whsFromU9Update = new ArrayList();
        try {
            List<U9SkuStore> list = SqlServerUtils.getForU9UpdateSkuList("SELECT\n\titeminfo_itemcode,WhCode\nFROM\n\tCJ_V_WhQoh \nWHERE\n\tModifiedOn >= ? \nGROUP BY\n\titeminfo_itemcode,WhCode;\n", args);
            if (CollectionUtils.isNotEmpty(list)) {
                List<String> skuNoList = list.stream().map(u -> u.getSkuNo()).collect(Collectors.toList());
                String sql = this.pullSkuUpdateBySql(skuNoList);
                List<WhQoh> whsFromU9Update1 = SqlServerUtils.getForStoreList(sql);
                for (WhQoh whQoh : whsFromU9Update1) {
                    List collect = list.stream().filter(u -> u.getSkuNo().equals(whQoh.getItemInfo_ItemCode()) && u.getWhCode().equals(whQoh.getWhCode())).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(collect)) continue;
                    whsFromU9.add(whQoh);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898update +e: " + exception));
            throw new ApiException("sql is error");
        }
        if (ListUtil.isNotEmpty(whsFromU9)) {
            for (final WhQoh whQoh : whsFromU9) {
                itemThreadPoolExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ExStoreServiceImpl.this.makeWhOpstoreDomain1(whQoh, "0", ComConstants.storeGoodsBtype_t);
                    }
                });
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.makeSuccessReturn("\u5e93\u5b58\u6539\u53d8\u6210\u529f!");
    }

    private String pullSkuUpdateBySql(List<String> skuList) {
        String sql = "SELECT\n\titeminfo_itemcode,\n\tWhCode,\n\tWhName,\n\tOrgCode,\n\tSUM ( StoreQty ) StoreQty\nFROM\n\tCJ_V_WhQoh \nWHERE\n\titeminfo_itemcode in ( ";
        for (int i = 0; i < skuList.size(); ++i) {
            sql = i == skuList.size() - 1 ? sql + "'" + skuList.get(i) + "') GROUP BY iteminfo_itemcode,WhCode,WhName,OrgCode;" : sql + "'" + skuList.get(i) + "',";
        }
        return sql;
    }

    private String pullSkuSaveBySql(List<String> skuList) {
        String sql = "SELECT\n\titeminfo_itemcode,\n\tWhCode,\n\tWhName,\n\tOrgCode,\n\tSUM ( StoreQty ) StoreQty\nFROM\n\tCJ_V_WhQoh \nWHERE\n\titeminfo_itemcode in ( \n";
        for (int i = 0; i < skuList.size(); ++i) {
            sql = i == skuList.size() - 1 ? sql + "'" + skuList.get(i) + "') GROUP BY iteminfo_itemcode,WhCode,WhName,OrgCode;" : sql + "'" + skuList.get(i) + "',";
        }
        return sql;
    }

    private void saveLogError(InternalRouter internalRouter, WhQoh whQoh, String clientType, String tenantCode, String clientExecuteMethod, Exception e) {
        final LogErrorLogDomain logErrorLogDomain = new LogErrorLogDomain();
        logErrorLogDomain.setTenantCode(tenantCode);
        logErrorLogDomain.setUserCode(whQoh.getItemInfo_ItemCode());
        logErrorLogDomain.setClientType(clientType);
        logErrorLogDomain.setClientExecuteMethod("clientExecuteMethod: " + clientExecuteMethod + "errorMsg: " + e);
        logErrorLogDomain.setErrorLogMessage(JsonUtil.buildNonDefaultBinder().toJson((Object)whQoh));
        HashMap<String, Object> logMap = new HashMap<String, Object>(){
            {
                this.put("logErrorLogDomain", JsonUtil.buildNormalBinder().toJson((Object)logErrorLogDomain));
            }
        };
        internalRouter.inInvoke("log.log.saveErrorLog", (Map)logMap);
    }

    private void queryWhStoreSkuAndUpate(InternalRouter internalRouter, WhQoh whQoh) throws Exception {
        WhStoreSkuDomain whStoreSkuDomainOld = this.queryWhStoreSkuDomain(internalRouter, whQoh);
        WhStoreSkuDomain whStoreSkuDomainNew = this.buildWhStoreSku(whQoh);
        boolean isUpdate = false;
        if (null == whStoreSkuDomainOld) {
            this.saveWhStoreSkuDomain(internalRouter, whStoreSkuDomainNew);
        } else {
            this.updateWhStoreSkuDomain(internalRouter, whStoreSkuDomainOld, whStoreSkuDomainNew, isUpdate);
            if (isUpdate) {
                this.saveLogRouterLog(internalRouter, whStoreSkuDomainOld, whStoreSkuDomainNew);
            }
        }
    }

    private void updateWhStoreSkuDomain(InternalRouter internalRouter, final WhStoreSkuDomain whStoreSkuDomainOld, WhStoreSkuDomain whStoreSkuDomainNew, boolean isUpdate) throws Exception {
        if (whStoreSkuDomainOld.getGoodsSupplynum().compareTo(whStoreSkuDomainNew.getGoodsSupplynum()) != 0) {
            isUpdate = true;
            BigDecimal oldGoodsSupplynum = whStoreSkuDomainOld.getGoodsSupplynum();
            whStoreSkuDomainOld.setGoodsSupplynum(whStoreSkuDomainNew.getGoodsSupplynum());
            HashMap<String, Object> map = new HashMap<String, Object>(){
                {
                    this.put("rsStoreSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomainOld));
                }
            };
            logger.error(this.SYS_CODE + ".updateWhStoreSkuDomain\u3002\u4fee\u6539\u5e93\u5b58\u5f00\u59cb", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomainOld));
            internalRouter.inInvoke("wh.whStoreGoods.updateStoreSku", (Map)map);
            logger.error(this.SYS_CODE + ".updateWhStoreSkuDomain.\u4fee\u6539\u5e93\u5b58\u7ed3\u675f");
            whStoreSkuDomainOld.setGoodsSupplynum(oldGoodsSupplynum);
        }
    }

    private WhStoreSkuDomain queryWhStoreSkuDomain(InternalRouter internalRouter, WhQoh whQoh) {
        final HashMap<String, String> whStoreMap = new HashMap<String, String>();
        if (null != whQoh.getItemInfo_ItemCode()) {
            whStoreMap.put("skuNo", whQoh.getItemInfo_ItemCode());
        }
        if (null != whQoh.getWhCode()) {
            whStoreMap.put("warehouseCode2", whQoh.getWhCode());
        }
        HashMap<String, Object> whStoreParamMap = new HashMap<String, Object>(){
            {
                this.put("map", JsonUtil.buildNormalBinder().toJson((Object)whStoreMap));
            }
        };
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain", (Object)"\u67e5\u8be2storeSku\u5f00\u59cb");
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain.whStoreParamMap", (Object)JsonUtil.buildNormalBinder().toJson((Object)whStoreParamMap));
        String storeSkuListStr = (String)internalRouter.inInvoke("wh.whStoreGoods.queryStoreSkuPage", (Map)whStoreParamMap);
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain", (Object)"\u67e5\u8be2storeSku\u7ed3\u675f");
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(storeSkuListStr, SupQueryResult.class);
        if (null == supQueryResult) {
            logger.error(this.SYS_CODE + ".supQueryResult", (Object)"supQueryResult is null");
            return null;
        }
        List storeSkuList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhStoreSkuDomain.class);
        if (null == storeSkuList || ListUtil.isEmpty((Collection)storeSkuList)) {
            logger.error(this.SYS_CODE + ".storeSkuList", (Object)"storeSkuList is null");
            return null;
        }
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain.storeSkuList", (Object)JsonUtil.buildNormalBinder().toJson((Object)storeSkuList));
        logger.error(this.SYS_CODE + ".queryWhStoreSkuDomain...", (Object)"\u67e5\u8be2storeSku\u7ed3\u675f");
        return (WhStoreSkuDomain)storeSkuList.get(0);
    }

    private void saveLogRouterLog(InternalRouter internalRouter, WhStoreSkuDomain oldWhStoreDomain, WhStoreSkuDomain newWhStoreDomain) throws Exception {
        final LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setTenantCode(oldWhStoreDomain.getTenantCode());
        logRouterlogDomain.setRouterType("5");
        logRouterlogDomain.setRouterlogMessage("oldWhStoreDomain " + JsonUtil.buildNormalBinder().toJson((Object)oldWhStoreDomain) + " | newWhStoreDomain\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)newWhStoreDomain));
        HashMap<String, Object> batchSaveUpMap = new HashMap<String, Object>(){
            {
                this.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveLogRouterLog", (Object)("saveLogRouterLog logRouterlogDomain: " + JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain)));
        internalRouter.inInvoke("log.logRouterlog.saveRouterlog", (Map)batchSaveUpMap);
        logger.error(this.SYS_CODE + ".saveLogRouterLog", (Object)"saveLogRouterLog\u7ed3\u675f");
    }

    private void saveWhStoreSkuDomain(InternalRouter internalRouter, final WhStoreSkuDomain whStoreSkuDomain) throws Exception {
        HashMap<String, Object> whSkuMap = new HashMap<String, Object>(){
            {
                this.put("rsStoreSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomain));
            }
        };
        logger.error(this.SYS_CODE + ".saveWhStoreSkuDomain", (Object)("\u4fdd\u5b58saveRsStoreSkuDomain\u5f00\u59cb rsStoreSkuDomain: " + JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuDomain)));
        internalRouter.inInvoke("wh.whStoreGoods.saveStoreSku", (Map)whSkuMap);
        logger.error(this.SYS_CODE + ".saveWhStoreSkuDomain", (Object)"\u4fdd\u5b58saveRsStoreSkuDomain\u7ed3\u675f");
    }

    private WhStoreSkuDomain buildWhStoreSku(final WhQoh whQoh) throws Exception {
        final String tenantCode = "728243877368496147";
        HashMap<String, Object> skuMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("skuEocode", whQoh.getItemInfo_ItemCode());
            }
        };
        QueryResult<RsSkuDomain> rsSkuDomainQueryResult = this.queryRsSkuPage((Map<String, Object>)skuMap);
        logger.error(this.SYS_CODE + ".buildWhStoreSku.rsSkuDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(rsSkuDomainQueryResult));
        if (null == rsSkuDomainQueryResult || ListUtil.isEmpty((Collection)rsSkuDomainQueryResult.getList())) {
            throw new RuntimeException("sku is null skuEocde: " + whQoh.getItemInfo_ItemCode());
        }
        final RsSkuDomain rsSkuDomain = (RsSkuDomain)rsSkuDomainQueryResult.getList().get(0);
        HashMap<String, Object> goodsMap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", tenantCode);
                this.put("goodsEocode", rsSkuDomain.getGoodsEocode());
            }
        };
        QueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainQueryResult = this.queryRsResourceGoodsPage((Map<String, Object>)goodsMap);
        logger.error(this.SYS_CODE + ".buildWhStoreSku.rsResourceGoodsReDomainQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsReDomainQueryResult));
        if (null == rsResourceGoodsReDomainQueryResult || ListUtil.isEmpty((Collection)rsResourceGoodsReDomainQueryResult.getList())) {
            throw new RuntimeException("goods is null goodsEocode: " + rsSkuDomain.getGoodsEocode());
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)rsResourceGoodsReDomainQueryResult.getList().get(0);
        WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
        BeanUtils.copyAllPropertysNotNull((Object)whStoreSkuDomain, (Object)rsSkuDomain);
        BeanUtils.copyAllPropertysNotNull((Object)whStoreSkuDomain, (Object)rsResourceGoodsReDomain);
        whStoreSkuDomain.setTenantCode(tenantCode);
        whStoreSkuDomain.setSkuNo(whQoh.getItemInfo_ItemCode());
        whStoreSkuDomain.setSkuName(whQoh.getItemInfo_ItemName());
        whStoreSkuDomain.setWarehouseName(whQoh.getWhName());
        whStoreSkuDomain.setWarehouseCode2(whQoh.getWhCode());
        whStoreSkuDomain.setGoodsSupplynum(new BigDecimal(whQoh.getStoreQty()));
        return whStoreSkuDomain;
    }

    @Override
    public String sendSaveExOpstoreByEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.tenantCode", (Object)tenantCode);
        if (MapUtil.isEmpty(resStream)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), WhOpstoreDomain.class);
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreCode())) {
            whOpstoreDomain.setOpstoreNcode(whOpstoreDomain.getOpstoreCode());
            whOpstoreDomain.setOpstoreCode(null);
        }
        whOpstoreDomain.setTenantCode(tenantCode);
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.storeGoodsType", "\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "whOpstoreSkuDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
        QueryResult<WhOpstoreReDomain> queryResult = this.queryOpstorePage(map);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.opstoreOcode", "\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
        }
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.skuNo", "skuNo\u53c2\u6570\u4e3a\u7a7a");
            }
            if (null == whOpstoreSkuDomain.getGoodsNum()) {
                throw new ApiException(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.goodsNum", "goodsNum\u53c2\u6570\u4e3a\u7a7a");
            }
            whOpstoreSkuDomain.setTenantCode(tenantCode);
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        }
        String code = this.sendSaveOpstoreTwo(whOpstoreDomain);
        return this.makeSuccessReturn(code);
    }

    private String makeWhOpstoreDomain(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreDomain");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)whOpstoreDomain.getOpstoreOcode())) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreDomain");
            return "opstoreOcode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        HashMap<String, WhWarehouseReDomain> waMap = new HashMap<String, WhWarehouseReDomain>();
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreGoodsDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
            return "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            if (StringUtils.isEmpty((String)whOpstoreGoodsDomain.getWarehouseCode())) {
                return "\u4ed3\u5e93\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
            }
            if (StringUtils.isEmpty((String)whOpstoreGoodsDomain.getWarehouseName())) {
                return "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
            }
            WhWarehouseReDomain whWarehouseReDomain = null;
            String s = whOpstoreGoodsDomain.getWarehouseCode() + whOpstoreGoodsDomain.getWarehouseName();
            whWarehouseReDomain = waMap.containsKey(s) ? (WhWarehouseReDomain)waMap.get(s) : this.getWarehouse(whOpstoreGoodsDomain.getWarehouseCode(), null, whOpstoreDomain.getTenantCode(), whOpstoreGoodsDomain.getWarehouseName());
            if (whWarehouseReDomain == null) {
                return "\u4ed3\u5e93\u7f16\u7801" + whOpstoreGoodsDomain.getWarehouseCode() + "\u672a\u67e5\u8be2\u5230\u6570\u636e! ";
            }
            waMap.put(s, whWarehouseReDomain);
            whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
            whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            String warehouseCode = whWarehouseReDomain.getWarehouseCode();
            String warehouseName = whWarehouseReDomain.getWarehouseName();
            whOpstoreGoodsDomain.setWarehouseCode(warehouseCode);
            whOpstoreGoodsDomain.setWarehouseName(warehouseName);
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreSkuDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
                return "whOpstoreSkuDomainList\u4e3a\u7a7a! ";
            }
            if (whOpstoreDomain.getStoreGoodsType().equals(ComConstants.storeGoodsType_3)) {
                whOpstoreGoodsDomain.setOpstoreDir("0");
            } else if (whOpstoreDomain.getStoreGoodsType().equals(ComConstants.storeGoodsType_4) || whOpstoreDomain.getStoreGoodsType().equals(ComConstants.storeGoodsType_20)) {
                whOpstoreGoodsDomain.setOpstoreDir("1");
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                String goodsWeightstr = whOpstoreSkuDomain.getGoodsWeightstr();
                if (StringUtils.isEmpty((String)whOpstoreSkuDomain.getSkuNo())) {
                    return "\u6599\u53f7\u4e0d\u80fd\u4e3a\u7a7a! ";
                }
                BigDecimal goodsNum = whOpstoreSkuDomain.getGoodsNum();
                paramMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                paramMap.put("channelCode", ComConstants.channelCode);
                paramMap.put("tenantCode", whOpstoreDomain.getTenantCode());
                QueryResult<RsSkuDomain> queryResutl = this.queryRsSkuPage(paramMap);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.queryResutl", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "sku\u4e3a\u7a7a! " + paramMap.toString();
                }
                rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), whOpstoreDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.rsResourceGoodsReDomain", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                try {
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                if (whOpstoreDomain.getStoreGoodsType().equals("3")) {
                    whOpstoreSkuDomain.setOpstoreDir("0");
                } else if (whOpstoreDomain.getStoreGoodsType().equals("4") || whOpstoreDomain.getStoreGoodsType().equals("20")) {
                    whOpstoreSkuDomain.setOpstoreDir("1");
                }
                if (StringUtils.isBlank((String)goodsWeightstr)) {
                    whOpstoreSkuDomain.setGoodsWeightstr(null);
                } else {
                    whOpstoreSkuDomain.setGoodsWeightstr(goodsWeightstr);
                }
                whOpstoreSkuDomain.setGoodsNum(goodsNum);
                whOpstoreSkuDomain.setOpstoreGoodsEocode(whOpstoreDomain.getOpstoreNcode());
                whOpstoreSkuDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, rsResourceGoodsReDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copyspu", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u7cfb\u7edf\u5f02\u5e38! ";
            }
            whOpstoreGoodsDomain.setWarehouseCode(warehouseCode);
            whOpstoreGoodsDomain.setWarehouseName(warehouseName);
            whOpstoreGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            whOpstoreGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
        }
        return null;
    }

    private WhWarehouseReDomain getWarehouse(String warehouseCode, String warehouseOcode, String tenantCode, String warehouseName) {
        WhWarehouseReDomain whWarehouseReDomain;
        if (StringUtils.isBlank((String)warehouseCode)) {
            Map map = this.getQueryMapParam("warehouseOcode", new Object[]{warehouseOcode, tenantCode});
            QueryResult<WhWarehouseReDomain> qwh = this.queryWarehousePage(map);
            if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
                logger.error(this.SYS_CODE + ".getWarehouse.getWarehouseCode", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
            if (qwh.getList().size() > 1) {
                logger.error(this.SYS_CODE + ".getWarehouse.qwh", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u5f02\u5e38");
            }
            whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("warehouseName", warehouseName);
            map.put("warehouseCode", warehouseCode);
            map.put("tenantCode", tenantCode);
            map.put("fuzzy", true);
            QueryResult<WhWarehouseReDomain> qwh = this.queryWarehousePage(map);
            if (null == qwh || CollectionUtils.isEmpty((Collection)qwh.getList())) {
                logger.error(this.SYS_CODE + ".getWarehouse.whWarehouseReDomain", (Object)(warehouseCode + "=" + tenantCode));
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
            whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        }
        return whWarehouseReDomain;
    }

    private String checkOpstore(WhOpstoreDomain whOpstoreDomain) {
        QueryResult<WhOpstoreReDomain> qwh;
        if (null == whOpstoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreWhlocal())) {
            msg = msg + "storeWhlocal\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            msg = msg + "opstoreOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u4e3a\u7a7a! ";
        } else if (!"3,4,20".contains(whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u5f02\u5e38[" + whOpstoreDomain.getStoreGoodsType() + "]! ";
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreOcode()) && null != (qwh = this.queryOpstorePage(this.getQueryMapParam("opstoreOcode,tenantCode", new Object[]{whOpstoreDomain.getOpstoreOcode(), whOpstoreDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qwh.getList())) {
            msg = msg + "opstoreOcode[" + whOpstoreDomain.getOpstoreOcode() + "]\u91cd\u590d! ";
            return msg;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            msg = msg + "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
            return msg;
        }
        int i = 0;
        int j = 0;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            ++i;
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseName())) {
                msg = msg + "\u7b2c" + i + "\u884cwarehouseName\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode())) {
                msg = msg + "\u7b2c" + i + "\u884cwarehouseCode\u4e3a\u7a7a! ";
            }
            whOpstoreGoodsDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                msg = msg + "\u7b2c" + i + "\u884cwhOpstoreSkuDomainList\u4e3a\u7a7a! ";
                return msg;
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                ++j;
                whOpstoreSkuDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (null != whOpstoreSkuDomain.getGoodsNum()) continue;
                msg = msg + "\u7b2c" + i + "-" + j + "\u884cgoodsNum\u4e3a\u7a7a! ";
            }
        }
        return msg;
    }

    private String checkWarehouse(WhWarehouseDomain whWarehouseDomain) {
        QueryResult<WhWarehouseReDomain> qlist;
        if (null == whWarehouseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseOcode())) {
            msg = msg + "warehouseOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)whWarehouseDomain.getWarehouseOcode()) && null != (qlist = this.queryWarehousePage(this.getQueryMapParam("warehouseOcode,tenantCode", new Object[]{whWarehouseDomain.getWarehouseOcode(), whWarehouseDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "warehouseOcode[" + whWarehouseDomain.getWarehouseOcode() + "]\u91cd\u590d! ";
        }
        return msg;
    }

    @Override
    public String querySkuStoreFromU9(String skuNo) {
        if (StringUtils.isBlank((String)skuNo)) {
            logger.error(this.SYS_CODE + ".querySkuStoreFromU9.skuNo", (Object)"skuNo is null");
            throw new ApiException("skuNo is null");
        }
        if (skuNo.contains(",")) {
            for (String s : skuNo.split(",")) {
                this.pullStoreSkuBySkuNo(s);
            }
        } else {
            this.pullStoreSkuBySkuNo(skuNo);
        }
        return this.makeSuccessReturn("\u5e93\u5b58\u6539\u53d8\u6210\u529f!");
    }

    private void pullStoreSkuBySkuNo(String skuNo) {
        List<Object> whsFromU9 = new ArrayList();
        try {
            whsFromU9 = SqlServerUtils.getForU9SkuStoreList("SELECT\n\titeminfo_itemcode,\n\tWhCode,\n\tWhName,\n\tOrgCode,\n\tSUM ( StoreQty ) StoreQty\nFROM\n\tCJ_V_WhQoh \nWHERE\n\titeminfo_itemcode = ? \nGROUP BY\n\titeminfo_itemcode,\n\tWhCode,\n\tWhName,\n\tOrgCode\n", skuNo);
            if (ListUtil.isNotEmpty(whsFromU9)) {
                for (final WhQoh whQoh : whsFromU9) {
                    itemThreadPoolExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ExStoreServiceImpl.this.makeWhOpstoreDomain1(whQoh, "0", ComConstants.storeGoodsBtype_t);
                        }
                    });
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898+e: " + e));
            throw new ApiException("sql is error");
        }
    }
}

