/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.u9.WhQoh;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhOpstoreRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhWarehouseRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhOpstoreResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhWarehouseResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusStoreService;
import com.yqbsoft.laser.service.ext.bus.data.service.impl.ExStoreServiceImpl;
import com.yqbsoft.laser.service.ext.bus.data.supbase.StoreBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.SqlServerUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BusStoreServiceImpl
extends StoreBaseService
implements BusStoreService {
    private String SYS_CODE = "busdata.BusStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusStoreServiceImpl.class);
    private String ddcode = "store";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusWarehouse(WhWarehouseReDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseDomain");
            return "error";
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        WhWarehouseRequest whWarehouseRequest = new WhWarehouseRequest();
        whWarehouseRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)whWarehouseRequest, (Object)whWarehouseDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Throwable)e);
            return "error";
        }
        WhWarehouseResponse whWarehouseResponse = this.restTempfacade.execute(whWarehouseRequest);
        if (null == whWarehouseResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse");
            return "error";
        }
        if (!whWarehouseResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusWarehouse.whWarehouseResponse", (Object)whWarehouseResponse.getMsg());
            return whWarehouseResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusOpstore(WhOpstoreReDomain whOpstoreReDomain) {
        if (null == whOpstoreReDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOpstore.WhWarehouseDomain");
            return "error";
        }
        String tenantCode = whOpstoreReDomain.getTenantCode();
        WhOpstoreRequest whOpstoreRequest = new WhOpstoreRequest();
        whOpstoreRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreRequest, (Object)whOpstoreReDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.e", (Object)e);
            return "error";
        }
        WhOpstoreResponse whOpstoreResponse = this.restTempfacade.execute(whOpstoreRequest);
        if (null == whOpstoreResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse");
            return "error";
        }
        if (!whOpstoreResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusOpstore.whOpstoreResponse", (Object)whOpstoreResponse.getMsg());
            return whOpstoreResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String pullSkuStoreBySkuNoFromU9(String skuNo) {
        if (StringUtils.isBlank((String)skuNo)) {
            logger.error(this.SYS_CODE + ".pullSkuStoreBySkuNoFromU9.skuNo", (Object)"skuNo is null");
            throw new ApiException("skuNo is null");
        }
        try {
            List<WhQoh> whsFromU9 = SqlServerUtils.getForU9SaveStoreList("SELECT\n            iteminfo_itemcode,\n            WhCode,\n            WhName,\n            OrgCode,\n            SUM ( StoreQty ) StoreQty\n            FROM\n            CJ_V_WhQoh \n            WHERE\n            iteminfo_itemcode = ? \n            GROUP BY\n            iteminfo_itemcode,\n            WhCode,WhName,OrgCode;", skuNo);
            if (ListUtil.isNotEmpty(whsFromU9)) {
                for (final WhQoh whQoh : whsFromU9) {
                    ExStoreServiceImpl.itemThreadPoolExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            BusStoreServiceImpl.this.makeWhOpstoreDomain1(whQoh, "0", ComConstants.storeGoodsBtype_t);
                        }
                    });
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.SYS_CODE + ".sendSaveBusOpstoreU9.whsFromU9", (Object)("\u89c6\u56fe\u6709\u95ee\u9898+e: " + e));
            throw new ApiException("sql is error");
        }
        return "success";
    }
}

