/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.exdate.common.enums.ApiCodeEnums;
import com.yqbsoft.laser.service.exdate.common.enums.ResultEnums;
import com.yqbsoft.laser.service.exdate.common.enums.UrlEnums;
import com.yqbsoft.laser.service.exdate.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.exdate.facade.http.Httpfacade;
import com.yqbsoft.laser.service.exdate.facade.request.AydRsClassTreeRequest;
import com.yqbsoft.laser.service.exdate.facade.request.AydStoreInfoRequest;
import com.yqbsoft.laser.service.exdate.facade.response.AydRsClassTreeResponse;
import com.yqbsoft.laser.service.exdate.service.AydRsClassTreeService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="aydRsClassTreeService")
public class AydRsClassTreeServiceImpl
extends BaseServiceImpl
implements AydRsClassTreeService {
    private static final String SYS_CODE = "ayd.RsClassTreeServiceImpl";

    @Override
    public String queryclassTree(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("ayd.RsClassTreeServiceImpl.queryclassTree.null");
            return ResultEnums.error.getCode();
        }
        AydRsClassTreeRequest classTreeRequest = new AydRsClassTreeRequest();
        String url = AydRsClassTreeRequest.getUrl(tenantCode, "aydSynUrl", "url");
        String aydSynFlag = AydStoreInfoRequest.getUrl(tenantCode, "aydSynFlag", "url");
        this.logger.error("ayd.RsClassTreeServiceImpl====url=====aydSynFlag===", (Object)("====" + url + "=====" + aydSynFlag + "==="));
        Httpfacade httpfacade = new Httpfacade(url);
        classTreeRequest.setTopHttpMethod(UrlEnums.classTree.getUrlMethed());
        AydRsClassTreeResponse execute = httpfacade.execute(classTreeRequest);
        List<RsClasstreeDomain> rsClasstreeList = execute.getRsClasstreeList();
        if (ListUtil.isEmpty(rsClasstreeList)) {
            this.logger.error("ayd.RsClassTreeServiceImpl.queryStoreInfo.umUserinfoDomainBeanList");
            return ResultEnums.error.getCode();
        }
        for (RsClasstreeDomain rsClasstreeDomain : rsClasstreeList) {
            rsClasstreeDomain.setTenantCode(tenantCode);
        }
        HashMap<String, String> userinfoMap = new HashMap<String, String>();
        userinfoMap.put("rsClasstreeDomains", JsonUtil.buildNormalBinder().toJson(rsClasstreeList));
        this.internalInvoke(ApiCodeEnums.saveClasstreeList.getApiCode(), userinfoMap);
        return ResultEnums.success.getCode();
    }
}

