/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.exdate.test.GneteGatewayRequestUtils;
import com.yqbsoft.laser.service.exdate.test.HttpUtils;
import java.awt.Desktop;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OpenAcctDemoMain {
    private static final String ZIP_PATH = "src\\main\\resources\\1.zip";
    private static final String JUMP_TYPE = "10";

    public static void main(String[] args) throws Exception {
        OpenAcctDemoMain.disableSslVerification();
        String uploadUrl = OpenAcctDemoMain.requestUploadUrl();
        String fileId = OpenAcctDemoMain.uploadZipFile(uploadUrl + "&fileName=demo.zip", ZIP_PATH);
        String jumpUrl = OpenAcctDemoMain.requestRegisterTicket(fileId);
        System.out.println("Register jump url: " + jumpUrl + "&mobileNo=15534551565");
        OpenAcctDemoMain.browse(jumpUrl + "&mobileNo=15534551565");
    }

    private static String requestUploadUrl() throws IOException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("jumpType", "12");
        JSONObject ret = GneteGatewayRequestUtils.callGneteGateway("gnete.wextbc.WextbcTradeRpcService.applyTicket", JSON.toJSONString(params));
        return ret.getJSONObject("response").getString("jumpUrl");
    }

    private static String uploadZipFile(String url, String path) throws IOException {
        String ret = OpenAcctDemoMain.upload(url, path);
        return JSON.parseObject((String)ret).getJSONObject("result").getString("fileId");
    }

    private static String requestRegisterTicket(String fileId) throws IOException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("jumpType", JUMP_TYPE);
        params.put("callbackUrl", "https://easylinkpay.gnete.com/callbackUrl");
        params.put("notifyUrl", "https://easylinkpay.gnete.com/notifyUrl");
        params.put("regInfoFileId", fileId);
        JSONObject ret = GneteGatewayRequestUtils.callGneteGateway("gnete.wextbc.WextbcTradeRpcService.applyTicket", JSON.toJSONString(params));
        return ret.getJSONObject("response").getString("jumpUrl");
    }

    public static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String upload(String url, String filePath) throws IOException {
        System.out.println("Upload " + filePath + " -> " + url);
        String ret = HttpUtils.post(url, new FileInputStream(filePath), "application/zip");
        System.out.println("Upload success: " + ret);
        return ret;
    }

    private static void browse(String url) {
        try {
            URI uri = new URI(url);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

