/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exdate.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.exdate.test.CryptoUtils;
import com.yqbsoft.laser.service.exdate.test.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public abstract class GneteGatewayRequestUtilsTest {
    public static JSONObject callGneteGateway(String method, String bizContent, String APP_ID, String SIGN_ALG, String MCT_PRIVATE_KEY_PATH, String MCT_PRIVATE_KEY_PWD, String GNETE_GATEWAY_URL, String GNETE_GATEWAY_PUBLIC_KEY_PATH) throws IOException {
        bizContent = URLEncoder.encode(bizContent, "UTF-8");
        String requestBody = GneteGatewayRequestUtilsTest.buildRequestBody(method, bizContent, APP_ID);
        requestBody = GneteGatewayRequestUtilsTest.sign(requestBody, SIGN_ALG, MCT_PRIVATE_KEY_PATH, MCT_PRIVATE_KEY_PWD);
        System.out.println("-------------------------Request [" + method + "]-------------------------");
        System.out.println("\u53c2\u6570================" + URLDecoder.decode(requestBody, "UTF-8"));
        System.out.println();
        String result = HttpUtils.post(GNETE_GATEWAY_URL, requestBody);
        System.out.println(result);
        GneteGatewayRequestUtilsTest.verifySign(result, GNETE_GATEWAY_PUBLIC_KEY_PATH, SIGN_ALG);
        return JSON.parseObject((String)result);
    }

    private static String buildRequestBody(String method, String bizContent, String APP_ID) {
        String timestamp = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        return "app_id=" + APP_ID + "&timestamp=" + timestamp + "&method=" + method + "&v=1.0.1&biz_content=" + bizContent + "&sign_alg=0";
    }

    private static String sign(String requestBody, String SIGN_ALG, String MCT_PRIVATE_KEY_PATH, String MCT_PRIVATE_KEY_PWD) {
        PrivateKey MCT_PRIVATE_KEY = CryptoUtils.initPrivateKeyFromFile(new File(MCT_PRIVATE_KEY_PATH), MCT_PRIVATE_KEY_PWD);
        String signature = CryptoUtils.sign(SIGN_ALG, requestBody, MCT_PRIVATE_KEY, "UTF-8");
        return requestBody + "&sign=" + signature;
    }

    private static void verifySign(String responseBody, String GNETE_GATEWAY_PUBLIC_KEY_PATH, String SIGN_ALG) {
        PublicKey GNETE_GATEWAY_PUBLIC_KEY;
        int index = responseBody.lastIndexOf("sign");
        String sign = responseBody.substring(index + 7, responseBody.length() - 2);
        String source = responseBody.substring(0, index - 2) + "}";
        boolean pass = CryptoUtils.verifySign(SIGN_ALG, source, sign, GNETE_GATEWAY_PUBLIC_KEY = CryptoUtils.initPublicKeyFromFile(new File(GNETE_GATEWAY_PUBLIC_KEY_PATH)), "UTF-8");
        if (!pass) {
            throw new RuntimeException("\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
        }
    }
}

