/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.huifu.util;

import com.yqbsoft.laser.service.ext.channel.huifu.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.ext.channel.huifu.util.SHA1Utils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClientUtil {
    private static OkHttpClient client = OKHttpClientUtil.getOkHttpClirnt();
    private static MediaType mediaType = MediaType.parse((String)"application/json;charset=utf-8");
    private static String postJson = "secretKey=%s&timestamp=%s&path=%s&body=%s";
    private static String getJson = "secretKey=%s&timestamp=%s&path=%s";
    private static String tokenStr = "token";
    private static String accesskeyStr = "accesskey";
    private static String timestampStr = "timestamp";

    public static String post(String url, Map<String, Object> map, String secretKey, String accesskey, String path) {
        String bodyjson = JsonUtil.buildNormalBinder().toJson(map);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)bodyjson);
        String timestamp = String.valueOf(System.currentTimeMillis());
        String json = String.format(postJson, secretKey, timestamp, path, bodyjson);
        String token = SHA1Utils.getSha1(json);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader(tokenStr, token).addHeader(accesskeyStr, accesskey).addHeader(timestampStr, timestamp).post(body);
        Request request = requestBuilder.build();
        Response response = null;
        String stringTemp = null;
        try {
            response = client.newCall(request).execute();
            stringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringTemp;
    }

    public static String get(String url, String secretKey, String accesskey, String path) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String json = String.format(getJson, secretKey, timestamp, path);
        String token = SHA1Utils.getSha1(json);
        System.out.println(token);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader(tokenStr, token).addHeader(accesskeyStr, accesskey).addHeader(timestampStr, timestamp);
        Request request = requestBuilder.build();
        Response response = null;
        String stringTemp = null;
        try {
            response = client.newCall(request).execute();
            stringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringTemp;
    }
}

