/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wms.utils.supportUtils;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpiUtils {
    private static final Log log = LogFactory.getLog(SpiUtils.class);
    private static final String TOP_SIGN_LIST = "top-sign-list";
    private static final String[] HEADER_FIELDS_IP = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static Map<String, String> getHeaderMap(HttpServletRequest request, String charset) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String signList = request.getHeader(TOP_SIGN_LIST);
        if (!StringUtils.isEmpty((String)signList)) {
            String[] keys;
            String[] var5 = keys = signList.split(",");
            int var6 = keys.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                String key = var5[var7];
                String value = request.getHeader(key);
                if (StringUtils.isEmpty((String)value)) {
                    headerMap.put(key, "");
                    continue;
                }
                headerMap.put(key, URLDecoder.decode(value, charset));
            }
        }
        return headerMap;
    }

    public static Map<String, String> getQueryMap(String queryString, String charset) throws IOException {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; ++i) {
            String key;
            String[] kv = params[i].split("=");
            if (kv.length == 2) {
                key = URLDecoder.decode(kv[0], charset);
                String value = URLDecoder.decode(kv[1], charset);
                queryMap.put(key, value);
                continue;
            }
            if (kv.length != 1) continue;
            key = URLDecoder.decode(kv[0], charset);
            queryMap.put(key, "");
        }
        return queryMap;
    }

    public static Map<String, String> getFormMap(HttpServletRequest request, Map<String, String> queryMap) throws IOException {
        HashMap<String, String> formMap = new HashMap<String, String>();
        Set keys = request.getParameterMap().keySet();
        for (Object tmp : keys) {
            String key = String.valueOf(tmp);
            if (queryMap.containsKey(key)) continue;
            String value = request.getParameter(key);
            if (StringUtils.isEmpty((String)value)) {
                formMap.put(key, "");
                continue;
            }
            formMap.put(key, value);
        }
        return formMap;
    }

    public static String sign(Map<String, String> params, String body, String secret, String charset) throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(SpiUtils.getParamStrFromMap(params));
        if (body != null) {
            sb.append(body);
        }
        sb.append(secret);
        byte[] bytes = SpiUtils.encryptMD5(sb.toString().getBytes(charset));
        return SpiUtils.byte2hex(bytes);
    }

    private static String getParamStrFromMap(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object name = keys[i];
                if ("sign".equals(name)) continue;
                sb.append((String)name);
                sb.append(params.get(name));
            }
        }
        return sb.toString();
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static byte[] encryptMD5(byte[] data) throws IOException {
        Object var1 = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(data);
            return bytes;
        }
        catch (GeneralSecurityException var3) {
            throw new IOException(var3.toString());
        }
    }
}

