/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wms.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreGoodsOpDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreOpDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreSkuOpDomain;
import com.yqbsoft.laser.service.wms.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.wms.facade.request.JbsWmsPurInWhNoticeRequest;
import com.yqbsoft.laser.service.wms.facade.request.JbsWmsQueryWhInfoRequest;
import com.yqbsoft.laser.service.wms.facade.response.JbsWmsPurInWhNoticeResponse;
import com.yqbsoft.laser.service.wms.facade.response.JbsWmsQueryWhInfoResponse;
import com.yqbsoft.laser.service.wms.service.JbsWmsWarehouseService;
import com.yqbsoft.laser.service.wms.utils.JbsUtils;
import com.yqbsoft.laser.service.wms.utils.ParamsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsWmsWarehouseServiceImpl
extends BaseServiceImpl
implements JbsWmsWarehouseService {
    public static final String SYS_CODE = "jbsWms.JbsWmsWarehouseServiceImpl";

    @Override
    public String sendPurchaseInwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.sendPurchaseInwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        JbsWmsPurInWhNoticeResponse execute = null;
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            String url = "http://58.209.173.55:8100/open/edi/qimen";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.in.order.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getWarehouseCode()));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5f02\u5e38\n" + JsonUtil.buildNormalBinder().toJson(execute)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getWarehouseCode()));
        }
    }

    @Override
    public String receivePurchaseInwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a\u7a7a");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a\u7a7a", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"R1,W4".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            if ("R1".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("R2");
            }
            if ("W4".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W5");
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            try {
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)ParamsUtils.makeWmsInDomain(whOpstoreOpDomain)));
                this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.make whOpstoreOpDomain>>>", (Object)JsonUtil.buildNormalBinder().toJson(sendMap));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "save Data Exception");
                this.logger.error(SYS_CODE, (Object)("save Data Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCode:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendPurchaseExwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.sendPurchaseExwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        JbsWmsPurInWhNoticeResponse execute = null;
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            String url = "http://58.209.173.55:8100/open/edi/qimen";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.out.order.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5f02\u5e38\n" + JsonUtil.buildNormalBinder().toJson(execute)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    @Override
    public String receivePurchaseExwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"O0,W0,L0,L1".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            if ("O0".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("O1");
            }
            if ("W0".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W1");
            }
            if ("L0".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("L2");
            }
            if ("L1".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("L2");
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)ParamsUtils.makeWmsInDomain(whOpstoreOpDomain)));
                this.logger.error(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreOpDomain)));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "save Data Exception");
                this.logger.error(SYS_CODE, (Object)("save Data Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorWhNo:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendAllotExwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        JbsWmsPurInWhNoticeResponse execute = null;
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.sendAllotExwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            String url = "http://58.209.173.55:8100/open/edi/qimen";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.out.order.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5f02\u5e38\n" + JsonUtil.buildNormalBinder().toJson(execute)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    @Override
    public String receiveAllotExwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setStoreGoodsBtype("D6");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)ParamsUtils.makeWmsInDomain(whOpstoreOpDomain)));
                this.logger.error(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreOpDomain)));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "save Data Exception");
                this.logger.error(SYS_CODE, (Object)("save Data Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCode:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendAllotInwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        JbsWmsPurInWhNoticeResponse execute = null;
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.sendAllotInwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            String url = "http://58.209.173.55:8100/open/edi/qimen";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.in.order.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5f02\u5e38\n" + JsonUtil.buildNormalBinder().toJson(execute)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    @Override
    public String receiveAllotInwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setStoreGoodsBtype("D9");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                this.logger.error(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreOpDomain)));
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)ParamsUtils.makeWmsInDomain(whOpstoreOpDomain)));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "save Data Exception");
                this.logger.error(SYS_CODE, (Object)("save Data Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCode:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receivePALBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receivePALBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receivePALBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)ParamsUtils.makeWmsInDomain(whOpstoreOpDomain)));
                this.logger.error(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreOpDomain)));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "save Data Exception");
                this.logger.error(SYS_CODE, (Object)("save Data Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCode:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receiveWhAdjustment(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receiveWhAdjustment", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.receiveWhAdjustment", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"T6,T7,P0,P1,T3".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)ParamsUtils.makeWmsInDomain(whOpstoreOpDomain)));
                this.logger.error(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreOpDomain)));
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (Exception e) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "save Data Exception");
                this.logger.error(SYS_CODE, (Object)("save Data Exception" + e));
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCode:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendWhQueryInfo(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.sendWhQueryInfo", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson(paramsMap)));
        JbsWmsQueryWhInfoResponse execute = null;
        try {
            String url = "http://ricar.frp.gfscold.com/open/edi/swift/inventory";
            HttpFormfacade httpFormfacade = new HttpFormfacade(url);
            JbsWmsQueryWhInfoRequest jbsWmsQueryWhInfoRequest = new JbsWmsQueryWhInfoRequest();
            jbsWmsQueryWhInfoRequest.setSkuNoList((List)paramsMap.get("skuNoList"));
            jbsWmsQueryWhInfoRequest.setWarhouseCode((List)paramsMap.get("warhouseCode"));
            execute = httpFormfacade.execute(jbsWmsQueryWhInfoRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5f02\u5e38\n" + JsonUtil.buildNormalBinder().toJson(execute)));
            e.printStackTrace();
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }
}

