/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wms.facade.http;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.wms.common.facade.SupperFacade;
import com.yqbsoft.laser.service.wms.common.request.SupperRequest;
import com.yqbsoft.laser.service.wms.common.response.SupperResponse;
import com.yqbsoft.laser.service.wms.utils.JbsUtils;
import com.yqbsoft.laser.service.wms.utils.RequestUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class HttpFormfacade
extends SupperFacade {
    private static String SYS_CODE = "HttpFormfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(HttpFormfacade.class);

    private String httpRequestReJson(String requestUrl, Map<String, Object> sendhttpParam) {
        String json = "";
        try {
            HashMap<String, String> sendParam = new HashMap<String, String>();
            for (String key : sendhttpParam.keySet()) {
                sendParam.put(key, (String)sendhttpParam.get(key));
            }
            json = WebUtils.doPost((String)requestUrl, sendParam, (int)10000000, (int)10000000, null);
            logger.error(SYS_CODE + "json.=====", (Object)json);
        }
        catch (Exception e) {
            logger.error(SYS_CODE + ".webUtilRequest.e", (Object)requestUrl, (Throwable)e);
            throw new ApiException(SYS_CODE + ".HttpRequestReJson.ex", (Throwable)e);
        }
        return json;
    }

    public Map<String, String> getConnectConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_wms-jbs_wms");
        JSONObject jsonObject = JSONObject.json2object((String)paramJson);
        configMap.put("WMS_CURRENT_BASE_URL", jsonObject.getString("base_url") + "/qimen");
        configMap.put("WMS_CURRENT_QUERYWH_URL", jsonObject.getString("base_url") + "/swift/inventory");
        configMap.put("WMS_APPKEY", jsonObject.getString("app_key"));
        configMap.put("WMS_APPSECRET", jsonObject.getString("app_secret"));
        configMap.put("WMS_CUSTOMERID", jsonObject.getString("customer_id"));
        return configMap;
    }

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        if (null == supperRequest) {
            return null;
        }
        try {
            Map<String, String> connectConfig = this.getConnectConfig();
            String url = "";
            String appKey = connectConfig.get("WMS_APPKEY");
            String method = supperRequest.getApiMethodName();
            url = StringUtils.isBlank((String)method) || "null".equals(method) ? connectConfig.get("WMS_CURRENT_QUERYWH_URL") : connectConfig.get("WMS_CURRENT_BASE_URL");
            String appSecret = connectConfig.get("WMS_APPSECRET");
            String customerId = connectConfig.get("WMS_CUSTOMERID");
            String timestamp = new Date().getTime() + "";
            String paramsUrl = "";
            String jsonDataStr = "";
            jsonDataStr = !EmptyUtil.isEmpty((Object)supperRequest.getDataBody()) ? JsonUtil.buildNormalBinder().toJson(supperRequest.getDataBody()) : JsonUtil.buildNormalBinder().toJson(supperRequest.getTextParams());
            paramsUrl = StringUtils.isNotBlank((String)method) ? "app_key=" + appKey + "&method=" + method + "&format=json&sign_method=md5&customerId=" + customerId + "&timestamp=" + timestamp : "app_key=" + appKey + "&format=json&sign_method=md5&customerId=" + customerId + "&timestamp=" + timestamp;
            String sign = JbsUtils.getSign(paramsUrl, jsonDataStr, appSecret);
            String signStr = "&sign=" + sign;
            Map<String, Object> returnMap = RequestUtils.postForEntity(url + "?" + paramsUrl + signStr, jsonDataStr, null);
            logger.error(SYS_CODE + ".Httpfacade.execute.response >>", (Object)("URL:" + url + "?" + paramsUrl + "\n\u8bf7\u6c42\u53c2\u6570\uff1a" + jsonDataStr + "\n\u8fd4\u56de\u4fe1\u606f\uff1a" + returnMap));
            if (MapUtil.isEmpty(returnMap) || EmptyUtil.isEmpty((Object)returnMap.get("response"))) {
                logger.error(SYS_CODE + ".execute.returnMap", (Object)"returnMap or get Map.response is null");
                return null;
            }
            String json = JsonUtil.buildNormalBinder().toJson(returnMap.get("response"));
            if (StringUtils.isBlank((String)json)) {
                logger.error(SYS_CODE + ".execute.json", (Object)"Response to Json is null");
                return null;
            }
            SupperResponse localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
            localResponse.setMsg(json);
            localResponse.makeDomain(json);
            return (T)localResponse;
        }
        catch (Exception xe) {
            logger.error(SYS_CODE, (Object)("\u53d1\u9001\u5f02\u5e38\uff1a" + xe.toString()), (Throwable)xe);
            throw new ApiException(xe + "\u8c03\u7528\u5f02\u5e38");
        }
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public HttpFormfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public HttpFormfacade(String host) {
        super(host);
    }

    public HttpFormfacade() {
    }
}

