/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wms.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.wms.domain.GoodsBean;
import com.yqbsoft.laser.service.wms.domain.RsResourceGoods;
import com.yqbsoft.laser.service.wms.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreGoodsOpDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreOpDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.wms.domain.WhOpstoreSkuOpDomain;
import com.yqbsoft.laser.service.wms.domain.WhWarehouseReDomain;
import com.yqbsoft.laser.service.wms.facade.http.HttpFormfacade;
import com.yqbsoft.laser.service.wms.facade.request.JbsWmsPurInWhNoticeRequest;
import com.yqbsoft.laser.service.wms.facade.request.JbsWmsQueryWhInfoRequest;
import com.yqbsoft.laser.service.wms.facade.response.JbsWmsPurInWhNoticeResponse;
import com.yqbsoft.laser.service.wms.facade.response.JbsWmsQueryWhInfoResponse;
import com.yqbsoft.laser.service.wms.model.WhOpstore;
import com.yqbsoft.laser.service.wms.service.JbsWmsWarehouseService;
import com.yqbsoft.laser.service.wms.utils.JbsUtils;
import com.yqbsoft.laser.service.wms.utils.ParamsUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JbsWmsWarehouseServiceImpl
extends BaseServiceImpl
implements JbsWmsWarehouseService {
    public static final String SYS_CODE = "jbsWms.JbsWmsWarehouseServiceImpl";

    @Override
    public String sendPurchaseInwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.sendPurchaseInwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        JbsWmsPurInWhNoticeResponse execute = null;
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.in.order.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getWarehouseCode()));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("WMS\u91c7\u8d2d\u5165\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("WMS\u91c7\u8d2d\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain.getWarehouseCode()));
        }
    }

    @Override
    public String receivePurchaseInwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a\u7a7a");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a\u7a7a", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"R1,W4,X2".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                continue;
            }
            if ("R1".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("R2");
            }
            if ("W4".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W5");
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setStoreType("0");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setOpstoreDir("1");
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    whOpstoreSkuOpDomain.setOpstoreDir("1");
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                        errorCodes.add(whOpstoreOpDomain.getWhNo() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            try {
                HashMap<String, String> sendMap = new HashMap<String, String>();
                WhOpstoreDomain whOpstoreDomain = ParamsUtils.makeWmsInDomain(whOpstoreOpDomain);
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj, whOpstoreOpDomain.getStoreGoodsBtype());
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u91c7\u8d2d\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u91c7\u8d2d\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u91c7\u8d2d\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u91c7\u8d2d\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCause:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendPurchaseExwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.sendPurchaseExwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        JbsWmsPurInWhNoticeResponse execute = null;
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.out.order.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("WMS\u91c7\u8d2d\u51fa\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    @Override
    public String receivePurchaseExwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receivePurchaseExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"O0,L0,L1".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            if ("O0".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("O1");
            }
            if ("L0".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("L2");
            }
            if ("L1".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("L2");
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setStoreType("0");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                whOpstoreGoodsOpDomain.setOpstoreDir("0");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    whOpstoreSkuOpDomain.setOpstoreDir("0");
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                WhOpstoreDomain whOpstoreDomain = ParamsUtils.makeWmsInDomain(whOpstoreOpDomain);
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj, whOpstoreOpDomain.getStoreGoodsBtype());
                this.checkCompanyCode(whOpstoreDomain);
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u91c7\u8d2d\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u91c7\u8d2d\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u91c7\u8d2d\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u91c7\u8d2d\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorWhNo:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    private void checkCompanyCode(WhOpstoreDomain whOpstoreDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreDomain) && StringUtils.isNotBlank((String)whOpstoreDomain.getStoreGoodsBtype()) && "L2".equals(whOpstoreDomain.getStoreGoodsBtype())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("opstoreCode", whOpstoreDomain.getOpstoreOcode());
            map.put("tenantCode", "2019071800001392");
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            QueryResult queryResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", sendMap, WhOpstore.class);
            if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList()) && !EmptyUtil.isEmpty(queryResult.getList().get(0))) {
                WhOpstore whOpstore = (WhOpstore)queryResult.getList().get(0);
                whOpstoreDomain.setCompanyCode(whOpstore.getCompanyCode());
            } else {
                throw new ApiException(whOpstoreDomain.getOpstoreOcode() + ":\u9886\u6599\u51fa\u5e93\u786e\u8ba4\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9886\u6599\u5355");
            }
        }
    }

    @Override
    public String sendAllotExwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        JbsWmsPurInWhNoticeResponse execute = null;
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.sendAllotExwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.out.allocation.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("WMS\u8c03\u62e8\u51fa\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("WMS\u8c03\u62e8\u51fa\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    @Override
    public String receiveAllotExwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotExwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotExwhConfirmBill", (Object)("data\u8f6cListh\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"W0,W8,D4".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setStoreType("0");
            if ("D4".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("D6");
            }
            if ("W0".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W1");
            }
            if ("W8".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W9");
            }
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setOpstoreDir("0");
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    whOpstoreSkuOpDomain.setOpstoreDir("0");
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                WhOpstoreDomain whOpstoreDomain = ParamsUtils.makeWmsInDomain(whOpstoreOpDomain);
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj, whOpstoreOpDomain.getStoreGoodsBtype());
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u8c03\u62e8\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u8c03\u62e8\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u8c03\u62e8\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u8c03\u62e8\u51fa\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCause:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String sendAllotInwhNoticeBill(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        JbsWmsPurInWhNoticeResponse execute = null;
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.sendAllotInwhNoticeBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
        try {
            WhOpstoreOpDomain whOpstoreOpDomain = ParamsUtils.makeWmsOutDomain(whOpstoreDomain);
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            httpFormfacade.setInsideOrderNo(whOpstoreDomain.getOpstoreCode());
            httpFormfacade.setOutsideOrderNo(whOpstoreDomain.getOpstoreOcode());
            JbsWmsPurInWhNoticeRequest jbsWmsPurInWhNoticeRequest = new JbsWmsPurInWhNoticeRequest();
            jbsWmsPurInWhNoticeRequest.setApiMethodName("swift.in.allocation.create");
            jbsWmsPurInWhNoticeRequest.setDataBody(whOpstoreOpDomain);
            execute = httpFormfacade.execute(jbsWmsPurInWhNoticeRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("WMS\u8c03\u62e8\u5165\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("WMS\u8c03\u62e8\u5165\u5e93\u901a\u77e5\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    @Override
    public String receiveAllotInwhConfirmBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receiveAllotInwhConfirmBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"D7,W4,W6,W10".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            if ("D7".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("D9");
            }
            if ("W4".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W5");
            }
            if ("W6".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W7");
            }
            if ("W10".equals(whOpstoreOpDomain.getStoreGoodsBtype() + "")) {
                whOpstoreOpDomain.setStoreGoodsBtype("W11");
            }
            whOpstoreOpDomain.setStoreType("0");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setOpstoreDir("1");
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    whOpstoreSkuOpDomain.setOpstoreDir("1");
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                WhOpstoreDomain whOpstoreDomain = ParamsUtils.makeWmsInDomain(whOpstoreOpDomain);
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj, whOpstoreOpDomain.getStoreGoodsBtype());
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u8c03\u62e8\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u8c03\u62e8\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u8c03\u62e8\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u8c03\u62e8\u5165\u5e93\u786e\u8ba4\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCause:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receivePALBill(String dataStr) throws ApiException {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receivePALBill", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receivePALBill", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"X1,X2,X3".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5355\u636e\u7c7b\u578b\u672a\u77e5");
                checkDetail = false;
                continue;
            }
            whOpstoreOpDomain.setStoreGoodsType("1");
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                WhOpstoreDomain whOpstoreDomain = ParamsUtils.makeWmsInDomain(whOpstoreOpDomain);
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj, whOpstoreOpDomain.getStoreGoodsBtype());
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCause:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String receiveWhAdjustment(String dataStr) throws Exception {
        if (StringUtils.isBlank((String)dataStr)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receiveWhAdjustment", (Object)("\u63a5\u6536\u6570\u636e\n" + dataStr));
        List jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(dataStr, WhOpstoreOpDomain.class);
        if (ListUtil.isEmpty((Collection)jsonToList)) {
            this.logger.error(SYS_CODE, (Object)"\u63a5\u6536\u6570\u636e\u8f6cList \u4e3a null");
            return JbsUtils.getErrorMap("\u63a5\u6536\u6570\u636e\u8f6cList", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.receiveWhAdjustment", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson((Object)jsonToList)));
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (WhOpstoreOpDomain whOpstoreOpDomain : jsonToList) {
            Boolean checkDetail = true;
            if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
                errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            if (!"T6,T7,P0,T3,T5,T9,T10".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u672a\u77e5\u7c7b\u578b:" + whOpstoreOpDomain.getStoreGoodsBtype());
                checkDetail = false;
                continue;
            }
            if ("T5".equals(whOpstoreOpDomain.getStoreGoodsBtype())) {
                whOpstoreOpDomain.setStoreGoodsType("3");
                whOpstoreOpDomain.setStoreType("1");
            } else if ("T9".contains(whOpstoreOpDomain.getStoreGoodsBtype())) {
                whOpstoreOpDomain.setStoreGoodsType("4");
                whOpstoreOpDomain.setStoreType("1");
            } else {
                whOpstoreOpDomain.setStoreGoodsType("1");
                whOpstoreOpDomain.setStoreType("0");
            }
            whOpstoreOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
            if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                continue;
            }
            for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getOpstoreDir())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
                List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                    whOpstoreSkuOpDomain.setGoodsNo(whOpstoreGoodsOpDomain.getGoodsNo());
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                        checkDetail = false;
                        break;
                    }
                    if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir())) {
                        errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u64cd\u4f5c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
                        checkDetail = false;
                        break;
                    }
                    whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
                }
                if (checkDetail.booleanValue()) continue;
                break;
            }
            HashMap<String, String> sendMap = new HashMap<String, String>();
            try {
                WhOpstoreDomain whOpstoreDomain = ParamsUtils.makeWmsInDomain(whOpstoreOpDomain);
                Map checkResultMap = this.checkExist(whOpstoreDomain);
                Boolean checkFlag = Boolean.valueOf(checkResultMap.get("checkFlag") + "");
                WhOpstoreDomain currentObj = (WhOpstoreDomain)checkResultMap.get("currentObj");
                this.checkGoodsClass(currentObj, whOpstoreOpDomain.getStoreGoodsBtype());
                this.checkAdjData(whOpstoreOpDomain, currentObj.getStoreGoodsBtype());
                sendMap.put("whOpstoreDomain", JsonUtil.buildNormalBinder().toJson((Object)currentObj));
                this.logger.info(SYS_CODE, (Object)(".make whOpstoreOpDomain" + JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain)));
                if (checkFlag.booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u8be5\u5355\u636e\u5df2\u5b58\u5728");
                    continue;
                }
                this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", sendMap);
            }
            catch (ApiException e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5904\u7406\u5931\u8d25" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5904\u7406\u5931\u8d25\uff1a" + e.getErrCode());
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)("WMS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "WMS\u5e93\u5b58\u8c03\u6574\u63a5\u53e3\u5f02\u5e38");
            }
        }
        if (ListUtil.isNotEmpty(errorCodes)) {
            return JbsUtils.getErrorMap("\u90e8\u5206\u6570\u636e\u5904\u7406\u5931\u8d25", "ErrorCause:" + errorCodes);
        }
        return JbsUtils.getSuccessMap("");
    }

    private void checkAdjData(WhOpstoreOpDomain whOpstoreOpDomain, String type) throws Exception {
        List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList;
        if (!EmptyUtil.isEmpty((Object)whOpstoreOpDomain) && ListUtil.isNotEmpty(whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList())) {
            if (type != null && "T3".equals(type)) {
                String goodsDirFlag = "";
                String skuDirFlag = "";
                for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
                    if (StringUtils.isBlank((String)goodsDirFlag)) {
                        goodsDirFlag = whOpstoreGoodsOpDomain.getOpstoreDir();
                    }
                    if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getOpstoreDir()) || !whOpstoreGoodsOpDomain.getOpstoreDir().equals(goodsDirFlag)) {
                        throw new ApiException("\u635f\u76ca\u5355opstoreDir\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u80fd\u90e8\u5206\u635f\u90e8\u5206\u76ca");
                    }
                    List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
                    if (!ListUtil.isNotEmpty(whOpstoreSkuOpDomainList)) continue;
                    for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                        if (StringUtils.isBlank((String)skuDirFlag)) {
                            skuDirFlag = whOpstoreSkuOpDomain.getOpstoreDir();
                            continue;
                        }
                        if (!StringUtils.isBlank((String)whOpstoreSkuOpDomain.getOpstoreDir()) && whOpstoreSkuOpDomain.getOpstoreDir().equals(skuDirFlag)) continue;
                        throw new ApiException("\u635f\u76ca\u5355opstoreDir\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e0d\u80fd\u90e8\u5206\u635f\u90e8\u5206\u76ca");
                    }
                }
            } else if (type != null && "T7".equals(type)) {
                Integer goodsIn = 0;
                Integer goodsOut = 0;
                for (WhOpstoreGoodsOpDomain goodsObj : whOpstoreGoodsOpDomainList) {
                    Integer n;
                    Integer n2;
                    if (StringUtils.isNotBlank((String)goodsObj.getOpstoreDir()) && "0".equals(goodsObj.getOpstoreDir())) {
                        n2 = goodsOut;
                        n = goodsOut = Integer.valueOf(goodsOut + 1);
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)goodsObj.getOpstoreDir()) && "1".equals(goodsObj.getOpstoreDir())) {
                        n2 = goodsIn;
                        n = goodsIn = Integer.valueOf(goodsIn + 1);
                        continue;
                    }
                    this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.checkAdjData", (Object)"\u5e93\u5b58\u5904\u7406\u65b9\u5411opstoreDir\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a\u672a\u77e5\u7c7b\u578b");
                    throw new ApiException("\u5e93\u5b58\u5904\u7406\u65b9\u5411opstoreDir\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a\u672a\u77e5\u7c7b\u578b:" + goodsObj.getOpstoreDir());
                }
                if (!(goodsOut == 1 && goodsIn >= 1 || goodsIn == 1 && goodsOut >= 1)) {
                    this.logger.error("jbsWms.JbsWmsWarehouseServiceImpl.checkAdjData", (Object)("\u6bcd\u5b50\u8f6c\u6362\u6570\u636e\u7ed3\u6784\u9519\u8bef(\u6bcd\u8f6c\u5b501\uff1aN\uff0c\u5b50\u8f6c\u6bcdN\uff1a1)\uff0c\u5f53\u524d\uff1a\u51fa\u5e93=" + goodsOut + ",\u5165\u5e93=" + goodsIn));
                    throw new ApiException("\u6bcd\u5b50\u8f6c\u6362\u6570\u636e\u7ed3\u6784\u9519\u8bef(\u6bcd\u8f6c\u5b501\uff1aN\uff0c\u5b50\u8f6c\u6bcdN\uff1a1)\uff0c\u5f53\u524d\uff1a\u51fa\u5e93=" + goodsOut + ",\u5165\u5e93=" + goodsIn);
                }
            }
        }
    }

    @Override
    public String sendWhQueryInfo(Map<String, Object> paramsMap) throws ApiException {
        if (MapUtil.isEmpty(paramsMap)) {
            this.logger.error(SYS_CODE, (Object)"param is null");
            return JbsUtils.getErrorMap("param is null", "");
        }
        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.sendWhQueryInfo", (Object)("\u63a5\u6536\u6570\u636e\n" + JsonUtil.buildNormalBinder().toJson(paramsMap)));
        JbsWmsQueryWhInfoResponse execute = null;
        try {
            HttpFormfacade httpFormfacade = new HttpFormfacade();
            JbsWmsQueryWhInfoRequest jbsWmsQueryWhInfoRequest = new JbsWmsQueryWhInfoRequest();
            jbsWmsQueryWhInfoRequest.setSkuNoList((List)paramsMap.get("skuNoList"));
            jbsWmsQueryWhInfoRequest.setWarhouseCode((List)paramsMap.get("warhouseCode"));
            execute = httpFormfacade.execute(jbsWmsQueryWhInfoRequest);
            if (null == execute || !execute.getSuccess().booleanValue()) {
                this.logger.error(SYS_CODE, (Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\n" + JsonUtil.buildNormalBinder().toJson((Object)execute)));
                return JbsUtils.getErrorMap("\u6570\u636e\u53d1\u9001\u5931\u8d25", JsonUtil.buildNormalBinder().toJson((Object)execute));
            }
            return JbsUtils.getSuccessMap(JsonUtil.buildNormalBinder().toJson((Object)execute));
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)("WMS\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38" + e.toString()), (Throwable)e);
            return JbsUtils.getErrorMap("WMS\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38", JsonUtil.buildNormalBinder().toJson(execute));
        }
    }

    public void checkGoodsClass(WhOpstoreDomain whOpstoreDomain, String storeGoodsBtype) throws Exception {
        if (EmptyUtil.isEmpty((Object)whOpstoreDomain) || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return;
        }
        HashMap<String, String> whMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        whMap.put("warehouseCode", whOpstoreDomain.getWarehouseCode());
        whMap.put("tenantCode", "2019071800001392");
        map.put("map", JsonUtil.buildNormalBinder().toJson(whMap));
        QueryResult qwh = this.getQueryResutl("wh.warehouse.queryWarehousePage", map, WhWarehouseReDomain.class);
        if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
            throw new ApiException("checkGoodsClass.warehouseCode", whMap.toString());
        }
        this.logger.error("JbsWmsWarehouseServiceImpl.checkGoodsClass.whMap", (Object)JsonUtil.buildNormalBinder().toJson(whMap));
        this.logger.error("JbsWmsWarehouseServiceImpl.checkGoodsClass.qwh", (Object)JsonUtil.buildNormalBinder().toJson((Object)qwh));
        WhWarehouseReDomain whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        String goodsClass = "plat";
        String memberCode = whWarehouseReDomain.getMemberCode();
        whOpstoreDomain.setMemberCode(memberCode);
        whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        if ("0".equals(whWarehouseReDomain.getWarehouseCtype()) || "1".equals(whWarehouseReDomain.getWarehouseCtype())) {
            goodsClass = "pos";
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            whOpstoreGoodsDomain.setGoodsEocode(whOpstoreGoodsDomain.getGoodsNo());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
            this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("goodsClass", goodsClass);
            paramMap.put("skuNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCode", memberCode);
            paramMap.put("tenantCode", "2019071800001392");
            this.logger.error("JbsWmsWarehouseServiceImpl.checkGoodsClass.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            String returnJsonStr = this.internalInvoke("rs.resourceGoods.getResourceBySkuNo", paramMap);
            if (StringUtils.isNotBlank((String)returnJsonStr)) {
                GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(returnJsonStr, GoodsBean.class);
                if (null == goodsBean || null == goodsBean.getRsResourceGoods() || null == goodsBean.getRsSku()) continue;
                RsResourceGoods rsResourceGoods = goodsBean.getRsResourceGoods();
                whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
                whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
                whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
                whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
                whOpstoreGoodsDomain.setGoodsProperty(rsResourceGoods.getGoodsProperty3());
                whOpstoreGoodsDomain.setGoodsEocode(rsResourceGoods.getGoodsEocode());
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                whOpstoreGoodsDomain.setMemberName(whOpstoreDomain.getMemberName());
                this.checkNegative(whOpstoreGoodsDomain.getGoodsNum());
                this.checkNegative(whOpstoreGoodsDomain.getGoodsWeight());
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (!ListUtil.isNotEmpty(whOpstoreSkuDomainList)) continue;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    whOpstoreSkuDomain.setClasstreeCode(goodsBean.getRsSku().getClasstreeCode());
                    whOpstoreSkuDomain.setClasstreeName(goodsBean.getRsSku().getClasstreeName());
                    whOpstoreSkuDomain.setGoodsNo(goodsBean.getRsSku().getGoodsNo());
                    whOpstoreSkuDomain.setGoodsCode(goodsBean.getRsSku().getGoodsCode());
                    whOpstoreSkuDomain.setGoodsEocode(goodsBean.getRsSku().getGoodsEocode());
                    whOpstoreSkuDomain.setSpuCode(goodsBean.getRsSku().getSpuCode());
                    whOpstoreSkuDomain.setSkuCode(goodsBean.getRsSku().getSkuCode());
                    whOpstoreSkuDomain.setSkuName(goodsBean.getRsSku().getSkuName());
                    whOpstoreSkuDomain.setOperatorCode(goodsBean.getRsSku().getMschannelName());
                    whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                    whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                    whOpstoreSkuDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                    whOpstoreSkuDomain.setMemberName(whOpstoreDomain.getMemberName());
                    whOpstoreSkuDomain.setStoreType(this.checkStoreType(whOpstoreSkuDomain));
                    whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                    this.checkNegative(whOpstoreSkuDomain.getGoodsNum());
                    this.checkNegative(whOpstoreSkuDomain.getGoodsWeight());
                }
                continue;
            }
            paramMap.clear();
            HashMap<String, String> sendMap = new HashMap<String, String>();
            paramMap.put("goodsClass", goodsClass);
            paramMap.put("goodsNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCode", memberCode);
            paramMap.put("tenantCode", "2019071800001392");
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            this.logger.error("JbsWmsWarehouseServiceImpl.checkGoodsClass.paramMap", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
            QueryResult queryResult = this.sendReSupObject("rs.resourceGoods.queryResourceGoodsPage", sendMap, RsResourceGoodsReDomain.class);
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                RsResourceGoodsReDomain rsResourceGoods = (RsResourceGoodsReDomain)queryResult.getList().get(0);
                whOpstoreGoodsDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                whOpstoreGoodsDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
                whOpstoreGoodsDomain.setGoodsSpec5(rsResourceGoods.getGoodsProperty2());
                whOpstoreGoodsDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                whOpstoreGoodsDomain.setSpuCode(rsResourceGoods.getSpuCode());
                whOpstoreGoodsDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
                whOpstoreGoodsDomain.setGoodsProperty(rsResourceGoods.getGoodsProperty3());
                whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                whOpstoreGoodsDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                whOpstoreGoodsDomain.setMemberName(whOpstoreDomain.getMemberName());
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (!ListUtil.isNotEmpty(whOpstoreSkuDomainList)) continue;
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                    whOpstoreSkuDomain.setClasstreeCode(rsResourceGoods.getClasstreeCode());
                    whOpstoreSkuDomain.setClasstreeName(rsResourceGoods.getClasstreeName());
                    whOpstoreSkuDomain.setGoodsCode(rsResourceGoods.getGoodsCode());
                    whOpstoreSkuDomain.setSpuCode(rsResourceGoods.getSpuCode());
                    whOpstoreSkuDomain.setGoodsNo(rsResourceGoods.getGoodsNo());
                    whOpstoreSkuDomain.setStoreType(this.checkStoreType(whOpstoreSkuDomain));
                    whOpstoreGoodsDomain.setStoreType(whOpstoreSkuDomain.getStoreType());
                    this.checkNegative(whOpstoreSkuDomain.getGoodsNum());
                    this.checkNegative(whOpstoreSkuDomain.getGoodsWeight());
                    whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                    whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                    whOpstoreSkuDomain.setMemberCode(whOpstoreDomain.getMemberCode());
                    whOpstoreSkuDomain.setMemberName(whOpstoreDomain.getMemberName());
                }
                continue;
            }
            throw new ApiException(whOpstoreGoodsDomain.getGoodsNo() + ":\u8be5\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    private String checkStoreType(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (!EmptyUtil.isEmpty((Object)whOpstoreSkuDomain) && StringUtils.isNotBlank((String)whOpstoreSkuDomain.getPntreeName()) && "J001 \u95e8\u5e97/\u524d\u7f6e\u4ed3\u9000\u8d27\u5e93-\u6709\u5b9e\u7269,J002 \u95e8\u5e97/\u524d\u7f6e\u4ed3\u9000\u8d27\u5e93-\u65e0\u5b9e\u7269,J003 \u7535\u5546\u9000\u8d27\u5e93-\u6709\u5b9e\u7269,J004 \u7535\u5546\u9000\u8d27\u5e93-\u65e0\u5b9e\u7269".contains(whOpstoreSkuDomain.getPntreeName())) {
            return "1";
        }
        return "0";
    }

    public Map checkExist(WhOpstoreDomain whOpstoreDomain) throws Exception {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            throw new ApiException("checkExist.\u4f20\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            queryMap.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
            queryMap.put("tenantCode", "2019071800001392");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
            QueryResult queryStoreResult = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
            if (queryStoreResult != null && ListUtil.isNotEmpty((Collection)queryStoreResult.getList())) {
                queryMap.put("checkFlag", "true");
            } else {
                if ("L2".contains(whOpstoreDomain.getStoreGoodsBtype())) {
                    queryMap.clear();
                    map.clear();
                    queryMap.put("opstoreCode", whOpstoreDomain.getOpstoreOcode());
                    queryMap.put("tenantCode", "2019071800001392");
                    map.put("map", JsonUtil.buildNormalBinder().toJson(queryMap));
                    QueryResult queryStoreResult2 = this.sendReSupObject("wh.WhOpstore.queryOpstorePage", map, WhOpstoreDomain.class);
                    if (queryStoreResult2 != null && ListUtil.isNotEmpty((Collection)queryStoreResult2.getList())) {
                        this.logger.info("jbsWms.JbsWmsWarehouseServiceImpl.checkExist.queryopStore", (Object)JsonUtil.buildNormalBinder().toJson((Object)(queryStoreResult2.getList() + "===" + ((WhOpstoreDomain)queryStoreResult2.getList().get(0)).getEmployeeName())));
                        whOpstoreDomain.setEmployeeName(((WhOpstoreDomain)queryStoreResult2.getList().get(0)).getEmployeeName());
                    }
                }
                queryMap.put("checkFlag", "false");
            }
            queryMap.put("currentObj", whOpstoreDomain);
            return queryMap;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)"checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new ApiException("checkExist\u5904\u7406\u6570\u636e\u5f02\u5e38");
        }
    }

    public Boolean checkWhplace(String whPlace) {
        if (StringUtils.isBlank((String)whPlace)) {
            return false;
        }
        String paramJson = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2019071800001392-jbs_place-jbs_place");
        JSONObject jsonObject = JSONObject.json2object((String)paramJson);
        String ddFlagwhPlace = jsonObject.getString("wh_place");
        if (StringUtils.isNotBlank((String)ddFlagwhPlace) && ddFlagwhPlace.contains(whPlace)) {
            return true;
        }
        return false;
    }

    private void checkReceiveData(WhOpstoreOpDomain whOpstoreOpDomain, Boolean checkDetail, List<String> errorCodes) {
        if (StringUtils.isBlank((String)whOpstoreOpDomain.getWhNo())) {
            errorCodes.add("\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            checkDetail = false;
            return;
        }
        if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeNum())) {
            errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            checkDetail = false;
            return;
        }
        if (EmptyUtil.isEmpty((Object)whOpstoreOpDomain.getSkuChangeWeight())) {
            errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            checkDetail = false;
            return;
        }
        if (StringUtils.isBlank((String)whOpstoreOpDomain.getStoreGoodsBtype())) {
            errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            checkDetail = false;
            return;
        }
        List<WhOpstoreGoodsOpDomain> whOpstoreGoodsOpDomainList = whOpstoreOpDomain.getWhOpstoreGoodsOpDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsOpDomainList)) {
            errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            checkDetail = false;
            return;
        }
        for (WhOpstoreGoodsOpDomain whOpstoreGoodsOpDomain : whOpstoreGoodsOpDomainList) {
            if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getDetailUniqueCode())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5355\u636e\u8be6\u60c5\u552f\u4e00code\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                break;
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsOpDomain.getGoodsNo())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                break;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeNum())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                break;
            }
            if (EmptyUtil.isEmpty((Object)whOpstoreGoodsOpDomain.getSkuChangeWeight())) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u7684\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                break;
            }
            whOpstoreGoodsOpDomain.setTenantCode("2019071800001392");
            List<WhOpstoreSkuOpDomain> whOpstoreSkuOpDomainList = whOpstoreGoodsOpDomain.getWhOpstoreSkuOpDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuOpDomainList)) {
                errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                checkDetail = false;
                break;
            }
            for (WhOpstoreSkuOpDomain whOpstoreSkuOpDomain : whOpstoreSkuOpDomainList) {
                if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getBatchNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (StringUtils.isBlank((String)whOpstoreSkuOpDomain.getGoodsEocode())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u8d27\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNum())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeight())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeNumUnit())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u6570\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getSkuChangeWeightUnit())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u53d8\u66f4\u91cd\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlant())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (EmptyUtil.isEmpty((Object)whOpstoreSkuOpDomain.getWhPlace())) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    checkDetail = false;
                    break;
                }
                if (!this.checkWhplace(whOpstoreSkuOpDomain.getWhPlace()).booleanValue()) {
                    errorCodes.add(whOpstoreOpDomain.getBatchNum() + "SKU\u6279\u6b21\u5e93\u5b58\u5e93\u4f4d\u4e0d\u5b58\u5728");
                    checkDetail = false;
                    break;
                }
                whOpstoreSkuOpDomain.setTenantCode("2019071800001392");
            }
            if (checkDetail.booleanValue()) continue;
            break;
        }
    }

    private void checkNegative(BigDecimal data) throws Exception {
        if (!EmptyUtil.isEmpty((Object)data) && BigDecimal.ZERO.compareTo(data) > 0) {
            throw new ApiException("\u5546\u54c1\u6570\u91cf\u6216\u91cd\u91cf\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
    }
}

