/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.jdvop.goods.service;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSellPrice.GetSellPriceGoodsResp;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.GetSkuPoolInfoGoodsResp;
import com.jd.open.api.sdk.domain.vopsp.SkuInfoGoodsProvider.response.getSkuDetailInfo.OpenRpcResult;
import com.jd.open.api.sdk.domain.vopsp.SkuPoolGoodsProvider.response.getSkuPoolInfo.GetSkuPoolInfoItemGoodsResp;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.vopsp.VopGoodsGetSkuDetailInfoRequest;
import com.jd.open.api.sdk.response.vopsp.VopGoodsGetSkuDetailInfoResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisChannel;
import com.yqbsoft.laser.service.ext.channel.discom.domain.DisOauthToken;
import com.yqbsoft.laser.service.ext.channel.discom.domain.GoodsBean;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.channel.discom.domain.RsSkuDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.EditSkuDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.JdResponseMessageContentDomain;
import com.yqbsoft.laser.service.ext.channel.jdvop.domain.PoolSkubean;
import com.yqbsoft.laser.service.ext.channel.jdvop.goods.EsGoodsService;
import com.yqbsoft.laser.service.ext.channel.jdvop.goods.service.DisGoodsServiceImpl;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.JdBeanUtil;
import com.yqbsoft.laser.service.ext.channel.jdvop.util.JdInterfaceUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EsGoodsServiceImpl
extends DisGoodsServiceImpl
implements EsGoodsService {
    private String SYS_CODE = "jdvop.EsGoodsServiceImpl";
    private static final String RESOURCEGOODS_GETNO_API_CODE = "rs.resourceGoods.getResourceBySkuNo";
    private static final String RESOURCEGOODS_DEL_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SOLD_CODE = "rs.resource.sendUpdateSoldOutGoods";
    private static final String RESOURCEGOODS_SHELVE_CODE = "rs.resource.sendUpdateShelveGoods";

    @Override
    public void saveGoodsPool(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolSkubean", (Object)"===>parm is null");
            return;
        }
        GetSkuPoolInfoItemGoodsResp poolInfo = poolSkubean.getPoolInfo();
        if (null == poolInfo) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolInfo", (Object)"===>parm is null");
            return;
        }
        DisChannel disChannel = poolSkubean.getDisChannel();
        if (null == disChannel) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.poolInfo", (Object)"===>parm is null");
            return;
        }
        String tenantCode = disChannel.getTenantCode();
        JdClient client = poolSkubean.getClient();
        if (null == client) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPool.client", (Object)"===>parm is null");
            return;
        }
        this.saveGoodsPool(poolInfo, disChannel, tenantCode, client, poolSkubean);
    }

    @Override
    public void saveGoodsPoolEx(PoolSkubean poolSkubean) {
    }

    @Override
    public void saveGoodsPrice(PoolSkubean poolSkubean) {
        if (null == poolSkubean) {
            return;
        }
        GetSkuPoolInfoItemGoodsResp poolInfo = poolSkubean.getPoolInfo();
        DisChannel disChannel = poolSkubean.getDisChannel();
        JdClient client = poolSkubean.getClient();
        try {
            this.synJdVopPrice(disChannel, client, poolInfo, poolSkubean);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".saveGoodsPrice.e", (Throwable)e);
        }
    }

    @Override
    public boolean saveVopJdSkuIds(PoolSkubean poolSkubean) {
        return this.saveGoodsSkuStr(poolSkubean.getPoolInfo(), poolSkubean.getDisChannel(), poolSkubean.getTenantCode(), poolSkubean.getClient(), poolSkubean.getItems(), poolSkubean);
    }

    @Override
    public boolean saveVopJdSkuIdslog(PoolSkubean poolSkubean) {
        return this.saveGoodsSkuStrlog(poolSkubean.getPoolInfo(), poolSkubean.getDisChannel(), poolSkubean.getTenantCode(), poolSkubean.getClient(), poolSkubean.getItems(), poolSkubean);
    }

    @Override
    public boolean saveVopJdSkuIdsEx(PoolSkubean poolSkubean) {
        return this.saveGoodsSkuStrEx(poolSkubean.getPoolInfo(), poolSkubean.getDisChannel(), poolSkubean.getTenantCode(), poolSkubean.getClient(), poolSkubean.getItems(), poolSkubean);
    }

    @Override
    public void updateGoodsInfo(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        JdClient client = jdResponseMessageContentDomain.getClient();
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            this.logger.info(this.SYS_CODE + ".updateGoodsInfo.updateGoodsSku========16================" + skuId);
            client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSku(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
        String msgId = jdResponseMessageContentDomain.getId() + "";
        this.logger.info(this.SYS_CODE + ".deleteVopMsgById msgId", (Object)msgId);
        this.deleteVopMsgById(client, msgId);
    }

    @Override
    public void updateGoodsInfoEx(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            this.logger.info(this.SYS_CODE + ".updateGoodsInfo.updateGoodsSku========16================" + skuId);
            JdClient client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSkuEx(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
    }

    @Override
    public void updateGoodsInfoDown(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".updateGoodsInfoDown.updateGoodsInfo \u901a\u8fc7skuId\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff0cskuId = " + skuId);
                return;
            }
            ArrayList<Long> addGoodsVopIds = new ArrayList<Long>();
            RsResourceGoodsDomain rsResourceGoods = goodsBean.getRsResourceGoods();
            addGoodsVopIds.add(Long.parseLong(rsResourceGoods.getGoodsNo()));
            this.logger.info(this.SYS_CODE + ".updateGoodsInfoDown.updateGoodsInfo.updateGoodsSku========16================" + skuId);
            JdClient client = this.getJdClient(jdResponseMessageContentDomain);
            this.updateGoodsSkuDown(client, addGoodsVopIds, jdResponseMessageContentDomain.getDisChannel(), jdResponseMessageContentDomain.getDisChannel().getTenantCode());
        }
    }

    @Override
    public void putOrOffGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.info(this.SYS_CODE + ".putOrOffGoods.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String state = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            ArrayList<String> goodsIds = new ArrayList<String>();
            goodsIds.add(skuId);
            state = JsonUtil.buildNormalBinder().toJson(contentMap.get("state"));
            this.soldOrShelveGoodsByGoodsIds(goodsIds, state, jdResponseMessageContentDomain);
        }
    }

    @Override
    public void putOrOffGoodsEx(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        this.logger.info(this.SYS_CODE + ".putOrOffGoods.e", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        String state = null;
        if (MapUtil.isNotEmpty(contentMap)) {
            this.logger.info(this.SYS_CODE + ".contentMap>>>>>>>>>>>>>>>>" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
            skuId = JsonUtil.buildNormalBinder().toJson(contentMap.get("skuId"));
            ArrayList<String> goodsIds = new ArrayList<String>();
            goodsIds.add(skuId);
            state = JsonUtil.buildNormalBinder().toJson(contentMap.get("state"));
            this.soldOrShelveGoodsByGoodsIdsEx(goodsIds, state, jdResponseMessageContentDomain);
        }
    }

    @Override
    public void addOrRemoveGoods(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = "";
        if (null != jdResponseMessageContentDomain && null != jdResponseMessageContentDomain.getDisChannel()) {
            tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods.e-" + tenantCode, (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        Object pageNum = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoods \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent=" + tenantCode + "--" + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        String msgId = jdResponseMessageContentDomain.getId() + "";
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods contentMap= " + tenantCode + "--" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addGoods \u5546\u54c1\u5df2\u7ecf\u5b58\u5728\uff0cskuId= " + tenantCode + "--" + skuId);
                this.logger.info(this.SYS_CODE + ".deleteVopMsgById msgId", (Object)msgId);
                this.deleteVopMsgById(jdResponseMessageContentDomain.getClient(), msgId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addGoods skuId= " + tenantCode + "--", (Object)skuId);
            this.addGoodsBySkuId(Long.valueOf(skuId), jdResponseMessageContentDomain);
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".RemoveGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + tenantCode + "--" + skuId);
                this.logger.info(this.SYS_CODE + ".deleteVopMsgById msgId", (Object)msgId);
                this.deleteVopMsgById(jdResponseMessageContentDomain.getClient(), msgId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".RemoveGoods goodsIds= " + tenantCode + "--", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            if (null != goodsBean.getRsResourceGoods() && 1 == goodsBean.getRsResourceGoods().getDataOpbillstate()) {
                this.delGoodsByGoodsIds(goodsIds);
            }
        }
        this.logger.info(this.SYS_CODE + ".deleteVopMsgById msgId", (Object)msgId);
        this.deleteVopMsgById(jdResponseMessageContentDomain.getClient(), msgId);
    }

    @Override
    public void addOrRemoveGoodslog(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = "";
        if (null != jdResponseMessageContentDomain && null != jdResponseMessageContentDomain.getDisChannel()) {
            tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog.e-" + tenantCode, (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent=" + tenantCode + "--" + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog contentMap= " + tenantCode + "--" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog \u5546\u54c1\u5df2\u7ecf\u5b58\u5728\uff0cskuId= " + tenantCode + "--" + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog skuId= " + tenantCode + "--", (Object)skuId);
            this.addGoodsBySkuIdlog(Long.valueOf(skuId), jdResponseMessageContentDomain);
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + tenantCode + "--" + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoodslog goodsIds= " + tenantCode + "--", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            this.delGoodsByGoodsIds(goodsIds);
        }
    }

    @Override
    public void addOrRemoveGoodsEx(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = "";
        if (null != jdResponseMessageContentDomain && null != jdResponseMessageContentDomain.getDisChannel()) {
            tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods.e-" + tenantCode, (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)jdResponseMessageContentDomain));
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = null;
        Object pageNum = null;
        if (!MapUtil.isNotEmpty(contentMap)) {
            this.logger.error(this.SYS_CODE + ".addOrRemoveGoods \u4eac\u4e1c\u8fd4\u56de\u6d88\u606f\u5185\u5bb9\u9519\u8bef\uff0ccontent=" + tenantCode + "--" + content);
            return;
        }
        skuId = contentMap.get("skuId").toString();
        GoodsBean goodsBean = this.getGoodsBySkuNo(skuId, jdResponseMessageContentDomain.getDisChannel());
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        if (goodsBean != null) {
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
        }
        this.logger.error(this.SYS_CODE + ".addOrRemoveGoods contentMap= " + tenantCode + "--" + JsonUtil.buildNonEmptyBinder().toJson(contentMap));
        if ("1".equals(contentMap.get("state").toString())) {
            if (null != goodsBean) {
                this.logger.error(this.SYS_CODE + ".addGoods \u5546\u54c1\u5df2\u7ecf\u5b58\u5728\uff0cskuId= " + tenantCode + "--" + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".addGoods skuId= " + tenantCode + "--", (Object)skuId);
            this.addGoodsBySkuIdEx(Long.valueOf(skuId), jdResponseMessageContentDomain);
        } else if ("2".equals(contentMap.get("state").toString())) {
            if (null == goodsBean) {
                this.logger.error(this.SYS_CODE + ".RemoveGoods \u83b7\u53d6goodsBean \u5931\u8d25\uff0cskuId= " + tenantCode + "--" + skuId);
                return;
            }
            this.logger.error(this.SYS_CODE + ".RemoveGoods goodsIds= " + tenantCode + "--", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsIds));
            this.delGoodsByGoodsIds(goodsIds);
        }
    }

    @Override
    public String updateGoodsPrice(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = contentMap.get("skuId").toString();
        JdClient client = JdInterfaceUtil.getJdClient(jdResponseMessageContentDomain, this.getToken(disChannel));
        RsSkuDomain goodsBean = this.getSkuBySkuNo(skuId, disChannel);
        if (null == goodsBean) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.goodsBean", (Object)skuId);
            return "ERROR";
        }
        if (null == goodsBean.getPricesetNprice()) {
            goodsBean.setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == goodsBean.getPricesetAsprice()) {
            goodsBean.setPricesetAsprice(BigDecimal.ZERO);
        }
        List<GetSellPriceGoodsResp> jdVopSellPriceInfo = this.getJdVopSellPrice(client, skuId);
        this.logger.error(this.SYS_CODE + ".updateGoodsPrice.jdVopSellPriceInfo", (Object)JsonUtil.buildNormalBinder().toJson(jdVopSellPriceInfo));
        if (null == jdVopSellPriceInfo) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.jdVopSellPriceInfo", (Object)skuId);
            return "ERROR";
        }
        BigDecimal bigDecimal = this.makePrice(jdVopSellPriceInfo, client, skuId);
        if (null == bigDecimal) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.makePrice", (Object)skuId);
            return "ERROR";
        }
        if (goodsBean.getPricesetNprice().compareTo(bigDecimal) == 0 && goodsBean.getPricesetAsprice().compareTo(jdVopSellPriceInfo.get(0).getSalePrice()) == 0) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.PricesetNprice", (Object)(skuId + "=" + jdVopSellPriceInfo.get(0).getJdPrice()));
            return "SUCCESS";
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(goodsBean.getSkuId());
        editSkuDomain.setGoodsCode(goodsBean.getGoodsCode());
        editSkuDomain.setSkuCode(goodsBean.getSkuCode());
        editSkuDomain.setSkuNo(String.valueOf(jdVopSellPriceInfo.get(0).getSkuId()));
        editSkuDomain.setPricesetNprice(bigDecimal);
        editSkuDomain.setPricesetMakeprice(jdVopSellPriceInfo.get(0).getJdPrice());
        editSkuDomain.setPricesetPrefprice(jdVopSellPriceInfo.get(0).getSalePrice());
        editSkuDomain.setPricesetAsprice(jdVopSellPriceInfo.get(0).getSalePrice());
        editSkuDomain.setMemberCode(disChannel.getMemberCcode());
        editSkuDomain.setMemberCcode(disChannel.getMemberCcode());
        editSkuDomain.setTenantCode(disChannel.getTenantCode());
        String json = JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain);
        this.logger.error(this.SYS_CODE + ".synJdVopPrice.info", (Object)json);
        try {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("editSkuDomain", json);
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit", updateMap);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.e", (Throwable)e);
        }
        return "SUCCESS";
    }

    private BigDecimal getSalePrice(BigDecimal salePrice, BigDecimal jdPrice) {
        return salePrice;
    }

    @Override
    public String updateGoodsPriceEx(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        List<GetSellPriceGoodsResp> jdVopSellPriceInfo;
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = contentMap.get("skuId").toString();
        JdClient client = JdInterfaceUtil.getJdClient(jdResponseMessageContentDomain, this.getToken(disChannel));
        RsSkuDomain goodsBean = this.getSkuBySkuNo(skuId, disChannel);
        if (null == goodsBean) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.goodsBean", (Object)skuId);
            return "ERROR";
        }
        if (null == goodsBean.getPricesetNprice()) {
            goodsBean.setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == goodsBean.getPricesetAsprice()) {
            goodsBean.setPricesetAsprice(BigDecimal.ZERO);
        }
        if (null == (jdVopSellPriceInfo = this.getJdVopSellPrice(client, skuId))) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.jdVopSellPriceInfo", (Object)skuId);
            return "ERROR";
        }
        BigDecimal Nprice = this.makePrice(jdVopSellPriceInfo, client, skuId);
        if (null == Nprice) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.makePrice", (Object)skuId);
            return "ERROR";
        }
        if (goodsBean.getPricesetNprice().compareTo(Nprice) == 0 && goodsBean.getPricesetAsprice().compareTo(jdVopSellPriceInfo.get(0).getSalePrice()) == 0) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.PricesetNprice", (Object)(skuId + "=" + jdVopSellPriceInfo.get(0).getJdPrice()));
            return "SUCCESS";
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(goodsBean.getSkuId());
        editSkuDomain.setGoodsCode(goodsBean.getGoodsCode());
        editSkuDomain.setSkuCode(goodsBean.getSkuCode());
        editSkuDomain.setSkuNo(String.valueOf(jdVopSellPriceInfo.get(0).getSkuId()));
        editSkuDomain.setPricesetNprice(Nprice);
        editSkuDomain.setPricesetMakeprice(jdVopSellPriceInfo.get(0).getJdPrice());
        editSkuDomain.setPricesetPrefprice(jdVopSellPriceInfo.get(0).getSalePrice());
        editSkuDomain.setPricesetAsprice(jdVopSellPriceInfo.get(0).getSalePrice());
        editSkuDomain.setMemberCode(disChannel.getMemberCcode());
        editSkuDomain.setMemberCcode(disChannel.getMemberCcode());
        editSkuDomain.setTenantCode(disChannel.getTenantCode());
        Map<String, Object> map = this.getupmPoints(editSkuDomain.getMemberCcode(), editSkuDomain.getTenantCode());
        if (MapUtil.isEmpty(map)) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.getupmPoints", null);
            return "ERROR";
        }
        String pointsRemark = map.get("pointsRemark").toString();
        String pointsLimit = map.get("pointsLimit").toString();
        String pointsRatio = map.get("pointsRatio").toString();
        BigDecimal nprice = new BigDecimal(pointsRemark);
        BigDecimal limit = new BigDecimal(pointsLimit);
        BigDecimal ratio = new BigDecimal(pointsRatio);
        BigDecimal bigDecimal = this.makePriceCrm(editSkuDomain.getPricesetAsprice(), editSkuDomain.getPricesetMakeprice(), editSkuDomain.getPricesetRefrice(), nprice, limit, ratio, goodsBean.getGoodsType());
        if (null == bigDecimal) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.makePriceCrm", null);
            return "ERROR";
        }
        editSkuDomain.setPricesetPrefprice(bigDecimal);
        editSkuDomain.setPricesetBaseprice(editSkuDomain.getPricesetNprice());
        editSkuDomain.setPricesetNprice(BigDecimal.ZERO);
        String json = JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain);
        this.logger.error(this.SYS_CODE + ".synJdVopPrice.info", (Object)json);
        try {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("editSkuDomain", json);
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit", updateMap);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            GoodsBean goodsBean1 = this.getGoodsBySkuNo(skuId, disChannel);
            if (null != goodsBean1) {
                Integer goodsId = goodsBean1.getRsResourceGoods().getGoodsId();
                ids.add(goodsId);
            }
            this.delGoodsByGoodsIds(ids);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.e", (Throwable)e);
        }
        return "SUCCESS";
    }

    @Override
    public String updateGoodsPriceDown(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String content = jdResponseMessageContentDomain.getContent();
        Map<String, Object> contentMap = JdBeanUtil.getJdContentMap(content);
        String skuId = contentMap.get("skuId").toString();
        JdClient client = JdInterfaceUtil.getJdClient(jdResponseMessageContentDomain, this.getToken(disChannel));
        RsSkuDomain goodsBean = this.getSkuBySkuNo(skuId, disChannel);
        if (null == goodsBean) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.goodsBean", (Object)skuId);
            return "ERROR";
        }
        if (null == goodsBean.getPricesetNprice()) {
            goodsBean.setPricesetNprice(BigDecimal.ZERO);
        }
        if (null == goodsBean.getPricesetAsprice()) {
            goodsBean.setPricesetAsprice(BigDecimal.ZERO);
        }
        List<GetSellPriceGoodsResp> jdVopSellPriceInfo = null;
        String value = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)disChannel.getTenantCode().concat("-").concat("getJdVopSellPrice").concat("-").concat("getJdVopSellPrice"));
        jdVopSellPriceInfo = StringUtils.isNotBlank((String)value) ? JsonUtil.buildNormalBinder().getJsonToList(value, GetSellPriceGoodsResp.class) : this.getJdVopSellPrice(client, skuId);
        if (null == jdVopSellPriceInfo) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.jdVopSellPriceInfo", (Object)skuId);
            return "ERROR";
        }
        BigDecimal bigDecimal = this.makePrice(jdVopSellPriceInfo, client, skuId);
        if (null == bigDecimal) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.makePrice", (Object)skuId);
            return "ERROR";
        }
        if (goodsBean.getPricesetNprice().compareTo(bigDecimal) == 0 && goodsBean.getPricesetAsprice().compareTo(jdVopSellPriceInfo.get(0).getSalePrice()) == 0) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.PricesetNprice", (Object)(skuId + "=" + jdVopSellPriceInfo.get(0).getJdPrice()));
            return "SUCCESS";
        }
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(goodsBean.getSkuId());
        editSkuDomain.setGoodsCode(goodsBean.getGoodsCode());
        editSkuDomain.setSkuCode(goodsBean.getSkuCode());
        editSkuDomain.setSkuNo(String.valueOf(jdVopSellPriceInfo.get(0).getSkuId()));
        editSkuDomain.setPricesetNprice(bigDecimal);
        editSkuDomain.setPricesetMakeprice(new BigDecimal(0));
        editSkuDomain.setPricesetPrefprice(jdVopSellPriceInfo.get(0).getSalePrice());
        editSkuDomain.setPricesetAsprice(jdVopSellPriceInfo.get(0).getSalePrice());
        editSkuDomain.setMemberCode(disChannel.getMemberCcode());
        editSkuDomain.setMemberCcode(disChannel.getMemberCcode());
        editSkuDomain.setTenantCode(disChannel.getTenantCode());
        String json = JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain);
        this.logger.error(this.SYS_CODE + ".synJdVopPrice.info", (Object)json);
        try {
            HashMap<String, String> updateMap = new HashMap<String, String>();
            updateMap.put("editSkuDomain", json);
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit", updateMap);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            GoodsBean goodsBean1 = this.getGoodsBySkuNo(skuId, disChannel);
            boolean boo = this.jdPrice(editSkuDomain.getPricesetNprice(), editSkuDomain.getPricesetAsprice(), editSkuDomain.getTenantCode(), editSkuDomain.getSkuNo(), "\u4fee\u6539");
            if (null != goodsBean1) {
                RsResourceGoodsDomain rsResourceGoods = goodsBean1.getRsResourceGoods();
                ids.add(rsResourceGoods.getGoodsId());
                if (boo && 0 == rsResourceGoods.getDataOpbillstate()) {
                    this.sendUpdateShelveGoods(ids);
                } else if (!boo && 1 == rsResourceGoods.getDataOpbillstate()) {
                    this.delGoodsByGoodsIds(ids);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".synJdVopPrice.e", (Throwable)e);
        }
        return "SUCCESS";
    }

    private void delGoodsByGoodsIds(List<Integer> goodsIds) {
        this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", goodsIds);
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        try {
            params.put("goodsIds", goodsIds);
            this.logger.error(this.SYS_CODE + ".deletePromotioneToGoods.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
            this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".delGoodsByGoodsIds:\u5220\u9664\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private void sendUpdateShelveGoods(List<Integer> goodsIds) {
        this.logger.error(this.SYS_CODE + ".sendUpdateShelveGoods:\u6279\u91cf\u4e0a\u4ef7\u4eac\u4e1c\u5546\u54c1", goodsIds);
        if (ListUtil.isEmpty(goodsIds)) {
            return;
        }
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        try {
            params.put("goodsIds", goodsIds);
            this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".sendUpdateShelveGoods:\u6279\u91cf\u4e0a\u4ef7\u4eac\u4e1c\u5546\u54c1", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".delGoodsByGoodsIds.ex", (Throwable)e);
        }
    }

    private void addGoodsBySkuId(Long skuId, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (null == skuId || null == jdResponseMessageContentDomain || null == jdResponseMessageContentDomain.getDisChannel()) {
            this.logger.error(this.SYS_CODE + ".addGoodsBySkuIdStr", (Object)("skuId" + skuId + "jdResponseMessageContentDomain" + JsonUtil.buildNormalBinder().toJson((Object)jdResponseMessageContentDomain)));
        }
        PoolSkubean poolSkubean = new PoolSkubean();
        GetSkuPoolInfoItemGoodsResp poolInfo = new GetSkuPoolInfoItemGoodsResp();
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        JdClient client = this.getJdClient(jdResponseMessageContentDomain);
        poolSkubean.setDisChannel(disChannel);
        poolSkubean.setPoolInfo(poolInfo);
        poolSkubean.setTenantCode(tenantCode);
        poolSkubean.setClient(client);
        poolSkubean.setKeymap(jdResponseMessageContentDomain.getKeyMap());
        ArrayList<Long> items = new ArrayList<Long>();
        items.add(skuId);
        poolSkubean.setItems(items);
        this.logger.error(this.SYS_CODE + ".addGoodsBySkuId poolSkubeanList" + tenantCode + "--", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)poolSkubean));
        this.saveVopJdSkuIds(poolSkubean);
    }

    private void addGoodsBySkuIdlog(Long skuId, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (null == skuId || null == jdResponseMessageContentDomain || null == jdResponseMessageContentDomain.getDisChannel()) {
            this.logger.error(this.SYS_CODE + ".addGoodsBySkuIdlog.addGoodsBySkuIdStr", (Object)("skuId" + skuId + "jdResponseMessageContentDomain" + JsonUtil.buildNormalBinder().toJson((Object)jdResponseMessageContentDomain)));
        }
        PoolSkubean poolSkubean = new PoolSkubean();
        GetSkuPoolInfoItemGoodsResp poolInfo = new GetSkuPoolInfoItemGoodsResp();
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        JdClient client = this.getJdClient(jdResponseMessageContentDomain);
        poolSkubean.setDisChannel(disChannel);
        poolSkubean.setPoolInfo(poolInfo);
        poolSkubean.setTenantCode(tenantCode);
        poolSkubean.setClient(client);
        poolSkubean.setKeymap(jdResponseMessageContentDomain.getKeyMap());
        ArrayList<Long> items = new ArrayList<Long>();
        items.add(skuId);
        poolSkubean.setItems(items);
        this.logger.error(this.SYS_CODE + ".addGoodsBySkuIdlog poolSkubeanList" + tenantCode + "--", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)poolSkubean));
        this.saveVopJdSkuIdslog(poolSkubean);
    }

    private void addGoodsBySkuIdEx(Long skuId, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (null == skuId || null == jdResponseMessageContentDomain || null == jdResponseMessageContentDomain.getDisChannel()) {
            this.logger.error(this.SYS_CODE + ".addGoodsBySkuIdStr", (Object)("skuId" + skuId + "jdResponseMessageContentDomain" + JsonUtil.buildNormalBinder().toJson((Object)jdResponseMessageContentDomain)));
        }
        PoolSkubean poolSkubean = new PoolSkubean();
        GetSkuPoolInfoItemGoodsResp poolInfo = new GetSkuPoolInfoItemGoodsResp();
        DisChannel disChannel = jdResponseMessageContentDomain.getDisChannel();
        String tenantCode = disChannel.getTenantCode();
        JdClient client = this.getJdClient(jdResponseMessageContentDomain);
        poolSkubean.setDisChannel(disChannel);
        poolSkubean.setPoolInfo(poolInfo);
        poolSkubean.setTenantCode(tenantCode);
        poolSkubean.setClient(client);
        poolSkubean.setKeymap(jdResponseMessageContentDomain.getKeyMap());
        ArrayList<Long> items = new ArrayList<Long>();
        items.add(skuId);
        poolSkubean.setItems(items);
        this.logger.error(this.SYS_CODE + ".addGoodsBySkuId poolSkubeanList" + tenantCode + "--", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)poolSkubean));
        this.saveVopJdSkuIdsEx(poolSkubean);
    }

    private void soldOrShelveGoodsByGoodsIds(List<String> jdSkuIds, String type, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (ListUtil.isEmpty(jdSkuIds) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", (Object)(jdSkuIds + "===" + type));
            return;
        }
        Map<String, Object> keyMap = jdResponseMessageContentDomain.getKeyMap();
        boolean crmFlag = false;
        if (MapUtil.isNotEmpty(keyMap)) {
            crmFlag = "true".equals(String.valueOf(keyMap.get("crmFlag")));
        }
        try {
            ArrayList<Integer> goodsIds = new ArrayList<Integer>();
            for (String skuNo : jdSkuIds) {
                GoodsBean goodsBean = this.getGoodsBySkuNo(skuNo, jdResponseMessageContentDomain.getDisChannel());
                if (goodsBean == null) {
                    this.logger.error(this.SYS_CODE + ".contentMap---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean));
                    continue;
                }
                goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
                this.logger.info(this.SYS_CODE + ".contentMap==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds));
                if (!ListUtil.isNotEmpty(goodsIds)) continue;
                HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
                params.put("goodsIds", goodsIds);
                if ("0".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                    continue;
                }
                if (!"1".equals(type)) continue;
                this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.mapStr:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                this.getInternalRouter().inInvoke(RESOURCEGOODS_SHELVE_CODE, params);
            }
        }
        catch (Exception e) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25", (Object)e.getMessage());
            throw new ApiException(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.ex", (Throwable)e);
        }
        finally {
            String msgId = jdResponseMessageContentDomain.getId() + "";
            this.logger.error(this.SYS_CODE + ".deleteVopMsgById msgId", (Object)msgId);
            this.deleteVopMsgById(jdResponseMessageContentDomain.getClient(), msgId);
        }
    }

    private void soldOrShelveGoodsByGoodsIdsEx(List<String> jdSkuIds, String type, JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        if (ListUtil.isEmpty(jdSkuIds) || StringUtils.isBlank((String)type)) {
            this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u53c2\u6570\u4e3a\u7a7a", (Object)(jdSkuIds + "===" + type));
            return;
        }
        Map<String, Object> keyMap = jdResponseMessageContentDomain.getKeyMap();
        boolean crmFlag = false;
        if (MapUtil.isNotEmpty(keyMap)) {
            crmFlag = "true".equals(String.valueOf(keyMap.get("crmFlag")));
        }
        ArrayList<Integer> goodsIds = new ArrayList<Integer>();
        for (String skuNo : jdSkuIds) {
            GoodsBean goodsBean = this.getGoodsBySkuNo(skuNo, jdResponseMessageContentDomain.getDisChannel());
            if (goodsBean == null) {
                this.logger.error(this.SYS_CODE + ".contentMap---------------" + JsonUtil.buildNonEmptyBinder().toJson((Object)goodsBean));
                continue;
            }
            goodsIds.add(goodsBean.getRsResourceGoods().getGoodsId());
            this.logger.info(this.SYS_CODE + ".contentMap==========>" + JsonUtil.buildNonEmptyBinder().toJson(goodsIds));
            if (!ListUtil.isNotEmpty(goodsIds)) continue;
            HashMap<String, ArrayList<Integer>> params = new HashMap<String, ArrayList<Integer>>();
            try {
                params.put("goodsIds", goodsIds);
                if ("0".equals(type)) {
                    this.logger.info(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.maps:", (Object)JsonUtil.buildNormalBinder().toJson(params));
                    this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutGoods", params);
                    continue;
                }
                if (!"1".equals(type)) continue;
            }
            catch (Exception e) {
                this.logger.error(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds:\u4e0a/\u4e0b\u67b6\u5931\u8d25", (Object)e.getMessage());
                throw new ApiException(this.SYS_CODE + ".soldOrShelveGoodsByGoodsIds.ex", (Throwable)e);
            }
        }
    }

    @Override
    public String updateGoodsSku(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        for (Long skuIds : skuId) {
            GetSkuPoolInfoGoodsResp jdVopGoodsInfo = null;
            try {
                jdVopGoodsInfo = this.getSkuPoolInfoGoodsResp(client, skuIds);
            }
            catch (Exception e1) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.e1", (Throwable)e1);
                return "SUCCESS";
            }
            if (null == jdVopGoodsInfo) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.null", skuId);
                return "SUCCESS";
            }
            String pntreeCode = EsGoodsServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error(this.SYS_CODE + ".saveGoodsPool.pntreeCode", (Object)"=====>pntreeCode");
                return "ERROR";
            }
            this.updateInformation(client, jdVopGoodsInfo, disChannel, tenantCode, pntreeCode, String.valueOf(skuIds));
        }
        return "SUCCESS";
    }

    public static void main(String[] args) {
        GetSkuPoolInfoGoodsResp jdVopGoodsInfo = null;
        DefaultJdClient client = new DefaultJdClient("https://api.jd.com/routerjson", "57e684e2f7e7471eb1ea89035123fd9fg0zt", "1E4D4C2814BFC08AAB164CDC64D30545", "d0d4a3cfe70d45d1bd2f9b5ff65f0958");
        try {
            VopGoodsGetSkuDetailInfoRequest request = new VopGoodsGetSkuDetailInfoRequest();
            request.setSkuId(100002858948L);
            VopGoodsGetSkuDetailInfoResponse getSkuDetailResponse = (VopGoodsGetSkuDetailInfoResponse)client.execute((JdRequest)request);
            OpenRpcResult getSkuDetailResult = getSkuDetailResponse.getOpenRpcResult();
            if (null == getSkuDetailResult) {
                // empty if block
            }
            if (!getSkuDetailResult.getSuccess()) {
                // empty if block
            }
            jdVopGoodsInfo = getSkuDetailResult.getResult();
            System.out.println(JsonUtil.buildNormalBinder().toJson((Object)jdVopGoodsInfo));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String updateGoodsSkuEx(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        for (Long skuIds : skuId) {
            GetSkuPoolInfoGoodsResp jdVopGoodsInfo = null;
            try {
                jdVopGoodsInfo = this.getSkuPoolInfoGoodsResp(client, skuIds);
            }
            catch (Exception e1) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.e1", (Throwable)e1);
                return "SUCCESS";
            }
            if (null == jdVopGoodsInfo) {
                this.logger.error(this.SYS_CODE + ".saveGoods.jdVopGoodsInfo.null", skuId);
                return "SUCCESS";
            }
            String pntreeCode = EsGoodsServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error(this.SYS_CODE + ".saveGoodsPool.pntreeCode", (Object)"=====>pntreeCode");
                return "ERROR";
            }
            this.updateInformationEx(client, jdVopGoodsInfo, disChannel, tenantCode, pntreeCode, String.valueOf(skuIds));
        }
        return "SUCCESS";
    }

    public String updateGoodsSkuDown(JdClient client, List<Long> skuId, DisChannel disChannel, String tenantCode) {
        for (Long skuIds : skuId) {
            GetSkuPoolInfoGoodsResp jdVopGoodsInfo = null;
            try {
                jdVopGoodsInfo = this.getSkuPoolInfoGoodsResp(client, skuIds);
            }
            catch (Exception e1) {
                this.logger.error(this.SYS_CODE + ".updateGoodsSkuDown.saveGoods.jdVopGoodsInfo.e1", (Throwable)e1);
                return "SUCCESS";
            }
            if (null == jdVopGoodsInfo) {
                this.logger.error(this.SYS_CODE + ".updateGoodsSkuDown.saveGoods.jdVopGoodsInfo.null", skuId);
                return "SUCCESS";
            }
            String pntreeCode = EsGoodsServiceImpl.getPntreeCode(tenantCode);
            if (StringUtils.isBlank((String)pntreeCode)) {
                this.logger.error(this.SYS_CODE + ".updateGoodsSkuDown.saveGoodsPool.pntreeCode", (Object)"=====>pntreeCode");
                return "ERROR";
            }
            this.updateInformationDown(client, jdVopGoodsInfo, disChannel, tenantCode, pntreeCode, String.valueOf(skuIds));
        }
        return "SUCCESS";
    }

    private GoodsBean getGoodsBySkuNo(String skuNo, DisChannel disChannel) {
        if (StringUtils.isBlank((String)skuNo) || null == disChannel) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("skuNo", skuNo);
        params.put("memberCode", disChannel.getMemberCcode());
        params.put("memberCcode", disChannel.getMemberCcode());
        params.put("channelCode", disChannel.getChannelCode());
        params.put("tenantCode", disChannel.getTenantCode());
        this.logger.error(this.SYS_CODE + ".getGoodsBySkuNo" + JsonUtil.buildNonEmptyBinder().toJson(params));
        return (GoodsBean)this.getForObject(RESOURCEGOODS_GETNO_API_CODE, GoodsBean.class, params);
    }

    private JdClient getJdClient(JdResponseMessageContentDomain jdResponseMessageContentDomain) {
        String tenantCode = jdResponseMessageContentDomain.getDisChannel().getTenantCode();
        String channelCode = jdResponseMessageContentDomain.getDisChannel().getChannelCode();
        String memberCode = jdResponseMessageContentDomain.getDisChannel().getMemberCcode();
        String accessToken = this.getToken(tenantCode, channelCode, memberCode);
        String serverUrl = (String)jdResponseMessageContentDomain.getKeyMap().get("serverUrl");
        String appKey = (String)jdResponseMessageContentDomain.getKeyMap().get("appKey");
        String appSecret = (String)jdResponseMessageContentDomain.getKeyMap().get("appSecret");
        DefaultJdClient client = new DefaultJdClient(serverUrl, accessToken, appKey, appSecret);
        return client;
    }

    public String getToken(DisChannel disChannel) {
        String tokenStr;
        String tenantCode = disChannel.getTenantCode();
        String channelCode = disChannel.getChannelCode();
        String memberCode = disChannel.getMemberCcode();
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = "";
        }
        if (StringUtils.isBlank((String)(tokenStr = DisUtil.getRemotMap((String)"DisOauthToken-channelCode", (String)(channelCode + "-" + memberCode + "-" + tenantCode))))) {
            return null;
        }
        DisOauthToken disOauthToken = (DisOauthToken)JsonUtil.buildNormalBinder().getJsonToObject(tokenStr, DisOauthToken.class);
        if (null == disOauthToken) {
            return null;
        }
        return disOauthToken.getOauthTokenToken();
    }
}

